// TrimIndicatorGauge.cpp: implementation of the CTrimIndicatorGauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "TrimIndicatorGauge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTrimIndicatorGauge::CTrimIndicatorGauge()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Trim_Indicator");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(208,96));

   m_aileron_angle      =  0.0f;
   m_rudder_angle       =  0.0f;
   m_elevator_angle     =  0.0f;

   m_aileron_angle_cv   =  m_aileron_angle;
   m_rudder_angle_cv    =  m_rudder_angle;
   m_elevator_angle_cv  =  m_elevator_angle;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Aileron Trim");
   m_listGraphicalElementVars.push_back("Rudder Trim");
   m_listGraphicalElementVars.push_back("Elevator Trim");

   m_list   =  -1;
}

CTrimIndicatorGauge::~CTrimIndicatorGauge()
{
}

void  CTrimIndicatorGauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   aileron_needle.Format("%c", AILERON_TRIM);

   aileronTicks.Initialize();
   aileronTicks.SetOuterRadius(0.25f   /  m_aspect_ratio);
   aileronTicks.SetLabelProperties(1.0f, 1.0f);
   aileronTicks.SetTickColor(255, 255, 255);
   aileronTicks.SetTickLengths(0.15f /  m_aspect_ratio,  0.11f /  m_aspect_ratio,   0.07f /  m_aspect_ratio);

   TICK_INFO   tick_info;

   tick_info.location   =  140.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   aileronTicks.TickList.AddTail(tick_info);

   tick_info.location   =  115.0;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   aileronTicks.TickList.AddTail(tick_info);

   tick_info.location   =  65.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   aileronTicks.TickList.AddTail(tick_info);

   tick_info.location   =  40.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   aileronTicks.TickList.AddTail(tick_info);

   aileronTicks.GenerateLists();


   // Green...
   aileronGreenTicks.Initialize();
   aileronGreenTicks.SetOuterRadius(0.25f   /  m_aspect_ratio);
   aileronGreenTicks.SetLabelProperties(1.0f, 1.0f);
   aileronGreenTicks.SetTickColor(0, 192, 0);
   aileronGreenTicks.SetTickLengths(0.15f /  m_aspect_ratio,  0.11f /  m_aspect_ratio,   0.07f /  m_aspect_ratio);

   tick_info.location   =  90.0;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   aileronGreenTicks.TickList.AddTail(tick_info);

   aileronGreenTicks.GenerateLists();


   rudder_needle.Format("%c", RUDDER_TRIM);

   rudderTicks.Initialize();
   rudderTicks.SetOuterRadius(0.25f   /  m_aspect_ratio);
   rudderTicks.SetLabelProperties(1.0f, 1.0f);
   rudderTicks.SetTickColor(255, 255, 255);
   rudderTicks.SetTickLengths(0.15f /  m_aspect_ratio,  0.11f /  m_aspect_ratio,   0.07f /  m_aspect_ratio);

   tick_info.location   =  312.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   rudderTicks.TickList.AddTail(tick_info);

   tick_info.location   =  340.0;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   rudderTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.0;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   rudderTicks.TickList.AddTail(tick_info);

   tick_info.location   =  20.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   rudderTicks.TickList.AddTail(tick_info);

   tick_info.location   =  60.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   rudderTicks.TickList.AddTail(tick_info);

   tick_info.location   =  88.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   rudderTicks.TickList.AddTail(tick_info);

   rudderTicks.GenerateLists();


   // Green...
   rudderGreenTicks.Initialize();
   rudderGreenTicks.SetOuterRadius(0.25f   /  m_aspect_ratio);
   rudderGreenTicks.SetLabelProperties(1.0f, 1.0f);
   rudderGreenTicks.SetTickColor(0, 192, 0);
   rudderGreenTicks.SetTickLengths(0.15f /  m_aspect_ratio,  0.11f /  m_aspect_ratio,   0.07f /  m_aspect_ratio);

   tick_info.location   =  40.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   rudderGreenTicks.TickList.AddTail(tick_info);

   rudderGreenTicks.GenerateLists();



   elevator_needle.Format("%c", ELEVATOR_TRIM);

   elevatorTicks.Initialize();
   elevatorTicks.SetOuterRadius(0.25f   /  m_aspect_ratio);
   elevatorTicks.SetLabelProperties(1.0f, 1.0f);
   elevatorTicks.SetTickColor(255, 255, 255);
   elevatorTicks.SetTickLengths(0.15f /  m_aspect_ratio,  0.11f /  m_aspect_ratio,   0.07f /  m_aspect_ratio);


   tick_info.location   =  340.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   elevatorTicks.TickList.AddTail(tick_info);

   tick_info.location   =  305.0;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   elevatorTicks.TickList.AddTail(tick_info);

   tick_info.location   =  245.5f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   elevatorTicks.TickList.AddTail(tick_info);

   elevatorTicks.GenerateLists();


   // Green...
   elevatorGreenTicks.Initialize();
   elevatorGreenTicks.SetOuterRadius(0.25f   /  m_aspect_ratio);
   elevatorGreenTicks.SetLabelProperties(1.0f, 1.0f);
   elevatorGreenTicks.SetTickColor(0, 192, 0);
   elevatorGreenTicks.SetTickLengths(0.15f /  m_aspect_ratio,  0.11f /  m_aspect_ratio,   0.07f /  m_aspect_ratio);

   tick_info.location   =  270.0;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   elevatorGreenTicks.TickList.AddTail(tick_info);

   elevatorGreenTicks.GenerateLists();

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();

         // Draw tick marks and labels.
         glTranslatef(-0.66f  /  m_aspect_ratio,  0.0f, 0.0f);
         aileronTicks.Draw();
         aileronGreenTicks.Draw();
         glTranslatef(0.66f  /  m_aspect_ratio,  0.0f, 0.0f);

         // Draw tick marks and labels.
         rudderTicks.Draw();
         rudderGreenTicks.Draw();


         // Draw tick marks and labels.
         glTranslatef(0.66f  /  m_aspect_ratio,  0.0f, 0.0f);
         elevatorTicks.Draw();
         elevatorGreenTicks.Draw();
      }
      glPopMatrix();
   }
   glEndList();
}

void  CTrimIndicatorGauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      glPushMatrix();
         glTranslatef(-0.66f  /  m_aspect_ratio,  0.0f, 0.0f);
         glRotatef(-m_aileron_angle + 90.0f, 0.0f, 0.0f, 1.0f);
         aileronNeedle.Draw(aileron_needle,  true, 0.0f, 5.0f /  m_aspect_ratio, 1.0f);
      glPopMatrix();

   
      glPushMatrix();
         glRotatef(-m_rudder_angle + 90.0f, 0.0f, 0.0f, 1.0f);
         rudderNeedle.Draw(rudder_needle,  true, 0.0f, 5.0f /  m_aspect_ratio, 1.0f);
      glPopMatrix();


      glPushMatrix();
         glTranslatef(0.66f  /  m_aspect_ratio,  0.0f, 0.0f);
         glRotatef(-m_elevator_angle   -  90.0f, 0.0f, 0.0f, 1.0f);
         elevatorNeedle.Draw(elevator_needle,  true, 0.0f, 5.0f /  m_aspect_ratio, 1.0f);
      glPopMatrix();
   }
   glPopMatrix();

   EndDraw();
}

void  CTrimIndicatorGauge::SetAileronTrim(float aileronTrim)
{
   if (aileronTrim  >  0.0f)
      m_aileron_angle_cv   =  90.0f +  (50.0f/1.0f *  -aileronTrim);
   else
      m_aileron_angle_cv   =  90.0f +  (50.0f/1.0f *  -aileronTrim);
}

void  CTrimIndicatorGauge::SetRudderTrim(float rudderTrim)
{
   if (rudderTrim  >  0.0f)
      m_rudder_angle_cv =  90.0f +  (88.0f/11.0f *  rudderTrim);
   else
      m_rudder_angle_cv =  90.0f +  (48.0f/6.0f *  rudderTrim);
}


void  CTrimIndicatorGauge::SetElevatorTrim(float elevatorTrim)
{
   if (elevatorTrim  >  0.0f)
      m_elevator_angle_cv  =  270.0f +  (75.25f/21.0f  *  elevatorTrim);
   else
      m_elevator_angle_cv  =  270.0f +  (19.25f/7.0f   *  elevatorTrim);
}

CWidget* CTrimIndicatorGauge::CreateObject()
{
   return new CTrimIndicatorGauge();
}

void CTrimIndicatorGauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Aileron Trim")
   {
      SetAileronTrim(*pVariant);
   }
   else if (rstrElementVar   == "Rudder Trim")
   {
      SetRudderTrim(*pVariant);
   }
   else if (rstrElementVar   == "Elevator Trim")
   {
      SetElevatorTrim(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CTrimIndicatorGauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CTrimIndicatorGauge::UpdateRenderVariables()
{
   m_aileron_angle      =  m_aileron_angle_cv;
   m_rudder_angle       =  m_rudder_angle_cv;
   m_elevator_angle     =  m_elevator_angle_cv;

   return CWidget::UpdateRenderVariables();
}