// ThrottlePosition.cpp: implementation of the CThrottlePosition class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "ThrottlePosition.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CThrottlePosition::CThrottlePosition()
{
   m_exPtUpperLeft            =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight           =  CExtentsPoint(CPoint(75,175));

   m_stlStrWidgetName         =  _FSI_STL::string("Throttle_Position");

   m_throttlePosition_offset     =  0.0f;
   m_throttlePosition_offset_cv  =  m_throttlePosition_offset;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Throttle Position");

   m_list   =  -1;
}

CThrottlePosition::~CThrottlePosition()
{
}

void  CThrottlePosition::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   m_CStr_throttle_position   =  "PCL";
   m_CStr_idle                =  "IDLE";
   m_CStr_max                 =  "MAX ";
   m_CStr_off                 =  "OFF ";

   m_throttlePosition_indicator.Format("%c", DIAMOND);
   throttlePositionIndicator.SetForegroundColor(0,  192,  0);    // Green


   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();

         glTranslatef(-0.1f *  m_aspect_ratio, -0.10f * m_aspect_ratio, 0.0f);

         // Draw the PCL label
         glPushMatrix();
            glTranslatef(0.0f *  m_aspect_ratio, 0.28f * m_aspect_ratio, 0.0f);
            m_title.Draw(m_CStr_throttle_position, false, 0.0f, 3.3f *  m_aspect_ratio, 1.0f);
         glPopMatrix();

         // Draw the MAX, IDLE and OFF labels
         glPushMatrix();
            glTranslatef(0.26f *  m_aspect_ratio, 0.8f * m_aspect_ratio, 0.0f);
            m_max.Draw(m_CStr_max, true, 0.0f, 1.7f *  m_aspect_ratio, 1.0f);
         glPopMatrix();

         glPushMatrix();
            glTranslatef(0.26f *  m_aspect_ratio, -0.25f * m_aspect_ratio, 0.0f);
            m_idle.Draw(m_CStr_idle, true, 0.0f, 1.7f *  m_aspect_ratio, 1.0f);
         glPopMatrix();

         glPushMatrix();
            glTranslatef(0.26f *  m_aspect_ratio, -0.72f * m_aspect_ratio, 0.0f);
            m_off.Draw(m_CStr_off, true, 0.0f, 1.7f *  m_aspect_ratio, 1.0f);
         glPopMatrix();
         

         glPushMatrix();

         glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
            glRGB(255, 255, 255);
            glBegin(GL_QUADS);
               glVertex2f(-0.15f, 0.90f   *  m_aspect_ratio);
               glVertex2f(-0.15f, 0.76f   *  m_aspect_ratio);
               glVertex2f( 0.15f, 0.76f   *  m_aspect_ratio);
               glVertex2f( 0.15f, 0.90f   *  m_aspect_ratio);
            glEnd();

         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
            glBegin(GL_QUADS);

               glRGB(192, 192, 192);
               glVertex2f(-0.15f, 0.90f   *  m_aspect_ratio);
               glVertex2f(-0.15f, 0.76f   *  m_aspect_ratio);
               glVertex2f( 0.15f, 0.76f   *  m_aspect_ratio);
               glVertex2f( 0.15f, 0.90f   *  m_aspect_ratio);

               glRGB(0, 0, 0);
               glVertex2f( 0.15f,  0.900f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  0.872f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  0.816f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  0.844f   *  m_aspect_ratio);

               glTranslatef(0.0f, -0.056f   *  m_aspect_ratio, 0.0f);

               glVertex2f( 0.15f,  0.900f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  0.872f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  0.816f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  0.844f   *  m_aspect_ratio);
            glEnd();
         glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
         glPopMatrix();

         glPushMatrix();

         glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
            glBegin(GL_QUADS);
               glRGB(255, 255, 255);
               glVertex2f(-0.15f, -0.20f   *  m_aspect_ratio);
               glVertex2f(-0.15f, -0.76f   *  m_aspect_ratio);
               glVertex2f( 0.15f, -0.76f   *  m_aspect_ratio);
               glVertex2f( 0.15f, -0.20f   *  m_aspect_ratio);
            glEnd();

         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
            glBegin(GL_QUADS);
               glRGB(192, 192, 192);
               glVertex2f(-0.15f, -0.20f   *  m_aspect_ratio);
               glVertex2f(-0.15f, -0.76f   *  m_aspect_ratio);
               glVertex2f( 0.15f, -0.76f   *  m_aspect_ratio);
               glVertex2f( 0.15f, -0.20f   *  m_aspect_ratio);

               glRGB(0, 0, 0);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);

               glTranslatef(0.0f,  -0.056f   *  m_aspect_ratio, 0.0f);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);

               glTranslatef(0.0f,  -0.056f   *  m_aspect_ratio, 0.0f);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);

               glTranslatef(0.0f,  -0.056f   *  m_aspect_ratio, 0.0f);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);

               glTranslatef(0.0f,  -0.056f   *  m_aspect_ratio, 0.0f);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);

               glTranslatef(0.0f,  -0.056f   *  m_aspect_ratio, 0.0f);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);

               glTranslatef(0.0f,  -0.056f   *  m_aspect_ratio, 0.0f);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);

               glTranslatef(0.0f,  -0.056f   *  m_aspect_ratio, 0.0f);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);

               glTranslatef(0.0f,  -0.056f   *  m_aspect_ratio, 0.0f);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);

               glTranslatef(0.0f,  -0.056f   *  m_aspect_ratio, 0.0f);
               glVertex2f( 0.15f,  -0.200f   *  m_aspect_ratio);
               glVertex2f( 0.15f,  -0.228f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.284f   *  m_aspect_ratio);
               glVertex2f(-0.15f,  -0.256f   *  m_aspect_ratio);
            glEnd();
         glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
         glPopMatrix();

      }
      glPopMatrix();
   }
   glEndList();
}

void  CThrottlePosition::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      // Glideslope Indicator
      glTranslatef(-0.25f *  m_aspect_ratio, (m_throttlePosition_offset - 0.10f) *  m_aspect_ratio, 0.0f);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         throttlePositionIndicator.Draw(m_throttlePosition_indicator,   true, 90.0f, 2.25f *  m_aspect_ratio, 1.0f);
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glPopMatrix();

   EndDraw();
}

void  CThrottlePosition::SetThrottlePositionOffset(float offset)
{
   if (offset  < 0.0f)
      offset   = 0.0f;
   else if (offset > 53.0f)
      offset   = 53.0f;

   m_throttlePosition_offset_cv  =  ((offset /  53.0f)   *  1.65f)  -  0.75f;
}

CWidget* CThrottlePosition::CreateObject()
{
   return new CThrottlePosition();
}

void CThrottlePosition::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Throttle Position")
   {
      SetThrottlePositionOffset(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CThrottlePosition::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CThrottlePosition::UpdateRenderVariables()
{
   m_throttlePosition_offset = m_throttlePosition_offset_cv;

   return CWidget::UpdateRenderVariables();
}
