// Switch.h: interface for the CSwitch class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SWITCH_H__77C03242_8A19_11D2_AD51_006008B0E0C3__INCLUDED_)
#define AFX_SWITCH_H__77C03242_8A19_11D2_AD51_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"
#include "..\core\OpenGLtext.h"

typedef  enum  position_type
{
   SWITCH_NORMAL,
   SWITCH_UP,
   SWITCH_DOWN,
   SWITCH_LEFT,
   SWITCH_RIGHT
};

class CSwitch : public COpenGLWidget, public CPanel
{
public:
	CSwitch();
	virtual ~CSwitch();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);

   COpenGLtext theLegend;

   COpenGLtext UpPositionLegend;
   COpenGLtext DownPositionLegend;
   COpenGLtext LeftPositionLegend;
   COpenGLtext RightPositionLegend;

   COpenGLtext NormalPositionLegend;

   COpenGLtext theSwitch;
   CString     m_switch;
   float m_switch_angle;
   bool  m_horizontal;

   void  SetPosition(position_type  position);
   void  SetLegends(CString main, CString up, CString down, CString left = "", CString right = "", CString normal = "");
   void  SetNumberOfLevers(int number_of_levers);

protected:
   CString  m_theLegend;
   CString  m_upPositionLegend;
   CString  m_downPositionLegend;
   CString  m_leftPositionLegend;
   CString  m_rightPositionLegend;
   CString  m_normalPositionLegend;

   int      m_number_of_levers;

// Attributes
public:
  	enum { IDB = IDB_TOGGLE_SWITCH  };
};

#endif // !defined(AFX_SWITCH_H__77C03242_8A19_11D2_AD51_006008B0E0C3__INCLUDED_)
