// Switch.cpp: implementation of the CSwitch class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "Switch.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSwitch::CSwitch()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Toggle_Switch");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(64,64));
   m_number_of_levers   =  1;
   m_switch_angle       =  -30.0f;
   m_switch.Format("%c", TOGGLE_SWITCH);
   m_horizontal         =  false;

   m_list   =  -1;
}

CSwitch::~CSwitch()
{
}

void  CSwitch::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   theSwitch.SetForegroundColor(128, 128, 128);

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      CPanel::Draw();   // Draw the standard stuff, (bezel, screw heads, and primary title).
   }
   glEndList();
}

void  CSwitch::Render(void)
{
   BeginDraw(0.25f, 0.25f, 0.25f);

   glPushMatrix();
   {
      glCallList(m_list);

      // This all needs to be revised and put where possible into the
      // display list in Setup.

      glPushMatrix();
         glTranslatef(0.0f,   0.75f,   0.0f);
         theLegend.Draw(m_theLegend,   true, 0.0f, 4.0f, 1.0f);
      glPopMatrix();

      glTranslatef(0.0f,   -0.20f,  0.0f);

      GLUquadricObj  *pquad   =  gluNewQuadric();
         glPushMatrix();
            glRGB(0, 0, 0);
            gluDisk(pquad, 0.25f,  0.28f, 30, 1);
            glRGB(32, 32, 32);
            gluDisk(pquad, 0.20f,  0.25f, 30, 1);
            glRGB(80, 80, 80);
            gluDisk(pquad, 0.00f,  0.20f, 30, 1);
         glPopMatrix();
      gluDeleteQuadric(pquad);

      glPushMatrix();
         glTranslatef(0.0f,   0.75f,   0.0f);
         UpPositionLegend.Draw(m_upPositionLegend, true, 0.0f, 4.0f, 1.0f);
      glPopMatrix();

      glPushMatrix();
         glTranslatef(0.0f,   -0.55f,  0.0f);
         DownPositionLegend.Draw(m_downPositionLegend,   true, 0.0f, 4.0f, 1.0f);
      glPopMatrix();

      glPushMatrix();
         glTranslatef(-0.55f, 0.00f,   0.0f);
         LeftPositionLegend.Draw(m_leftPositionLegend,   false, 0.0f, 4.0f, 1.0f);
      glPopMatrix();

      glPushMatrix();
         glTranslatef(0.55f,  0.00f,   0.0f);
         RightPositionLegend.Draw(m_rightPositionLegend, false, 0.0f, 4.0f, 1.0f);
      glPopMatrix();


      glPushMatrix();
         if (m_horizontal)
            glRotatef(m_switch_angle, 0.0f, 1.0f, 0.0f);
         else
            glRotatef(m_switch_angle, 1.0f, 0.0f, 0.0f);

         if (m_number_of_levers  == 2)
         {
            glPushMatrix();
               glTranslatef(-0.10f,   -0.10f,   0.0f);
               theSwitch.Draw(m_switch,   true, 0.0f, 4.5f, 0.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef( 0.10f,   0.00f,   0.0f);
               theSwitch.Draw(m_switch,   true, 0.0f, 4.5f, 0.0f);
            glPopMatrix();
         }
         else if (m_number_of_levers  == 3)
         {
            glPushMatrix();
               glTranslatef(0.0f,   0.00f,   0.0f);
               theSwitch.Draw(m_switch,   true, 0.0f, 4.5f, 0.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef(-0.20f, 0.00f,   0.0f);
               theSwitch.Draw(m_switch,   true, 0.0f, 4.5f, 0.0f);
            glPopMatrix();
            glPushMatrix();
               glTranslatef(0.20f,  0.00f,   0.0f);
               theSwitch.Draw(m_switch,   true, 0.0f, 4.5f, 0.0f);
            glPopMatrix();
         }
         else  // Draw a single lever.
         {
            glPushMatrix();
               glTranslatef(0.0f,   0.00f,   0.0f);
               theSwitch.Draw(m_switch,   true, 0.0f, 4.5f, 0.0f);
            glPopMatrix();
         }
      glPopMatrix();
   }
   glPopMatrix();

   EndDraw();
}

void  CSwitch::SetPosition(position_type  position)
{
   m_switch.Format("%c", TOGGLE_SWITCH);

   switch (position)
   {
      case  SWITCH_UP:
         m_switch_angle =  -30.0f;
         m_horizontal   =  false;
         break;

      case  SWITCH_DOWN:
         m_switch_angle =  30.0f;
         m_horizontal   =  false;
         break;

      case  SWITCH_LEFT:
         m_switch_angle =  -30.0f;
         m_horizontal   =  true;
         break;

      case  SWITCH_RIGHT:
         m_switch_angle =  30.0f;
         m_horizontal   =  true;
         break;

      default:
         m_switch_angle =  0.0f;
         m_horizontal   =  false;
         break;
   }
}

void  CSwitch::SetLegends(CString main, CString up, CString down, CString left, CString right, CString normal)
{
   m_theLegend             =  main;
   m_upPositionLegend      =  up;
   m_downPositionLegend    =  down;
   m_leftPositionLegend    =  left;
   m_rightPositionLegend   =  right;
   m_normalPositionLegend  =  normal;
}

void  CSwitch::SetNumberOfLevers(int number_of_levers)
{
   m_number_of_levers   =  number_of_levers;
}

CWidget* CSwitch::CreateObject()
{
   return new CSwitch();
}
