// StickPosition.cpp: implementation of the CStickPosition class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "StickPosition.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CStickPosition::CStickPosition()
{
   m_exPtUpperLeft            =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight           =  CExtentsPoint(CPoint(175,175));

   m_stlStrWidgetName         =  _FSI_STL::string("Stick_Position");

   m_stickPosition_x          =  0.0f;
   m_stickPosition_y          =  0.0f;

   m_stickPosition_x_cv       =  m_stickPosition_x;
   m_stickPosition_y_cv       =  m_stickPosition_y;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Stick X Position");
   m_listGraphicalElementVars.push_back("Stick Y Position");

   m_list   =  -1;
}

CStickPosition::~CStickPosition()
{
}

void  CStickPosition::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   stick_position.Format("STICK  POSN ");
   m_stickPosition_indicator.Format("%c", DIAMOND);
   stickPositionIndicator.SetForegroundColor(0,  192,  0);    // Green

   stickPositionTicksY.Initialize();
   stickPositionTicksY.SetTickStyle(LINEAR, VERTICAL);
   stickPositionTicksY.SetLabelProperties(1.3f   *  m_aspect_ratio, 1.0f);
   stickPositionTicksY.SetLabelRadius(0.20f *  m_aspect_ratio);
   stickPositionTicksY.SetTickLengths(0.0375f *  m_aspect_ratio, 0.0275f *  m_aspect_ratio, 0.0175f *  m_aspect_ratio);


   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  0.75f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, ">100%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  0.60f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "> 80%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  0.45f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "> 60%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  0.30f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "> 40%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  0.15f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "> 20%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  0.00f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, ">  0%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  -0.15f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "> 20%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  -0.30f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "> 40%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  -0.45f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "> 60%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  -0.60f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "> 80%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   tick_info.location   =  -0.75f *  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, ">100%");
   stickPositionTicksY.TickList.AddTail(tick_info);

   stickPositionTicksY.GenerateLists();


   stickPositionTicksX.Initialize();
   stickPositionTicksX.SetTickStyle(LINEAR, HORIZONTAL);
   stickPositionTicksX.SetLabelProperties(1.3f   *  m_aspect_ratio, 1.0f);
   stickPositionTicksX.SetLabelRadius(0.20f *  m_aspect_ratio);
   stickPositionTicksX.SetTickLengths(0.0375f *  m_aspect_ratio, 0.0275f *  m_aspect_ratio, 0.0175f *  m_aspect_ratio);



   strcpy(tick_info.ident, "");

   tick_info.location   =  0.75f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "^100%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  0.60f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "  80%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  0.45f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "^ 60%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  0.30f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, " 40%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  0.15f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "^ 20%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  0.00f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "  0%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  -0.15f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "^ 20%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  -0.30f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, " 40%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  -0.45f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "^ 60%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  -0.60f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, " 80%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   tick_info.location   =  -0.75f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "^100%");
   stickPositionTicksX.TickList.AddTail(tick_info);

   stickPositionTicksX.GenerateLists();

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();

         glPushMatrix();
            glTranslatef(0.0f, 0.75f, 0.0f);
            m_title.Draw(stick_position,  true, 0.0f, 3.0f *  m_aspect_ratio, 1.0f);
         glPopMatrix();

         stickPositionTicksX.Draw();
         stickPositionTicksY.Draw();
      }
      glPopMatrix();
   }
   glEndList();
}

void  CStickPosition::Render(void)
{
   BeginDraw();


   glPushMatrix();
   {
      glCallList(m_list);

      glTranslatef(m_stickPosition_x *  m_aspect_ratio, m_stickPosition_y *  m_aspect_ratio, 0.0f);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         stickPositionIndicator.Draw(m_stickPosition_indicator,   true, 90.0f, 5.0f *  m_aspect_ratio, 1.0f);
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glPopMatrix();

   EndDraw();
}

void  CStickPosition::SetStickXPosition(float x)
{
   m_stickPosition_x_cv =  ((x /  13.5f)   *  -0.75f);
}

void  CStickPosition::SetStickYPosition(float y)
{
   m_stickPosition_y_cv =  ((y /  14.5f)   *  0.75f);
}

CWidget* CStickPosition::CreateObject()
{
   return new CStickPosition();
}

void CStickPosition::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Stick X Position")
   {
      SetStickXPosition(*pVariant);
   }
   else if (rstrElementVar == "Stick Y Position")
   {
      SetStickYPosition(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CStickPosition::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CStickPosition::UpdateRenderVariables()
{
   m_stickPosition_x       =  m_stickPosition_x_cv;
   m_stickPosition_y       =  m_stickPosition_y_cv;

   return CWidget::UpdateRenderVariables();
}

