// SpeedBrake.cpp: implementation of the CSpeedBrake class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "SpeedBrake.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSpeedBrake::CSpeedBrake()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Speed_Brake");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(64,64));

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("annunciator_speed_brake");

   m_list   =  -1;
}

CSpeedBrake::~CSpeedBrake()
{
}

void  CSpeedBrake::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   annunciator_cv.Initialize();
   annunciator_cv.SetPosition(0.0f, 0.20f);
   annunciator_cv.SetTitle("SPEED\nBRAKE", 7.5f, 1.0f);
   annunciator_cv.SetTitleColor(0,  192,  0);   // Green
   annunciator_cv.SetCondition(false);

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      CPanel::Draw();   // Draw the standard stuff, (bezel, screw heads, and primary title).
   }
   glEndList();
}

void  CSpeedBrake::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      annunciator.Draw();
   }
   glPopMatrix();

   EndDraw();
}

CWidget* CSpeedBrake::CreateObject()
{
   return new CSpeedBrake();
}

void CSpeedBrake::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "annunciator_speed_brake")
      annunciator_cv.SetCondition(*pVariant);

}

/////////////////////////////////////////////////////////////////////////////
//
// bool CSpeedBrake::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 24 June 1999
//
// Engineer         : Charles Brissey
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CSpeedBrake::UpdateRenderVariables()
{
   annunciator =  annunciator_cv;

   return CWidget::UpdateRenderVariables();
}

