// RudderPosition.cpp: implementation of the CRudderPosition class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "RudderPosition.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRudderPosition::CRudderPosition()
{
   m_exPtUpperLeft         =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight        =  CExtentsPoint(CPoint(175,75));

   m_stlStrWidgetName      =  _FSI_STL::string("Rudder_Position");
   m_rudderPosition_offset =  0.0f;

   m_rudderPosition_offset_cv =  m_rudderPosition_offset;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Rudder Position Percentage");

   m_list   =  -1;
}

CRudderPosition::~CRudderPosition()
{
}

void  CRudderPosition::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());


   rudder_position.Format("RUDDER POSITION");
   m_rudderPosition_indicator.Format("%c", DIAMOND);
   rudderPositionIndicator.SetForegroundColor(0,  192,  0);    // Green

   rudderPositionTicks.Initialize();
   rudderPositionTicks.SetTickStyle(LINEAR, HORIZONTAL);
   rudderPositionTicks.SetLabelProperties(1.25f  /  m_aspect_ratio, 1.0f);
   rudderPositionTicks.SetLabelRadius(0.100f    /  m_aspect_ratio);
   rudderPositionTicks.SetTickLengths(0.0375f   /  m_aspect_ratio, 0.0275f /  m_aspect_ratio, 0.0175f /  m_aspect_ratio);


   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  0.700f   /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "R");
   rudderPositionTicks.TickList.AddTail(tick_info);

   strcpy(tick_info.ident, "");
   tick_info.location   =  0.525f   /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "75%");
   rudderPositionTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.350f   /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "^50%");
   rudderPositionTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.175f   /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "25%");
   rudderPositionTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.000f   /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "N");
   rudderPositionTicks.TickList.AddTail(tick_info);

   strcpy(tick_info.ident, "");
   tick_info.location   =  -0.175f  /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "-25%");
   rudderPositionTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -0.350f  /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "^-50%");
   rudderPositionTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -0.525f  /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
//   strcpy(tick_info.ident, "-75%");
   rudderPositionTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -0.700f  /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "L");
   rudderPositionTicks.TickList.AddTail(tick_info);

   rudderPositionTicks.GenerateLists();

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();

         glTranslatef(0.0f, 0.20f /  m_aspect_ratio, 0.0f);
         m_title.Draw(rudder_position, true, 0.0f, 1.25f /  m_aspect_ratio, 1.0f);
         glTranslatef(0.0f, -0.20f / m_aspect_ratio, 0.0f);

         rudderPositionTicks.Draw();
      }
      glPopMatrix();
   }
   glEndList();
}

void  CRudderPosition::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);
 
      glTranslatef(m_rudderPosition_offset /  m_aspect_ratio, 0.0f, 0.0f);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         rudderPositionIndicator.Draw(m_rudderPosition_indicator, true, 0.0f, 1.75f /  m_aspect_ratio, 1.0f);
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glPopMatrix();

   EndDraw();
}

void  CRudderPosition::SetRudderPositionOffset(float offset)
{
   m_rudderPosition_offset_cv  =  ((offset /  17.5f)   *  0.7f);
}

CWidget* CRudderPosition::CreateObject()
{
   return new CRudderPosition();
}

void CRudderPosition::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Rudder Position Percentage")
   {
      SetRudderPositionOffset(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CRudderPosition::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CRudderPosition::UpdateRenderVariables()
{
   m_rudderPosition_offset =  m_rudderPosition_offset_cv;

   return CWidget::UpdateRenderVariables();
}
