// RotarySwitch.cpp: implementation of the CRotarySwitch class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "RotarySwitch.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRotarySwitch::CRotarySwitch()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Rotary_Switch");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(96,96));

   m_list   =  -1;
}

CRotarySwitch::~CRotarySwitch()
{
}

void  CRotarySwitch::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());


   theTicks.Initialize();
   theTicks.SetLabelRadius(0.70f);
   theTicks.SetOuterRadius(0.45f);
   theTicks.SetLabelProperties(3.0f, 1.0f);
   theTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   tick_info.location   =  225.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "OFF");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "BRT");
   theTicks.TickList.AddTail(tick_info);

   theTicks.GenerateLists();

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      CPanel::Draw();   // Draw the standard stuff, (bezel, screw heads, and primary title).
   }
   glEndList();
}

void  CRotarySwitch::Render(void)
{
   BeginDraw(0.25f, 0.25f, 0.25f);

   glPushMatrix();
   {
      glCallList(m_list);


      // All of this needs to be revised and put where possible into the
      // display list in Setup.
      if (m_title_y  >  0.0f)
         glTranslatef(0.0f,  -0.20f,   0.0f);
      else
         glTranslatef(0.0f,   0.20f,   0.0f);

      glPushMatrix();
         glTranslatef(m_title_x, m_title_y,   0.0f);
         theLegend.Draw(m_title, true, 0.0f, 3.0f, 1.0f);
      glPopMatrix();

      GLUquadricObj  *pquad   =  gluNewQuadric();
         glPushMatrix();
            glRGB(0, 0, 0);
            gluDisk(pquad, 0.25f,  0.28f, 30, 1);
            glRGB(32, 32, 32);
            gluDisk(pquad, 0.20f,  0.25f, 30, 1);
            glRGB(80, 80, 80);
            gluDisk(pquad, 0.00f,  0.20f, 30, 1);
         glPopMatrix();
      gluDeleteQuadric(pquad);

      theTicks.Draw();
      theTicks.DrawArc(false, -135.0f, 135.0f, 1.05f);
   }
   glPopMatrix();

   EndDraw();
}

void  CRotarySwitch::SetTitleAndPosition(CString title, float x, float y)
{
   m_title     =  title;
   m_title_x   =  x;
   m_title_y   =  y;
}

CWidget* CRotarySwitch::CreateObject()
{
   return new CRotarySwitch();
}
