// RMUPanel.h: interface for the CRMUPanel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_RMUPANEL_H__09554B91_75C8_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_RMUPANEL_H__09554B91_75C8_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"
#include "..\core\OpenGLText.h"

class CRMUPanel : public COpenGLWidget, public CPanel
{
public:
	CRMUPanel();
	virtual ~CRMUPanel();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();
   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

private:
   CString     uhf;
   COpenGLtext UHFLegend;
   COpenGLtext UHFActiveFrequency;
   void        SetUHFActiveFrequency(long UHF_frequency);
   CString     m_UHFActiveFrequency;
   CString     m_UHFActiveFrequency_cv;

   void        SetUHFMode(bool UHF_Mode);
   CString     m_UHFMode;
   CString     m_UHFMode_cv;

   void        SetUHFChannel(long UHF_Channel);
   CString     m_UHFChannel;
   CString     m_UHFChannel_cv;
   CString     m_UHFDisplay;

   bool        m_UHF_Channel_valid;
   bool        m_UHF_Channel_valid_cv;

   CString     vhf;
   COpenGLtext VHFLegend;
   COpenGLtext VHFActiveFrequency;
   void        SetVHFActiveFrequency(long VHF_frequency);
   CString     m_VHFActiveFrequency;
   CString     m_VHFActiveFrequency_cv;
   bool        m_Nav_Pwr_Fail;
   bool        m_Nav_Pwr_Fail_cv;

   void        SetVHFChannel(long VHF_Channel);
   CString     m_VHFChannel;
   CString     m_VHFChannel_cv;
   CString     m_VHFDisplay;

   bool        m_VHF_Channel_valid;
   bool        m_VHF_Channel_valid_cv;

#ifndef  HAF
   CString     atc;
   COpenGLtext ATCLegend;
   COpenGLtext ATCCode;
   void        SetATCCode(long ATC_code);
   CString     m_CStr_ATCCode;
   CString     m_CStr_ATCCode_cv;

   COpenGLtext ATCMode;
   CString     m_CStr_ATCMode;
   long        m_ATC_Mode;
   long        m_ATC_Mode_cv;

   bool        m_bool_Atc_Ident;
   bool        m_bool_Atc_Ident_cv;
   CString     m_CStr_Atc_Ident;

   CString     flightId;
   COpenGLtext flightIdLegend;
   COpenGLtext flightIdText;
   CString     m_CStr_flightId;
   CString     m_CStr_flightId_cv;
#else
   CString     tacan;
   COpenGLtext TACANLegend;
   COpenGLtext TACANCode;
   void        SetTACANCode(long TACAN_code);
   CString     m_CStr_TACANCode;
   CString     m_CStr_TACANCode_cv;

   COpenGLtext TACANMode;
   CString     m_CStr_TACANMode;
   long        m_TACAN_Mode;
   long        m_TACAN_Mode_cv;

   bool        m_bool_Tacan_XY;
   bool        m_bool_Tacan_XY_cv;
   CString     m_CStr_Tacan_XY;
#endif

   CString     nav;
   COpenGLtext NavLegend;
   COpenGLtext NavActiveFrequency;
   void        SetNavActiveFrequency(long nav_frequency);
   CString     m_navActiveFrequency;
   CString     m_navActiveFrequency_cv;

   CString     dme;
   COpenGLtext DMELegend;
   COpenGLtext DMEHold;
   void        SetDMEHold(bool DME_Hold);
   CString     m_DMEHold;
   CString     m_DMEHold_cv;

   bool        m_bool_RMU_Power;
   bool        m_bool_RMU_Power_cv;

   bool        m_bool_Uhf_Tx;
   bool        m_bool_Uhf_Tx_cv;

   bool        m_bool_Vhf_Tx;
   bool        m_bool_Vhf_Tx_cv;

   CString     m_CStr_transmit;

   COpenGLtext Remote;
   CString     m_CStr_remote;
   bool        m_bool_remote;
   bool        m_bool_remote_cv;

// Attributes
public:
  	enum { IDB = IDB_RMU  };
};

#endif // !defined(AFX_RMUPANEL_H__09554B91_75C8_11D2_AD4F_006008B0E0C3__INCLUDED_)
