// RMUPanel.cpp: implementation of the CRMUPanel class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "..\core\dataconversion.h"
#include "RMUPanel.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CRMUPanel::CRMUPanel()
{
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(128,64));
   m_stlStrWidgetName   =  _FSI_STL::string("RMU_Panel");

   float frequency   =  (float)(399975)/1000.0f;

   // The format %5.4lf would show four places after the decimal, but %5.2lf would
   // cause the value to be rounded before showing two places after the decimal.
   // The following code truncates the value to two places after the decimal without rounding.
   CString  value;
   value.Format("%5.4lf",  frequency);            
   m_UHFActiveFrequency.Format("%.6s", value);
   m_UHFActiveFrequency_cv    =  m_UHFActiveFrequency;

   m_UHFMode.Format("M");
   m_UHFMode_cv               =  m_UHFMode;
   
   m_UHFChannel.Format("20");
   m_UHFChannel_cv            =  m_UHFChannel;
   
   m_UHF_Channel_valid        =  false;
   m_UHF_Channel_valid_cv     =  m_UHF_Channel_valid;


   frequency   =  (float)(118275)/1000.0f;
   value.Format("%5.4lf",  frequency);            
   m_VHFActiveFrequency.Format("%.6s", value);
   m_VHFActiveFrequency_cv    =  m_VHFActiveFrequency;
   m_VHFChannel.Format("  ");
   m_VHFChannel_cv            =  m_VHFChannel;
   
   m_VHF_Channel_valid        =  false;
   m_VHF_Channel_valid_cv     =  m_VHF_Channel_valid;
   
#ifndef  HAF
   m_CStr_ATCCode             =  "1234";
   m_CStr_ATCCode_cv          =  m_CStr_ATCCode;

   m_ATC_Mode                 =  0;
   m_ATC_Mode_cv              =  m_ATC_Mode;
   m_CStr_ATCMode             =  "STBY";

   m_bool_Atc_Ident           =  false;
   m_bool_Atc_Ident_cv        =  false;
   m_CStr_Atc_Ident           =  "IDT";

   m_CStr_flightId            =  "";
   m_CStr_flightId_cv         =  m_CStr_flightId;
#else
   m_CStr_TACANCode           =  "123";
   m_CStr_TACANCode_cv        =  m_CStr_TACANCode;

   m_TACAN_Mode               =  0;
   m_TACAN_Mode_cv            =  m_TACAN_Mode;
   m_CStr_TACANMode           =  "STBY";

   m_bool_Tacan_XY           =  false;
   m_bool_Tacan_XY_cv        =  false;
   m_CStr_Tacan_XY           =  "X";
#endif

   m_bool_RMU_Power           =  true;
   m_bool_RMU_Power_cv        =  m_bool_RMU_Power;

   m_bool_Uhf_Tx              =  false;
   m_bool_Uhf_Tx_cv           =  false;
   m_bool_Vhf_Tx              =  false;
   m_bool_Vhf_Tx_cv           =  false;
   m_CStr_transmit            =  "TX";

   m_Nav_Pwr_Fail             =  false;
   m_Nav_Pwr_Fail_cv          =  m_Nav_Pwr_Fail;

   m_navActiveFrequency.Format("113.80");
   m_navActiveFrequency_cv    =  m_navActiveFrequency;

   m_DMEHold.Format("----");
   m_DMEHold_cv               =  m_DMEHold;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Uhf_Frequency");
   m_listGraphicalElementVars.push_back("Uhf_Mode");
   m_listGraphicalElementVars.push_back("Uhf_Channel");
   m_listGraphicalElementVars.push_back("Uhf_Channel_Active");

   m_listGraphicalElementVars.push_back("Vhf_Frequency");
   m_listGraphicalElementVars.push_back("VHF Channel");
   m_listGraphicalElementVars.push_back("VHF Channel Valid");

#ifndef  HAF
   m_listGraphicalElementVars.push_back("ATC Code");
   m_listGraphicalElementVars.push_back("ATC Mode");
   m_listGraphicalElementVars.push_back("Atc_Ident");
   m_listGraphicalElementVars.push_back("Flight ID");
#else
   m_listGraphicalElementVars.push_back("TACAN Code");
   m_listGraphicalElementVars.push_back("TACAN Mode");
   m_listGraphicalElementVars.push_back("TACAN XY");
#endif

   m_listGraphicalElementVars.push_back("Nav_Frequency");

   m_listGraphicalElementVars.push_back("Dme_Hold");
   m_listGraphicalElementVars.push_back("Ils_Selected");

   m_listGraphicalElementVars.push_back("RMU_Power");

   m_listGraphicalElementVars.push_back("UHF Frequency (backup)");

   m_listGraphicalElementVars.push_back("Uhf_Tx");
   m_listGraphicalElementVars.push_back("Vhf_Tx");

   m_list   =  -1;
}

CRMUPanel::~CRMUPanel()
{
}

void  CRMUPanel::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   UHFActiveFrequency.SetForegroundColor(0,  192,  0);   // Green
   VHFActiveFrequency.SetForegroundColor(0,  192,  0);   // Green

#ifndef  HAF
   ATCCode.SetForegroundColor(0,  192,  0);              // Green
   ATCMode.SetForegroundColor(0,  192,  0);              // Green
   atc   =  "ATC";
   ATCLegend.SetForegroundColor(0,  192,  0);            // Green
   
   flightId = "FLTID";
   flightIdLegend.SetForegroundColor(0, 192, 0);
   flightIdText.SetForegroundColor(0, 192, 0);
#else
   TACANCode.SetForegroundColor(0,  192,  0);              // Green
   TACANMode.SetForegroundColor(0,  192,  0);              // Green
   tacan =  "TACAN";
   TACANLegend.SetForegroundColor(0,  192,  0);            // Green
#endif

   NavActiveFrequency.SetForegroundColor(0,  192,  0);   // Green
   DMEHold.SetForegroundColor(0,  192,  0);              // Green

   uhf   =  "UHF";
   UHFLegend.SetForegroundColor(0,  192,  0);            // Green

   dme   =  "DME";
   DMELegend.SetForegroundColor(0,  192,  0);            // Green

   nav   =  "NAV";
   NavLegend.SetForegroundColor(0,  192,  0);            // Green

   vhf   =  "VHF";
   VHFLegend.SetForegroundColor(0,  192,  0);            // Green

   m_CStr_remote  =  "REMOTE";
   Remote.SetForegroundColor(0,  192,  0);               // Green

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();

         glPushMatrix();
            glTranslatef(-0.75f /  m_aspect_ratio,  1.0f,  0.0f);
            UHFLegend.Draw(uhf,  true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();

         glPushMatrix();
            glTranslatef(-0.75f /  m_aspect_ratio,  0.6f,  0.0f);
            VHFLegend.Draw(vhf,  true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();

#ifndef  HAF
         glPushMatrix();
            glTranslatef(-0.75f /  m_aspect_ratio,  0.2f,  0.0f);
            ATCLegend.Draw(atc,  true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
            
         glPushMatrix();
            glTranslatef(-0.64f /  m_aspect_ratio,  -0.2f,  0.0f);
            flightIdLegend.Draw(flightId,  true, 0.0f, 2.4f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
#else
         glPushMatrix();
            glTranslatef(-0.65f /  m_aspect_ratio,  0.00f,  0.0f);
            TACANLegend.Draw(tacan,  true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
#endif

#ifndef  HAF
         glPushMatrix();
            glTranslatef(-0.75f /  m_aspect_ratio,  -1.0f,  0.0f);
            DMELegend.Draw(dme,   true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
#endif
      }
      glPopMatrix();
   }
   glEndList();
}

void  CRMUPanel::Render(void)
{
   BeginDraw();

   if (m_bool_RMU_Power)
   {
      glPushMatrix();
      {
         glCallList(m_list);

         glPushMatrix();
            glTranslatef(-0.75f /  m_aspect_ratio,  -0.6f,  0.0f);
            NavLegend.Draw(nav,  true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();


         if (m_bool_remote)
         {
            glPushMatrix();
               glTranslatef( 0.25f,  1.0f,  0.0f);
               Remote.Draw(m_CStr_remote, true, 0.0f, 2.5f  /  m_aspect_ratio, 0.0f);
            glPopMatrix();
         }
         else
         {
            glPushMatrix();
               glTranslatef( 0.25f /  m_aspect_ratio,  1.0f,  0.0f);
               if (m_bool_Uhf_Tx)
                  m_UHFDisplay   =  m_UHFMode   +  " "   +  m_UHFChannel   +  m_CStr_transmit   +  " "   +  m_UHFActiveFrequency;
               else
                  m_UHFDisplay   =  m_UHFMode   +  " "   +  m_UHFChannel   +  " "   +  m_UHFActiveFrequency;
               UHFActiveFrequency.Draw(m_UHFDisplay,  true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
            glPopMatrix();
         }
   
         glPushMatrix();
            glTranslatef( 0.25f /  m_aspect_ratio,  0.6f,  0.0f);
            if (m_bool_Vhf_Tx)
               m_VHFDisplay   =  "  "  +  m_VHFChannel   +  m_CStr_transmit   +  " "   +  m_VHFActiveFrequency;
            else
               m_VHFDisplay   =  "  "  +  m_VHFChannel   +  " "   +  m_VHFActiveFrequency;
            VHFActiveFrequency.Draw(m_VHFDisplay,  true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
   

#ifndef  HAF
         glPushMatrix();
            glTranslatef( 0.30f /  m_aspect_ratio,  0.2f,  0.0f);
            ATCCode.Draw(m_CStr_ATCCode,   true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
         
         glPushMatrix();

            CString flightIdJustified;
            m_CStr_flightId.TrimRight();  // trim trailing whitespace
            m_CStr_flightId.TrimLeft();   // trim leading whitespace
            flightIdJustified.Format("%10s", m_CStr_flightId); // right-justify text
            glTranslatef( 0.32f /  m_aspect_ratio,  -0.2f,  0.0f);
            flightIdText.Draw(flightIdJustified,   true, 0.0f, 2.4f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
            

         glPushMatrix();
            glTranslatef(-0.25f /  m_aspect_ratio,  0.2f,  0.0f);
            ATCMode.Draw(m_CStr_ATCMode,   true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();

         if (m_bool_Atc_Ident)
         {
            glPushMatrix();
               glTranslatef( 0.75f /  m_aspect_ratio,  0.2f,  0.0f);
               ATCCode.Draw(m_CStr_Atc_Ident,   true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
            glPopMatrix();
         }
#else
         glPushMatrix();
            glTranslatef(0.50f /  m_aspect_ratio,  0.00f,  0.0f);
            TACANCode.Draw(m_CStr_TACANCode,   true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();

         glPushMatrix();
            glTranslatef(0.00f /  m_aspect_ratio,  0.00f,  0.0f);
            TACANMode.Draw(m_CStr_TACANMode,   true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();

         glPushMatrix();
            glTranslatef(0.90f /  m_aspect_ratio,  0.00f,  0.0f);
            TACANCode.Draw(m_CStr_Tacan_XY,   true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
#endif

         if (m_Nav_Pwr_Fail)
             m_navActiveFrequency = "---.--";
         glPushMatrix();
            glTranslatef( 0.40f /  m_aspect_ratio,  -0.6f,  0.0f);
            NavActiveFrequency.Draw(m_navActiveFrequency,   true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();

#ifndef  HAF
         glPushMatrix();
            glTranslatef( 0.40f /  m_aspect_ratio,  -1.0f,  0.0f);
            DMEHold.Draw(m_DMEHold, true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);
         glPopMatrix();
#endif
      }
      glPopMatrix();
   }
   else
   {
      // Draw the standard stuff, (bezel, screw heads, and primary title).
      CPanel::Draw();
   }

   EndDraw();
}

void  CRMUPanel::SetUHFActiveFrequency(long UHF_frequency)
{
   float frequency   =  (float)(UHF_frequency)/1000.0f;

   // The format %5.4lf would show four places after the decimal, but %5.2lf would
   // cause the value to be rounded before showing two places after the decimal.
   // The following code truncates the value to two places after the decimal without rounding.
   CString  value;
   value.Format("%5.4lf",  frequency);            
   m_UHFActiveFrequency_cv.Format("%.6s", value);
}

void  CRMUPanel::SetUHFMode(bool UHF_Mode)
{
   if (UHF_Mode)
      m_UHFMode_cv.Format("B");  // Both
   else
      m_UHFMode_cv.Format("M");  // Main
}

void  CRMUPanel::SetUHFChannel(long UHF_Channel)
{
   if (m_UHF_Channel_valid_cv)
      m_UHFChannel_cv.Format("%d", UHF_Channel);
   else
      m_UHFChannel_cv.Format("  ");
}


void  CRMUPanel::SetVHFActiveFrequency(long VHF_frequency)
{
   float frequency   =  (float)(VHF_frequency)/1000.0f;

   // The format %5.4lf would show four places after the decimal, but %5.2lf would
   // cause the value to be rounded before showing two places after the decimal.
   // The following code truncates the value to two places after the decimal without rounding.
   CString  value;
   value.Format("%5.4lf",  frequency);            
   m_VHFActiveFrequency_cv.Format("%.6s", value);
}

void  CRMUPanel::SetVHFChannel(long VHF_Channel)
{
   if (m_VHF_Channel_valid_cv)
      m_VHFChannel_cv.Format("%d", VHF_Channel);
   else
      m_VHFChannel_cv.Format("  ");
}


#ifndef  HAF

void  CRMUPanel::SetATCCode(long	ATC_code)
{
   m_CStr_ATCCode_cv.Format("%4d", ATC_code);
}

#else

void  CRMUPanel::SetTACANCode(long	TACAN_code)
{
   m_CStr_TACANCode_cv.Format("%3d", TACAN_code);
}

#endif


void  CRMUPanel::SetNavActiveFrequency(long nav_frequency)
{
   m_navActiveFrequency_cv.Format("%4.2f", (float)(nav_frequency)/100.0f);
}


void  CRMUPanel::SetDMEHold(bool DME_Hold)
{
   if (DME_Hold)
      m_DMEHold_cv.Format("HOLD");
   else
      m_DMEHold_cv.Format("----");
}


CWidget* CRMUPanel::CreateObject()
{
   return new CRMUPanel();
}


void CRMUPanel::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
      return;
   }
   CVariant *pVariant   =  pCV->Variant();

   if (rstrElementVar   == "Uhf_Frequency")
   {
      SetUHFActiveFrequency((long)*pVariant);
   }
   else if (rstrElementVar   == "Uhf_Mode")
   {
      SetUHFMode((bool)*pVariant);
   }
   else if (rstrElementVar   == "Uhf_Channel")
   {
      SetUHFChannel((long)*pVariant);
   }
   else if (rstrElementVar   == "Uhf_Channel_Active")
   {
      m_UHF_Channel_valid_cv  =  (bool)*pVariant;
   }
   else if (rstrElementVar == "Vhf_Frequency")
   {
      SetVHFActiveFrequency((long)*pVariant);
   }
   else if (rstrElementVar == "VHF Channel")
   {
      SetVHFChannel((long)*pVariant);
   }
   else if (rstrElementVar   == "VHF Channel Valid")
   {
      m_VHF_Channel_valid_cv  =  (bool)*pVariant;
   }
#ifndef  HAF
   else if (rstrElementVar == "ATC Code")
   {
      SetATCCode((long)*pVariant);
   }
   else if (rstrElementVar == "ATC Mode")
   {
      m_ATC_Mode_cv  =  (long)*pVariant;
   }
   else if (rstrElementVar == "Atc_Ident")
   {
      m_bool_Atc_Ident_cv  =  (bool)*pVariant;
   }
   else if (rstrElementVar == "Flight ID")
   {
       m_CStr_flightId_cv = (char*)((_FSI_STL::string)*pVariant).c_str();
   }
#else
   else if (rstrElementVar == "TACAN Code")
   {
      SetTACANCode((long)*pVariant);
   }
   else if (rstrElementVar == "TACAN Mode")
   {
      m_TACAN_Mode_cv  =  (long)*pVariant;
   }
   else if (rstrElementVar == "TACAN XY")
   {
      m_bool_Tacan_XY_cv   =  (bool)*pVariant;
   }
#endif
   else if (rstrElementVar == "Nav_Frequency")
   {
      SetNavActiveFrequency((long)*pVariant);
   }
   else if (rstrElementVar == "Dme_Hold")
   {
      SetDMEHold((bool)*pVariant);
   }
   else if (rstrElementVar == "Ils_Selected")
   {
      bool  ils_selected   =  (bool)*pVariant;

      if (ils_selected)
         nav.Format("LOC");
      else
         nav.Format("VOR");
   }
   else if (rstrElementVar == "RMU_Power")
   {
      m_bool_RMU_Power_cv  =  (bool)*pVariant;
   }
   else if (rstrElementVar == "UHF Frequency (backup)")
   {
      if ((long)*pVariant)
         m_bool_remote_cv  =  true;
      else
         m_bool_remote_cv  =  false;
   }
   else if (rstrElementVar == "Uhf_Tx")
   {
      m_bool_Uhf_Tx_cv     =  (bool)*pVariant;
   }
   else if (rstrElementVar == "Vhf_Tx")
   {
      m_bool_Vhf_Tx_cv     =  (bool)*pVariant;
   }
   else if (rstrElementVar == "Nav Pwr Fail")
   {
      m_Nav_Pwr_Fail_cv    =  (bool)*pVariant;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CRMUPanel::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CRMUPanel::UpdateRenderVariables()
{
   m_UHFActiveFrequency    =  m_UHFActiveFrequency_cv;
   m_UHFMode               =  m_UHFMode_cv;
   m_UHFChannel            =  m_UHFChannel_cv;
   m_UHF_Channel_valid     =  m_UHF_Channel_valid_cv;

   m_VHFActiveFrequency    =  m_VHFActiveFrequency_cv;
   m_VHFChannel            =  m_VHFChannel_cv;
   m_VHF_Channel_valid     =  m_VHF_Channel_valid_cv;

   m_Nav_Pwr_Fail          =  m_Nav_Pwr_Fail_cv;

   m_navActiveFrequency    =  m_navActiveFrequency_cv;
   m_DMEHold               =  m_DMEHold_cv;

   m_bool_RMU_Power        =  m_bool_RMU_Power_cv;

   m_bool_remote           =  m_bool_remote_cv;

   m_bool_Uhf_Tx           =  m_bool_Uhf_Tx_cv;
   m_bool_Vhf_Tx           =  m_bool_Vhf_Tx_cv;

#ifndef  HAF
   m_CStr_ATCCode          =  m_CStr_ATCCode_cv;
   m_ATC_Mode              =  m_ATC_Mode_cv;
   m_bool_Atc_Ident        =  m_bool_Atc_Ident_cv;

   switch   (m_ATC_Mode)
   {
      case  0:
         m_CStr_ATCMode   =  "STBY";
         break;

      case  1:
         m_CStr_ATCMode   =  "ON";
         break;

      case  2:
         m_CStr_ATCMode   =  "ALT";
         break;
   }

   m_CStr_flightId         =  m_CStr_flightId_cv;
#else
   m_CStr_TACANCode        =  m_CStr_TACANCode_cv;
   m_TACAN_Mode            =  m_TACAN_Mode_cv;
   m_bool_Tacan_XY         =  m_bool_Tacan_XY_cv;

   if (m_bool_Tacan_XY)
      m_CStr_Tacan_XY   =  "X";
   else
      m_CStr_Tacan_XY   =  "Y";

   switch   (m_TACAN_Mode)
   {
      case  0:
         m_CStr_TACANMode  =  "STBY";
         break;

      case  1:
         m_CStr_TACANMode  =  "A/G";
         break;

      case  3:
         m_CStr_TACANMode  =  "A/A";
         break;
   }
#endif

   return CWidget::UpdateRenderVariables();
}
