// Panel.h: interface for the CPanel class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PANEL_H__E02411DA_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_PANEL_H__E02411DA_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <afxtempl.h>
#include <gl\gl.h>              // OpenGL
#include <gl\glu.h>             // GLU library
#include <gl\glaux.h>		// Header File For The Glaux Library
#include "resource.h"
#include "..\core\Ticks.h"

#define  glRGB(x, y, z) glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)

class CPanel  
{
public:
	CPanel();
	virtual ~CPanel();

   virtual  void  Initialize(HWND hwnd);
   virtual  void  Draw(void);

   float m_aspect_ratio;
   float m_width;
   float m_height;

   CRect rectView;
   CRect rectViewCoord;

protected:
   void  BeginDraw(float red = 0.5f, float green = 0.5f, float blue = 0.5f);
   void  EndDraw(void);
   bool  m_update;
   COpenGLtext plus;
   COpenGLtext o;

   float outer[8][2];
   float middle[8][2];
   float inner[8][2];
   float x_center;
   float y_center;

   int   m_bezel_list;
   int   m_list;

private:
	float m_border;
   void  DrawBezel(void);
   void  DrawScrewHeads(void);
   void  DrawScrewHead(void);
   HWND  m_hwnd;

   bool  LoadGLTextures();
   AUX_RGBImageRec   *LoadBMP(const char *Filename);
   static   GLuint   m_texture[3];
   static   bool     m_is_loaded;

};

#endif // !defined(AFX_PANEL_H__E02411DA_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
