// Panel.cpp: implementation of the CPanel class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "..\core\widget.h"
#include "Panel.h"
#include "..\general\OpenGLWidget.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

GLuint   CPanel::m_texture[3] =  {  0, 0, 0  };
bool     CPanel::m_is_loaded  =  false;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPanel::CPanel()
{
   m_border          =  0.1f;
   m_aspect_ratio    =  1.0f;
   m_bezel_list      =  -1;
   m_list            =  -1;
}

CPanel::~CPanel()
{
   if (m_bezel_list != -1)
      glDeleteLists(m_bezel_list, 1);

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_is_loaded  =  false;

   if (m_texture[0]  != 0)
      glDeleteTextures(3, &m_texture[0]);
}

void  CPanel::Initialize(HWND hwnd)
{
   m_hwnd   =  hwnd;

   CRect rectangle;
   GetWindowRect(hwnd, &rectangle);

   m_width  =  (float)rectangle.Width();
   m_height =  (float)rectangle.Height();

   rectViewCoord = rectangle;
   rectView = CRect(0,0,1152,800);

   // Get the size of the view.
   CWnd* pWnd = CWnd::FromHandle(m_hwnd);
   CFrameWnd* pFrame = pWnd->GetParentFrame();
   if (pFrame != NULL)
   {
       CView* pView = pFrame->GetActiveView();
       if (pView != NULL)
       {
           pView->GetWindowRect(&rectView);
           pView->ScreenToClient(&rectViewCoord);
       }
   }

   m_aspect_ratio =  m_height /  m_width;


   if (!LoadGLTextures())
      return;

/*
   if (m_aspect_ratio   <= 1.0f && m_aspect_ratio > 0.0f)
   {
      outer[0][0] =  -1.0f / m_aspect_ratio;
      outer[1][0] =  (-1.0f +  2.0f  *  m_border   *  m_aspect_ratio) / m_aspect_ratio;
      outer[2][0] =  ( 1.0f -  2.0f  *  m_border   *  m_aspect_ratio) / m_aspect_ratio;
      outer[3][0] =   1.0f / m_aspect_ratio;
      outer[4][0] =   1.0f / m_aspect_ratio;
      outer[5][0] =  ( 1.0f -  2.0f  *  m_border   *  m_aspect_ratio) / m_aspect_ratio;
      outer[6][0] =  (-1.0f +  2.0f  *  m_border   *  m_aspect_ratio) / m_aspect_ratio;
      outer[7][0] =  -1.0f / m_aspect_ratio;

      outer[0][1] =   1.0f -  2.0f  *  m_border;
      outer[1][1] =   1.0f;
      outer[2][1] =   1.0f;
      outer[3][1] =   1.0f -  2.0f  *  m_border;
      outer[4][1] =  -1.0f +  2.0f  *  m_border;
      outer[5][1] =  -1.0f;
      outer[6][1] =  -1.0f;
      outer[7][1] =  -1.0f +  2.0f  *  m_border;


      middle[0][0]   =  outer[0][0] +  m_border;
      middle[1][0]   =  outer[1][0];
      middle[2][0]   =  outer[2][0];  
      middle[3][0]   =  outer[3][0] -  m_border;
      middle[4][0]   =  outer[4][0] -  m_border;
      middle[5][0]   =  outer[5][0];  
      middle[6][0]   =  outer[6][0];  
      middle[7][0]   =  outer[7][0] +  m_border;

      middle[0][1]   =  outer[0][1]; 
      middle[1][1]   =  outer[1][1] -  m_border;
      middle[2][1]   =  outer[2][1] -  m_border;
      middle[3][1]   =  outer[3][1];  
      middle[4][1]   =  outer[4][1];
      middle[5][1]   =  outer[5][1] +  m_border;
      middle[6][1]   =  outer[6][1] +  m_border;
      middle[7][1]   =  outer[7][1];

      float border   =  m_border *  1.5f;
      inner[0][0]    =  outer[0][0] +  border;
      inner[1][0]    =  outer[1][0];
      inner[2][0]    =  outer[2][0];  
      inner[3][0]    =  outer[3][0] -  border;
      inner[4][0]    =  outer[4][0] -  border;
      inner[5][0]    =  outer[5][0];  
      inner[6][0]    =  outer[6][0];  
      inner[7][0]    =  outer[7][0] +  border;

      inner[0][1]    =  outer[0][1]; 
      inner[1][1]    =  outer[1][1] -  border;
      inner[2][1]    =  outer[2][1] -  border;
      inner[3][1]    =  outer[3][1];  
      inner[4][1]    =  outer[4][1];
      inner[5][1]    =  outer[5][1] +  border;
      inner[6][1]    =  outer[6][1] +  border;
      inner[7][1]    =  outer[7][1];
   }
   else
   {
      outer[0][0] =  -1.0f;
      outer[1][0] =  -1.0f +  2.0f  *  m_border;
      outer[2][0] =   1.0f -  2.0f  *  m_border;
      outer[3][0] =   1.0f;
      outer[4][0] =   1.0f;
      outer[5][0] =   1.0f -  2.0f  *  m_border;
      outer[6][0] =  -1.0f +  2.0f  *  m_border;
      outer[7][0] =  -1.0f;

      outer[0][1] =  ( 1.0f -  2.0f  *  m_border   /  m_aspect_ratio) * m_aspect_ratio;
      outer[1][1] =   1.0f * m_aspect_ratio;
      outer[2][1] =   1.0f * m_aspect_ratio;
      outer[3][1] =  ( 1.0f -  2.0f  *  m_border   /  m_aspect_ratio) * m_aspect_ratio;
      outer[4][1] =  (-1.0f +  2.0f  *  m_border   /  m_aspect_ratio) * m_aspect_ratio;
      outer[5][1] =  -1.0f * m_aspect_ratio;
      outer[6][1] =  -1.0f * m_aspect_ratio;
      outer[7][1] =  (-1.0f +  2.0f  *  m_border   /  m_aspect_ratio) * m_aspect_ratio;


      middle[0][0]   =  outer[0][0] +  m_border;
      middle[1][0]   =  outer[1][0];
      middle[2][0]   =  outer[2][0];  
      middle[3][0]   =  outer[3][0] -  m_border; 
      middle[4][0]   =  outer[4][0] -  m_border; 
      middle[5][0]   =  outer[5][0];  
      middle[6][0]   =  outer[6][0];  
      middle[7][0]   =  outer[7][0] +  m_border;

      middle[0][1]   =  outer[0][1];
      middle[1][1]   =  outer[1][1] -  m_border;
      middle[2][1]   =  outer[2][1] -  m_border;
      middle[3][1]   =  outer[3][1];
      middle[4][1]   =  outer[4][1];
      middle[5][1]   =  outer[5][1] +  m_border;
      middle[6][1]   =  outer[6][1] +  m_border;
      middle[7][1]   =  outer[7][1];

      float border   =  m_border *  1.5f;
      inner[0][0]    =  outer[0][0] +  border;
      inner[1][0]    =  outer[1][0];
      inner[2][0]    =  outer[2][0];  
      inner[3][0]    =  outer[3][0] -  border; 
      inner[4][0]    =  outer[4][0] -  border; 
      inner[5][0]    =  outer[5][0];  
      inner[6][0]    =  outer[6][0];  
      inner[7][0]    =  outer[7][0] +  border;

      inner[0][1]    =  outer[0][1];
      inner[1][1]    =  outer[1][1] -  border;
      inner[2][1]    =  outer[2][1] -  border;
      inner[3][1]    =  outer[3][1];
      inner[4][1]    =  outer[4][1];
      inner[5][1]    =  outer[5][1] +  border;
      inner[6][1]    =  outer[6][1] +  border;
      inner[7][1]    =  outer[7][1];
   }

   if (m_aspect_ratio   <= 1.0f && m_aspect_ratio > 0.0f)
   {
      x_center =  1.0f / m_aspect_ratio  -  (m_border  /  2.0f);
      y_center =  1.0f  -  (m_border  /  2.0f);
   }
   else
   {
      x_center =  1.0f  -  (m_border  /  2.0f);
      y_center =  1.0f * m_aspect_ratio -  (m_border  /  2.0f);
   }


   plus.SetForegroundColor(0, 0, 0);
   o.SetForegroundColor(0, 0, 0);

   if (m_bezel_list != -1)
      glDeleteLists(m_bezel_list, 1);

   int ii = 0;
   m_bezel_list = glGenLists(1);
   glNewList(m_bezel_list, GL_COMPILE);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

      glRGB(128, 128, 128);
      // Fill the graphing area with a color different than the background color.
      if (m_aspect_ratio   <= 1.0f && m_aspect_ratio > 0.0f)
      {
         glBegin(GL_QUADS);
            glVertex2f(-1.0f  /  m_aspect_ratio,   -1.0f);
            glVertex2f( 1.0f  /  m_aspect_ratio,   -1.0f);
            glVertex2f( 1.0f  /  m_aspect_ratio,    1.0f);
            glVertex2f(-1.0f  /  m_aspect_ratio,    1.0f);
         glEnd();
      }
      else
      {
         glBegin(GL_QUADS);
            glVertex2f(-1.0f, -1.0f *  m_aspect_ratio);
            glVertex2f( 1.0f, -1.0f *  m_aspect_ratio);
            glVertex2f( 1.0f,  1.0f *  m_aspect_ratio);
            glVertex2f(-1.0f,  1.0f *  m_aspect_ratio);
         glEnd();
      }

      // Draw screw heads.
      DrawScrewHeads();

      glRGB(48, 48, 48);
      glBegin(GL_TRIANGLE_FAN);
         for (ii = 0; ii < 8; ii++)
             glVertex2f(outer[ii][0], outer[ii][1]);
      glEnd();

      glRGB(64, 64, 64);
      glBegin(GL_TRIANGLE_FAN);
         for (ii = 0; ii < 8; ii++)
            glVertex2f(middle[ii][0], middle[ii][1]);
      glEnd();

      glRGB(0, 0, 0);
      glBegin(GL_TRIANGLE_FAN);
         for (ii = 0; ii < 8; ii++)
            glVertex2f(inner[ii][0], inner[ii][1]);
      glEnd();


      glRGB(255, 255, 255);   // White
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   glEndList();
*/
}


void  CPanel::BeginDraw(float red, float green, float blue)
{
   if (m_hwnd == NULL)
   {
      return;
   }

   COpenGLWidget  *pWidget =  dynamic_cast<COpenGLWidget *>(this);
   if (pWidget)
   {
      if (pWidget->GetEditing())
      {
         glViewport(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
         glScissor(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
         glClear(GL_COLOR_BUFFER_BIT);
         Initialize(m_hwnd);
      }
   }


   glViewport(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
   glScissor(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);

   glLoadIdentity();

   glOrtho(-m_width / 2.0f, m_width / 2.0f, -m_height / 2.0f, m_height / 2.0f, 0.0f, -14400.0f);

   glScalef(m_width / 2.0f,  m_height / 2.0f, 1.0f);

   if (m_aspect_ratio  <= 1.0f)
      glScalef(m_aspect_ratio, 1.0f, 1.0f);
   else if (m_aspect_ratio != 0.0f)
      glScalef(1.0f, 1.0f  /  m_aspect_ratio, 1.0f);
}

void  CPanel::EndDraw(void)
{
}

void  CPanel::Draw()
{
//   DrawBezel();

   glEnable(GL_TEXTURE_2D);
   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
   glRGB(0, 0, 0);
   glPolygonMode(GL_FRONT, GL_FILL);

   if (m_aspect_ratio      >= 0.9f  && m_aspect_ratio <= 1.1f)
   {
	   glBindTexture(GL_TEXTURE_2D, m_texture[0]);
      glBegin(GL_QUADS);
         glTexCoord2f(0.0f,   0.0f);   glVertex3f(-1.0f,  -1.0f, 0.0f);
         glTexCoord2f(1.0f,   0.0f);   glVertex3f( 1.0f,  -1.0f, 0.0f);
         glTexCoord2f(1.0f,   1.0f);   glVertex3f( 1.0f,   1.0f, 0.0f);
         glTexCoord2f(0.0f,   1.0f);   glVertex3f(-1.0f,   1.0f, 0.0f);
      glEnd();
   }
   else if (m_aspect_ratio   <= 1.0f && m_aspect_ratio > 0.0f)
   {
	   glBindTexture(GL_TEXTURE_2D, m_texture[1]);
      glBegin(GL_QUADS);
         glTexCoord2f(0.0f,   0.0f);   glVertex3f(-1.0f  /  m_aspect_ratio,  -1.0f, 0.0f);
         glTexCoord2f(1.0f,   0.0f);   glVertex3f( 1.0f  /  m_aspect_ratio,  -1.0f, 0.0f);
         glTexCoord2f(1.0f,   1.0f);   glVertex3f( 1.0f  /  m_aspect_ratio,   1.0f, 0.0f);
         glTexCoord2f(0.0f,   1.0f);   glVertex3f(-1.0f  /  m_aspect_ratio,   1.0f, 0.0f);
      glEnd();
   }
   else
   {
	   glBindTexture(GL_TEXTURE_2D, m_texture[2]);
      glBegin(GL_QUADS);
         glTexCoord2f(0.0f,   0.0f);   glVertex3f(-1.0f, -1.0f *  m_aspect_ratio, 0.0f);
         glTexCoord2f(1.0f,   0.0f);   glVertex3f( 1.0f, -1.0f *  m_aspect_ratio, 0.0f);
         glTexCoord2f(1.0f,   1.0f);   glVertex3f( 1.0f,  1.0f *  m_aspect_ratio, 0.0f);
         glTexCoord2f(0.0f,   1.0f);   glVertex3f(-1.0f,  1.0f *  m_aspect_ratio, 0.0f);
      glEnd();
   }

   glDisable(GL_TEXTURE_2D);
   glPolygonMode(GL_FRONT, GL_LINE);

}

void  CPanel::DrawBezel(void)
{
   glCallList(m_bezel_list);
}

void  CPanel::DrawScrewHeads(void)
{
   // Draw screw heads.
   glPushMatrix();
      glTranslatef(-x_center,  y_center, 0.0f);
      DrawScrewHead();

      glTranslatef( 2.0f*x_center, 0.0f, 0.0f);
      DrawScrewHead();

      glTranslatef( 0.0, -2.0f*y_center, 0.0f);
      DrawScrewHead();

      glTranslatef(-2.0f*x_center, 0.0f, 0.0f);
      DrawScrewHead();
   glPopMatrix();
}

void  CPanel::DrawScrewHead(void)
{
   static   CString  the_plus("+");
   plus.Draw(the_plus,  true, 0.0f, 1.4f, 1.1f);

   static   CString  the_O("O");
   glPushMatrix();
      glScalef(1.5f, 1.0f, 1.0f);
      o.Draw(the_O,        true, 0.0f, 1.4f, 1.1f);
   glPopMatrix();
}


bool  CPanel::LoadGLTextures()                     // Load Bitmaps And Convert To Textures
{
   if (m_is_loaded)
      return   true;

   bool  status[3]   =  {  false, false, false  }; // Status Indicator

   AUX_RGBImageRec   *TextureImage[3];             // Create Storage Space For The Texture
   memset(TextureImage,0,sizeof(void *)*3);        // Set The Pointer To NULL

   glGenTextures(3, &m_texture[0]);                // Create The Texture

   CString  path("Instruments^IMAGES^");
   CWidget::ExpandPath(path);

   // Load The Bitmap, Check For Errors, If Bitmap's Not Found Quit
   if (TextureImage[0]  =  LoadBMP(path + "panel.bmp"))
   {
      status[0]   =  true;                         // Set The Status To TRUE
      glBindTexture(GL_TEXTURE_2D, m_texture[0]);  // Typical Texture Generation Using Data From The Bitmap
      glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[0]->sizeX, TextureImage[0]->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, TextureImage[0]->data);
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
   }

   if (TextureImage[1]  =  LoadBMP(path + "widepanel.bmp"))
   {
      status[1]   =  true;                         // Set The Status To TRUE
      glBindTexture(GL_TEXTURE_2D, m_texture[1]);  // Typical Texture Generation Using Data From The Bitmap
      glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[1]->sizeX, TextureImage[1]->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, TextureImage[1]->data);
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
   }

   if (TextureImage[2]  =  LoadBMP(path + "tallpanel.bmp"))
   {
      status[2]   =  true;                         // Set The Status To TRUE
      glBindTexture(GL_TEXTURE_2D, m_texture[2]);  // Typical Texture Generation Using Data From The Bitmap
      glTexImage2D(GL_TEXTURE_2D, 0, 3, TextureImage[2]->sizeX, TextureImage[2]->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, TextureImage[2]->data);
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
      glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
   }

   for (int ii = 0; ii < 3; ii++)
   {
      if (TextureImage[ii])                     // If Texture Exists
      {
         if (TextureImage[ii]->data)            // If Texture Image Exists
            free(TextureImage[ii]->data);       // Free The Texture Image Memory

         free(TextureImage[ii]);                // Free The Image Structure
      }
   }

   m_is_loaded =  status[0]   && status[1]   && status[2];

   return   m_is_loaded;
}

AUX_RGBImageRec *CPanel::LoadBMP(const char *Filename)
{
   FILE  *File =  NULL;                         // File Handle

   if (!Filename)                               // Make Sure A Filename Was Given
   {
      return   NULL;                            // If Not Return NULL
   }

   File=fopen(Filename,"r");                    // Check To See If The File Exists

   if (File)                                    // Does The File Exist?
   {
      fclose(File);                             // Close The Handle
      return   auxDIBImageLoad(Filename);       // Load The Bitmap And Return A Pointer
   }

   return   NULL;                               // If Load Failed Return NULL
}
