// MissionTime.cpp: implementation of the CMissionTime class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "MissionTime.h"
#include "math.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMissionTime::CMissionTime()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Mission_Time");

   m_mission_time.Format("%02d:%02d:%02d", 0, 0, 0);
   m_mission_time_cv = m_mission_time;
   
   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Mission Time");

   m_list   =  -1;
}

CMissionTime::~CMissionTime()
{
}

void  CMissionTime::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   mission_time   =  "MISSION TIME";

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         CPanel::Draw();   // Draw the standard stuff, (bezel, screw heads, and primary title).

         glTranslatef(0.0f,   0.15f /  m_aspect_ratio,   0.0f);
         MissionTimeLegend.Draw(mission_time,   true, 0.0f, 3.25f /  m_aspect_ratio, 0.0f);
      }
      glPopMatrix();
   }
   glEndList();
}

void  CMissionTime::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      glPushMatrix();
         glTranslatef(0.0f,  -0.15f /  m_aspect_ratio,   0.0f);
         MissionTimeValue.Draw(m_mission_time,  true, 0.0f, 3.25f /  m_aspect_ratio, 0.0f);
      glPopMatrix();
   }
   glPopMatrix();

   EndDraw();
}

void  CMissionTime::SetMissionTime(float mission_time)
{
   int   hours    =  (int)(mission_time / 3600);
   float min_sec  =  (float)fmod(mission_time, 3600.0f);
   int   minutes  =  (int)(min_sec  /  60);
   int   seconds  =  (int)fmod(min_sec, 60.0f);

   m_mission_time_cv.Format("%02d:%02d:%02d", hours, minutes, seconds);
}

CWidget* CMissionTime::CreateObject()
{
   return new CMissionTime();
}

void CMissionTime::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Mission Time")
   {
      SetMissionTime(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CRudderPosition::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CMissionTime::UpdateRenderVariables()
{
   m_mission_time = m_mission_time_cv;

   return CWidget::UpdateRenderVariables();
}
