// MasterWarning.cpp: implementation of the CMasterWarning class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "MasterWarning.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CMasterWarning::CMasterWarning()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Master_Warning");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(64,32));

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("annunciator_master_warning");

   m_list   =  -1;
}

CMasterWarning::~CMasterWarning()
{
}

void  CMasterWarning::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   annunciator_cv.Initialize();
   annunciator_cv.SetPosition(0.0f, 0.15f /  m_aspect_ratio);
   annunciator_cv.SetTitle("MASTER\nWARNING", 4.0f /  m_aspect_ratio, 1.0f);
   annunciator_cv.SetTitleColor(255, 0, 0);
   annunciator_cv.SetCondition(false);

   if (m_list != -1)
   {
      glDeleteLists(m_list, 1);
   }

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      CPanel::Draw();   // Draw the standard stuff, (bezel, screw heads, and primary title).
   }
   glEndList();
}

void  CMasterWarning::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      annunciator.Draw();
   }
   glPopMatrix();

   EndDraw();
}

CWidget* CMasterWarning::CreateObject()
{
   return new CMasterWarning();
}

void CMasterWarning::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "annunciator_master_warning")
      annunciator_cv.SetCondition(*pVariant);

}

/////////////////////////////////////////////////////////////////////////////
//
// bool CMasterWarning::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 24 June 1999
//
// Engineer         : Charles Brissey
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CMasterWarning::UpdateRenderVariables()
{
   annunciator =  annunciator_cv;

   return CWidget::UpdateRenderVariables();
}
