// Light.h: interface for the CLight class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LIGHT_H__C2311AA4_9E7B_11D2_AD5C_006008B0E0C3__INCLUDED_)
#define AFX_LIGHT_H__C2311AA4_9E7B_11D2_AD5C_006008B0E0C3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <afxtempl.h>
#include <gl\gl.h>              // OpenGL
#include <gl\glu.h>             // GLU library
#include "..\core\OpenGLtext.h"

#define  glRGB(x, y, z) glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)

class CLight  
{
public:
	CLight();
	virtual ~CLight();

   virtual  void  Initialize();
   virtual  void  Draw(void);

   void  SetSizeAndPosition(float x_size, float y_size, float x_position, float y_position);
   void  SetColor(int red, int green, int blue);
   void  SetCondition(bool on);

   int   m_red;
   int   m_green;
   int   m_blue;

   float m_x_size;
   float m_y_size;
   float m_x_position;
   float m_y_position;

   bool  m_last_known_condition;
};

#endif // !defined(AFX_LIGHT_H__C2311AA4_9E7B_11D2_AD5C_006008B0E0C3__INCLUDED_)
