// Light.cpp: implementation of the CLight class.
//
//////////////////////////////////////////////////////////////////////
#include "..\core\stdafx.h"
#include "Light.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLight::CLight()
{
}

CLight::~CLight()
{
}

void  CLight::Initialize()
{
   m_x_position            =  0.0f;
   m_y_position            =  0.0f;
   m_last_known_condition  =  true;    // Assume it's on, so initial colors will be set correctly.
}

void  CLight::SetColor(int red, int green, int blue)
{
   m_red    =  red;
   m_green  =  green;
   m_blue   =  blue;
}

void  CLight::SetSizeAndPosition(float x_size, float y_size, float x_position, float y_position)
{
   m_x_size       =  x_size;
   m_y_size       =  y_size;
   m_x_position   =  x_position;
   m_y_position   =  y_position;
}


void  CLight::Draw()
{
   glPushMatrix();
   {
      glTranslatef(m_x_position, m_y_position, 0.0f);

      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glRGB(m_red, m_green, m_blue);
         glBegin(GL_QUADS);
            glVertex2f(-m_x_size /  2.0f,  m_y_size   /  2.0f);
            glVertex2f( m_x_size /  2.0f,  m_y_size   /  2.0f);
            glVertex2f( m_x_size /  2.0f, -m_y_size   /  2.0f);
            glVertex2f(-m_x_size /  2.0f, -m_y_size   /  2.0f);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glPopMatrix();
}


void  CLight::SetCondition(bool condition)
{
   if (m_last_known_condition != condition)
   {
      if (condition)
      {
         m_red    *= 8;
         m_green  *= 8;
         m_blue   *= 8;
      }
      else
      {
         m_red    /= 8;
         m_green  /= 8;
         m_blue   /= 8;
      }
      m_last_known_condition  =  condition;
   }
}
