// LandingGearLights.cpp: implementation of the CLandingGearLights class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "LandingGearLights.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLandingGearLights::CLandingGearLights()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Landing_Gear_Panel");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(128,64));

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Left Landing Gear Green");
   m_listGraphicalElementVars.push_back("Nose Landing Gear Green");
   m_listGraphicalElementVars.push_back("Right Landing Gear Green");
   m_listGraphicalElementVars.push_back("Left Landing Gear Red");
   m_listGraphicalElementVars.push_back("Nose Landing Gear Red");
   m_listGraphicalElementVars.push_back("Right Landing Gear Red");
   m_listGraphicalElementVars.push_back("Landing Gear Handle");

   m_list   =  -1;
}

CLandingGearLights::~CLandingGearLights()
{
}

void  CLandingGearLights::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   const float    x_size      =  0.60f;
   const float    y_size      =  0.40f;
   const float    column[3]   =  
   {  
      -0.600f  /  m_aspect_ratio, 
       0.000f  /  m_aspect_ratio,  
       0.600f  /  m_aspect_ratio   
   };
   const float    row[4]      =  
   {  
       0.0f,
      -y_size,
       y_size,
       0.0f
   };
   CLight   *ptr;

   // First Column
   ptr   =  &landing_gear_lights_cv[LEFT_GEAR_DOWN];
   ptr->Initialize();
   ptr->SetSizeAndPosition(x_size, y_size, column[0],   row[0]);
   ptr->SetColor(0,     192,  0);   // Green
   ptr->SetCondition(false);

   ptr   =  &landing_gear_lights_cv[LEFT_GEAR_UNSAFE];
   ptr->Initialize();
   ptr->SetSizeAndPosition(x_size, y_size, column[0],   row[1]);
   ptr->SetColor(255,   0, 0);      // Red
   ptr->SetCondition(false);


   ptr   =  &landing_gear_lights_cv[NOSE_GEAR_DOWN];
   ptr->Initialize();
   ptr->SetSizeAndPosition(x_size, y_size, column[1],   row[2]);
   ptr->SetColor(0,     192,  0);   // Green
   ptr->SetCondition(false);
   
   ptr   =  &landing_gear_lights_cv[NOSE_GEAR_UNSAFE];
   ptr->Initialize();
   ptr->SetSizeAndPosition(x_size, y_size, column[1],   row[3]);
   ptr->SetColor(255,   0, 0);      // Red
   ptr->SetCondition(false);


   ptr   =  &landing_gear_lights_cv[RIGHT_GEAR_DOWN];
   ptr->Initialize();
   ptr->SetSizeAndPosition(x_size, y_size, column[2],   row[0]);
   ptr->SetColor(0,     192,  0);   // Green
   ptr->SetCondition(false);

   ptr   =  &landing_gear_lights_cv[RIGHT_GEAR_UNSAFE];
   ptr->Initialize();
   ptr->SetSizeAndPosition(x_size, y_size, column[2],   row[1]);
   ptr->SetColor(255,   0, 0);      // Red
   ptr->SetCondition(false);


   m_landing_gear_handle_light.Initialize();
   m_landing_gear_handle_light.SetSizeAndPosition(x_size + 0.2f, y_size, 0.0f, row[1] - 0.15f);
   m_landing_gear_handle_light.SetColor(255, 0, 0);
   m_landing_gear_handle_light.SetCondition(true);


   for (int ii = 0; ii < NUMBER_OF_LIGHTS; ii++)
   {
       landing_gear_lights[ii] = landing_gear_lights_cv[ii];
   }

   m_landing_gear_handle_light_cv = m_landing_gear_handle_light;

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      CPanel::Draw();   // Draw the standard stuff, (bezel, screw heads, and primary title).
   }
   glEndList();
}


void  CLandingGearLights::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      for (int ii = 0; ii < NUMBER_OF_LIGHTS; ii++)
      {
         landing_gear_lights[ii].Draw();
      }

      m_landing_gear_handle_light.Draw();
   }
   glPopMatrix();

   EndDraw();
}

CWidget* CLandingGearLights::CreateObject()
{
   return new CLandingGearLights();
}

void CLandingGearLights::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();


   if (rstrElementVar      == "Left Landing Gear Green")
   {
      landing_gear_lights_cv[LEFT_GEAR_DOWN].SetCondition(*pVariant);
   }
   else if (rstrElementVar == "Nose Landing Gear Green")
   {
      landing_gear_lights_cv[NOSE_GEAR_DOWN].SetCondition(*pVariant);
   }
   else if (rstrElementVar == "Right Landing Gear Green")
   {
      landing_gear_lights_cv[RIGHT_GEAR_DOWN].SetCondition(*pVariant);
   }
   else if (rstrElementVar == "Left Landing Gear Red")
   {
      landing_gear_lights_cv[LEFT_GEAR_UNSAFE].SetCondition(*pVariant);
   }
   else if (rstrElementVar == "Nose Landing Gear Red")
   {
      landing_gear_lights_cv[NOSE_GEAR_UNSAFE].SetCondition(*pVariant);
   }
   else if (rstrElementVar == "Right Landing Gear Red")
   {
      landing_gear_lights_cv[RIGHT_GEAR_UNSAFE].SetCondition(*pVariant);
   }
   else if (rstrElementVar == "Landing Gear Handle")
   {
      if ((bool)*pVariant  == true)
         m_landing_gear_handle_light_cv.SetColor(255, 0, 0);
      else
         m_landing_gear_handle_light_cv.SetColor(32, 32, 32);

      m_landing_gear_handle_light_cv.SetCondition(true);
   }
   
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CLandingGearLights::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CLandingGearLights::UpdateRenderVariables()
{

   for (int ii = 0; ii < NUMBER_OF_LIGHTS; ii++)
   {
      landing_gear_lights[ii] = landing_gear_lights_cv[ii];
   }

   m_landing_gear_handle_light = m_landing_gear_handle_light_cv;

   return CWidget::UpdateRenderVariables();
}
