// InstrumentsComponentInterface.h: interface for the CInstrumentsComponentInterface class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_INSTRUMENTSCOMPONENTINTERFACE_H_)
#define _INSTRUMENTSCOMPONENTINTERFACE_H_

#include "..\core\ComponentInterface.h"

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CInstrumentsComponentInterface : public CComponentInterface  
{
private:
    static const char m_cRevisionDate[];
    static const char m_cRevisionTime[];

protected:

public:
    // Constructors
	CInstrumentsComponentInterface(_FSI_STL::string stlStrPathName = 
                                                   _FSI_STL::string("Unknown"));

    // Destructor
	virtual ~CInstrumentsComponentInterface();

};

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

/////////////////////////////////////////////////////////////////////////////
//
// __declspec(dllexport) bool ComponentInterface()
//
// Inputs           : CComponentInterface*& rpCI - a reference to a 
//                    pointer to a CComponentInterface instance or an 
//                    instance of a class derived from CComponentInterface.
//
// Return Values    : true - the instance of the component interface 
//                           was created.
//                    false - the instance of the component interface was
//                            not created.
//
// Date             : 19 October 1998
//
// Engineer         : Billy Baker
//
// Description      : ComponetInterface is the lone exported function 
//                    from the DLL.  Its purpose is to create an 
//                    instance of the class derived from 
//                    CComponentInterface that is implemented in the 
//                    library that contains this ComponentInterface 
//                    method.  The return value indicates the success 
//                    or failure of the new operation.
//
/////////////////////////////////////////////////////////////////////////////
__declspec(dllexport) bool ComponentInterface(CComponentInterface*& rpCI,
                                              _FSI_STL::string stlStrPathName)
{
    bool bRetVal = true;
    rpCI = new CInstrumentsComponentInterface(stlStrPathName);

    if (rpCI == NULL)
        bRetVal = false;
    
    return bRetVal;
}

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // !defined(_INSTRUMENTSCOMPONENTINTERFACE_H_)
