// InstrumentsComponentInterface.cpp: implementation of the CInstrumentsComponentInterface class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"

#include "InstrumentsComponentInterface.h"

#include "AccelerationPanel.h"
#include "AdiGauge.h"
#include "AirspeedGauge.h"
#include "AltitudeGauge.h"
#include "AngleOfAttackGauge.h"
#include "AngleOfAttackPanel.h"
#include "AnnunciatorPanel.h"

#include "EHSIGauge.h"
#include "Engine1Gauge.h"
#include "Engine2Gauge.h"
#include "Engine3Gauge.h"

#include "Fire.h"
#include "FlapPositionGauge.h"

#include "GenericAPUGauge.h"
#include "GenericEngineGauge.h"

#include "LandingGearLights.h"

#include "MasterCaution.h"
#include "MasterWarning.h"
#include "MissionTime.h"

#include "NACWS.h"
#include "NoseWheelSteering.h"

#include "RMUPanel.h"
#include "RotarySwitch.h"
#include "RudderPosition.h"

#include "SpeedBrake.h"
#include "StickPosition.h"
#include "Switch.h"

#include "ThrottlePosition.h"
#include "TrimIndicatorGauge.h"

#include "UHFBackupPanel.h"

#include "VerticalSpeedGauge.h"

#include "Honeywell_TAS.h"
#include "tas-ind.h"

#include "LeftBrake.h"
#include "RightBrake.h"

#include "..\fsisuite\product_version.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// The following static members contain the date and time of the last
// compilation of this class.
const char CInstrumentsComponentInterface::m_cRevisionDate[] = __DATE__;
const char CInstrumentsComponentInterface::m_cRevisionTime[] = __TIME__;

CInstrumentsComponentInterface::CInstrumentsComponentInterface(
                                                  _FSI_STL::string stlStrPathName) :
                 CComponentInterface(_FSI_STL::string("Instruments"),stlStrPathName)

{
    _FSI_STL::string stlStrDate(m_cRevisionDate);
    _FSI_STL::string stlStrTime(m_cRevisionTime);

    m_listWidgetCtrls.push_back(CAccelerationPanel::CreateObject);
    m_listWidgetCtrls.push_back(CAdiGauge::CreateObject);
    m_listWidgetCtrls.push_back(CAirspeedGauge::CreateObject);
    m_listWidgetCtrls.push_back(CAltitudeGauge::CreateObject);
    m_listWidgetCtrls.push_back(CAngleOfAttackGauge::CreateObject);
    m_listWidgetCtrls.push_back(CAngleOfAttackPanel::CreateObject);
    m_listWidgetCtrls.push_back(CAnnunciatorPanel::CreateObject);

    m_listWidgetCtrls.push_back(CEHSIGauge::CreateObject);
    m_listWidgetCtrls.push_back(CEngine1Gauge::CreateObject);
    m_listWidgetCtrls.push_back(CEngine2Gauge::CreateObject);
    m_listWidgetCtrls.push_back(CEngine3Gauge::CreateObject);

    m_listWidgetCtrls.push_back(CFire::CreateObject);
//    m_listWidgetCtrls.push_back(CFlapPositionGauge::CreateObject);

//    m_listWidgetCtrls.push_back(CGenericAPUGauge::CreateObject);
//    m_listWidgetCtrls.push_back(CGenericEngineGauge::CreateObject);

    m_listWidgetCtrls.push_back(CLandingGearLights::CreateObject);

    m_listWidgetCtrls.push_back(CMasterCaution::CreateObject);
    m_listWidgetCtrls.push_back(CMasterWarning::CreateObject);
//    m_listWidgetCtrls.push_back(CMissionTime::CreateObject);

#ifndef  HAF
    m_listWidgetCtrls.push_back(CNACWS::CreateObject);
    m_listWidgetCtrls.push_back(CTAS::CreateObject  );
#endif
    m_listWidgetCtrls.push_back(CNoseWheelSteering::CreateObject);

    m_listWidgetCtrls.push_back(CRMUPanel::CreateObject);
//    m_listWidgetCtrls.push_back(CRotarySwitch::CreateObject);

#ifndef  HAF
    m_listWidgetCtrls.push_back(CRudderPosition::CreateObject);
    m_listWidgetCtrls.push_back(CStickPosition::CreateObject);
    m_listWidgetCtrls.push_back(CThrottlePosition::CreateObject);
#endif

    m_listWidgetCtrls.push_back(CSpeedBrake::CreateObject);
//    m_listWidgetCtrls.push_back(CSwitch::CreateObject);

    m_listWidgetCtrls.push_back(CTrimIndicatorGauge::CreateObject);

    m_listWidgetCtrls.push_back(CUHFBackupPanel::CreateObject);

    m_listWidgetCtrls.push_back(CVerticalSpeedGauge::CreateObject);

    m_listWidgetCtrls.push_back(CHoneywellTAS::CreateObject);

    m_listWidgetCtrls.push_back(CLeftBrake::CreateObject);
    m_listWidgetCtrls.push_back(CRightBrake::CreateObject);


    CBitmap* pBmp = new CBitmap;
    pBmp->LoadBitmap(CAccelerationPanel::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CAdiGauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CAirspeedGauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CAltitudeGauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CAngleOfAttackGauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CAngleOfAttackPanel::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CAnnunciatorPanel::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CEHSIGauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CEngine1Gauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CEngine2Gauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CEngine3Gauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CFire::IDB);
    m_listWidgetImages.push_back(pBmp);

//    pBmp = new CBitmap;
//    pBmp->LoadBitmap(CFlapPositionGauge::IDB);
//    m_listWidgetImages.push_back(pBmp);

//    pBmp = new CBitmap;
//    pBmp->LoadBitmap(CGenericAPUGauge::IDB);
//    m_listWidgetImages.push_back(pBmp);

//    pBmp = new CBitmap;
//    pBmp->LoadBitmap(CGenericEngineGauge::IDB);
//    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CLandingGearLights::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CMasterCaution::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CMasterWarning::IDB);
    m_listWidgetImages.push_back(pBmp);

//    pBmp = new CBitmap;
//    pBmp->LoadBitmap(CMissionTime::IDB);
//    m_listWidgetImages.push_back(pBmp);

#ifndef  HAF
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CNACWS::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CTAS::IDB);
    m_listWidgetImages.push_back(pBmp);

#endif

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CNoseWheelSteering::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CRMUPanel::IDB);
    m_listWidgetImages.push_back(pBmp);

//    pBmp = new CBitmap;
//    pBmp->LoadBitmap(CRotarySwitch::IDB);
//    m_listWidgetImages.push_back(pBmp);

#ifndef  HAF
    pBmp = new CBitmap;
    pBmp->LoadBitmap(CRudderPosition::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CStickPosition::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CThrottlePosition::IDB);
    m_listWidgetImages.push_back(pBmp);
#endif

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CSpeedBrake::IDB);
    m_listWidgetImages.push_back(pBmp);


//    pBmp = new CBitmap;
//    pBmp->LoadBitmap(CSwitch::IDB);
//    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CTrimIndicatorGauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CUHFBackupPanel::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CVerticalSpeedGauge::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CHoneywellTAS::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CLeftBrake::IDB);
    m_listWidgetImages.push_back(pBmp);

    pBmp = new CBitmap;
    pBmp->LoadBitmap(CRightBrake::IDB);
    m_listWidgetImages.push_back(pBmp);

    m_stlStrDate = stlStrDate + " " + stlStrTime;
}

CInstrumentsComponentInterface::~CInstrumentsComponentInterface()
{
}

