// GenericEngineGauge.h: interface for the CGenericEngineGauge class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GENERICENGINEGAUGE_H__E02411D2_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_GENERICENGINEGAUGE_H__E02411D2_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"

class CGenericEngineGauge : public COpenGLWidget, public CPanel
{
public:
	CGenericEngineGauge();
	virtual ~CGenericEngineGauge();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();

   void  SetLeftN1Value(float LeftN1);
   void  SetRightN1Value(float RightN1);

   void  SetLeftN2Value(float LeftN2);
   void  SetRightN2Value(float RightN2);

   void  SetLeftIttValue(float LeftItt);
   void  SetRightIttValue(float RightItt);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

protected:
   CTicks      LeftN1Ticks;
   CTicks      LeftN1GreenTicks;
   CTicks      LeftN1RedTicks;
   COpenGLtext LeftN1Label;
   COpenGLtext LeftN1Needle;
   COpenGLtext LeftN1Value;
   CString     m_LeftN1_value;
   CString     m_LeftN1_value_cv;

   CTicks      RightN1Ticks;
   CTicks      RightN1GreenTicks;
   CTicks      RightN1RedTicks;
   COpenGLtext RightN1Label;
   COpenGLtext RightN1Needle;
   COpenGLtext RightN1Value;
   CString     m_RightN1_value;
   CString     m_RightN1_value_cv;


   CTicks      LeftN2Ticks;
   CTicks      LeftN2GreenTicks;
   CTicks      LeftN2RedTicks;
   COpenGLtext LeftN2Label;
   COpenGLtext LeftN2Needle;
   COpenGLtext LeftN2Value;
   CString     m_LeftN2_value;
   CString     m_LeftN2_value_cv;

   CTicks      RightN2Ticks;
   CTicks      RightN2GreenTicks;
   CTicks      RightN2RedTicks;
   COpenGLtext RightN2Label;
   COpenGLtext RightN2Needle;
   COpenGLtext RightN2Value;
   CString     m_RightN2_value;
   CString     m_RightN2_value_cv;


   CTicks      LeftIttTicks;
   CTicks      LeftIttRedTicks;
   COpenGLtext LeftIttLabel;
   COpenGLtext LeftIttNeedle;
   COpenGLtext LeftIttValue;
   CString     m_LeftItt_value;
   CString     m_LeftItt_value_cv;

   CTicks      RightIttTicks;
   CTicks      RightIttRedTicks;
   COpenGLtext RightIttLabel;
   COpenGLtext RightIttNeedle;
   COpenGLtext RightIttValue;
   CString     m_RightItt_value;
   CString     m_RightItt_value_cv;

   CString  needle;
   CString  n1;
   CString  n2;
   CString  itt;

private:
   void  SetupLeftN1Ticks(void);
   float m_LeftN1_angle;
   float m_LeftN1;
   float m_LeftN1_angle_cv;
   float m_LeftN1_cv;

   void  SetupRightN1Ticks(void);
   float m_RightN1_angle;
   float m_RightN1;
   float m_RightN1_angle_cv;
   float m_RightN1_cv;


   void  SetupLeftN2Ticks(void);
   float m_LeftN2_angle;
   float m_LeftN2;
   float m_LeftN2_angle_cv;
   float m_LeftN2_cv;

   void  SetupRightN2Ticks(void);
   float m_RightN2_angle;
   float m_RightN2;
   float m_RightN2_angle_cv;
   float m_RightN2_cv;


   void  SetupLeftIttTicks(void);
   float m_LeftItt_angle;
   float m_LeftItt;
   float m_LeftItt_angle_cv;
   float m_LeftItt_cv;

   void  SetupRightIttTicks(void);
   float m_RightItt_angle;
   float m_RightItt;
   float m_RightItt_angle_cv;
   float m_RightItt_cv;

// Attributes
public:
  	enum { IDB = IDB_GENERIC_ENGINE  };
};

#endif // !defined(AFX_GENERICENGINEGAUGE_H__E02411D2_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
