// GenericEngineGauge.cpp: implementation of the CGenericEngineGauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "GenericEngineGauge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGenericEngineGauge::CGenericEngineGauge()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Generic_Engine");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(200,400));
   
   m_LeftN1_value.Format("%.0f %%", 0.0f);
   m_RightN1_value.Format("%.0f %%", 0.0f);
   m_LeftN2_value.Format("%.0f %%", 0.0f);
   m_RightN2_value.Format("%.0f %%", 0.0f);
   m_LeftItt_value.Format("%.0f%cC", 0.0f, DEGREES);
   m_RightItt_value.Format("%.0f%cC", 0.0f, DEGREES);

   m_LeftN1_value_cv   = m_LeftN1_value;
   m_RightN1_value_cv  = m_RightN1_value;
   m_LeftN2_value_cv   = m_LeftN2_value;
   m_RightN2_value_cv  = m_RightN2_value;
   m_LeftItt_value_cv  = m_LeftItt_value;
   m_RightItt_value_cv = m_RightItt_value;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("LeftN1");
   m_listGraphicalElementVars.push_back("RightN1");
   m_listGraphicalElementVars.push_back("LeftN2");
   m_listGraphicalElementVars.push_back("RightN2");
   m_listGraphicalElementVars.push_back("LeftItt");
   m_listGraphicalElementVars.push_back("RightItt");

   m_list   =  -1;
}

CGenericEngineGauge::~CGenericEngineGauge()
{
}

void  CGenericEngineGauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   SetupLeftN1Ticks();
   SetupRightN1Ticks();
   SetupLeftN2Ticks();
   SetupRightN2Ticks();
   SetupLeftIttTicks();
   SetupRightIttTicks();

   needle.Format("%c", NOMINAL_NEEDLE);
   n1.Format("N1");
   n2.Format("N2");
   itt.Format("ITT");

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
        glPushMatrix();
        {
           // Draw the standard stuff, (bezel, screw heads, and primary title).
           CPanel::Draw();

           glPushMatrix();
              glTranslatef(-0.4f, 0.75f, 0.0f);
              LeftN1Ticks.Draw();
              LeftN1Ticks.DrawArc(false, -135.0f, -12.5f);

              LeftN1GreenTicks.Draw();
              LeftN1GreenTicks.DrawArc(false, -12.3f, 120.1f);

              LeftN1RedTicks.Draw();

              glPushMatrix();
                 glTranslatef(0.0f, -0.20f, 0.0f);
                 LeftN1Label.Draw(n1, true, 0.0f, 1.4f, 1.0f);
              glPopMatrix();
           glPopMatrix();

           // RightN1 portion of Gauge
           glPushMatrix();
              glTranslatef( 0.4f, 0.75f, 0.0f);
              RightN1Ticks.Draw();
              RightN1Ticks.DrawArc(false, -135.0f, -12.5f);

              RightN1GreenTicks.Draw();
              RightN1GreenTicks.DrawArc(false, -12.3f, 120.1f);

              RightN1RedTicks.Draw();

              glTranslatef(0.0f, -0.20f, 0.0f);
              RightN1Label.Draw(n1,   true, 0.0f, 1.4f, 1.0f);
          glPopMatrix();

          // LeftN2 portion of Gauge
          glPushMatrix();
             glTranslatef(-0.4f, 0.0f, 0.0f);
             LeftN2Ticks.Draw();
             LeftN2Ticks.DrawArc(false, -135.0f, -12.5f);

             LeftN2GreenTicks.Draw();
             LeftN2GreenTicks.DrawArc(false, -12.3f, 120.1f);

             LeftN2RedTicks.Draw();

             glTranslatef(0.0f, -0.20f, 0.0f);
             LeftN2Label.Draw(n2, true, 0.0f, 1.4f, 1.0f);
         glPopMatrix();

         // RightN2 portion of Gauge
         glPushMatrix();
            glTranslatef( 0.4f, 0.0f, 0.0f);
            RightN2Ticks.Draw();
            RightN2Ticks.DrawArc(false, -135.0f, -12.5f);

            RightN2GreenTicks.Draw();
            RightN2GreenTicks.DrawArc(false, -12.3f, 120.1f);

            RightN2RedTicks.Draw();

            glTranslatef(0.0f, -0.20f, 0.0f);
            RightN2Label.Draw(n2,   true, 0.0f, 1.4f, 1.0f);
         glPopMatrix();

         // LeftItt portion of Gauge
         glPushMatrix();
            glTranslatef(-0.4f, -0.75f, 0.0f);
            LeftIttTicks.Draw();
            LeftIttTicks.DrawArc(false, -135.0f, 53.8f);

            LeftIttRedTicks.Draw();

            glTranslatef(0.0f, -0.20f, 0.0f);
            LeftIttLabel.Draw(itt,  true, 0.0f, 1.4f, 1.0f);
         glPopMatrix();

         // RightItt portion of Gauge
         glPushMatrix();
            glTranslatef( 0.4f, -0.75f, 0.0f);
            RightIttTicks.Draw();
            RightIttTicks.DrawArc(false, -135.0f, 53.8f);

            RightIttRedTicks.Draw();

            glTranslatef(0.0f, -0.20f, 0.0f);
            RightIttLabel.Draw(itt, true, 0.0f, 1.4f, 1.0f);
         glPopMatrix();
        }
        glPopMatrix();
   }
   glEndList();
}

void  CGenericEngineGauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      // LeftN1 portion of Gauge
      glPushMatrix();
         glTranslatef(-0.4f, 0.75f, 0.0f);

         if (m_LeftN1_angle   >= 120.3f)
            LeftN1RedTicks.DrawArc(false, 120.3f, m_LeftN1_angle);

         if (m_LeftN1 >  104.0f)
         {
            LeftN1Value.SetBackgroundColor(true, 255,  0,  0);
            LeftN1Needle.SetForegroundColor(255, 0, 0);
         }
         else
         {
            LeftN1Value.SetBackgroundColor(false, 0,  0,  0);
            LeftN1Needle.SetForegroundColor(255, 255, 255);
         }
         LeftN1Value.Draw(m_LeftN1_value, true, 0.0f, 1.4f, 1.0f);

         glRotatef(-m_LeftN1_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.085f, 0.0f);
         LeftN1Needle.Draw(needle,  true, 0.0f, 10.0f, 1.0f);
      glPopMatrix();

      // RightN1 portion of Gauge
      glPushMatrix();
         glTranslatef( 0.4f, 0.75f, 0.0f);

         if (m_RightN1_angle   >= 120.3f)
            RightN1RedTicks.DrawArc(false, 120.3f, m_RightN1_angle);

         if (m_RightN1 >  104.0f)
         {
            RightN1Value.SetBackgroundColor(true, 255,  0,  0);
            RightN1Needle.SetForegroundColor(255, 0, 0);
         }
         else
         {
            RightN1Value.SetBackgroundColor(false, 0,  0,  0);
            RightN1Needle.SetForegroundColor(255, 255, 255);
         }
         RightN1Value.Draw(m_RightN1_value,  true, 0.0f, 1.4f, 1.0f);

         glRotatef(-m_RightN1_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.085f, 0.0f);
         RightN1Needle.Draw(needle,  true, 0.0f, 10.0f, 1.0f);
      glPopMatrix();


      // LeftN2 portion of Gauge
      glPushMatrix();
         glTranslatef(-0.4f, 0.0f, 0.0f);

         if (m_LeftN2_angle   >= 120.3f)
            LeftN2RedTicks.DrawArc(false, 120.3f, m_LeftN2_angle);

         if (m_LeftN2 >  104.0f)
         {
            LeftN2Value.SetBackgroundColor(true, 255,  0,  0);
            LeftN2Needle.SetForegroundColor(255, 0, 0);
         }
         else
         {
            LeftN2Value.SetBackgroundColor(false, 0,  0,  0);
            LeftN2Needle.SetForegroundColor(255, 255, 255);
         }
         LeftN2Value.Draw(m_LeftN2_value, true, 0.0f, 1.4f, 1.0f);

         glRotatef(-m_LeftN2_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.085f, 0.0f);
         LeftN2Needle.Draw(needle,  true, 0.0f, 10.0f, 1.0f);
      glPopMatrix();

      // RightN2 portion of Gauge
      glPushMatrix();
         glTranslatef( 0.4f, 0.0f, 0.0f);

         if (m_RightN2_angle   >= 120.3f)
            RightN2RedTicks.DrawArc(false, 120.3f, m_RightN2_angle);

         if (m_RightN2 >  104.0f)
         {
            RightN2Value.SetBackgroundColor(true, 255,  0,  0);
            RightN2Needle.SetForegroundColor(255, 0, 0);
         }
         else
         {
            RightN2Value.SetBackgroundColor(false, 0,  0,  0);
            RightN2Needle.SetForegroundColor(255, 255, 255);
         }
         RightN2Value.Draw(m_RightN2_value, true, 0.0f, 1.4f, 1.0f);

         glRotatef(-m_RightN2_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.085f, 0.0f);
         RightN2Needle.Draw(needle,  true, 0.0f, 10.0f, 1.0f);
      glPopMatrix();


      // LeftItt portion of Gauge
      glPushMatrix();
         glTranslatef(-0.4f, -0.75f, 0.0f);

         if (m_LeftItt_angle   >= 54.0f)
            LeftIttRedTicks.DrawArc(false, 54.0f, m_LeftItt_angle);

         if (m_LeftItt   >  820.0f)
         {
            LeftIttValue.SetBackgroundColor(true, 255,  0,  0);
            LeftIttNeedle.SetForegroundColor(255, 0, 0);
         }
         else
         {
            LeftIttValue.SetBackgroundColor(false, 0,  0,  0);
            LeftIttNeedle.SetForegroundColor(255, 255, 255);
         }
         LeftIttValue.Draw(m_LeftItt_value,  true, 0.0f, 1.4f, 1.0f);

         glRotatef(-m_LeftItt_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef( 0.0f, 0.085f, 0.0f);
         LeftIttNeedle.Draw(needle,  true, 0.0f, 10.0f, 1.0f);
      glPopMatrix();

      // RightItt portion of Gauge
      glPushMatrix();
         glTranslatef( 0.4f, -0.75f, 0.0f);

         if (m_RightItt_angle   >= 54.0f)
            RightIttRedTicks.DrawArc(false, 54.0f, m_RightItt_angle);

         if (m_RightItt   >  820.0f)
         {
            RightIttValue.SetBackgroundColor(true, 255,  0,  0);
            RightIttNeedle.SetForegroundColor(255, 0, 0);
         }
         else
         {
            RightIttValue.SetBackgroundColor(false, 0,  0,  0);
            RightIttNeedle.SetForegroundColor(255, 255, 255);
         }
         RightIttValue.Draw(m_RightItt_value,   true, 0.0f, 1.4f, 1.0f);

         glRotatef(-m_RightItt_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef( 0.0f, 0.085f, 0.0f);
         RightIttNeedle.Draw(needle,  true, 0.0f, 10.0f, 1.0f);
      glPopMatrix();
   }
   glPopMatrix();

   EndDraw();
}


void  CGenericEngineGauge::SetLeftN1Value(float LeftN1)
{
   m_LeftN1_cv           =  LeftN1;
   m_LeftN1_value_cv.Format("%.0f %%", LeftN1);

   if (LeftN1   >  0.0f)
      m_LeftN1_angle_cv  =  (270.0f/110.0f * LeftN1) - 135.0f;
   else
      m_LeftN1_angle_cv  =  -135.0f;
}

void  CGenericEngineGauge::SetRightN1Value(float RightN1)
{
   m_RightN1_cv           =  RightN1;
   m_RightN1_value_cv.Format("%.0f %%", RightN1);

   if (RightN1   >  0.0f)
      m_RightN1_angle_cv  =  (270.0f/110.0f * RightN1) - 135.0f;
   else
      m_RightN1_angle_cv  =  -135.0f;
}


void  CGenericEngineGauge::SetLeftN2Value(float LeftN2)
{
   m_LeftN2_cv           =  LeftN2;
   m_LeftN2_value_cv.Format("%.0f %%", LeftN2);

   if (LeftN2   >  0.0f)
      m_LeftN2_angle_cv  =  (270.0f/110.0f * LeftN2) - 135.0f;
   else
      m_LeftN2_angle_cv  =  -135.0f;
}

void  CGenericEngineGauge::SetRightN2Value(float RightN2)
{
   m_RightN2_cv           =  RightN2;
   m_RightN2_value_cv.Format("%.0f %%", RightN2);

   if (RightN2   >  0.0f)
      m_RightN2_angle_cv  =  (270.0f/110.0f * RightN2) - 135.0f;
   else
      m_RightN2_angle_cv  =  -135.0f;
}


void  CGenericEngineGauge::SetLeftIttValue(float LeftItt)
{
   m_LeftItt_cv          =  LeftItt;
   m_LeftItt_value_cv.Format("%.0f%cC", LeftItt, DEGREES);

   if (LeftItt  >  400.0f)
      m_LeftItt_angle_cv =  ((270.0f /  600.0f)  *  (LeftItt  -  400.0f)) - 135.0f;
   else
      m_LeftItt_angle_cv =  -135.0f;
}

void  CGenericEngineGauge::SetRightIttValue(float RightItt)
{
   m_RightItt_cv          =  RightItt;
   m_RightItt_value_cv.Format("%.0f%cC", RightItt, DEGREES);

   if (RightItt  >  400.0f)
      m_RightItt_angle_cv =  ((270.0f /  600.0f)  *  (RightItt  -  400.0f)) - 135.0f;
   else
      m_RightItt_angle_cv =  -135.0f;
}

void  CGenericEngineGauge::SetupLeftN1Ticks(void)
{
   LeftN1Ticks.Initialize();
   LeftN1Ticks.SetLabelRadius(0.45f);
   LeftN1Ticks.SetOuterRadius(0.35f);
   LeftN1Ticks.SetLabelProperties(1.4f, 1.0f);
   LeftN1Ticks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "0");
   LeftN1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  249.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "10");
   LeftN1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  274.1f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "20");
   LeftN1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  298.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "30");
   LeftN1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  323.2f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "40");
   LeftN1Ticks.TickList.AddTail(tick_info);

   LeftN1Ticks.GenerateLists();


   LeftN1GreenTicks.Initialize();
   LeftN1GreenTicks.SetLabelRadius(0.45f);
   LeftN1GreenTicks.SetOuterRadius(0.35f);
   LeftN1GreenTicks.SetLabelProperties(1.4f, 1.0f);
   LeftN1GreenTicks.SetTickColor(0, 128, 0);

   tick_info.location   =  347.7f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "50");
   LeftN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  359.9f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "50");
   LeftN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  12.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "60");
   LeftN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  36.8f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "70");
   LeftN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  64.4f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "80");
   LeftN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  85.9f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "90");
   LeftN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "100");
   LeftN1GreenTicks.TickList.AddTail(tick_info);

   LeftN1GreenTicks.GenerateLists();


   LeftN1RedTicks.Initialize();
   LeftN1RedTicks.SetLabelRadius(0.45f);
   LeftN1RedTicks.SetOuterRadius(0.35f);
   LeftN1RedTicks.SetLabelProperties(1.4f, 1.0f);
   LeftN1RedTicks.SetTickColor(255, 0, 0);

   tick_info.location   =  120.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "104");
   LeftN1RedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "110");
   LeftN1RedTicks.TickList.AddTail(tick_info);

   LeftN1RedTicks.GenerateLists();
}

void  CGenericEngineGauge::SetupRightN1Ticks(void)
{
   RightN1Ticks.Initialize();
   RightN1Ticks.SetLabelRadius(0.45f);
   RightN1Ticks.SetOuterRadius(0.35f);
   RightN1Ticks.SetLabelProperties(1.4f, 1.0f);
   RightN1Ticks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "0");
   RightN1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  249.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "10");
   RightN1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  274.1f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "20");
   RightN1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  298.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "30");
   RightN1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  323.2f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "40");
   RightN1Ticks.TickList.AddTail(tick_info);

   RightN1Ticks.GenerateLists();


   RightN1GreenTicks.Initialize();
   RightN1GreenTicks.SetLabelRadius(0.45f);
   RightN1GreenTicks.SetOuterRadius(0.35f);
   RightN1GreenTicks.SetLabelProperties(1.4f, 1.0f);
   RightN1GreenTicks.SetTickColor(0, 128, 0);

   tick_info.location   =  347.7f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "50");
   RightN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  359.9f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "50");
   RightN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  12.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "60");
   RightN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  36.8f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "70");
   RightN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  64.4f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "80");
   RightN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  85.9f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "90");
   RightN1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "100");
   RightN1GreenTicks.TickList.AddTail(tick_info);

   RightN1GreenTicks.GenerateLists();


   RightN1RedTicks.Initialize();
   RightN1RedTicks.SetLabelRadius(0.45f);
   RightN1RedTicks.SetOuterRadius(0.35f);
   RightN1RedTicks.SetLabelProperties(1.4f, 1.0f);
   RightN1RedTicks.SetTickColor(255, 0, 0);

   tick_info.location   =  120.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "104");
   RightN1RedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "110");
   RightN1RedTicks.TickList.AddTail(tick_info);

   RightN1RedTicks.GenerateLists();
}


void  CGenericEngineGauge::SetupLeftN2Ticks(void)
{
   LeftN2Ticks.Initialize();
   LeftN2Ticks.SetLabelRadius(0.45f);
   LeftN2Ticks.SetOuterRadius(0.35f);
   LeftN2Ticks.SetLabelProperties(1.4f, 1.0f);
   LeftN2Ticks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "0");
   LeftN2Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  249.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "10");
   LeftN2Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  274.1f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "20");
   LeftN2Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  298.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "30");
   LeftN2Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  323.2f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "40");
   LeftN2Ticks.TickList.AddTail(tick_info);

   LeftN2Ticks.GenerateLists();


   LeftN2GreenTicks.Initialize();
   LeftN2GreenTicks.SetLabelRadius(0.45f);
   LeftN2GreenTicks.SetOuterRadius(0.35f);
   LeftN2GreenTicks.SetLabelProperties(1.4f, 1.0f);
   LeftN2GreenTicks.SetTickColor(0, 128, 0);

   tick_info.location   =  347.7f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "50");
   LeftN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  359.9f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "50");
   LeftN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  12.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "60");
   LeftN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  36.8f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "70");
   LeftN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  64.4f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "80");
   LeftN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  85.9f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "90");
   LeftN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "100");
   LeftN2GreenTicks.TickList.AddTail(tick_info);

   LeftN2GreenTicks.GenerateLists();


   LeftN2RedTicks.Initialize();
   LeftN2RedTicks.SetLabelRadius(0.45f);
   LeftN2RedTicks.SetOuterRadius(0.35f);
   LeftN2RedTicks.SetLabelProperties(1.4f, 1.0f);
   LeftN2RedTicks.SetTickColor(255, 0, 0);

   tick_info.location   =  120.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "104");
   LeftN2RedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "110");
   LeftN2RedTicks.TickList.AddTail(tick_info);

   LeftN2RedTicks.GenerateLists();
}

void  CGenericEngineGauge::SetupRightN2Ticks(void)
{
   RightN2Ticks.Initialize();
   RightN2Ticks.SetLabelRadius(0.45f);
   RightN2Ticks.SetOuterRadius(0.35f);
   RightN2Ticks.SetLabelProperties(1.4f, 1.0f);
   RightN2Ticks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "0");
   RightN2Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  249.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "10");
   RightN2Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  274.1f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "20");
   RightN2Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  298.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "30");
   RightN2Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  323.2f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "40");
   RightN2Ticks.TickList.AddTail(tick_info);

   RightN2Ticks.GenerateLists();


   RightN2GreenTicks.Initialize();
   RightN2GreenTicks.SetLabelRadius(0.45f);
   RightN2GreenTicks.SetOuterRadius(0.35f);
   RightN2GreenTicks.SetLabelProperties(1.4f, 1.0f);
   RightN2GreenTicks.SetTickColor(0, 128, 0);

   tick_info.location   =  347.7f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "50");
   RightN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  359.9f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "50");
   RightN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  12.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "60");
   RightN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  36.8f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "70");
   RightN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  64.4f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "80");
   RightN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  85.9f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "90");
   RightN2GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "100");
   RightN2GreenTicks.TickList.AddTail(tick_info);

   RightN2GreenTicks.GenerateLists();


   RightN2RedTicks.Initialize();
   RightN2RedTicks.SetLabelRadius(0.45f);
   RightN2RedTicks.SetOuterRadius(0.35f);
   RightN2RedTicks.SetLabelProperties(1.4f, 1.0f);
   RightN2RedTicks.SetTickColor(255, 0, 0);

   tick_info.location   =  120.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "104");
   RightN2RedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "110");
   RightN2RedTicks.TickList.AddTail(tick_info);

   RightN2RedTicks.GenerateLists();
}


void  CGenericEngineGauge::SetupLeftIttTicks(void)
{
   LeftIttTicks.Initialize();
   LeftIttTicks.SetLabelRadius(0.45f);
   LeftIttTicks.SetOuterRadius(0.35f);
   LeftIttTicks.SetLabelProperties(1.4f, 1.0f);
   LeftIttTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");


   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "400");
   LeftIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  247.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "450");
   LeftIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  270.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "500");
   LeftIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  292.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "550");
   LeftIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  315.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "600");
   LeftIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  337.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "650");
   LeftIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "700");
   LeftIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  22.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "750");
   LeftIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  45.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "800");
   LeftIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  54.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "820");
   LeftIttTicks.TickList.AddTail(tick_info);

   LeftIttTicks.GenerateLists();


   LeftIttRedTicks.Initialize();
   LeftIttRedTicks.SetLabelRadius(0.45f);
   LeftIttRedTicks.SetOuterRadius(0.35f);
   LeftIttRedTicks.SetLabelProperties(1.4f, 1.0f);
   LeftIttRedTicks.SetTickColor(255, 0, 0);


   tick_info.location   =  54.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "820");
   LeftIttRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  67.5f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "850");
   LeftIttRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  90.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "900");
   LeftIttRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  112.5f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "950");
   LeftIttRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "1000");
   LeftIttRedTicks.TickList.AddTail(tick_info);

   LeftIttRedTicks.GenerateLists();
}


void  CGenericEngineGauge::SetupRightIttTicks(void)
{
   RightIttTicks.Initialize();
   RightIttTicks.SetLabelRadius(0.45f);
   RightIttTicks.SetOuterRadius(0.35f);
   RightIttTicks.SetLabelProperties(1.4f, 1.0f);
   RightIttTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");


   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "400");
   RightIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  247.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "450");
   RightIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  270.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "500");
   RightIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  292.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "550");
   RightIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  315.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "600");
   RightIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  337.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "650");
   RightIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "700");
   RightIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  22.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "750");
   RightIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  45.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "800");
   RightIttTicks.TickList.AddTail(tick_info);

   tick_info.location   =  54.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "820");
   RightIttTicks.TickList.AddTail(tick_info);

   RightIttTicks.GenerateLists();


   RightIttRedTicks.Initialize();
   RightIttRedTicks.SetLabelRadius(0.45f);
   RightIttRedTicks.SetOuterRadius(0.35f);
   RightIttRedTicks.SetLabelProperties(1.4f, 1.0f);
   RightIttRedTicks.SetTickColor(255, 0, 0);


   tick_info.location   =  54.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "820");
   RightIttRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  67.5f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "850");
   RightIttRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  90.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "900");
   RightIttRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  112.5f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "950");
   RightIttRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "1000");
   RightIttRedTicks.TickList.AddTail(tick_info);

   RightIttRedTicks.GenerateLists();
}

CWidget* CGenericEngineGauge::CreateObject()
{
   return new CGenericEngineGauge();
}

void CGenericEngineGauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar      == "LeftItt")
   {
      SetLeftIttValue(*pVariant);
   }
   else if (rstrElementVar == "RightItt")
   {
      SetRightIttValue(*pVariant);
   }
   else if (rstrElementVar == "LeftN1")
   {
      SetLeftN1Value(*pVariant);
   }
   else if (rstrElementVar == "RightN1")
   {
      SetRightN1Value(*pVariant);
   }
   else if (rstrElementVar == "LeftN2")
   {
      SetLeftN2Value(*pVariant);
   }
   else if (rstrElementVar == "RightN2")
   {
      SetRightN2Value(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CGenericEngineGauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CGenericEngineGauge::UpdateRenderVariables()
{
   m_LeftN1_value   = m_LeftN1_value_cv;
   m_RightN1_value  = m_RightN1_value_cv;
   m_LeftN2_value   = m_LeftN2_value_cv;
   m_RightN2_value  = m_RightN2_value_cv;
   m_LeftItt_value  = m_LeftItt_value_cv;
   m_RightItt_value = m_RightItt_value_cv;

   m_LeftN1_angle   =  m_LeftN1_angle_cv;
   m_LeftN1         =  m_LeftN1_cv;
   m_RightN1_angle  =  m_RightN1_angle_cv;
   m_RightN1        =  m_RightN1_cv;
   m_LeftN2_angle   =  m_LeftN2_angle_cv;
   m_LeftN2         =  m_LeftN2_cv;
   m_RightN2_angle  =  m_RightN2_angle_cv;
   m_RightN2        =  m_RightN2_cv;
   m_LeftItt_angle  =  m_LeftItt_angle_cv;
   m_LeftItt        =  m_LeftItt_cv;
   m_RightItt_angle =  m_RightItt_angle_cv;
   m_RightItt       =  m_RightItt_cv;

   return CWidget::UpdateRenderVariables();
}
