// GenericAPUGauge.h: interface for the CGenericAPUGauge class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_GENERICAPUGAUGE_H__E02411D2_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_GENERICAPUGAUGE_H__E02411D2_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"

class CGenericAPUGauge : public COpenGLWidget, public CPanel
{
public:
	CGenericAPUGauge();
	virtual ~CGenericAPUGauge();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();

   void  SetRPMValue(float RPM);
   void  SetEGTValue(float EGT);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

protected:

   CTicks      RPMTicks;
   CTicks      RPMGreenTicks;
   CTicks      RPMRedTicks;
   COpenGLtext RPMLabel;
   COpenGLtext RPMNeedle;
   COpenGLtext RPMValue;
   CString     m_RPM_value;
   CString     m_RPM_value_cv;

   CTicks      EGTTicks;
   CTicks      EGTGreenTicks;
   CTicks      EGTRedTicks;
   COpenGLtext EGTLabel;
   COpenGLtext EGTNeedle;
   COpenGLtext EGTValue;
   CString     m_EGT_value;
   CString     m_EGT_value_cv;

   CString     rpm;
   CString     egt;
   CString     needle;

private:
   void  SetupRPMTicks(void);
   float m_RPM_angle;
   float m_RPM;
   float m_RPM_angle_cv;
   float m_RPM_cv;

   void  SetupEGTTicks(void);
   float m_EGT_angle;
   float m_EGT;
   float m_EGT_angle_cv;
   float m_EGT_cv;


// Attributes
public:
  	enum { IDB = IDB_GENERIC_APU  };
};

#endif // !defined(AFX_GENERICAPUGAUGE_H__E02411D2_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
