// GenericAPUGauge.cpp: implementation of the CGenericAPUGauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "GenericAPUGauge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CGenericAPUGauge::CGenericAPUGauge()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Generic_APU");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(296,144));

   m_RPM_value.Format("%.0f %%", 0.0f);
   m_EGT_value.Format("%.0f %%", 0.0f);

   m_RPM_value_cv = m_RPM_value;
   m_EGT_value_cv = m_EGT_value;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("RPM");
   m_listGraphicalElementVars.push_back("EGT");

   m_list   =  -1;
}

CGenericAPUGauge::~CGenericAPUGauge()
{
}

void  CGenericAPUGauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   rpm.Format("RPM");
   egt.Format("EGT");
   needle.Format("%c", NOMINAL_NEEDLE);
   SetupRPMTicks();
   SetupEGTTicks();

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();

         // RPM portion of Gauge
         glPushMatrix();
            glTranslatef(-0.75f, 0.0f, 0.0f);
            RPMTicks.Draw();
            RPMTicks.DrawArc(false, -135.0f, -12.5f);

            RPMGreenTicks.Draw();
            RPMGreenTicks.DrawArc(false, -12.3f, 120.1f);

            RPMRedTicks.Draw();

            glTranslatef(0.0f, -0.20f, 0.0f);
            RPMLabel.Draw(rpm,   true, 0.0f, 2.2f, 1.0f);
         glPopMatrix();

         // EGT portion of Gauge
         glPushMatrix();
            glTranslatef( 0.75f, 0.0f, 0.0f);
            EGTTicks.Draw();
            EGTTicks.DrawArc(false, -135.0f, -12.5f);

            EGTGreenTicks.Draw();
            EGTGreenTicks.DrawArc(false, -12.3f, 120.1f);

            EGTRedTicks.Draw();

            glTranslatef(0.0f, -0.20f, 0.0f);
            EGTLabel.Draw(egt, true, 0.0f, 2.2f, 1.0f);
         glPopMatrix();
      }
      glPopMatrix();
   }
   glEndList();
}

void  CGenericAPUGauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      // RPM portion of Gauge
      glPushMatrix();
         glTranslatef(-0.75f, 0.0f, 0.0f);

         if (m_RPM_angle   >= 120.3f)
            RPMRedTicks.DrawArc(false, 120.3f, m_RPM_angle);

         if (m_RPM >  104.0f)
         {
            RPMValue.SetBackgroundColor(true, 255,  0,  0);
            RPMNeedle.SetForegroundColor(255, 0, 0);
         }
         else
         {
            RPMValue.SetBackgroundColor(false, 0,  0,  0);
            RPMNeedle.SetForegroundColor(255, 255, 255);
         }
         RPMValue.Draw(m_RPM_value, true, 0.0f, 2.2f, 1.0f);

         glRotatef(-m_RPM_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.085f, 0.0f);
         RPMNeedle.Draw(needle,  true, 0.0f, 15.0f, 1.0f);
      glPopMatrix();

      // EGT portion of Gauge
      glPushMatrix();
         glTranslatef( 0.75f, 0.0f, 0.0f);

         if (m_EGT_angle   >= 120.3f)
            EGTRedTicks.DrawArc(false, 120.3f, m_EGT_angle);

         if (m_EGT >  104.0f)
         {
            EGTValue.SetBackgroundColor(true, 255,  0,  0);
            EGTNeedle.SetForegroundColor(255, 0, 0);
         }
         else
         {
            EGTValue.SetBackgroundColor(false, 0,  0,  0);
            EGTNeedle.SetForegroundColor(255, 255, 255);
         }
         EGTValue.Draw(m_EGT_value, true, 0.0f, 2.2f, 1.0f);

         glRotatef(-m_EGT_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.085f, 0.0f);
         EGTNeedle.Draw(needle,  true, 0.0f, 15.0f, 1.0f);
      glPopMatrix();
   }
   glPopMatrix();

   EndDraw();
}


void  CGenericAPUGauge::SetRPMValue(float RPM)
{
   m_RPM_cv           =  RPM;
   m_RPM_value_cv.Format("%.0f %%", RPM);

   if (RPM   >  0.0f)
      m_RPM_angle_cv  =  (270.0f/110.0f * RPM) - 135.0f;
   else
      m_RPM_angle_cv  =  -135.0f;
}

void  CGenericAPUGauge::SetEGTValue(float EGT)
{
   m_EGT_cv           =  EGT;
   m_EGT_value_cv.Format("%.0f %%", EGT);

   if (EGT   >  0.0f)
      m_EGT_angle_cv  =  (270.0f/110.0f * EGT) - 135.0f;
   else
      m_EGT_angle_cv  =  -135.0f;
}


void  CGenericAPUGauge::SetupRPMTicks(void)
{
   RPMTicks.Initialize();
   RPMTicks.SetTickLengths(0.25f, 0.17f, 0.11f);
   RPMTicks.SetLabelRadius(0.75f);
   RPMTicks.SetOuterRadius(0.65f);
   RPMTicks.SetLabelProperties(1.4f, 1.0f);
   RPMTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "0");
   RPMTicks.TickList.AddTail(tick_info);

   tick_info.location   =  249.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "10");
   RPMTicks.TickList.AddTail(tick_info);

   tick_info.location   =  274.1f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "20");
   RPMTicks.TickList.AddTail(tick_info);

   tick_info.location   =  298.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "30");
   RPMTicks.TickList.AddTail(tick_info);

   tick_info.location   =  323.2f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "40");
   RPMTicks.TickList.AddTail(tick_info);

   RPMTicks.GenerateLists();


   RPMGreenTicks.Initialize();
   RPMGreenTicks.SetTickLengths(0.25f, 0.17f, 0.11f);
   RPMGreenTicks.SetLabelRadius(0.75f);
   RPMGreenTicks.SetOuterRadius(0.65f);
   RPMGreenTicks.SetLabelProperties(1.4f, 1.0f);
   RPMGreenTicks.SetTickColor(0, 128, 0);

   tick_info.location   =  347.7f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "50");
   RPMGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  359.9f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "50");
   RPMGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  12.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "60");
   RPMGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  36.8f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "70");
   RPMGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  64.4f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "80");
   RPMGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  85.9f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "90");
   RPMGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "100");
   RPMGreenTicks.TickList.AddTail(tick_info);

   RPMGreenTicks.GenerateLists();


   RPMRedTicks.Initialize();
   RPMRedTicks.SetTickLengths(0.25f, 0.17f, 0.11f);
   RPMRedTicks.SetLabelRadius(0.75f);
   RPMRedTicks.SetOuterRadius(0.65f);
   RPMRedTicks.SetLabelProperties(1.4f, 1.0f);
   RPMRedTicks.SetTickColor(255, 0, 0);

   tick_info.location   =  120.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "104");
   RPMRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "110");
   RPMRedTicks.TickList.AddTail(tick_info);

   RPMRedTicks.GenerateLists();
}

void  CGenericAPUGauge::SetupEGTTicks(void)
{
   EGTTicks.Initialize();
   EGTTicks.SetTickLengths(0.25f, 0.17f, 0.11f);
   EGTTicks.SetLabelRadius(0.75f);
   EGTTicks.SetOuterRadius(0.65f);
   EGTTicks.SetLabelProperties(1.4f, 1.0f);
   EGTTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "0");
   EGTTicks.TickList.AddTail(tick_info);

   tick_info.location   =  249.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "10");
   EGTTicks.TickList.AddTail(tick_info);

   tick_info.location   =  274.1f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "20");
   EGTTicks.TickList.AddTail(tick_info);

   tick_info.location   =  298.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "30");
   EGTTicks.TickList.AddTail(tick_info);

   tick_info.location   =  323.2f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "40");
   EGTTicks.TickList.AddTail(tick_info);

   EGTTicks.GenerateLists();


   EGTGreenTicks.Initialize();
   EGTGreenTicks.SetTickLengths(0.25f, 0.17f, 0.11f);
   EGTGreenTicks.SetLabelRadius(0.75f);
   EGTGreenTicks.SetOuterRadius(0.65f);
   EGTGreenTicks.SetLabelProperties(1.4f, 1.0f);
   EGTGreenTicks.SetTickColor(0, 128, 0);

   tick_info.location   =  347.7f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "50");
   EGTGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  359.9f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "50");
   EGTGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  12.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "60");
   EGTGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  36.8f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "70");
   EGTGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  64.4f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "80");
   EGTGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  85.9f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "90");
   EGTGreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "100");
   EGTGreenTicks.TickList.AddTail(tick_info);

   EGTGreenTicks.GenerateLists();


   EGTRedTicks.Initialize();
   EGTRedTicks.SetTickLengths(0.25f, 0.17f, 0.11f);
   EGTRedTicks.SetLabelRadius(0.75f);
   EGTRedTicks.SetOuterRadius(0.65f);
   EGTRedTicks.SetLabelProperties(1.4f, 1.0f);
   EGTRedTicks.SetTickColor(255, 0, 0);

   tick_info.location   =  120.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "104");
   EGTRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "110");
   EGTRedTicks.TickList.AddTail(tick_info);

   EGTRedTicks.GenerateLists();
}



CWidget* CGenericAPUGauge::CreateObject()
{
   return new CGenericAPUGauge();
}

void CGenericAPUGauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "RPM")
   {
      SetRPMValue(*pVariant);
   }
   else if (rstrElementVar   == "EGT")
   {
      SetEGTValue(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CGenericAPUGauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CGenericAPUGauge::UpdateRenderVariables()
{
   m_RPM_value = m_RPM_value_cv;
   m_EGT_value = m_EGT_value_cv;

   m_RPM_angle    = m_RPM_angle_cv;
   m_RPM          = m_RPM_cv;
   m_EGT_angle    = m_EGT_angle_cv;
   m_EGT          = m_EGT_cv;

   return CWidget::UpdateRenderVariables();
}
