// FlapPositionGauge.cpp: implementation of the CFlapPositionGauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "FlapPositionGauge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFlapPositionGauge::CFlapPositionGauge()
{
   m_stlStrWidgetName = _FSI_STL::string("Flap_Position");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(200,200));

   m_flapPosition_angle =  170.0f;

   m_flapPosition_angle_cv = m_flapPosition_angle;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Flap Position");

   m_list   =  -1;
}

CFlapPositionGauge::~CFlapPositionGauge()
{
}

void  CFlapPositionGauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   theTicks.Initialize();
   theTicks.SetLabelRadius(0.84f);
   theTicks.SetOuterRadius(0.67f);
   theTicks.SetLabelProperties(2.5f, 1.25f);
   theTicks.SetTickColor(255, 255, 255);

   m_primary_title.Format("FLAPS");
   needle.Format("%c", AOA_NEEDLE);

   TICK_INFO   tick_info;

   tick_info.location   =  90.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "UP");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.0;
   tick_info.type       =  NO_TICK;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  130.0;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "TO");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  150.0f;
   tick_info.type       =  NO_TICK;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  170.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "LDG");
   theTicks.TickList.AddTail(tick_info);

   theTicks.GenerateLists();

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
        glPushMatrix();
        {
           // Draw the standard stuff, (bezel, screw heads, and primary title).
           CPanel::Draw();

           glTranslatef(0.0f, 0.6f, 0.0f);
           primary_title.Draw(m_primary_title,   true, 0.0f, 2.5f, 1.0f);

           //(-0.3f,  0.2f, 0.0f);
           glTranslatef(-0.3f,  -0.4f, 0.0f);

           // Draw tick marks and labels.
           theTicks.DrawTickMarks();
           theTicks.DrawTickLabels();
        }
        glPopMatrix();
   }
   glEndList();
}

void  CFlapPositionGauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      glRotatef(-m_flapPosition_angle, 0.0f, 0.0f, 1.0f);
      flapPositionNeedle.Draw(needle,  true, 0.0f, 20.0f, 1.0f);
   }
   glPopMatrix();

   EndDraw();
}

void  CFlapPositionGauge::SetFlapPosition(float flapPosition)
{
   if (flapPosition  >  0.0f)
      m_flapPosition_angle_cv =  170.0f   -  (80.0f/50.0f  *  flapPosition);
   else
      m_flapPosition_angle_cv =  170.0f;
}

CWidget* CFlapPositionGauge::CreateObject()
{
   return new CFlapPositionGauge();
}

void CFlapPositionGauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Flap Position")
   {
      SetFlapPosition(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CFlapPositionGauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CFlapPositionGauge::UpdateRenderVariables()
{
   m_flapPosition_angle = m_flapPosition_angle_cv;

   return CWidget::UpdateRenderVariables();
}
