// Fire.cpp: implementation of the CFire class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "Fire.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CFire::CFire()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Fire_Panel");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(64,64));

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("annunciator_fire1");
   m_listGraphicalElementVars.push_back("annunciator_fire2");

   m_top_lt_on       =  false;
   m_top_lt_on_cv    =  m_top_lt_on;
   
   m_bottom_lt_on    =  false;
   m_bottom_lt_on_cv =  m_bottom_lt_on;

   m_list   =  -1;
}

CFire::~CFire()
{
}

void  CFire::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   m_CStr_fire =  "FIRE";
   fire.SetForegroundColor(16, 0, 0);

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();
      }
      glPopMatrix();
   }
   glEndList();
}

void  CFire::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);   


      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);

      if (m_top_lt_on)
         glRGB(255,  0, 0);
      else if (m_bottom_lt_on)
         glRGB(160,  0, 0);
      else
         glRGB(64,   0, 0);

      // Draw the top light's background
      glBegin(GL_QUADS);
         glVertex2f(-0.9f  /  m_aspect_ratio, 0.0f);
         glVertex2f( 0.9f  /  m_aspect_ratio, 0.0f);
         glVertex2f( 0.9f  /  m_aspect_ratio, 0.8f);
         glVertex2f(-0.9f  /  m_aspect_ratio, 0.8f);
      glEnd();


      if (m_bottom_lt_on)
         glRGB(255,  0, 0);
      else if (m_top_lt_on)
         glRGB(160,  0, 0);
      else
         glRGB(64,   0, 0);

      // Draw the bottom light's background
      glBegin(GL_QUADS);
         glVertex2f(-0.9f  /  m_aspect_ratio, -0.8f);
         glVertex2f( 0.9f  /  m_aspect_ratio, -0.8f);
         glVertex2f( 0.9f  /  m_aspect_ratio, 0.0f);
         glVertex2f(-0.9f  /  m_aspect_ratio, 0.0f);
      glEnd();

      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);


      fire.Draw(m_CStr_fire, true, 0.0f, 7.5f /  m_aspect_ratio);
   }
   glPopMatrix();

   EndDraw();
}

CWidget* CFire::CreateObject()
{
   return new CFire();
}

void CFire::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar      == "annunciator_fire1")
      m_top_lt_on_cv       =  (bool)*pVariant;
   else if (rstrElementVar == "annunciator_fire2")
      m_bottom_lt_on_cv    =  (bool)*pVariant;
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CFire::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 24 June 1999
//
// Engineer         : Charles Brissey
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CFire::UpdateRenderVariables()
{
   m_top_lt_on    =  m_top_lt_on_cv;
   m_bottom_lt_on =  m_bottom_lt_on_cv;

   return CWidget::UpdateRenderVariables();
}
