// Engine3Gauge.h: interface for the CEngine3Gauge class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ENGINE3GAUGE_H__E02411D4_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_ENGINE3GAUGE_H__E02411D4_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"

#ifndef  HAF
   const int   MAX_NACWS_THREATS       =  2;
   const float NACWS_OUTER_RING_RADIUS =  0.70f;
   const float NACWS_INNER_RING_RADIUS =  NACWS_OUTER_RING_RADIUS *  0.5f;
   const float MAX_NACWS_RANGE         =  20.0f;
#endif

class CEngine3Gauge : public COpenGLWidget, public CPanel
{
public:
	CEngine3Gauge();
	virtual ~CEngine3Gauge();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();

   void  SetTemperatureValue(float temperature);
   void  SetHydraulicPressureValue(float hydraulicPressure);
   void  SetOilPressureValue(float oilPressure);
   void  SetVoltageValue(float voltage);
   void  SetAmperageValue(float amperage);

#ifndef  HAF
   void  DrawNacwsDisplay(void);
#endif

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

protected:
   CTicks      temperatureTicks;
   CTicks      temperatureGreenTicks;
   CTicks      temperatureRedTicks;
   CTicks      temperatureYellowTicks;
   COpenGLtext temperatureLabel;
   COpenGLtext temperatureNeedle;
   COpenGLtext temperatureValue;
   CString     m_CStr_temperature;
   CString     m_CStr_temperature_cv;
   float       m_temperature_angle;
   float       m_temperature_angle_cv;
   float       m_temperature;
   float       m_temperature_cv;
   void        SetupTemperatureTicks(void);

   CTicks      oilPressureTicks;
   CTicks      oilPressureGreenTicks;
   CTicks      oilPressureYellowTicks;
   CTicks      oilPressureRedTicks;
   COpenGLtext oilPressureLabel;
   COpenGLtext oilPressureNeedle;
   COpenGLtext oilPressureValue;
   CString     m_CStr_oilPressure;
   CString     m_CStr_oilPressure_cv;
   float       m_oilPressure_angle;
   float       m_oilPressure_angle_cv;
   float       m_oilPressure;
   float       m_oilPressure_cv;
   void        SetupOilPressureTicks(void);

   CTicks      hydraulicPressureTicks;
   CTicks      hydraulicPressureGreenTicks;
   CTicks      hydraulicPressureYellowTicks;
   COpenGLtext hydraulicPressureLabel;
   COpenGLtext hydraulicPressureNeedle;
   COpenGLtext hydraulicPressureValue;
   CString     m_CStr_hydraulicPressure;
   CString     m_CStr_hydraulicPressure_cv;
   float       m_hydraulicPressure_angle;
   float       m_hydraulicPressure_angle_cv;
   float       m_hydraulicPressure;
   float       m_hydraulicPressure_cv;
   void        SetupHydraulicPressureTicks(void);


   COpenGLtext voltageLabel;
   COpenGLtext voltageValue;
   CString     m_CStr_voltage;
   CString     m_CStr_voltage_cv;
   float       m_voltage;
   float       m_voltage_cv;

   COpenGLtext amperageLabel;
   COpenGLtext amperageValue;
   CString     m_CStr_amperage;
   CString     m_CStr_amperage_cv;
   float       m_amperage;
   float       m_amperage_cv;

   COpenGLtext oilTitle;
   CString     m_CStr_oilTitle;

   CString     m_CStr_needle;
   CString     m_CStr_temperature_title;
   CString     m_CStr_pressure_title;
   CString     m_CStr_hydraulic_pressure_title;

   enum
   {
      BEZEL,
      STATIC_TICKS,
      MAX_NUMBER_OF_LISTS
   };
   int         m_int_lists[MAX_NUMBER_OF_LISTS];

   bool        m_bool_exceedence_found;

   bool        m_bool_TAS_installed;

#ifndef  HAF
   COpenGLtext nacwsSystemMode;
   CString     m_CStr_nacwsSystemMode;

   COpenGLtext nacwsStatus;
   CString     m_CStr_nacwsStatus;


   CTicks      nacwsOuterTicks;
   CTicks      nacwsInnerTicks;
   void        SetupNacwsOuterTicks(void);
   void        SetupNacwsInnerTicks(void);


   typedef  struct   nacws_type
   {
      float       delta_altitude;
      float       bearing;
      float       range;
      bool        threat;
      bool        unknown_altitude;
      int         flash_counter;
      int         flash_counter_sign;
      bool        active;
      CTime       startTime;
      CTime       currentTime;
      CTimeSpan   elapsedTime;
   }  NACWS;

   NACWS       m_NACWS_list[MAX_NACWS_THREATS];

   bool        m_bool_nacws_off;
   bool        m_bool_nacws_off_cv;

   bool        m_bool_nacws_selected;
   bool        m_bool_nacws_selected_cv;
   CTime       m_CTime_nacws_deselected_startTime;
   CTime       m_CTime_nacws_currentTime;
   CTimeSpan   m_CTimeSpan_elapsedTime;

   float       m_float_Nacws_Display_Range;
   float       m_float_Nacws_Display_Range_cv;
   CString     m_CStr_nacws_display_outer_range;
   CString     m_CStr_nacws_display_inner_range;
   COpenGLtext range;

   long        m_long_nacws_system_status;
   long        m_long_nacws_system_status_cv;

   bool        m_bool_nacws_test;
   bool        m_bool_nacws_test_cv;

   long        m_long_nacws_status;
   long        m_long_nacws_status_cv;

   long        m_long_nacws_system_mode;
   long        m_long_nacws_system_mode_cv;

   long        m_long_nacws_detection_mode;
   long        m_long_nacws_detection_mode_cv;

   float       m_float_nacws_intr_range_1;
   float       m_float_nacws_intr_range_1_cv;

   float       m_float_nacws_intr_range_2;
   float       m_float_nacws_intr_range_2_cv;

   float       m_float_nacws_intr_rel_alt_1;
   float       m_float_nacws_intr_rel_alt_1_cv;

   float       m_float_nacws_intr_rel_alt_2;
   float       m_float_nacws_intr_rel_alt_2_cv;

   long        m_long_nacws_intr_disp_type_1;
   long        m_long_nacws_intr_disp_type_1_cv;

   long        m_long_nacws_intr_disp_type_2;
   long        m_long_nacws_intr_disp_type_2_cv;

   float       m_float_nacws_intr_brg_1;
   float       m_float_nacws_intr_brg_1_cv;

   float       m_float_nacws_intr_brg_2;
   float       m_float_nacws_intr_brg_2_cv;

   bool        m_bool_nacws_intr_active_1;
   bool        m_bool_nacws_intr_active_1_cv;

   bool        m_bool_nacws_intr_active_2;
   bool        m_bool_nacws_intr_active_2_cv;

   bool        m_bool_nacws_on;
   bool        m_bool_nacws_on_cv;

   bool        m_bool_nacws_show_list;
#endif

private:

// Attributes
public:
  	enum { IDB = IDB_ENGINE_OIL  };
};

#endif // !defined(AFX_ENGINE3GAUGE_H__E02411D4_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
