// Engine2Gauge.h: interface for the CEngine2Gauge class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ENGINE2GAUGE_H__E02411D3_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_ENGINE2GAUGE_H__E02411D3_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"

class CEngine2Gauge : public COpenGLWidget, public CPanel
{
public:
	CEngine2Gauge();
	virtual ~CEngine2Gauge();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();

   void  SetTorqueValue(float torque);
   void  SetN1Value(float n1);
   void  SetCockpitAltValue(float cockpitAlt);
   void  SetRawIttValue(float rawItt);
   void  SetCockpitDiffPressValue(float cockpitDiffPress);
   void  SetFuelFlowValue(float fuelFlow);
   void  SetLeftFuelQuantityValue(float leftFuelQuantity);
   void  SetRightFuelQuantityValue(float rightFuelQuantity);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

protected:
   COpenGLtext primary_title;
   CString     m_primary_title;

   COpenGLtext torqueLabel;
   CString     torque;
   CString     n1;
   CString     cockpit_alt;
   CString     r_itt;
   CString     delta_p;
   CString     ff;
   CString     lbs_x100;
   CString     needle;

   COpenGLtext torqueValue;
   CString     m_torque_value;
   CString     m_torque_value_cv;

   COpenGLtext n1Label;
   COpenGLtext n1Value;
   CString     m_n1_value;
   CString     m_n1_value_cv;

   COpenGLtext cockpitAltLabel;
   COpenGLtext cockpitAltValue;
   CString     m_cockpitAlt_value;
   CString     m_cockpitAlt_value_cv;

   COpenGLtext rawIttLabel;
   COpenGLtext rawIttValue;
   CString     m_rawItt_value;
   CString     m_rawItt_value_cv;

   COpenGLtext cockpitDiffPressLabel;
   COpenGLtext cockpitDiffPressValue;
   CString     m_cockpitDiffPress_value;
   CString     m_cockpitDiffPress_value_cv;

   COpenGLtext fuelFlowLabel;
   COpenGLtext fuelFlowValue;
   CString     m_fuelFlow_value;
   CString     m_fuelFlow_value_cv;

   COpenGLtext fuelQuantityLabel;

   CTicks      leftFuelQuantityTicks;
   CTicks      leftFuelQuantityYellowTicks;
   CString     m_leftFuelQuantity_value;

   CTicks      rightFuelQuantityTicks;
   CTicks      rightFuelQuantityYellowTicks;
   CString     m_rightFuelQuantity_value;

   COpenGLtext leftfuelQuantityNeedle;
   COpenGLtext rightfuelQuantityNeedle;

   COpenGLtext fpFail;
   CString     m_CStr_fpFail;

   bool        m_bool_Power;
   bool        m_bool_Power_cv;

private:
   float m_torque;
   float m_n1;
   float m_cockpitAlt;
   float m_rawItt;
   float m_cockpitDiffPress;
   float m_fuelFlow;

   float m_torque_cv;
   float m_n1_cv;
   float m_cockpitAlt_cv;
   float m_rawItt_cv;
   float m_cockpitDiffPress_cv;
   float m_fuelFlow_cv;

   void  SetupLeftFuelQuantityTicks(void);
   float m_leftFuelQuantity_angle;
   float m_leftFuelQuantity_angle_cv;

   void  SetupRightFuelQuantityTicks(void);
   float m_rightFuelQuantity_angle;
   float m_rightFuelQuantity_angle_cv;

   bool  m_fpFail;
   bool  m_Left_Ob_Probe_Fail_cv;
   bool  m_Left_Mid_Probe_Fail_cv;
   bool  m_Left_Ib_Probe_Fail_cv;
   bool  m_Right_Ob_Probe_Fail_cv;
   bool  m_Right_Mid_Probe_Fail_cv;
   bool  m_Right_Ib_Probe_Fail_cv;
   bool  m_Collector_Probe_Fail_cv;

// Attributes
public:
  	enum { IDB = IDB_ENGINE_SECONDARY  };
};

#endif // !defined(AFX_ENGINE2GAUGE_H__E02411D3_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
