// Engine2Gauge.cpp: implementation of the CEngine2Gauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "..\core\dataconversion.h"
#include "Engine2Gauge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CEngine2Gauge::CEngine2Gauge()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Engine_Secondary");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(200,200));

   m_torque_value.Format("%.0f%%", 0.0f);
   m_n1_value.Format("%.0f%%", 0.0f);
   m_cockpitAlt_value.Format("%.0f FT", 0.0f);
   m_rawItt_value.Format("%.0f%cC", 0.0f, DEGREES);
   m_cockpitDiffPress_value.Format("%.1f\nPSI", 0.0f);
   m_fuelFlow_value.Format("%.0f\nPPH", 0.0f);
   m_leftFuelQuantity_angle   =  -135.0f;
   m_rightFuelQuantity_angle  =  135.0f;

   m_torque_value_cv             =  m_torque_value;
   m_n1_value_cv                 =  m_n1_value;
   m_cockpitAlt_value_cv         =  m_cockpitAlt_value;
   m_rawItt_value_cv             =  m_rawItt_value;
   m_cockpitDiffPress_value_cv   =  m_cockpitDiffPress_value;
   m_fuelFlow_value_cv           =  m_fuelFlow_value;
   m_leftFuelQuantity_angle_cv   =  m_leftFuelQuantity_angle;
   m_rightFuelQuantity_angle_cv  =  m_rightFuelQuantity_angle;
   m_fpFail                      =  false;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("cockpit_alt");
   m_listGraphicalElementVars.push_back("cockpit_diff_press");
   m_listGraphicalElementVars.push_back("cockpit_rate_of_change");
   m_listGraphicalElementVars.push_back("fuel_flow");
   m_listGraphicalElementVars.push_back("raw_itt");
   m_listGraphicalElementVars.push_back("leftFuelQuantity");
   m_listGraphicalElementVars.push_back("rightFuelQuantity");
   m_listGraphicalElementVars.push_back("N1");
   m_listGraphicalElementVars.push_back("Torque");

   m_listGraphicalElementVars.push_back("Left_Ob_Probe_Fail");
   m_listGraphicalElementVars.push_back("Left_Mid_Probe_Fail");
   m_listGraphicalElementVars.push_back("Left_Ib_Probe_Fail");
   m_listGraphicalElementVars.push_back("Right_Ob_Probe_Fail");
   m_listGraphicalElementVars.push_back("Right_Mid_Probe_Fail");
   m_listGraphicalElementVars.push_back("Right_Ib_Probe_Fail");
   m_listGraphicalElementVars.push_back("Collector_Probe_Fail");
   m_listGraphicalElementVars.push_back("Aed_Power");


   m_list            =  -1;
   m_bool_Power      = true;
   m_bool_Power_cv   = true;

}

CEngine2Gauge::~CEngine2Gauge()
{
}


void  CEngine2Gauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   // Fuel gauge shared primary title.
   m_primary_title.Format("FUEL\nQTY\nL   R");

   torque.Format("TORQUE");
   n1.Format("N1");
   cockpit_alt.Format("COCKPIT\nALT");
   r_itt.Format("R ITT");
   delta_p.Format("%c P", DELTA);
   ff.Format("FF");
   lbs_x100.Format("LBS\nX100");
   needle.Format("%c", NOMINAL_NEEDLE);
   m_CStr_fpFail  =  "FP FAIL";

   fpFail.SetBackgroundColor(true, 0, 0, 0);
   fpFail.SetForegroundColor(255, 255, 0);

   SetupLeftFuelQuantityTicks();
   SetupRightFuelQuantityTicks();

   if (m_list != -1)
      glDeleteLists(m_list,1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      // Draw the standard stuff, (bezel, screw heads, and primary title).
      CPanel::Draw();

      glPushMatrix();
         primary_title.SetForegroundColor(192, 192, 192);
         glTranslatef(-0.25f, -0.25f, 0.0f);
         primary_title.Draw(m_primary_title,   true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      // Torque portion of Gauge.
      glPushMatrix();
         glTranslatef(-0.50f, 0.80f, 0.0f);
         torqueLabel.SetForegroundColor(192, 192, 192);
         torqueLabel.Draw(torque,   true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      // N1 portion of Gauge
      glPushMatrix();
         glTranslatef( 0.0f, 0.80f, 0.0f);
         n1Label.SetForegroundColor(192, 192, 192);
         n1Label.Draw(n1,  true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      // Cockpit Alt portion of Gauge
      glPushMatrix();
         glTranslatef( 0.5f, 0.80f, 0.0f);
         cockpitAltLabel.SetForegroundColor(192, 192, 192);
         cockpitAltLabel.Draw(cockpit_alt,   true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      // Raw ITT portion of Gauge
      glPushMatrix();
//         glTranslatef(-0.50f, 0.40f, 0.0f);
         glTranslatef(-0.50f, 0.45f, 0.0f);
         rawIttLabel.SetForegroundColor(192, 192, 192);
         rawIttLabel.Draw(r_itt, true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      // Cockpit Differential Pressure portion of Gauge
      glPushMatrix();
//         glTranslatef(0.6f, 0.30f, 0.0f);
         glTranslatef(0.6f, 0.35f, 0.0f);
         cockpitDiffPressLabel.SetForegroundColor(192, 192, 192);
         cockpitDiffPressLabel.Draw(delta_p, true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();
     
      // Fuel Flow portion of Gauge
      glPushMatrix();
//         glTranslatef(0.6f, -0.50f, 0.0f);
         glTranslatef(0.6f, -0.45f, 0.0f);
         fuelFlowLabel.SetForegroundColor(192, 192, 192);
         fuelFlowLabel.Draw(ff,  true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();


      // Fuel gauge shared secondary title.
      glPushMatrix();
         glTranslatef(-0.25f, -0.65f, 0.0f);
         fuelQuantityLabel.SetForegroundColor(192, 192, 192);
         fuelQuantityLabel.Draw(lbs_x100, true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      // Left Fuel Gauge
      glPushMatrix();
         glTranslatef(-0.25f, -0.35f, 0.0f);
         leftFuelQuantityTicks.Draw();
         leftFuelQuantityTicks.DrawArc(false, -108.0f, -9.0f, 1.5f);

         leftFuelQuantityYellowTicks.Draw();
         leftFuelQuantityYellowTicks.DrawArc(false, -135.0f, -108.0f, 1.5f);

         rightFuelQuantityTicks.Draw();
         rightFuelQuantityTicks.DrawArc(false, 9.0f, 108.0f, 1.5f);

         rightFuelQuantityYellowTicks.Draw();
         rightFuelQuantityYellowTicks.DrawArc(false, 108.0f, 135.0f, 1.5f);
      glPopMatrix();
   }
   glEndList();
}

void  CEngine2Gauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      // Torque portion of Gauge.
      glPushMatrix();
//         glTranslatef(-0.50f, 0.58f, 0.0f);
         glTranslatef(-0.50f, 0.65f, 0.0f);
         torqueValue.Draw(m_torque_value, true, 0.0f, 1.75f, 1.0f);
      glPopMatrix();

      // N1 portion of Gauge
      glPushMatrix();
//        glTranslatef(0.0f, 0.58f, 0.0f);
        glTranslatef(0.0f, 0.65f, 0.0f);
        n1Value.Draw(m_n1_value,   true, 0.0f, 1.75f, 1.0f);
      glPopMatrix();


      // Cockpit Alt portion of Gauge
      glPushMatrix();
//         glTranslatef( 0.5f, 0.48f, 0.0f);
         glTranslatef( 0.5f, 0.55f, 0.0f);
         cockpitAltValue.Draw(m_cockpitAlt_value,  true, 0.0f, 1.75f, 1.0f);
      glPopMatrix();


      // Raw ITT portion of Gauge
      glPushMatrix();
//         glTranslatef(-0.50f, 0.28f, 0.0f);
         glTranslatef(-0.50f, 0.30f, 0.0f);
         rawIttValue.Draw(m_rawItt_value, true, 0.0f, 1.75f, 1.0f);
      glPopMatrix();


      // Cockpit Differential Pressure portion of Gauge
      glPushMatrix();
//         glTranslatef(0.6f, 0.18f, 0.0f);
         glTranslatef(0.6f, 0.20f, 0.0f);
         cockpitDiffPressValue.Draw(m_cockpitDiffPress_value,  true, 0.0f, 1.75f, 1.0f);
      glPopMatrix();

   
      // Fuel Flow portion of Gauge
      glPushMatrix();
//         glTranslatef(0.6f, -0.62f, 0.0f);
         glTranslatef(0.6f, -0.60f, 0.0f);
         fuelFlowValue.Draw(m_fuelFlow_value,   true, 0.0f, 1.75f, 1.0f);
      glPopMatrix();


      glPushMatrix();
         glTranslatef(-0.25f, -0.35f, 0.0f);
         // Left Fuel Gauge
         glPushMatrix();
            glRotatef(-m_leftFuelQuantity_angle, 0.0f, 0.0f, 1.0f);
            glTranslatef( 0.0f, 0.125f, 0.0f);
            leftfuelQuantityNeedle.Draw(needle, true, 0.0f, 15.0f, 1.0f);
         glPopMatrix();
         // Right Fuel Gauge
         glPushMatrix();
            glRotatef(-m_rightFuelQuantity_angle, 0.0f, 0.0f, 1.0f);
            glTranslatef( 0.0f, 0.125f, 0.0f);
            rightfuelQuantityNeedle.Draw(needle, true, 0.0f, 15.0f, 1.0f);
         glPopMatrix();
      glPopMatrix();

      if (m_fpFail)
      {
         glPushMatrix();
            glTranslatef(0.0f, -0.78f, 0.0f);
            fpFail.Draw(m_CStr_fpFail, true, 0.0f, 1.6f);
         glPopMatrix();
      }
   }
   glPopMatrix();

   if (!m_bool_Power)
   {
      glColor4ub(255, 255, 255, 64);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_QUADS);
            glVertex2f(-1.0f, 1.0f);
            glVertex2f( 1.0f, 1.0f);
            glVertex2f( 1.0f, -1.0f);
            glVertex2f(-1.0f, -1.0f);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }

   EndDraw();
}


void  CEngine2Gauge::SetTorqueValue(float torque)
{
   m_torque_cv          =  torque;
   m_torque_value_cv.Format("%.0f%%", torque);
}

void  CEngine2Gauge::SetN1Value(float n1)
{
   m_n1_cv           =  n1;
   m_n1_value_cv.Format("%.0f%%", n1);
}

void  CEngine2Gauge::SetCockpitAltValue(float cockpitAlt)
{
   m_cockpitAlt_cv   =  ROUND(cockpitAlt, 0.01);   // Round to the nearest 100.
   m_cockpitAlt_value_cv.Format("%.0f FT", m_cockpitAlt_cv);
}

void  CEngine2Gauge::SetRawIttValue(float rawItt)
{
   m_rawItt_cv       =  rawItt;
   m_rawItt_value_cv.Format("%.0f%cC", rawItt, DEGREES);
}

void  CEngine2Gauge::SetCockpitDiffPressValue(float cockpitDiffPress)
{
   m_cockpitDiffPress_cv   =  cockpitDiffPress;
   m_cockpitDiffPress_cv   =  ROUND(cockpitDiffPress, 10.0);   // Round to the nearest 0.1.
   m_cockpitDiffPress_value_cv.Format("%.1f\nPSI", m_cockpitDiffPress_cv);
}

void  CEngine2Gauge::SetFuelFlowValue(float fuelFlow)
{
   m_fuelFlow_cv  =  ROUND(fuelFlow, 0.2);   // Round to the nearest 5.
   m_fuelFlow_value_cv.Format("%.0f\nPPH", m_fuelFlow_cv);
}

void  CEngine2Gauge::SetLeftFuelQuantityValue(float leftFuelQuantity)
{
   if (leftFuelQuantity  >  0.0f && leftFuelQuantity  <  700.0f)
      m_leftFuelQuantity_angle_cv   =  (126.0f/700.0f * leftFuelQuantity) - 135.0f;
   else if (leftFuelQuantity  >= 700.0f)
      m_leftFuelQuantity_angle_cv   =  -9.0f;
   else
      m_leftFuelQuantity_angle_cv   =  -135.0f;

   if (leftFuelQuantity < 150.5f)
      leftfuelQuantityNeedle.SetForegroundColor(255, 255, 0);    // Yellow
   else
      leftfuelQuantityNeedle.SetForegroundColor(255, 255, 255);  // White
}

void  CEngine2Gauge::SetRightFuelQuantityValue(float rightFuelQuantity)
{
   if (rightFuelQuantity  >  0.0f && rightFuelQuantity  <  700.0f)
      m_rightFuelQuantity_angle_cv  =  135.0f -  (126.0f/700.0f * rightFuelQuantity);
   else if (rightFuelQuantity  >= 700.0f)
      m_rightFuelQuantity_angle_cv   =   9.0f;
   else
      m_rightFuelQuantity_angle_cv   =   135.0f;

   if (rightFuelQuantity < 150.5f)
      rightfuelQuantityNeedle.SetForegroundColor(255, 255, 0);    // Yellow
   else
      rightfuelQuantityNeedle.SetForegroundColor(255, 255, 255);  // White
}

void  CEngine2Gauge::SetupLeftFuelQuantityTicks(void)
{
   leftFuelQuantityTicks.Initialize();
   leftFuelQuantityTicks.SetLabelRadius(0.50f);
   leftFuelQuantityTicks.SetOuterRadius(0.42f);
   leftFuelQuantityTicks.SetLabelProperties(1.6f, 1.0f);
   leftFuelQuantityTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;


   tick_info.location   =  252.0f;
   tick_info.type       =  NO_TICK;
   strcpy(tick_info.ident, "");
   leftFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  261.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "2");
   leftFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  279.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "3");
   leftFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  297.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "4");
   leftFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  315.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "5");
   leftFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  333.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "6");
   leftFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  351.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "7");
   leftFuelQuantityTicks.TickList.AddTail(tick_info);

   leftFuelQuantityTicks.GenerateLists();

   leftFuelQuantityYellowTicks.Initialize();
   leftFuelQuantityYellowTicks.SetLabelRadius(0.50f);
   leftFuelQuantityYellowTicks.SetOuterRadius(0.42f);
   leftFuelQuantityYellowTicks.SetLabelProperties(1.6f, 1.0f);
   leftFuelQuantityYellowTicks.SetTickColor(255, 255, 0);

   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "0");
   leftFuelQuantityYellowTicks.TickList.AddTail(tick_info);

   tick_info.location   =  243.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "1");
   leftFuelQuantityYellowTicks.TickList.AddTail(tick_info);

   leftFuelQuantityYellowTicks.GenerateLists();
}


void  CEngine2Gauge::SetupRightFuelQuantityTicks(void)
{
   rightFuelQuantityTicks.Initialize();
   rightFuelQuantityTicks.SetLabelRadius(0.50f);
   rightFuelQuantityTicks.SetOuterRadius(0.42f);
   rightFuelQuantityTicks.SetLabelProperties(1.6f, 1.0f);
   rightFuelQuantityTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;


   tick_info.location   =  9.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "7");
   rightFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  27.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "6");
   rightFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  45.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "5");
   rightFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  63.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "4");
   rightFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  81.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "3");
   rightFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  99.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "2");
   rightFuelQuantityTicks.TickList.AddTail(tick_info);

   tick_info.location   =  108.0f;
   tick_info.type       =  NO_TICK;
   strcpy(tick_info.ident, "");
   rightFuelQuantityTicks.TickList.AddTail(tick_info);

   rightFuelQuantityTicks.GenerateLists();

   rightFuelQuantityYellowTicks.Initialize();
   rightFuelQuantityYellowTicks.SetLabelRadius(0.50f);
   rightFuelQuantityYellowTicks.SetOuterRadius(0.42f);
   rightFuelQuantityYellowTicks.SetLabelProperties(1.6f, 1.0f);
   rightFuelQuantityYellowTicks.SetTickColor(255, 255, 0);

   tick_info.location   =  117.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "1");
   rightFuelQuantityYellowTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "0");
   rightFuelQuantityYellowTicks.TickList.AddTail(tick_info);

   rightFuelQuantityYellowTicks.GenerateLists();
}

CWidget* CEngine2Gauge::CreateObject()
{
   return new CEngine2Gauge();
}

void CEngine2Gauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar            == "cockpit_alt")
   {
      SetCockpitAltValue(*pVariant);
   }
   else if (rstrElementVar       == "cockpit_diff_press")
   {
      SetCockpitDiffPressValue(*pVariant);
   }
   else if (rstrElementVar       == "fuel_flow")
   {
      SetFuelFlowValue(*pVariant);
   }
   else if (rstrElementVar       == "leftFuelQuantity")
   {
      SetLeftFuelQuantityValue(*pVariant);
   }
   else if (rstrElementVar       == "N1")
   {
      SetN1Value(*pVariant);
   }
   else if (rstrElementVar       == "raw_itt")
   {
      SetRawIttValue(*pVariant);
   }
   else if (rstrElementVar       == "rightFuelQuantity")
   {
      SetRightFuelQuantityValue(*pVariant);
   }
   else if (rstrElementVar       == "Torque")
   {
      SetTorqueValue(*pVariant);
   }
   else if (rstrElementVar       == "Left_Ob_Probe_Fail")
   {
      m_Left_Ob_Probe_Fail_cv    =  (bool)*pVariant;
   }
   else if (rstrElementVar       == "Left_Mid_Probe_Fail")
   {
      m_Left_Mid_Probe_Fail_cv   =  (bool)*pVariant;
   }
   else if (rstrElementVar       == "Left_Ib_Probe_Fail")
   {
      m_Left_Ib_Probe_Fail_cv    =  (bool)*pVariant;
   }
   else if (rstrElementVar       == "Right_Ob_Probe_Fail")
   {
      m_Right_Ob_Probe_Fail_cv   =  (bool)*pVariant;
   }
   else if (rstrElementVar       == "Right_Mid_Probe_Fail")
   {
      m_Right_Mid_Probe_Fail_cv  =  (bool)*pVariant;
   }
   else if (rstrElementVar       == "Right_Ib_Probe_Fail")
   {
      m_Right_Ib_Probe_Fail_cv   =  (bool)*pVariant;
   }
   else if (rstrElementVar       == "Collector_Probe_Fail")
   {
      m_Collector_Probe_Fail_cv  =  (bool)*pVariant;
   }
   else if (rstrElementVar       == "Aed_Power")
   {
      m_bool_Power_cv            =  (bool)*pVariant;
   }

}

/////////////////////////////////////////////////////////////////////////////
//
// bool CEngine2Gauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CEngine2Gauge::UpdateRenderVariables()
{
   m_torque                   =  m_torque_cv;
   m_torque_value             =  m_torque_value_cv;
   m_n1                       =  m_n1_cv;
   m_n1_value                 =  m_n1_value_cv;
   m_cockpitAlt               =  m_cockpitAlt_cv;
   m_cockpitAlt_value         =  m_cockpitAlt_value_cv;
   m_rawItt                   =  m_rawItt_cv;
   m_rawItt_value             =  m_rawItt_value_cv;
   m_cockpitDiffPress         =  m_cockpitDiffPress_cv;
   m_cockpitDiffPress_value   =  m_cockpitDiffPress_value_cv;
   m_fuelFlow                 =  m_fuelFlow_cv;
   m_fuelFlow_value           =  m_fuelFlow_value_cv;
   m_leftFuelQuantity_angle   =  m_leftFuelQuantity_angle_cv;
   m_rightFuelQuantity_angle  =  m_rightFuelQuantity_angle_cv;
   
   m_fpFail                   =  (  m_Left_Ob_Probe_Fail_cv    || m_Left_Mid_Probe_Fail_cv   || m_Left_Ib_Probe_Fail_cv    ||
                                    m_Right_Ob_Probe_Fail_cv   || m_Right_Mid_Probe_Fail_cv  || m_Right_Ib_Probe_Fail_cv   ||
                                    m_Collector_Probe_Fail_cv);

   if (m_torque   >  100.0f)
      torqueValue.SetBackgroundColor(true, 255,  0,  0);
   else
      torqueValue.SetBackgroundColor(false, 0,  0,  0);

   if (m_n1 >  104.0f)
      n1Value.SetBackgroundColor(true, 255,  0,  0);
   else
      n1Value.SetBackgroundColor(false, 0,  0,  0);

   if (m_cockpitAlt >  19100.0f)
   {
      cockpitAltValue.SetForegroundColor(0, 0, 0);
      cockpitAltValue.SetBackgroundColor(true, 255, 255,  0);
   }
   else
   {
      cockpitAltValue.SetForegroundColor(255, 255, 255);
      cockpitAltValue.SetBackgroundColor(false, 0,  0,  0);
   }

   if (m_rawItt   >  820.0f)
      rawIttValue.SetBackgroundColor(true, 255,  0,  0);
   else
      rawIttValue.SetBackgroundColor(false, 0,  0,  0);

   if (m_cockpitDiffPress  >= 4.0f)
      cockpitDiffPressValue.SetBackgroundColor(true, 255, 0,  0);
   else
      cockpitDiffPressValue.SetBackgroundColor(false, 0,  0,  0);

   m_bool_Power                     =  m_bool_Power_cv;

   return CWidget::UpdateRenderVariables();
}
