// Engine1Gauge.h: interface for the CEngine1Gauge class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ENGINE1GAUGE_H__E02411D2_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_ENGINE1GAUGE_H__E02411D2_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"

class CEngine1Gauge : public COpenGLWidget, public CPanel
{
public:
	CEngine1Gauge();
	virtual ~CEngine1Gauge();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();

   void  SetTorqueValue(float torque);
   void  SetIttValue(float itt);
   void  SetN1Value(float n1);
   void  SetNpValue(float np);
   void  SetOatValue(float oat);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

protected:
   CTicks      torqueTicks;
   CTicks      torqueRedTicks;
   COpenGLtext torqueLabel;
   COpenGLtext torqueNeedle;
   COpenGLtext torqueValue;
   CString     m_torque_value;
   CString     m_torque_value_cv;

   CString     torque;
   CString     torque_needle;
   CString     nominal_needle;
   CString     itt;
   CString     n1;
   CString     np;
   CString     oat;


   CTicks      ittTicks;
   CTicks      ittRedTicks;
   COpenGLtext ittLabel;
   COpenGLtext ittNeedle;
   COpenGLtext ittValue;
   CString     m_itt_value;
   CString     m_itt_value_cv;

   CTicks      ittStartModeTicks;
   CTicks      ittStartModeRedTicks;


   CTicks      n1Ticks;
   CTicks      n1GreenTicks;
   CTicks      n1RedTicks;
   COpenGLtext n1Label;
   COpenGLtext n1Needle;
   COpenGLtext n1Value;
   CString     m_n1_value;
   CString     m_n1_value_cv;

   COpenGLtext npLabel;
   COpenGLtext npValue;
   CString     m_np_value;
   CString     m_np_value_cv;

   COpenGLtext oatLabel;
   COpenGLtext oatValue;
   CString     m_oat_value;
   CString     m_oat_value_cv;


private:
   void  SetupTorqueTicks(void);
   void  SetupIttTicks(void);
   void  SetupIttStartModeTicks(void);
   void  SetupN1Ticks(void);
   float m_torque_angle;
   float m_torque;
   float m_itt_angle;
   float m_itt;
   float m_n1_angle;
   float m_n1;

   float m_torque_angle_cv;
   float m_torque_cv;
   float m_itt_angle_cv;
   float m_itt_cv;
   float m_n1_angle_cv;
   float m_n1_cv;

   float m_np;
   float m_oat;

   float m_np_cv;
   float m_oat_cv;

   bool  m_start_mode;
   bool  m_start_mode_cv;

// Attributes
public:
  	enum { IDB = IDB_ENGINE_PRIMARY  };
};

#endif // !defined(AFX_ENGINE1GAUGE_H__E02411D2_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
