// Engine1Gauge.cpp: implementation of the CEngine1Gauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "Engine1Gauge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CEngine1Gauge::CEngine1Gauge()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Engine_Primary");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(200,200));

   m_torque_value.Format("%.0f%%", 0.0f);
   m_itt_value.Format("%.0f%cC", 0.0f, DEGREES);
   m_n1_value.Format("%.0f%%", 0.0f);
   m_np_value.Format("%.0f%%", 0.0f);
   m_oat_value.Format("%.0f%cC", 0.0f, DEGREES);

   m_torque_value_cv = m_torque_value;
   m_itt_value_cv    = m_itt_value;
   m_n1_value_cv     = m_n1_value;
   m_np_value_cv     = m_np_value;
   m_oat_value_cv    = m_oat_value;

   m_start_mode      =  true;
   m_start_mode_cv   =  m_start_mode;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Itt");
   m_listGraphicalElementVars.push_back("N1");
   m_listGraphicalElementVars.push_back("Np");
   m_listGraphicalElementVars.push_back("Oat");
   m_listGraphicalElementVars.push_back("Torque");
   m_listGraphicalElementVars.push_back("Start Mode");

   m_list   =  -1;
}

CEngine1Gauge::~CEngine1Gauge()
{
}

void  CEngine1Gauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   torque   =  "TORQUE";
   itt      =  "ITT";
   n1       =  "N1";
   np       =  "NP";
   oat      =  "IOAT";
   torque_needle.Format("%c", TORQUE_NEEDLE);
   nominal_needle.Format("%c", NOMINAL_NEEDLE);

   oatValue.SetForegroundColor(255, 255, 255);
   oatValue.SetBackgroundColor(false, 0,  0,  0);

   SetupTorqueTicks();
   SetupIttTicks();
   SetupIttStartModeTicks();
   SetupN1Ticks();


   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      // Draw the standard stuff, (bezel, screw heads, and primary title).
      CPanel::Draw();

      // Draw tick marks and labels.
      // Torque portion of Gauge.
      glPushMatrix();
         glTranslatef(-0.25f, 0.25f, 0.0f);
         torqueTicks.Draw();
         torqueTicks.DrawArc(false, -135.0f, 110.3f, 1.5f);
         torqueRedTicks.Draw();
      glPopMatrix();

      glPushMatrix();
         torqueLabel.SetForegroundColor(192, 192, 192);
         glTranslatef(-0.25f, -0.05f, 0.0f);
         torqueLabel.Draw(torque, true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      // ITT portion of Gauge
      glPushMatrix();
         ittLabel.SetForegroundColor(192, 192, 192);
         glTranslatef(-0.4f, -0.75f, 0.0f);
         ittLabel.Draw(itt, true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      glPushMatrix();
         glTranslatef( 0.4f, -0.55f, 0.0f);
         n1Ticks.Draw();
         n1Ticks.DrawArc(false, -135.0f, 12.3f, 1.5f);

         n1GreenTicks.Draw();
         n1GreenTicks.DrawArc(false, 12.3f, 120.1f, 1.5f);

         n1RedTicks.Draw();
      glPopMatrix();

      glPushMatrix();
         n1Label.SetForegroundColor(192, 192, 192);
         glTranslatef(0.4f, -0.75f, 0.0f);
         n1Label.Draw(n1,  true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      glPushMatrix();
         npLabel.SetForegroundColor(192, 192, 192);
         glTranslatef(0.6f, 0.75f, 0.0f);
         npLabel.Draw(np,  true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();

      glPushMatrix();
         oatLabel.SetForegroundColor(192, 192, 192);
         glTranslatef(0.6f, 0.40f, 0.0f);
         oatLabel.Draw(oat,   true, 0.0f, 1.6f, 1.0f);
      glPopMatrix();
   }
   glEndList();
}


void  CEngine1Gauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      // Torque portion of Gauge
      glPushMatrix();
         glTranslatef(-0.25f, 0.25f, 0.0f);
         torqueValue.Draw(m_torque_value, true, 0.0f, 1.75f, 1.0f);

         if (m_torque_angle   >= 110.5f)
            torqueRedTicks.DrawArc(false, 110.5f, m_torque_angle, 1.5f);
 
         glRotatef(-m_torque_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef( 0.0f, 0.125f, 0.0f);
         torqueNeedle.Draw(torque_needle,  true, 0.0f, 14.0f, 1.0f);
      glPopMatrix();

      // ITT portion of Gauge
      glPushMatrix();
         glTranslatef(-0.4f, -0.55f, 0.0f);
         ittValue.Draw(m_itt_value, true, 0.0f, 1.75f, 1.0f);
 
         if (m_start_mode)
         {
            ittStartModeTicks.Draw();
            ittStartModeTicks.DrawArc(false, -135.0f, 135.0f, 1.5f);
            ittStartModeRedTicks.Draw();
         }
         else
         {
            ittTicks.Draw();
            ittTicks.DrawArc(false, -135.0f, 53.8f, 1.5f);
            ittRedTicks.Draw();

            if (m_itt_angle   >= 54.0f)
               ittRedTicks.DrawArc(false, 54.0f, m_itt_angle, 1.5f);
         }

         glRotatef(-m_itt_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef( 0.0f, 0.085f, 0.0f);
         ittNeedle.Draw(nominal_needle,  true, 0.0f, 14.0f, 1.0f);
      glPopMatrix();


      // N1 portion of Gauge
      glPushMatrix();
         glTranslatef( 0.4f, -0.55f, 0.0f);
         n1Value.Draw(m_n1_value,   true, 0.0f, 1.75f, 1.0f);

         if (m_n1_angle   >= 120.3f)
            n1RedTicks.DrawArc(false, 120.3f, m_n1_angle, 1.5f);

         glRotatef(-m_n1_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.085f, 0.0f);
         n1Needle.Draw(nominal_needle, true, 0.0f, 14.0f, 1.0f);
      glPopMatrix();

      // Np portion of Gauge
      glPushMatrix();
         glTranslatef(0.6f, 0.60f, 0.0f);
         npValue.Draw(m_np_value,   true, 0.0f, 1.75f, 1.0f);
      glPopMatrix();

      // OAT portion of Gauge
      glPushMatrix();
         glTranslatef(0.6f, 0.25f, 0.0f);
         oatValue.Draw(m_oat_value, true, 0.0f, 1.75f, 1.0f);
      glPopMatrix();
   }
   glPopMatrix();

   EndDraw();
}


void  CEngine1Gauge::SetTorqueValue(float torque)
{
   m_torque_cv          =  torque;
   m_torque_value_cv.Format("%3.0f%%", torque);

   if (torque  >  0.0f  && torque   <  110.0f)
      m_torque_angle_cv =  ((270.0f /  110.0f)  *  torque) - 135.0f;
   else if (torque   >= 110.0f)
      m_torque_angle_cv =   135.0f;
   else
      m_torque_angle_cv =  -135.0f;
}

void  CEngine1Gauge::SetIttValue(float itt)
{
   m_itt_cv          =  itt;
   m_itt_value_cv.Format("%4.0f%cC", itt, DEGREES);

   if (itt  >  400.0f   && itt   <  1000.0f)
      m_itt_angle_cv =  ((270.0f /  600.0f)  *  (itt  -  400.0f)) - 135.0f;
   else if (itt   >= 1000.0f)
      m_itt_angle_cv =   135.0f;
   else
      m_itt_angle_cv =  -135.0f;
}

void  CEngine1Gauge::SetN1Value(float n1)
{
   m_n1_cv           =  n1;
   m_n1_value_cv.Format("%3.0f%%", n1);

   if (n1  >  0.0f  && n1   <  110.0f)
      m_n1_angle_cv =  ((270.0f /  110.0f)  *  n1) - 135.0f;
   else if (n1   >= 110.0f)
      m_n1_angle_cv =   135.0f;
   else
      m_n1_angle_cv =  -135.0f;
}

void  CEngine1Gauge::SetNpValue(float np)
{
   m_np_cv  =  np;
   m_np_value_cv.Format("%3.0f%%", np);
}

void  CEngine1Gauge::SetOatValue(float oat)
{
   m_oat_cv =  oat;
   m_oat_value_cv.Format("%3.0f%cC", oat, DEGREES);
}



void  CEngine1Gauge::SetupTorqueTicks(void)
{
   torqueTicks.Initialize();
   torqueTicks.SetLabelRadius(0.53f);
   torqueTicks.SetOuterRadius(0.42f);
   torqueTicks.SetLabelProperties(1.4f, 1.0f);
   torqueTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;


   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "0");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  249.6f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "10");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  274.1f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "20");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  298.6f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "30");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  323.2f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "40");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  347.7f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "50");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  359.9f;
   tick_info.type       =  NO_TICK;
   strcpy(tick_info.ident, "");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.0f;
   tick_info.type       =  NO_TICK;
   strcpy(tick_info.ident, "");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  12.3f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "60");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  36.8f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "70");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  64.4f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "80");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  85.9f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "90");
   torqueTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.5f;
   tick_info.type       =  NO_TICK;
   strcpy(tick_info.ident, "100");
   torqueTicks.TickList.AddTail(tick_info);

   torqueTicks.GenerateLists();


   torqueRedTicks.Initialize();
   torqueRedTicks.SetLabelRadius(0.53f);
   torqueRedTicks.SetOuterRadius(0.42f);
   torqueRedTicks.SetLabelProperties(1.4f, 3.25f);
   torqueRedTicks.SetTickColor(255, 0, 0);

   tick_info.location   =  110.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   torqueRedTicks.TickList.AddTail(tick_info);

   torqueRedTicks.GenerateLists();
}


void  CEngine1Gauge::SetupIttTicks(void)
{
   ittTicks.Initialize();
   ittTicks.SetLabelRadius(0.45f);
   ittTicks.SetOuterRadius(0.35f);
   ittTicks.SetLabelProperties(1.4f, 1.0f);
   ittTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");


   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "400");
   ittTicks.TickList.AddTail(tick_info);

   tick_info.location   =  247.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "450");
   ittTicks.TickList.AddTail(tick_info);

   tick_info.location   =  270.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "500");
   ittTicks.TickList.AddTail(tick_info);

   tick_info.location   =  292.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "550");
   ittTicks.TickList.AddTail(tick_info);

   tick_info.location   =  315.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "600");
   ittTicks.TickList.AddTail(tick_info);

   tick_info.location   =  337.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "650");
   ittTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "700");
   ittTicks.TickList.AddTail(tick_info);

   tick_info.location   =  22.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "750");
   ittTicks.TickList.AddTail(tick_info);

   tick_info.location   =  45.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "800");
   ittTicks.TickList.AddTail(tick_info);

   tick_info.location   =  54.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "820");
   ittTicks.TickList.AddTail(tick_info);

   ittTicks.GenerateLists();



   ittRedTicks.Initialize();
   ittRedTicks.SetLabelRadius(0.45f);
   ittRedTicks.SetOuterRadius(0.35f);
   ittRedTicks.SetLabelProperties(1.4f, 3.25f);
   ittRedTicks.SetTickColor(255, 0, 0);


   tick_info.location   =  54.0f;
   tick_info.type       =  INTERMEDIATE;
//   strcpy(tick_info.ident, "820");
   ittRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  67.5f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "850");
   ittRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  90.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "900");
   ittRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  112.5f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "950");
   ittRedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "1000");
   ittRedTicks.TickList.AddTail(tick_info);

   ittRedTicks.GenerateLists();
}


void  CEngine1Gauge::SetupIttStartModeTicks(void)
{
   ittStartModeTicks.Initialize();
   ittStartModeTicks.SetLabelRadius(0.45f);
   ittStartModeTicks.SetOuterRadius(0.35f);
   ittStartModeTicks.SetLabelProperties(1.4f, 1.0f);
   ittStartModeTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");


   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "400");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  247.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "450");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  270.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "500");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  292.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "550");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  315.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "600");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  337.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "650");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "700");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  22.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "750");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  45.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "800");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  67.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "850");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  90.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "900");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  112.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "950");
   ittStartModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "1000");
   ittStartModeTicks.TickList.AddTail(tick_info);

   ittStartModeTicks.GenerateLists();


   ittStartModeRedTicks.Initialize();
   ittStartModeRedTicks.SetLabelRadius(0.45f);
   ittStartModeRedTicks.SetOuterRadius(0.35f);
   ittStartModeRedTicks.SetLabelProperties(1.4f, 3.25f);
   ittStartModeRedTicks.SetTickColor(255, 0, 0);


   tick_info.location   =  135.0f;
   tick_info.type       =  INTERMEDIATE;
//   strcpy(tick_info.ident, "1000");
   ittStartModeRedTicks.TickList.AddTail(tick_info);

   ittStartModeRedTicks.GenerateLists();
}



void  CEngine1Gauge::SetupN1Ticks(void)
{
   n1Ticks.Initialize();
   n1Ticks.SetLabelRadius(0.45f);
   n1Ticks.SetOuterRadius(0.35f);
   n1Ticks.SetLabelProperties(1.4f, 1.0f);
   n1Ticks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "0");
   n1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  249.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "10");
   n1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  274.1f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "20");
   n1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  298.6f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "30");
   n1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  323.2f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "40");
   n1Ticks.TickList.AddTail(tick_info);

   tick_info.location   =  347.7f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "50");
   n1Ticks.TickList.AddTail(tick_info);

   n1Ticks.GenerateLists();


   n1GreenTicks.Initialize();
   n1GreenTicks.SetLabelRadius(0.45f);
   n1GreenTicks.SetOuterRadius(0.35f);
   n1GreenTicks.SetLabelProperties(1.4f, 1.0f);
   n1GreenTicks.SetTickColor(0, 128, 0);


   tick_info.location   =  12.3f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "60");
   n1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  36.8f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "70");
   n1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  64.4f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "80");
   n1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  85.9f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "90");
   n1GreenTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.5f;
   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "100");
   n1GreenTicks.TickList.AddTail(tick_info);

   n1GreenTicks.GenerateLists();



   n1RedTicks.Initialize();
   n1RedTicks.SetLabelRadius(0.45f);
   n1RedTicks.SetOuterRadius(0.35f);
   n1RedTicks.SetLabelProperties(1.4f, 3.25f);
   n1RedTicks.SetTickColor(255, 0, 0);

   tick_info.location   =  120.3f;
   tick_info.type       =  INTERMEDIATE;
//   strcpy(tick_info.ident, "104");
   n1RedTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  NO_TICK;
//   strcpy(tick_info.ident, "110");
   n1RedTicks.TickList.AddTail(tick_info);

   n1RedTicks.GenerateLists();
}

CWidget* CEngine1Gauge::CreateObject()
{
   return new CEngine1Gauge();
}

void CEngine1Gauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar      == "Itt")
   {
      SetIttValue(*pVariant);
   }
   else if (rstrElementVar == "N1")
   {
      SetN1Value(*pVariant);
   }
   else if (rstrElementVar == "Np")
   {
      SetNpValue(*pVariant);
   }
   else if (rstrElementVar == "Oat")
   {
      SetOatValue(*pVariant);
   }
   else if (rstrElementVar == "Torque")
   {
      SetTorqueValue(*pVariant);
   }
   else if (rstrElementVar == "Start Mode")
   {
      m_start_mode_cv   =  *pVariant;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CEngine1Gauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CEngine1Gauge::UpdateRenderVariables()
{
   m_torque       =  m_torque_cv;
   m_torque_value =  m_torque_value_cv;
   m_torque_angle =  m_torque_angle_cv;
   m_itt          =  m_itt_cv;
   m_itt_value    =  m_itt_value_cv;
   m_itt_angle    =  m_itt_angle_cv;
   m_n1           =  m_n1_cv;
   m_n1_value     =  m_n1_value_cv;
   m_n1_angle     =  m_n1_angle_cv;
   m_np           =  m_np_cv;
   m_np_value     =  m_np_value_cv;
   m_oat          =  m_oat_cv;
   m_oat_value    =  m_oat_value_cv;
   m_start_mode   =  m_start_mode_cv;

   if (m_torque   >  100.0f)
   {
      torqueValue.SetBackgroundColor(true, 255,  0,  0);
      torqueNeedle.SetForegroundColor(255,  0,  0);
   }
   else
   {
      torqueValue.SetBackgroundColor(false, 0,  0,  0);
      torqueNeedle.SetForegroundColor(255,  255,  255);
   }

   if (m_start_mode)
   {
      if (m_itt   >  1000.0f)
      {
         ittValue.SetBackgroundColor(true, 255,  0,  0);
         ittNeedle.SetForegroundColor(255, 0, 0);
      }
      else
      {
         ittValue.SetBackgroundColor(false, 0,  0,  0);
         ittNeedle.SetForegroundColor(255, 255, 255);
      }
   }
   else
   {
      if (m_itt   >  820.0f)
      {
         ittValue.SetBackgroundColor(true, 255,  0,  0);
         ittNeedle.SetForegroundColor(255, 0, 0);
      }
      else
      {
         ittValue.SetBackgroundColor(false, 0,  0,  0);
         ittNeedle.SetForegroundColor(255, 255, 255);
      }
   }

   if (m_n1 >  104.0f)
   {
      n1Value.SetBackgroundColor(true, 255,  0,  0);
      n1Needle.SetForegroundColor(255, 0, 0);
   }
   else
   {
      n1Value.SetBackgroundColor(false, 0,  0,  0);
      n1Needle.SetForegroundColor(255, 255, 255);
   }

   if (m_np >  102.0f   || (m_np  >  62.0f && m_np  <  82.0f))
      npValue.SetBackgroundColor(true, 255,  0,  0);
   else
      npValue.SetBackgroundColor(false, 0,  0,  0);

   return CWidget::UpdateRenderVariables();
}
