// EHSIGauge.h: interface for the CEHSIGauge class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_EHSIGAUGE_H__5A864543_6867_11D2_AD4D_006008B0E0C3__INCLUDED_)
#define AFX_EHSIGAUGE_H__5A864543_6867_11D2_AD4D_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"
#include "AdiGauge.h"
#include "..\core\OpenGLCircle.h"


#define  HSI_ENROUTE                0x00000000
#define  HSI_APPROACH               0x00000001

const int   MAX_WAYPOINTS     =  26;
const int   MAX_VHF_NAVAIDS   =  10;
const int   MAX_AIRPORTS      =  4;
const int   MAX_GPS_SYMBOLS   =  MAX_WAYPOINTS  +  MAX_VHF_NAVAIDS   +  MAX_AIRPORTS;
const int   VOR_SYMBOL_OFFSET =  MAX_GPS_SYMBOLS;  // 0 based so...

// Types of display.
enum  hsi_mode
{
   COMPOSITE,
   NORMAL_HSI,          // 360
   NORMAL_MAP,          // 360
   DIRECTIONAL_GYRO,
   EXPANDED_ARC,
   EXPANDED_MAP,
   ADI
};

// Defines for map mode
enum  map_mode
{
   MAP_MODE_WAYPOINTS,
   MAP_MODE_GROUND_STATIONS,
   MAP_MODE_AIRPORTS,
   MAP_MODE_GROUND_STATIONS_AND_AIRPORTS
};

// Sources
enum  nav_source
{
   NAV_SOURCE_VOR_WITHOUT_FIELDS,
   NAV_SOURCE_VOR_WITH_FIELDS,
   NAV_SOURCE_VOR1_WITHOUT_FIELDS,
   NAV_SOURCE_VOR1_WITH_FIELDS,
   NAV_SOURCE_VOR2_WITHOUT_FIELDS,
   NAV_SOURCE_VOR2_WITH_FIELDS,
   NAV_SOURCE_TACAN_WITHOUT_FIELDS,
   NAV_SOURCE_TACAN_WITH_FIELDS,
   NAV_SOURCE_GPS_WITHOUT_FIELDS,
   NAV_SOURCE_GPS_WITH_FIELDS
};

enum  bearing_source
{
   BEARING_SOURCE_DECLUTTER,
   BEARING_SOURCE_ADF,
   BEARING_SOURCE_VOR,
   BEARING_SOURCE_VOR1,
   BEARING_SOURCE_VOR2,
   BEARING_SOURCE_TACAN,
   BEARING_SOURCE_GPS
};


class CAdiGauge;

class CEHSIGauge : public COpenGLWidget, public CPanel
{
public:
	CEHSIGauge();
	virtual ~CEHSIGauge();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();

   void  DrawHsiSpecifics(void);
   void  SetSupportAdiCompositeMode(bool support);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

   CAdiGauge   *m_adiGauge;

protected:
   void  DrawMapSymbols(void);
   bool  DrawSymbols(long  index);
   void  DrawNoMap(void);
   void  DrawSelectedCourseInMapMode(void);
   void  DrawBearingAnnunciators(void);

   COpenGLtext headingLubberMark;
   CString     m_CStr_headingLubberMark;

   COpenGLtext thePlane;
   CString     m_CStr_thePlane;

   COpenGLtext singleNeedle;
   CString     m_singleNeedle;

   COpenGLtext doubleNeedle;
   CString     m_doubleNeedle;

   COpenGLtext selectedCourseNeedle;
   CString     m_selectedCourseNeedle;

   COpenGLtext headingBug;
   CString     m_headingBug;

   CTicks      glideslopeTicks;
   COpenGLtext glideslopeIndicator;
   CString     m_glideslope_indicator;

   COpenGLtext toFromIndicator;
   CString     m_toFromIndicator;
   
   CTicks      lateralPositionTicks;
   COpenGLtext lateralPositionIndicator;
   CString     m_lateralPosition_indicator;

   CTicks      lateralPositionTicksBottom;
   COpenGLtext lateralPositionIndicatorBottom;
   CString     m_lateralPosition_indicator_bottom;

   enum  nav_source  m_navigation_source;
   enum  nav_source  m_navigation_source_cv;

   COpenGLtext navigationSource;
   CString     m_CStr_navigationSource;

   COpenGLtext primary_dme;
   CString     m_CStr_primary_dme;
   float       m_float_primary_dme;
   float       m_float_primary_dme_cv;
   long        m_long_primary_dme_status;
   long        m_long_primary_dme_status_cv;

   COpenGLtext primary_dme_units;
   CString     m_CStr_primary_dme_units;

   COpenGLtext groundSpeedOrDMEHoldFreq;
   CString     m_CStr_groundSpeedOrDMEHoldFreq;
   float       m_float_ground_speed;
   float       m_float_ground_speed_cv;

   COpenGLtext groundSpeedOrDMEHoldFreq_units;           // KT for ground speed or H for dme hold.
   CString     m_CStr_groundSpeedOrDMEHoldFreq_units;
   long        m_long_groundspeed_status;
   long        m_long_groundspeed_status_cv;

   float       m_float_primary_dme_freq;
   float       m_float_primary_dme_freq_cv;

   COpenGLtext timeToGo;
   CString     m_CStr_timeToGo;
   float       m_float_time_to_go;
   float       m_float_time_to_go_cv;

   long        m_long_time_to_go_status;
   long        m_long_time_to_go_status_cv;

   COpenGLtext gpsAlert;
   CString     m_CStr_gpsAlert;
   long        m_long_gpsAlert_status;
   long        m_long_gpsAlert_status_cv;

   COpenGLtext noMap;
   CString     m_CStr_noMap;


   COpenGLtext selectedCourseOrDesiredTrack;
   CString     m_CStr_selectedCourseOrDesiredTrack;
   CString     m_CStr_selectedCourseOrDesiredTrack_cv;

   long        m_long_selected_course_valid;
   long        m_long_selected_course_valid_cv;

   COpenGLtext selectedHeading;
   CString     m_selectedHeading;
   CString     m_selectedHeading_cv;

   COpenGLtext bearing1Needle;
   CString     m_CStr_bearing1Needle;
   COpenGLtext bearing1Source;
   CString     m_CStr_bearing1Source;
   COpenGLtext bearing1Distance;
   CString     m_CStr_bearing1Distance;
   COpenGLtext bearing1Distance_units;
   CString     m_CStr_bearing1Distance_units;


   COpenGLtext bearing2Needle;
   CString     m_CStr_bearing2Needle;
   COpenGLtext bearing2Source;
   CString     m_CStr_bearing2Source;
   COpenGLtext bearing2Distance;
   CString     m_CStr_bearing2Distance;
   COpenGLtext bearing2Distance_units;
   CString     m_CStr_bearing2Distance_units;

   COpenGLtext xOut;
   CString     m_xOut;

   COpenGLtext aLine;
   CString     m_aLine;

   COpenGLtext hdgFailed;
   CString     m_hdgFailed;

   COpenGLtext controlPanelFailed;
   CString     m_controlPanelFailed;

   COpenGLtext symbol;
   CString     m_symbol;

   COpenGLtext mapRange;
   CString     m_CStr_mapRange;
   CString     m_CStr_mapRange_cv;

   COpenGLtext backCourseIndicator;
   CString     m_backCourseIndicator;

   COpenGLtext gps_annunciation;
   CString     m_CStr_gps_annunciation;

   COpenGLtext DMEHoldIndicator;
   CString     m_DMEHoldIndicator;

   typedef  struct   symbolInfo
   {
      CPosition3D    position;
      double         heading;
      CString        symbol;
      CString        symbol_label;
      int            type;
   }  SymbolInfo;

   SymbolInfo    m_symbolInfo[MAX_GPS_SYMBOLS   +  1];   // Add one to hold the symbol for VOR mode.
   long     m_long_gps_symbols;
   long     m_long_gps_symbols_cv;
   long     m_long_active_leg_index;
   long     m_long_active_leg_index_cv;
   long     m_long_gps_annunciation_mode;
   long     m_long_gps_annunciation_mode_cv;

private:
   void     DrawStationaryIndicators(void);
   CTicks   theTicks;
   CTicks   theArcModeTicks;
   float    m_bearing1;
   float    m_bearing2;
   float    m_glideslope_offset;
   float    m_lateralPosition_offset;
   float    m_selected_course;
   float    m_heading_bug;
   long     m_hsi_mode;
   long     m_arc_mode;
   long     m_map_mode;
   long     m_bearing1_source;
   long     m_bearing2_source;
   float    m_bearing1_distance;
   float    m_bearing2_distance;
   long     m_long_bearing1_distance_valid;
   long     m_long_bearing2_distance_valid;
   float    m_hsi_map_range;

   float    m_bearing1_cv;
   float    m_bearing2_cv;
   float    m_glideslope_offset_cv;
   float    m_lateralPosition_offset_cv;
   float    m_selected_course_cv;
   float    m_heading_bug_cv;
   long     m_hsi_mode_cv;
   long     m_arc_mode_cv;
   long     m_map_mode_cv;
   long     m_bearing1_source_cv;
   long     m_bearing2_source_cv;
   float    m_bearing1_distance_cv;
   float    m_bearing2_distance_cv;
   long     m_long_bearing1_distance_valid_cv;
   long     m_long_bearing2_distance_valid_cv;
   float    m_hsi_map_range_cv;

   bool     m_bearing1_valid;
   bool     m_bearing2_valid;
   bool     m_heading_failure;
   bool     m_heading_invalid;
   bool     m_attitude_fail;
   bool     m_cp_500_fail;
   long     m_long_GS_status;
   bool     m_bool_GS_fail;
   bool     m_bool_Nav_Pwr_Fail;
   long     m_long_lateral_offset_valid;
   bool     m_heading_select_knob_failure;
   long     m_to_from;
   float    m_ac_heading;
   double   m_ac_latitude;
   double   m_ac_longitude;
   bool     m_ils_selected;
   bool     m_back_course;
   bool     m_DME_hold;
   float    m_float_magvar_at_aircraft;
   float    m_float_magvar_from_gps;
   long     m_long_lateral_offset_red_x;

   bool     m_bearing1_valid_cv;
   bool     m_bearing2_valid_cv;
   bool     m_heading_failure_cv;
   bool     m_heading_invalid_cv;
   bool     m_attitude_fail_cv;
   bool     m_cp_500_fail_cv;
   long     m_long_GS_status_cv;
   bool     m_bool_GS_fail_cv;
   bool     m_bool_Nav_Pwr_Fail_cv;
   long     m_long_lateral_offset_valid_cv;
   bool     m_heading_select_knob_failure_cv;
   long     m_to_from_cv;
   float    m_ac_heading_cv;
   double   m_ac_latitude_cv;
   double   m_ac_longitude_cv;
   bool     m_ils_selected_cv;
   bool     m_back_course_cv;
   bool     m_DME_hold_cv;
   float    m_float_magvar_at_aircraft_cv;
   float    m_float_magvar_from_gps_cv;
   long     m_long_lateral_offset_red_x_cv;


   bool     m_bool_gps_obs_mode;
   bool     m_bool_gps_obs_mode_cv;

   bool     m_bool_EHSI_Power;
   bool     m_bool_EHSI_Power_cv;


   COpenGLtext FHDG;
   CString     m_FHDG;
   bool        m_bool_FHDG_Flag;
   bool        m_bool_FHDG_Flag_cv;

   COpenGLtext XTALK;
   CString     m_XTALK;
   bool        m_bool_XTALK_Flag;
   bool        m_bool_XTALK_Flag_cv;

   COpenGLCircle  m_circle;

   bool     m_support_ADI_composite_mode;
   bool     m_support_ADI_composite_mode_cv;

   int      m_stationary_indicators_list;
   GLUquadricObj  *m_pquad;

// Attributes
public:
  	enum { IDB = IDB_HSI  };
};

#endif // !defined(AFX_EHSIGAUGE_H__5A864543_6867_11D2_AD4D_006008B0E0C3__INCLUDED_)
