// EHSIGauge.cpp: implementation of the CEHSIGauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "EHSIGauge.h"
#include "..\core\DataConversion.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//#define  PROVEN
#define  OUTER_RADIUS            0.55f
#define  OUTER_RADIUS_ARC_MODE   1.5f

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CEHSIGauge::CEHSIGauge()
{
   m_stlStrWidgetName            =  _FSI_STL::string("HSI");
   m_exPtUpperLeft               =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight              =  CExtentsPoint(CPoint(200,200));

   m_bearing1                    =  40.0f;
   m_bearing2                    =  320.0f;
   m_glideslope_offset           =  0.0f;
   m_lateralPosition_offset      =  0.0f;
   m_selected_course             =  10.0f;
   m_heading_bug                 =  90.0f;
   m_hsi_mode                    =  1;
   m_arc_mode                    =  0;
   m_map_mode                    =  0;
   m_bearing1_source             =  2;
   m_bearing2_source             =  1;
   m_bearing1_distance           =  50.0f;
   m_bearing2_distance           =  75.0f;
   m_hsi_map_range               =  30.0f;

   m_bearing1_valid              =  0;
   m_bearing2_valid              =  0;
   m_heading_failure             =  0;
   m_heading_invalid             =  0;
   m_attitude_fail               =  0;
   m_cp_500_fail                 =  0;
   m_long_GS_status              =  0;
   m_bool_GS_fail                =  false;
   m_bool_Nav_Pwr_Fail           =  false;
   m_long_lateral_offset_valid   =  0;
   m_long_lateral_offset_red_x   =  0;
   m_heading_select_knob_failure =  0;
   m_to_from                     =  1;
   m_ac_heading                  =  0.0f;
   m_ac_latitude                 =  0.0;
   m_ac_longitude                =  0.0;
   m_support_ADI_composite_mode  =  0;
   m_float_magvar_at_aircraft    =  0.0f;
   m_long_gps_annunciation_mode  =  0;

   m_bearing1_cv                    =  m_bearing1;
   m_bearing2_cv                    =  m_bearing2;
   m_glideslope_offset_cv           =  m_glideslope_offset;
   m_lateralPosition_offset_cv      =  m_lateralPosition_offset;
   m_selected_course_cv             =  m_selected_course;
   m_heading_bug_cv                 =  m_heading_bug;
   m_hsi_mode_cv                    =  m_hsi_mode;
   m_arc_mode_cv                    =  m_arc_mode;
   m_map_mode_cv                    =  m_map_mode;
   m_bearing1_source_cv             =  m_bearing1_source;
   m_bearing2_source_cv             =  m_bearing2_source;
   m_bearing1_distance_cv           =  m_bearing1_distance;
   m_bearing2_distance_cv           =  m_bearing2_distance;
   m_hsi_map_range_cv               =  m_hsi_map_range;
   m_support_ADI_composite_mode_cv  =  m_support_ADI_composite_mode;


   m_bearing1_valid_cv              =  m_bearing1_valid;
   m_bearing2_valid_cv              =  m_bearing2_valid;
   m_heading_failure_cv             =  m_heading_failure;
   m_heading_invalid_cv             =  m_heading_invalid;
   m_attitude_fail_cv               =  m_attitude_fail;
   m_cp_500_fail_cv                 =  m_cp_500_fail;
   m_long_GS_status_cv              =  m_long_GS_status;
   m_bool_GS_fail_cv                =  m_bool_GS_fail;
   m_bool_Nav_Pwr_Fail_cv           =  m_bool_Nav_Pwr_Fail;
   m_long_lateral_offset_valid_cv   =  m_long_lateral_offset_valid;
   m_heading_select_knob_failure_cv =  m_heading_select_knob_failure;
   m_to_from_cv                     =  m_to_from;
   m_ac_heading_cv                  =  m_ac_heading;
   m_ac_latitude_cv                 =  m_ac_latitude;
   m_ac_longitude_cv                =  m_ac_longitude;
   m_float_magvar_at_aircraft_cv    =  m_float_magvar_at_aircraft;
   m_float_magvar_from_gps_cv       =  m_float_magvar_from_gps;
   m_long_gps_annunciation_mode_cv  =  m_long_gps_annunciation_mode;
   m_long_lateral_offset_red_x_cv   =  m_long_lateral_offset_red_x;


   m_bool_FHDG_Flag                 =  true;
   m_bool_FHDG_Flag_cv              =  m_bool_FHDG_Flag;

   m_bool_XTALK_Flag                =  true;
   m_bool_XTALK_Flag_cv             =  m_bool_XTALK_Flag;

   m_long_gps_symbols               =  7;
   m_long_gps_symbols_cv            =  m_long_gps_symbols;
   m_long_active_leg_index          =  3;
   m_long_active_leg_index_cv       =  m_long_active_leg_index;

   m_bool_EHSI_Power                =  true;
   m_bool_EHSI_Power_cv             =  m_bool_EHSI_Power;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Glideslope");
   m_listGraphicalElementVars.push_back("Lateral Offset");
   m_listGraphicalElementVars.push_back("Lateral Offset Valid");
   m_listGraphicalElementVars.push_back("Lateral Offset Red X");
   m_listGraphicalElementVars.push_back("Selected Course");
   m_listGraphicalElementVars.push_back("Selected Course Valid");
   m_listGraphicalElementVars.push_back("Selected Course Dtk");

   m_listGraphicalElementVars.push_back("Heading Bug");
   m_listGraphicalElementVars.push_back("HSI Mode");
   m_listGraphicalElementVars.push_back("ARC Mode");
   m_listGraphicalElementVars.push_back("MAP Mode");
   m_listGraphicalElementVars.push_back("bearing1");
   m_listGraphicalElementVars.push_back("bearing2");
   m_listGraphicalElementVars.push_back("Bearing 1 Source");
   m_listGraphicalElementVars.push_back("Bearing 2 Source");
   m_listGraphicalElementVars.push_back("Bearing 1 Distance");
   m_listGraphicalElementVars.push_back("Bearing 2 Distance");
   m_listGraphicalElementVars.push_back("Bearing 1 Valid");
   m_listGraphicalElementVars.push_back("Bearing 2 Valid");
   m_listGraphicalElementVars.push_back("Bearing 1 Distance Valid");
   m_listGraphicalElementVars.push_back("Bearing 2 Distance Valid");
   m_listGraphicalElementVars.push_back("HSI MAP Range");
   m_listGraphicalElementVars.push_back("Heading Failure");
   m_listGraphicalElementVars.push_back("Heading Invalid");
   m_listGraphicalElementVars.push_back("Attitude Fail");
   m_listGraphicalElementVars.push_back("CP 500 Fail");
   m_listGraphicalElementVars.push_back("Heading Select Knob Failure");
   m_listGraphicalElementVars.push_back("To From");
   m_listGraphicalElementVars.push_back("AC Heading");
   m_listGraphicalElementVars.push_back("ac_latitude");
   m_listGraphicalElementVars.push_back("ac_longitude");
   m_listGraphicalElementVars.push_back("Time To Go");
   m_listGraphicalElementVars.push_back("Ils_Selected");
   m_listGraphicalElementVars.push_back("Back Course");
   m_listGraphicalElementVars.push_back("Dme_Hold");

   m_listGraphicalElementVars.push_back("Navigation Source");
   m_listGraphicalElementVars.push_back("Primary DME");
   m_listGraphicalElementVars.push_back("Primary DME Status");
   m_listGraphicalElementVars.push_back("Ground Speed");
   m_listGraphicalElementVars.push_back("Ground Speed Status");
   m_listGraphicalElementVars.push_back("Time to Go Status");
   m_listGraphicalElementVars.push_back("Primary DME Frequency");
   m_listGraphicalElementVars.push_back("Primary GPS Alert");
   m_listGraphicalElementVars.push_back("GS Scale Status");
   m_listGraphicalElementVars.push_back("GS Rcvr Fail");
   m_listGraphicalElementVars.push_back("Nav Pwr Fail");

   m_listGraphicalElementVars.push_back("Waypoint_Ident");
   m_listGraphicalElementVars.push_back("Waypoint_Station_Type");
   m_listGraphicalElementVars.push_back("Waypoint_Latitude");
   m_listGraphicalElementVars.push_back("Waypoint_Longitude");
   m_listGraphicalElementVars.push_back("Waypoint_Active");
   m_listGraphicalElementVars.push_back("Waypoint_number");

   m_listGraphicalElementVars.push_back("VOR_Map_Station_Type");
   m_listGraphicalElementVars.push_back("VOR_Map_Lat");
   m_listGraphicalElementVars.push_back("VOR_Map_Lon");
   m_listGraphicalElementVars.push_back("GPS_OBS_Mode");

   m_listGraphicalElementVars.push_back("Magvar_at_aircraft");
   m_listGraphicalElementVars.push_back("Magvar_from_GPS");

   m_listGraphicalElementVars.push_back("EHSI_Power");
   m_listGraphicalElementVars.push_back("FHDG_Flag");
   m_listGraphicalElementVars.push_back("XTALK_Flag");

   // For the ADI (composite mode)
   m_listGraphicalElementVars.push_back("ac_pitch_wing");
   m_listGraphicalElementVars.push_back("ac_roll_wing");
   m_listGraphicalElementVars.push_back("ADI Mode");
   m_listGraphicalElementVars.push_back("Marker Beacon");
   m_listGraphicalElementVars.push_back("GPS Annunciation Mode");

   m_adiGauge  =  NULL;

   m_pquad  =  gluNewQuadric();

   m_list                        =  -1;
   m_stationary_indicators_list  =  -1;
}

CEHSIGauge::~CEHSIGauge()
{
   if (m_adiGauge)
      delete   m_adiGauge;

   gluDeleteQuadric(m_pquad);
}

void  CEHSIGauge::Setup(void)
{
   if (GetSafeHwnd())
      CPanel::Initialize(GetSafeHwnd());

   gluQuadricDrawStyle(m_pquad, GLU_FILL);

   bearing1Source.SetForegroundColor(255, 255, 255);
   bearing1Distance.SetForegroundColor(255, 255, 255);
   m_CStr_bearing1Needle.Format("%c", SINGLE_NEEDLE);
   bearing1Needle.SetForegroundColor(255, 255, 255);

   bearing1Distance_units.SetForegroundColor(255, 255, 255);
   m_CStr_bearing1Distance_units =  "NM";
   
   bearing2Source.SetForegroundColor(255, 0, 128);
   bearing2Distance.SetForegroundColor(255, 0, 128);
   m_CStr_bearing2Needle.Format("%c", DOUBLE_NEEDLE);
   bearing2Needle.SetForegroundColor(255, 0, 128);

   bearing2Distance_units.SetForegroundColor(255, 0, 128);
   m_CStr_bearing2Distance_units =  "NM";

   xOut.SetForegroundColor(255, 0, 0);
   m_xOut                        =  "X";

   hdgFailed.SetBoxOutlineColor(255, 0, 0);
   hdgFailed.SetForegroundColor(255, 0, 0);
   m_hdgFailed                   =  "HDG";

   controlPanelFailed.SetBoxOutlineColor(255, 0, 0);     // Red
   controlPanelFailed.SetForegroundColor(255, 0, 0);     // Red
   m_controlPanelFailed          =  "CP";

   backCourseIndicator.SetForegroundColor(0, 192,  0);   // Green
   m_backCourseIndicator         =  "BC";

   primary_dme_units.SetForegroundColor(0, 192, 0);      // Green
   m_CStr_primary_dme_units      =  "NM";

   DMEHoldIndicator.SetForegroundColor(255,  255,  0);   // Yellow
   m_DMEHoldIndicator            =  "H ";

   aLine.SetForegroundColor(255, 255, 255);              // White
   m_aLine.Format("%c", LINE);

   thePlane.SetForegroundColor(255, 255,  0);            // Yellow
   m_CStr_thePlane.Format("%c", THE_PLANE);

   singleNeedle.SetForegroundColor(255, 255, 255);       // White
   m_singleNeedle.Format("%c", SINGLE_NEEDLE);

   doubleNeedle.SetForegroundColor(255, 0,   128);       // Magenta
   m_doubleNeedle.Format("%c", DOUBLE_NEEDLE);

   selectedCourseNeedle.SetForegroundColor(0, 192, 0);   // Green
   m_selectedCourseNeedle.Format("%c", COURSE_NEEDLE);

   toFromIndicator.SetForegroundColor(255, 255, 255);    // White
   m_toFromIndicator.Format("%c", DELTA);

   headingLubberMark.SetForegroundColor(255, 255, 255);  // White
   m_CStr_headingLubberMark.Format("%c", DELTA);

   headingBug.SetForegroundColor(192, 192,  0);          // Yellow
   m_headingBug.Format("%c", HEADING_BUG);

   noMap.SetForegroundColor(255, 255, 255);              // White
   m_CStr_noMap   =  "NO MAP";

   FHDG.SetForegroundColor(255, 255, 255);               // White
   m_FHDG   =  "FHDG";

   XTALK.SetForegroundColor(192, 192, 0);                // Yellow
   XTALK.SetBoxOutlineColor(192, 192, 0);                // Yellow
   m_XTALK  =  "XTALK";

   m_circle.ArraySize(360);


   theTicks.Initialize();
   theTicks.SetLabelRadius(OUTER_RADIUS   -  0.12f);
   theTicks.SetOuterRadius(OUTER_RADIUS);
   theTicks.SetLabelProperties(1.5f, 1.0f, true);
   theTicks.SetTickColor(255, 255, 255);
   theTicks.SetTickLengths(0.07f, 0.065f, 0.04f);

   theArcModeTicks.Initialize();
   theArcModeTicks.SetLabelRadius(OUTER_RADIUS_ARC_MODE  -  0.24f);
   theArcModeTicks.SetOuterRadius(OUTER_RADIUS_ARC_MODE);
   theArcModeTicks.SetLabelProperties(2.0f, 1.0f, true);
   theArcModeTicks.SetTickColor(255, 255, 255);
   theArcModeTicks.SetTickLengths(0.07f*2.0f, 0.065f*2.0f, 0.04f*2.0f);


   TICK_INFO   tick_info;

   tick_info.location   =  0.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "N");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  5.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  10.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  15.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  20.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  25.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  30.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "3");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  35.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  40.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  45.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  50.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  55.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  60.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "6");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  65.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  70.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  75.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  80.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  85.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  90.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "E");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  95.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  100.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  105.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  110.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  115.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  120.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "12");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  125.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  130.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  135.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  140.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  145.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  150.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "15");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  155.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  160.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  165.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  170.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  175.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  180.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "S");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);


   tick_info.location   =  185.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  190.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  195.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  200.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  205.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  210.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "21");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  215.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  220.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  225.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  230.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  235.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  240.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "24");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  245.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  250.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  255.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  260.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  265.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  270.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "W");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);


   tick_info.location   =  275.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  280.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  285.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  290.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  295.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  300.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "30");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  305.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  310.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  315.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  320.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  325.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  330.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "33");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  335.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  340.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  345.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  350.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  355.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);
   theArcModeTicks.TickList.AddTail(tick_info);

   theTicks.GenerateLists();
   theArcModeTicks.GenerateLists();



   glideslopeIndicator.SetForegroundColor(0,  192,  0);    // Green
   m_glideslope_indicator.Format("%c", DELTA);

   glideslopeTicks.Initialize();
   glideslopeTicks.SetTickStyle(LINEAR, VERTICAL);
   glideslopeTicks.SetLabelProperties(1.25f, 1.0f);
   glideslopeTicks.SetLabelRadius(0.15f);
   glideslopeTicks.SetTickLengths(0.0375f, 0.0275f, 0.0175f);

   strcpy(tick_info.ident, "");
   tick_info.location   =  0.30f;
   tick_info.type       =  INTERMEDIATE_CIRCLE;
   strcpy(tick_info.ident, "^GS");
   glideslopeTicks.TickList.AddTail(tick_info);
   strcpy(tick_info.ident, "");

   tick_info.location   =  0.15f;
   tick_info.type       =  MINOR_CIRCLE;
   glideslopeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.0f;
   tick_info.type       =  MAJOR;
   glideslopeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -0.15f;
   tick_info.type       =  MINOR_CIRCLE;
   glideslopeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -0.30f;
   tick_info.type       =  INTERMEDIATE_CIRCLE;
   glideslopeTicks.TickList.AddTail(tick_info);

   glideslopeTicks.GenerateLists();


   m_lateralPosition_indicator.Format("%c", LINE);

   lateralPositionTicks.Initialize();
   lateralPositionTicks.SetTickStyle(LINEAR, HORIZONTAL);
   lateralPositionTicks.SetLabelProperties(1.25f, 1.0f);
   lateralPositionTicks.SetLabelRadius(0.20f);
   lateralPositionTicks.SetTickLengths(0.0375f, 0.0275f, 0.0175f);
   strcpy(tick_info.ident, "");

   tick_info.location   =  -0.30f;
   tick_info.type       =  MINOR_CIRCLE;
   lateralPositionTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -0.15f;
   tick_info.type       =  MINOR_CIRCLE;
   lateralPositionTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.15f;
   tick_info.type       =  MINOR_CIRCLE;
   lateralPositionTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.30f;
   tick_info.type       =  MINOR_CIRCLE;
   strcpy(tick_info.ident, "");
   lateralPositionTicks.TickList.AddTail(tick_info);
   strcpy(tick_info.ident, "");

   lateralPositionTicks.GenerateLists();


   m_lateralPosition_indicator_bottom.Format("%c", LINE);

   lateralPositionTicksBottom.Initialize();
   lateralPositionTicksBottom.SetTickStyle(LINEAR, HORIZONTAL);
   lateralPositionTicksBottom.SetLabelProperties(1.25f, 1.0f);
   lateralPositionTicksBottom.SetLabelRadius(0.20f);
   lateralPositionTicksBottom.SetTickLengths(0.0375f, 0.0275f, 0.0175f);
   strcpy(tick_info.ident, "");

   tick_info.location   =  -0.30f;
   tick_info.type       =  MINOR_CIRCLE;
   lateralPositionTicksBottom.TickList.AddTail(tick_info);

   tick_info.location   =  -0.15f;
   tick_info.type       =  MINOR_CIRCLE;
   lateralPositionTicksBottom.TickList.AddTail(tick_info);

   tick_info.location   =  0.0f;
   tick_info.type       =  MAJOR_DIAMOND;
   lateralPositionTicksBottom.TickList.AddTail(tick_info);

   tick_info.location   =  0.15f;
   tick_info.type       =  MINOR_CIRCLE;
   lateralPositionTicksBottom.TickList.AddTail(tick_info);

   tick_info.location   =  0.30f;
   tick_info.type       =  MINOR_CIRCLE;
   strcpy(tick_info.ident, "");
   lateralPositionTicksBottom.TickList.AddTail(tick_info);
   strcpy(tick_info.ident, "");

   lateralPositionTicksBottom.GenerateLists();


   mapRange.SetBackgroundColor(true, 0, 0, 0);

   for   (int  ii =  0; ii <  MAX_GPS_SYMBOLS   +  1; ii++)
   {
      m_symbolInfo[ii].position.m_latitude      =  0.0;
      m_symbolInfo[ii].position.m_longitude     =  0.0;
      m_symbolInfo[ii].heading                  =  0.0f;
      m_symbolInfo[ii].type                     =  0;
      m_symbolInfo[ii].symbol.Format("");
      m_symbolInfo[ii].symbol_label.Format("");
   }

   m_symbolInfo[0].position.m_latitude       =  29.5296742;
   m_symbolInfo[0].position.m_longitude      =  -98.2789008;
   m_symbolInfo[0].heading                   =  0.0f;
   m_symbolInfo[0].type                      =  AIRPORT;
   m_symbolInfo[0].symbol.Format("%c", AIRPORT);
   m_symbolInfo[0].symbol_label.Format("KRND");

   m_symbolInfo[1].position.m_latitude       =  29.5191192;
   m_symbolInfo[1].position.m_longitude      =  -98.2850119;
   m_symbolInfo[1].heading                   =  0.0f;
   m_symbolInfo[1].type                      =  VOR;
   m_symbolInfo[1].symbol.Format("%c", VOR);
   m_symbolInfo[1].symbol_label.Format("RND");

   m_symbolInfo[2].position.m_latitude       =  29.7068789;
   m_symbolInfo[2].position.m_longitude      =  -98.0351850;
   m_symbolInfo[2].heading                   =  0.0f;
   m_symbolInfo[2].type                      =  NDB;
   m_symbolInfo[2].symbol.Format("%c", NDB);
   m_symbolInfo[2].symbol_label.Format("BAZ");

   m_symbolInfo[3].position.m_latitude       =  29.6440308;
   m_symbolInfo[3].position.m_longitude      =  -98.4613503;
   m_symbolInfo[3].heading                   =  0.0f;
   m_symbolInfo[3].type                      =  VORTAC;
   m_symbolInfo[3].symbol.Format("%c", VORTAC);
   m_symbolInfo[3].symbol_label.Format("SAT");

   m_symbolInfo[4].position.m_latitude       =  29.3460681;
   m_symbolInfo[4].position.m_longitude      =  -98.8491931;
   m_symbolInfo[4].heading                   =  0.0f;
   m_symbolInfo[4].type                      =  NDB;
   m_symbolInfo[4].symbol.Format("%c", NDB);
   m_symbolInfo[4].symbol_label.Format("CVB");

   m_symbolInfo[5].position.m_latitude       =  29.2583792;
   m_symbolInfo[5].position.m_longitude      =  -98.4434758;
   m_symbolInfo[5].heading                   =  0.0f;
   m_symbolInfo[5].type                      =  VOR;
   m_symbolInfo[5].symbol.Format("%c", VOR);
   m_symbolInfo[5].symbol_label.Format("SSF");

   m_symbolInfo[6].position.m_latitude       =  29.5296742;
   m_symbolInfo[6].position.m_longitude      =  -98.2789008;
   m_symbolInfo[6].heading                   =  0.0f;
   m_symbolInfo[6].type                      =  AIRPORT;
   m_symbolInfo[6].symbol.Format("%c", AIRPORT);
   m_symbolInfo[6].symbol_label.Format("KRND");

   m_symbolInfo[7].position.m_latitude       =  0.0;
   m_symbolInfo[7].position.m_longitude      =  0.0;
   m_symbolInfo[7].heading                   =  0.0f;
   m_symbolInfo[7].type                      =  AIRPORT;
   m_symbolInfo[7].symbol.Format("%c", AIRPORT);
   m_symbolInfo[7].symbol_label.Format("KRND");


   m_symbolInfo[MAX_WAYPOINTS +  0].position.m_latitude       =  29.34333;
   m_symbolInfo[MAX_WAYPOINTS +  0].position.m_longitude      =  -99.1833;
   m_symbolInfo[MAX_WAYPOINTS +  0].heading                   =  0.0f;
   m_symbolInfo[MAX_WAYPOINTS +  0].type                      =  VOR;
   m_symbolInfo[MAX_WAYPOINTS +  0].symbol.Format("%c", VOR);
   m_symbolInfo[MAX_WAYPOINTS +  0].symbol_label.Format("HDO ");

   m_symbolInfo[MAX_WAYPOINTS +  1].position.m_latitude       =  29.918333;
   m_symbolInfo[MAX_WAYPOINTS +  1].position.m_longitude      =  -99.21783;
   m_symbolInfo[MAX_WAYPOINTS +  1].heading                   =  0.0f;
   m_symbolInfo[MAX_WAYPOINTS +  1].type                      =  VOR;
   m_symbolInfo[MAX_WAYPOINTS +  1].symbol.Format("%c", VOR);
   m_symbolInfo[MAX_WAYPOINTS +  1].symbol_label.Format("CSI ");

   m_symbolInfo[MAX_WAYPOINTS +  2].position.m_latitude       =  30.1975;
   m_symbolInfo[MAX_WAYPOINTS +  2].position.m_longitude      =  -98.707;
   m_symbolInfo[MAX_WAYPOINTS +  2].heading                   =  0.0f;
   m_symbolInfo[MAX_WAYPOINTS +  2].type                      =  VOR;
   m_symbolInfo[MAX_WAYPOINTS +  2].symbol.Format("%c", VOR);
   m_symbolInfo[MAX_WAYPOINTS +  2].symbol_label.Format("STV ");



   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS].position.m_latitude       =  29.3322;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS].position.m_longitude      =  -100.98117;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS].heading                   =  0.0f;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS].type                      =  AIRPORT;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS].symbol.Format("%c", AIRPORT);
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS].symbol_label.Format("MMCC");

   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  1].position.m_latitude       =  29.37367;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  1].position.m_longitude      =  -100.9238;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  1].heading                   =  0.0f;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  1].type                      =  AIRPORT;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  1].symbol.Format("%c", AIRPORT);
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  1].symbol_label.Format("KDLF");

   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  2].position.m_latitude       =  29.36217;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  2].position.m_longitude      =  -100.776;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  2].heading                   =  0.0f;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  2].type                      =  AIRPORT;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  2].symbol.Format("%c", AIRPORT);
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  2].symbol_label.Format("KDRT");

   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  3].position.m_latitude       =  29.1367;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  3].position.m_longitude      =  -100.474167;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  3].heading                   =  0.0f;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  3].type                      =  AIRPORT;
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  3].symbol.Format("%c", AIRPORT);
   m_symbolInfo[MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  3].symbol_label.Format("T70 ");


   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      CPanel::Draw();   // Draw the standard stuff, (bezel, screw heads, and primary title).
   }
   glEndList();


   if (m_stationary_indicators_list != -1)
      glDeleteLists(m_stationary_indicators_list, 1);

   m_stationary_indicators_list  =  glGenLists(1);
   glNewList(m_stationary_indicators_list, GL_COMPILE);
   {
      glPushMatrix();
         glLineWidth(1.5f);  // Apply the line width factor.

         float inner =  OUTER_RADIUS   +  0.02f;
         float outer =  OUTER_RADIUS   +  0.07f;

         glRotatef((float)45.0f, 0.0f, 0.0f, 1.0f);  // 45
         glBegin(GL_LINES);
            glVertex2f(0.0f,  outer);
            glVertex2f(0.0f,  inner);
         glEnd();
         glRotatef((float)45.0f, 0.0f, 0.0f, 1.0f);  // 90
         glBegin(GL_LINES);
            glVertex2f(0.0f,  outer);
            glVertex2f(0.0f,  inner);
         glEnd();
         glRotatef((float)45.0f, 0.0f, 0.0f, 1.0f);  // 135
         glBegin(GL_LINES);
            glVertex2f(0.0f,  outer);
            glVertex2f(0.0f,  inner);
         glEnd();
         glRotatef((float)45.0f, 0.0f, 0.0f, 1.0f);  // 180
         glBegin(GL_LINES);
            glVertex2f(0.0f,  outer);
            glVertex2f(0.0f,  inner);
         glEnd();
         glRotatef((float)45.0f, 0.0f, 0.0f, 1.0f);  // 225
         glBegin(GL_LINES);
            glVertex2f(0.0f,  outer);
            glVertex2f(0.0f,  inner);
         glEnd();
         glRotatef((float)45.0f, 0.0f, 0.0f, 1.0f);  // 270
         glBegin(GL_LINES);
            glVertex2f(0.0f,  outer);
            glVertex2f(0.0f,  inner);
         glEnd();
         glRotatef((float)45.0f, 0.0f, 0.0f, 1.0f);  // 315
         glBegin(GL_LINES);
            glVertex2f(0.0f,  outer);
            glVertex2f(0.0f,  inner);
         glEnd();

         glLineWidth(1.0f);  // Restore the line width factor.
      glPopMatrix();
   }
   glEndList();

   if (m_pWnd)
   {
      m_adiGauge     =  new   CAdiGauge;

      if (m_adiGauge)
      {
         m_adiGauge->rectView       =  rectView;
         m_adiGauge->rectViewCoord  =  rectViewCoord;
         m_adiGauge->Setup();
         m_adiGauge->m_width        =  m_width;
         m_adiGauge->m_height       =  m_height;
         m_adiGauge->m_aspect_ratio =  m_aspect_ratio;
      }
   }
}

void  CEHSIGauge::Render(void)
{
   BeginDraw();

   glCallList(m_list);

   DrawHsiSpecifics();


   if (!m_bool_EHSI_Power)
   {
      glColor4ub(255, 255, 255, 64);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_QUADS);
            glVertex2f(-1.0f, 1.0f);
            glVertex2f( 1.0f, 1.0f);
            glVertex2f( 1.0f, -1.0f);
            glVertex2f(-1.0f, -1.0f);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }

   EndDraw();
}

void  CEHSIGauge::DrawStationaryIndicators(void)
{
   // Stationary reference indicators.
   glPushMatrix();
      glPushMatrix();
         if (m_hsi_mode == EXPANDED_ARC   || m_hsi_mode  == EXPANDED_MAP)
            glTranslatef(0.0, 0.685f, 0.0f);
         else
            glTranslatef(0.0, OUTER_RADIUS   +  0.03f, 0.0f);

         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
            headingLubberMark.Draw(m_CStr_headingLubberMark, true, 180.0f, 1.2f);
         glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
      glPopMatrix();

      if (m_hsi_mode != EXPANDED_ARC   && m_hsi_mode  != EXPANDED_MAP)  // Just need the lubber mark at 0 and not the 45 marks.
      {
         glCallList(m_stationary_indicators_list);
      }
   glPopMatrix();
}

CWidget* CEHSIGauge::CreateObject()
{
   return new CEHSIGauge();
}

void CEHSIGauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar      == "bearing1")
   {
      m_bearing1_cv  =  -(float)(*pVariant);
   }
   else if (rstrElementVar == "bearing2")
   {
      m_bearing2_cv  =  -(float)(*pVariant);
   }
   else if (rstrElementVar == "Glideslope")                 // Glideslope Offset
   {
      m_glideslope_offset_cv     =  (float)(*pVariant);

      if (m_glideslope_offset_cv       >  2.5f)
         m_glideslope_offset_cv        =  2.5f  *  0.15f;
      else if (m_glideslope_offset_cv  <  -2.5f)
         m_glideslope_offset_cv        =  -2.5f *  0.15f;
      else
         m_glideslope_offset_cv        *= 0.15f;
   }
   else if (rstrElementVar == "Lateral Offset")             // Lateral Offset
   {
      m_lateralPosition_offset_cv      =  (float)(*pVariant);

      if (m_lateralPosition_offset_cv        >  2.5f)
         m_lateralPosition_offset_cv         =  2.5f  *  0.15f;
      else if (m_lateralPosition_offset_cv   <  -2.5f)
         m_lateralPosition_offset_cv         =  -2.5f *  0.15f;
      else
         m_lateralPosition_offset_cv         *= 0.15f;
   }
   else if (rstrElementVar == "Lateral Offset Valid")       // Lateral Offset Valid
   {
      m_long_lateral_offset_valid_cv   =  *pVariant;
   }
   else if (rstrElementVar == "Lateral Offset Red X")       // Lateral Offset Red X condition
   {
      m_long_lateral_offset_red_x_cv   =  *pVariant;
   }
   else if (rstrElementVar == "Selected Course")            // Selected Course
   {
//      long  selected_course         =  *pVariant;
//      m_selected_course_cv          =  (float)selected_course;
      m_selected_course_cv          =  (float)*pVariant;
      
      if (m_selected_course_cv      <  0.0f)
         m_selected_course_cv       += 360.0f;
      else if (m_selected_course_cv >  360.0f)
         m_selected_course_cv       -= 360.0f;

      m_selected_course_cv          *= -1.0f;
   }
   else if (rstrElementVar == "Selected Course Valid")      // Selected Course Valid
   {
      m_long_selected_course_valid_cv  =  *pVariant;
   }
   else if (rstrElementVar == "Selected Course Dtk")        // Selected Course Dtk
   {
      long  selected_course         =  *pVariant;
      m_selected_course_cv          =  (float)selected_course;
      
      if (m_selected_course_cv      <  0.0f)
         m_selected_course_cv       += 360.0f;
      else if (m_selected_course_cv >  360.0f)
         m_selected_course_cv       -= 360.0f;

      m_selected_course_cv          *= -1.0f;
   }
   else if (rstrElementVar == "Heading Bug")                // Heading Bug
   {
      long  heading_bug          =  *pVariant;
      m_heading_bug_cv           =  (float)heading_bug;

      if (m_heading_bug_cv       <  0.0f)
         m_heading_bug_cv        += 360.0f;
      else if (m_heading_bug_cv  >  360.0f)
         m_heading_bug_cv        -= 360.0f;

      m_selectedHeading_cv.Format("HDG %03.0f", m_heading_bug_cv);

      m_heading_bug_cv           *= -1.0f;
   }
   else if (rstrElementVar == "Ils_Selected")      // Ils_Selected
   {
      m_ils_selected_cv =  (bool)*pVariant;
   }
   else if (rstrElementVar == "Back Course")       // Back Course
   {
      m_back_course_cv  =  (bool)*pVariant;
   }
   else if (rstrElementVar == "Dme_Hold")                // DME Hold
   {
      m_DME_hold_cv     =  (bool)*pVariant;
   }
   else if (rstrElementVar == "Primary DME")             // Primary DME
   {
      m_float_primary_dme_cv  =  *pVariant;
   }
   else if (rstrElementVar == "Primary DME Status")      // Primary DME Status
   {
      m_long_primary_dme_status_cv  =  *pVariant;
   }
   else if (rstrElementVar == "Ground Speed")            // Ground Speed
   {
      m_float_ground_speed_cv =  *pVariant;
   }
   else if (rstrElementVar == "Ground Speed Status")     // Ground Speed Status
   {
      m_long_groundspeed_status_cv   =  *pVariant;
   }
   else if (rstrElementVar == "Time to Go Status")       // Time to Go Status
   {
      m_long_time_to_go_status_cv   =  *pVariant;
   }
   else if (rstrElementVar == "Primary GPS Alert")       // Primary GPS Alert
   {
      m_long_gpsAlert_status_cv     =  *pVariant;
   }
   else if (rstrElementVar == "Primary DME Frequency")   // Primary DME Frequency
   {
      m_float_primary_dme_freq_cv   =  (float)((long)*pVariant)   /  100.0f;
   }
   else if (rstrElementVar == "Navigation Source")       // Navigation Source
   {
      m_navigation_source_cv  =  (enum  nav_source)(long)*pVariant;
   }
   else if (rstrElementVar == "HSI Mode")                // HSI Mode
   {
      m_hsi_mode_cv           =  *pVariant;
   }
   else if (rstrElementVar == "ARC Mode")                // ARC Mode
   {
      m_arc_mode_cv           =  *pVariant;
   }
   else if (rstrElementVar == "MAP Mode")                // MAP Mode
   {
      m_map_mode_cv           =  *pVariant;
   }
   else if (rstrElementVar == "Bearing 1 Source")        // Bearing 1 Source
   {
      m_bearing1_source_cv    =  *pVariant;
   }
   else if (rstrElementVar == "Bearing 2 Source")     // Bearing 2 Source
   {
      m_bearing2_source_cv    =  *pVariant;
   }
   else if (rstrElementVar == "Bearing 1 Distance")   // Bearing 1 Distance
   {
      m_bearing1_distance_cv  =  *pVariant;
   }
   else if (rstrElementVar == "Bearing 2 Distance")   // Bearing 2 Distance
   {
      m_bearing2_distance_cv  =  *pVariant;
   }
   else if (rstrElementVar == "Bearing 1 Distance Valid")   // Bearing 1 Distance Valid
   {
      m_long_bearing1_distance_valid_cv   =  *pVariant;
   }
   else if (rstrElementVar == "Bearing 2 Distance Valid")   // Bearing 2 Distance Valid
   {
      m_long_bearing2_distance_valid_cv   =  *pVariant;
   }
   else if (rstrElementVar == "HSI MAP Range")        // HSI MAP Range
   {
      m_hsi_map_range_cv      =  *pVariant;

      switch ((int)m_hsi_map_range_cv)
      {
         case  0:
            m_hsi_map_range_cv   =  5.0;
            break;

         case  1:
            m_hsi_map_range_cv   =  10.0;
            break;

         case  2:
            m_hsi_map_range_cv   =  20.0;
            break;

         case  3:
            m_hsi_map_range_cv   =  40.0;
            break;

         case  4:
            m_hsi_map_range_cv   =  80.0;
            break;

         case  5:
            m_hsi_map_range_cv   =  160.0;
            break;

         case  6:
            m_hsi_map_range_cv   =  240.0;
            break;

         case  7:
            m_hsi_map_range_cv   =  320.0;
            break;

         case  8:
            m_hsi_map_range_cv   =  1000.0;
            break;
      }

      float range =  m_hsi_map_range_cv   /  2.0f;

      if (range  == (int)range)
         m_CStr_mapRange_cv.Format("%.0f", range);
      else
         m_CStr_mapRange_cv.Format("%.1f", range);

      m_hsi_map_range_cv      =  (3600.0f  /  m_hsi_map_range_cv);
   }
   else if (rstrElementVar == "Bearing 1 Valid")    // Bearing 1 valid
   {
      m_bearing1_valid_cv  =  *pVariant;
   }
   else if (rstrElementVar == "Bearing 2 Valid")    // Bearing 2 valid
   {
      m_bearing2_valid_cv  =  *pVariant;
   }
   else if (rstrElementVar == "Heading Failure")      // Heading Failure
   {
      m_heading_failure_cv    =  *pVariant;
   }
   else if (rstrElementVar == "Heading Invalid")      // Heading Invalid
   {
      m_heading_invalid_cv    =  *pVariant;
   }
   else if (rstrElementVar == "Attitude Fail")        // Attitude Fail
   {
      m_attitude_fail_cv      =  *pVariant;
   }
   else if (rstrElementVar == "CP 500 Fail")          // CP 500 Fail
   {
      m_cp_500_fail_cv        =  *pVariant;
   }
   else if (rstrElementVar == "GS Scale Status")      // GS Scale Status
   {
      m_long_GS_status_cv     =  *pVariant;
   }
   else if (rstrElementVar == "GS Rcvr Fail")         // Receiver Failure
   {
      m_bool_GS_fail_cv       =  (bool)*pVariant;
   }
   else if (rstrElementVar == "Nav Pwr Fail")         // Power Failure
   {
      m_bool_Nav_Pwr_Fail_cv  =  (bool)*pVariant;
   }
   else if (rstrElementVar == "Waypoint_Ident")       // Waypoint_Ident
   {
      int   ii;
      int   number_of_strings =  pVariant->Length()   /  6;

      if (number_of_strings   >  MAX_GPS_SYMBOLS)     // Prevent overflow problem.
         number_of_strings    =  MAX_GPS_SYMBOLS;

      char  *pData   =  (char *)(pVariant->CreateVar());
      for (ii = 0; ii < number_of_strings; ii++)
      {
         m_symbolInfo[ii].symbol_label.Format("%.6s", &(pData[ii*6]));
         m_symbolInfo[ii].symbol_label.MakeUpper();
      }
   }
   else if (rstrElementVar == "Waypoint_Station_Type")   // Waypoint_Station_Type
   {
      int   station_type[MAX_GPS_SYMBOLS];

      if (pVariant->Length()  <= sizeof(station_type)/sizeof(station_type[0]))
      {
         if (memcmp(&station_type, pVariant->CreateVar(), pVariant->Length()*sizeof(station_type[0])))
         {
            memcpy(&station_type,  pVariant->CreateVar(), pVariant->Length()*sizeof(station_type[0]));
         }

         for (int ii = 0; ii < MAX_GPS_SYMBOLS; ii++)
         {
            switch   (station_type[ii])
            {
               case  0:                   // None.
                  break;

               case  1:                   // Airport.
                  m_symbolInfo[ii].type   =  AIRPORT;
                  m_symbolInfo[ii].symbol.Format("%c", AIRPORT);
                  break;

               case  2:                   // DME.
                  m_symbolInfo[ii].type   =  DME;
                  m_symbolInfo[ii].symbol.Format("%c", DME);
                  break;

               case  3:                   // TACAN.
                  m_symbolInfo[ii].type   =  TACAN;
                  m_symbolInfo[ii].symbol.Format("%c", TACAN);
                  break;

               case  4:                   // VOR.
                  m_symbolInfo[ii].type   =  VOR;
                  m_symbolInfo[ii].symbol.Format("%c", VOR);
                  break;

               case  5:                   // VORDME.
                  m_symbolInfo[ii].type   =  VORDME;
                  m_symbolInfo[ii].symbol.Format("%c", VORDME);
                  break;

               case  6:                   // VORTAC.
                  m_symbolInfo[ii].type   =  VORTAC;
                  m_symbolInfo[ii].symbol.Format("%c", VORTAC);
                  break;

               case  7:                   // WAYPOINT.
                  m_symbolInfo[ii].type   =  WPT;
                  m_symbolInfo[ii].symbol.Format("%c", WPT);
                  break;
            }
         }
      }
   }
   else if (rstrElementVar == "Waypoint_Latitude")       // Waypoint_Latitude
   {
      double   waypoint_latitude[MAX_GPS_SYMBOLS];

      if (pVariant->Length()  <= sizeof(waypoint_latitude)/sizeof(waypoint_latitude[0]))
      {
         if (memcmp(&waypoint_latitude, pVariant->CreateVar(), pVariant->Length()*sizeof(waypoint_latitude[0])))
         {
            memcpy(&waypoint_latitude,  pVariant->CreateVar(), pVariant->Length()*sizeof(waypoint_latitude[0]));
         }

         for (int ii = 0; ii < MAX_GPS_SYMBOLS; ii++)
         {
            m_symbolInfo[ii].position.m_latitude   =  waypoint_latitude[ii];
         }
      }
   }
   else if (rstrElementVar == "Waypoint_Longitude")      // Waypoint_Longitude
   {
      double   waypoint_longitude[MAX_GPS_SYMBOLS];

      if (pVariant->Length()  <= sizeof(waypoint_longitude)/sizeof(waypoint_longitude[0]))
      {
         if (memcmp(&waypoint_longitude, pVariant->CreateVar(), pVariant->Length()*sizeof(waypoint_longitude[0])))
         {
            memcpy(&waypoint_longitude,  pVariant->CreateVar(), pVariant->Length()*sizeof(waypoint_longitude[0]));
         }

         for (int ii = 0; ii < MAX_GPS_SYMBOLS; ii++)
         {
            m_symbolInfo[ii].position.m_longitude   =  waypoint_longitude[ii];
         }
      }
   }
   else if (rstrElementVar == "Waypoint_Active")         // Waypoint_Active
   {
      m_long_active_leg_index_cv       =  *pVariant;  
      m_long_active_leg_index_cv       -= 1L;                     // Subtract one because host array is 1 based not 0 based.
   }
   else if (rstrElementVar == "Waypoint_number")         // Waypoint_number
   {
      m_long_gps_symbols_cv            =  *pVariant;

      if (m_long_gps_symbols_cv  >  MAX_WAYPOINTS)
         m_long_gps_symbols_cv   =  MAX_WAYPOINTS;
   }
   else if (rstrElementVar == "GPS Annunciation Mode")   // GPS Annunciation Mode (enroute or approach)
   {
      m_long_gps_annunciation_mode_cv  =  *pVariant;
   }
   else if (rstrElementVar == "Heading Select Knob Failure")   // Heading Select Knob Failure
   {
      m_heading_select_knob_failure_cv =  *pVariant;
   }
   else if (rstrElementVar == "To From")              // To From
   {
      m_to_from_cv            =  *pVariant;
   }
   else if (rstrElementVar == "AC Heading")           // Aircraft Heading.
   {
      m_ac_heading_cv         =  *pVariant;
   }
   else if (rstrElementVar == "Magvar_at_aircraft")   // Magnetic variation at the aircraft lat/long
   {
      m_float_magvar_at_aircraft_cv =  *pVariant;
   }
   else if (rstrElementVar == "Magvar_from_GPS")      // Magnetic variation from the GPS
   {
      m_float_magvar_from_gps_cv =  *pVariant;
   }
   else if (rstrElementVar == "ac_latitude")
   {
      m_ac_latitude_cv        =  *pVariant;
   }
   else if (rstrElementVar == "ac_longitude")
   {
      m_ac_longitude_cv       =  *pVariant;
      m_ac_longitude_cv       *= -1.0;
   }
   else if (rstrElementVar == "Time To Go")              // Time To Go
   {
      m_float_time_to_go_cv   =  *pVariant;                       // From host in minutes.
   }
   else if (rstrElementVar == "VOR_Map_Station_Type")    // VOR_Map_Station_Type
   {
      long  VOR_Map_Station_Type    =  *pVariant;

      switch   (VOR_Map_Station_Type)
      {
         case  0:                   // None.
            break;

         case  1:                   // Airport.
            m_symbolInfo[VOR_SYMBOL_OFFSET].type    =  AIRPORT;
            m_symbolInfo[VOR_SYMBOL_OFFSET].symbol.Format("%c", AIRPORT);
            break;

         case  2:                   // DME.
            m_symbolInfo[VOR_SYMBOL_OFFSET].type    =  DME;
            m_symbolInfo[VOR_SYMBOL_OFFSET].symbol.Format("%c", DME);
            break;

         case  3:                   // TACAN.
            m_symbolInfo[VOR_SYMBOL_OFFSET].type    =  TACAN;
            m_symbolInfo[VOR_SYMBOL_OFFSET].symbol.Format("%c", TACAN);
            break;

         case  4:                   // VOR.
            m_symbolInfo[VOR_SYMBOL_OFFSET].type    =  VOR;
            m_symbolInfo[VOR_SYMBOL_OFFSET].symbol.Format("%c", VOR);
            break;

         case  5:                   // VORDME.
            m_symbolInfo[VOR_SYMBOL_OFFSET].type    =  VORDME;
            m_symbolInfo[VOR_SYMBOL_OFFSET].symbol.Format("%c", VORDME);
            break;

         case  6:                   // VORTAC.
            m_symbolInfo[VOR_SYMBOL_OFFSET].type    =  VORTAC;
            m_symbolInfo[VOR_SYMBOL_OFFSET].symbol.Format("%c", VORTAC);
            break;

         case  7:                   // WAYPOINT.
            m_symbolInfo[VOR_SYMBOL_OFFSET].type    =  WPT;
            m_symbolInfo[VOR_SYMBOL_OFFSET].symbol.Format("%c", WPT);
            break;
      }
   }
   else if (rstrElementVar == "VOR_Map_Lat")             // VOR_Map_Lat
   {
      double   latitude    =  *pVariant;
      m_symbolInfo[VOR_SYMBOL_OFFSET].position.m_latitude   =  latitude;
   }
   else if (rstrElementVar == "VOR_Map_Lon")             // VOR_Map_Lon
   {
      double   longitude   =  *pVariant;
      m_symbolInfo[VOR_SYMBOL_OFFSET].position.m_longitude  =  longitude;
   }
   else if (rstrElementVar == "GPS_OBS_Mode")            // GPS_OBS_Mode
   {
      m_bool_gps_obs_mode_cv  =  (bool)*pVariant;
   }   
   else if (rstrElementVar == "EHSI_Power")              // EHSI_Power
   {
      m_bool_EHSI_Power_cv =  (bool)*pVariant;
   }   
   else if (rstrElementVar == "FHDG_Flag")               // FHDG_Flag
   {
      m_bool_FHDG_Flag_cv  =  (bool)*pVariant;
   }   
   else if (rstrElementVar == "XTALK_Flag")              // XTALK_Flag
   {
      m_bool_XTALK_Flag_cv =  (bool)*pVariant;
   }   
   

   if (m_adiGauge && m_pWnd)
   {
      m_adiGauge->SetSupportHsiCompositeMode(m_hsi_mode_cv  == COMPOSITE);
      m_adiGauge->ChangeValue(rstrElementVar, pCV);
   }
}


void CEHSIGauge::DrawMapSymbols(void)
{
   if (m_heading_failure)
   {
      DrawNoMap();
      return;
   }
   
   // If the GPS is the navigation source, 
   if (m_navigation_source == NAV_SOURCE_GPS_WITHOUT_FIELDS || m_navigation_source  == NAV_SOURCE_GPS_WITH_FIELDS)   
   {
      if (m_long_gps_symbols  == 0)       // and there isn't a flight plan from the GPS (m_long_gps_symbols == 0)
      {
         DrawNoMap();                     // then there is no map.
         return;
      }
   }
   else if (m_navigation_source == NAV_SOURCE_VOR_WITHOUT_FIELDS || m_navigation_source  == NAV_SOURCE_VOR_WITH_FIELDS)
   {
      if (m_ils_selected  && !m_bool_Nav_Pwr_Fail)       // Localizer is selected
      {
         DrawNoMap();                     // then there is no map.
         return;
      }
      else if (!m_long_lateral_offset_valid || m_long_primary_dme_status != 0)
      {                                      // If the lateral offset is invalid,
         DrawNoMap();                        // then there is no map, except for possibly the GPS Active Waypoint.
      }
   }
   else if (m_navigation_source == NAV_SOURCE_TACAN_WITHOUT_FIELDS   || m_navigation_source  == NAV_SOURCE_TACAN_WITH_FIELDS)
   {
      if (m_ils_selected  && !m_bool_Nav_Pwr_Fail)       // Localizer is selected
      {
         DrawNoMap();                     // then there is no map.
         return;
      }
      else if (!m_long_lateral_offset_valid || m_long_primary_dme_status != 0)
      {                                      // If the lateral offset is invalid,
         DrawNoMap();                        // then there is no map, except for possibly the GPS Active Waypoint.
      }
   }


   if (m_navigation_source  == NAV_SOURCE_GPS_WITHOUT_FIELDS ||   m_navigation_source  == NAV_SOURCE_GPS_WITH_FIELDS)
      m_float_magvar_at_aircraft =  m_float_magvar_from_gps;


   // Adjust the map to include magnetic variation
   glRotatef(m_float_magvar_at_aircraft, 0.0f, 0.0f, 1.0f);


   // Rotate to the map center.
   glRotated(m_ac_latitude,   1.0,  0.0,  0.0);
   glRotated(m_ac_longitude,  0.0,  1.0,  0.0);


   // Symbols
   glPushMatrix();
   {
      if (m_long_lateral_offset_valid && m_long_primary_dme_status == 0)
         DrawSymbols(VOR_SYMBOL_OFFSET);

      if (m_navigation_source == NAV_SOURCE_VOR_WITHOUT_FIELDS || m_navigation_source  == NAV_SOURCE_VOR_WITH_FIELDS)
      {
         if (m_long_active_leg_index   >= 0)             // If there is a valid active waypoint,
            DrawSymbols(m_long_active_leg_index);        // draw the GPS Active Waypoint.
      }
      else if (m_navigation_source == NAV_SOURCE_TACAN_WITHOUT_FIELDS   || m_navigation_source  == NAV_SOURCE_TACAN_WITH_FIELDS)
      {
         if (m_long_active_leg_index   >= 0)             // If there is a valid active waypoint,
            DrawSymbols(m_long_active_leg_index);        // draw the GPS Active Waypoint.
      }
      else
      {
         long  ii =  0;

         // Always show MAP_MODE_WAYPOINTS (flight plan).
         for (ii  =  0; ii <  m_long_gps_symbols;  ii++)
         {
            if (DrawSymbols(ii)  == false)
               break;
         }

         if (m_map_mode == MAP_MODE_GROUND_STATIONS)
         {
            for (ii  =  0; ii <  MAX_VHF_NAVAIDS;  ii++)
            {
               if (DrawSymbols(MAX_WAYPOINTS +  ii)  == false)
                  break;
            }
         }
         else if (m_map_mode == MAP_MODE_AIRPORTS)
         {
            for (ii  =  0; ii <  MAX_AIRPORTS;  ii++)
            {
               if (DrawSymbols(MAX_WAYPOINTS +  MAX_VHF_NAVAIDS   +  ii)  == false)
                  break;
            }
         }
         else if (m_map_mode == MAP_MODE_GROUND_STATIONS_AND_AIRPORTS)
         {
            for (ii  =  0; ii <  MAX_VHF_NAVAIDS   +  MAX_AIRPORTS;  ii++)
            {
               if (DrawSymbols(MAX_WAYPOINTS +  ii)  == false)
                  break;
            }
         }
      }
   }
   glPopMatrix();
}


bool  CEHSIGauge::DrawSymbols(long  index)
{
   SymbolInfo  symbolInfo        =  m_symbolInfo[index];
   SymbolInfo  symbolInfo_previous;

   
   if (m_navigation_source == NAV_SOURCE_VOR_WITHOUT_FIELDS    || m_navigation_source  == NAV_SOURCE_VOR_WITH_FIELDS    ||
       m_navigation_source == NAV_SOURCE_TACAN_WITHOUT_FIELDS  || m_navigation_source  == NAV_SOURCE_TACAN_WITH_FIELDS)
   {
      // If this is the GPS Active Waypoint,
      if (index   == m_long_active_leg_index)
      {
         // and only if bearing 1 or 2 source is GPS.
         if (m_bearing1_source   == BEARING_SOURCE_GPS   || m_bearing2_source == BEARING_SOURCE_GPS)
         {
            glPushMatrix();
            {
               glRotated(symbolInfo.position.m_longitude,  0.0,  1.0,  0.0);
               glRotated(-symbolInfo.position.m_latitude,  1.0,  0.0,  0.0);
               glTranslated(0.0, 0.0,  0.95  *  m_hsi_map_range);

               glRotated(270.0 - symbolInfo.heading,  0.0,  0.0,  1.0);

               // Setup the colors for this symbol and its label.
               if (m_bearing1_source      == BEARING_SOURCE_GPS)
                  symbol.SetForegroundColor(255, 255, 255);    // White.
               else if (m_bearing2_source == BEARING_SOURCE_GPS)
                  symbol.SetForegroundColor(255, 0,   128);    // Magenta

               // Draw the symbol...
               if (m_hsi_mode  == EXPANDED_MAP)
                  symbol.Draw(symbolInfo.symbol,         true, 90.0f -  m_ac_heading   -  m_float_magvar_at_aircraft,  1.2f);
               else
                  symbol.Draw(symbolInfo.symbol,         true, 90.0f -  m_ac_heading   -  m_float_magvar_at_aircraft,  2.0f);

               // Don't label the symbol.
               // Don't draw the selected course through this symbol.
            }
            glPopMatrix();
         }
      }
      else if (m_long_lateral_offset_valid)
      {
         glPushMatrix();
         {
            glRotated(symbolInfo.position.m_longitude,  0.0,  1.0,  0.0);
            glRotated(-symbolInfo.position.m_latitude,  1.0,  0.0,  0.0);
            glTranslated(0.0, 0.0,  0.95  *  m_hsi_map_range);

            glRotated(270.0 - symbolInfo.heading,  0.0,  0.0,  1.0);

            // Setup the colors for this symbol and its label.
            if (m_bearing1_source      == BEARING_SOURCE_VOR   || m_bearing1_source == BEARING_SOURCE_TACAN)
               symbol.SetForegroundColor(255, 255, 255);    // White.
            else if (m_bearing2_source == BEARING_SOURCE_VOR   || m_bearing2_source == BEARING_SOURCE_TACAN)
               symbol.SetForegroundColor(255, 0,   128);    // Magenta
            else
               symbol.SetForegroundColor(255, 255, 255);    // White.

            // Draw the symbol...
            if (m_hsi_mode  == EXPANDED_MAP)
               symbol.Draw(symbolInfo.symbol,         true, 90.0f -  m_ac_heading   -  m_float_magvar_at_aircraft,  1.2f);
            else
               symbol.Draw(symbolInfo.symbol,         true, 90.0f -  m_ac_heading   -  m_float_magvar_at_aircraft,  2.0f);

            // Don't label the symbol.

            DrawSelectedCourseInMapMode();
         }
         glPopMatrix();
      }

      return   true;
   }
   else
   {
      if (m_long_lateral_offset_valid  && index == VOR_SYMBOL_OFFSET)
      {
         // and only if bearing 1 or 2 source is VOR.
         if (m_bearing1_source   == BEARING_SOURCE_VOR   || m_bearing2_source == BEARING_SOURCE_VOR   ||
             m_bearing1_source   == BEARING_SOURCE_TACAN || m_bearing2_source == BEARING_SOURCE_TACAN)
         {
            glPushMatrix();
            {
               glRotated(symbolInfo.position.m_longitude,  0.0,  1.0,  0.0);
               glRotated(-symbolInfo.position.m_latitude,  1.0,  0.0,  0.0);
               glTranslated(0.0, 0.0,  0.95  *  m_hsi_map_range);

               glRotated(270.0 - symbolInfo.heading,  0.0,  0.0,  1.0);

               // Setup the colors for this symbol and its label.
               if (m_bearing1_source      == BEARING_SOURCE_VOR   || m_bearing1_source == BEARING_SOURCE_TACAN)
                  symbol.SetForegroundColor(255, 255, 255);    // White.
               else if (m_bearing2_source == BEARING_SOURCE_VOR   || m_bearing2_source == BEARING_SOURCE_TACAN)
                  symbol.SetForegroundColor(255, 0,   128);    // Magenta
               else
                  symbol.SetForegroundColor(255, 255, 255);    // White.

               // Draw the symbol...
               if (m_hsi_mode  == EXPANDED_MAP)
                  symbol.Draw(symbolInfo.symbol,         true, 90.0f -  m_ac_heading   -  m_float_magvar_at_aircraft,  1.2f);
               else
                  symbol.Draw(symbolInfo.symbol,         true, 90.0f -  m_ac_heading   -  m_float_magvar_at_aircraft,  2.0f);

               // Don't label the symbol.
               // Don't draw the selected course through this symbol.
            }
            glPopMatrix();
         }
      }
      else
      {
         glPushMatrix();
         {
            glRotated(symbolInfo.position.m_longitude,  0.0,  1.0,  0.0);
            glRotated(-symbolInfo.position.m_latitude,  1.0,  0.0,  0.0);
            glTranslated(0.0, 0.0,  0.95  *  m_hsi_map_range);

            glRotated(270.0 - symbolInfo.heading,  0.0,  0.0,  1.0);

            // Setup the colors for this symbol and its label.
            if (index   == m_long_active_leg_index)         // If this is the active waypoint.
            {
               if (m_long_gps_annunciation_mode == GPS_ANNUNCIATION_APPROACH)
                  symbol.SetForegroundColor(0, 192, 0);     // Green.
               else
                  symbol.SetForegroundColor(0, 255, 255);   // Cyan.
            }
            else                                            // Otherwise make it White.
               symbol.SetForegroundColor(255, 255, 255);    // White.

            // Draw the symbol...
            if (m_hsi_mode  == EXPANDED_MAP)
               symbol.Draw(symbolInfo.symbol,         true, 90.0f -  m_ac_heading   -  m_float_magvar_at_aircraft,  1.2f);
            else
               symbol.Draw(symbolInfo.symbol,         true, 90.0f -  m_ac_heading   -  m_float_magvar_at_aircraft,  2.0f);

            // Label the symbol...
            glPushMatrix();
               glRotatef(-m_ac_heading, 0.0f, 0.0f, 1.0f);
               if (m_hsi_mode == EXPANDED_MAP)
                  glScalef(0.6f, 0.6f, 1.0f);
               glTranslatef(0.0f, 0.2f, 0.0f);
               symbol.Draw(symbolInfo.symbol_label,   true, 90.0f   -  m_float_magvar_at_aircraft,  1.5f);
            glPopMatrix();


            // If in OBS mode and this is the active waypoint, draw the selected course indicator.
            if (m_bool_gps_obs_mode && index == m_long_active_leg_index)
            {
               DrawSelectedCourseInMapMode();
            }
         }
         glPopMatrix();


         if (index   >= 1)
         {
            symbolInfo_previous   =  m_symbolInfo[index   -  1];

            glPushMatrix();
            {
               glRotated(symbolInfo.position.m_longitude,  0.0,  1.0,  0.0);
               glRotated(-symbolInfo.position.m_latitude,  1.0,  0.0,  0.0);
               glTranslated(0.0, 0.0,  0.95  *  m_hsi_map_range);

               glRotated(270.0 - symbolInfo.heading,  0.0,  0.0,  1.0);

               if (index   <  MAX_WAYPOINTS  && !m_bool_gps_obs_mode)
               {
                  double   modelMatrix[16];
                  double   projMatrix[16];
                  int      viewport[4];
                  double   buffer[6];

                  glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
                  glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
                  glGetIntegerv(GL_VIEWPORT, viewport);
                  gluProject(0.0f, 0.0f, 0.0f, modelMatrix, projMatrix, viewport, &buffer[0], &buffer[1], &buffer[2]);

                  glPopMatrix();
                  glPushMatrix();
                  {
                     glRotated(symbolInfo_previous.position.m_longitude,  0.0,  1.0,  0.0);
                     glRotated(-symbolInfo_previous.position.m_latitude,  1.0,  0.0,  0.0);
                     glTranslated(0.0, 0.0,  0.95  *  m_hsi_map_range);
                     glRotated(270.0 - symbolInfo.heading,  0.0,  0.0,  1.0);

                     glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
                     glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
                     glGetIntegerv(GL_VIEWPORT, viewport);

                     gluProject(0.0f, 0.0f, 0.0f, modelMatrix, projMatrix, viewport, &buffer[3], &buffer[4], &buffer[5]);
                  }
                  glPopMatrix();
                  glPushMatrix();

                  glLoadIdentity();

                  double objx, objy, objz;
                  double next_objx, next_objy, next_objz;

                  glGetDoublev(GL_MODELVIEW_MATRIX, modelMatrix);
                  glGetDoublev(GL_PROJECTION_MATRIX, projMatrix);
                  glGetIntegerv(GL_VIEWPORT, viewport);

                  gluUnProject(buffer[0], buffer[1], 0.0, modelMatrix, projMatrix, viewport, &objx,      &objy,      &objz);
                  gluUnProject(buffer[3], buffer[4], 0.0, modelMatrix, projMatrix, viewport, &next_objx, &next_objy, &next_objz);

                  glBegin(GL_LINES);
                     if (index   == m_long_active_leg_index)      // If this is the active waypoint.
                     {
                        if (m_long_gps_annunciation_mode == GPS_ANNUNCIATION_APPROACH)
                           glRGB(0, 192, 0);    // Green.
                        else
                           glRGB(0, 255, 255);  // Cyan.
                     }
                     else
                        glRGB(255, 255, 255);

                     glVertex3f(objx, objy, 0.0f);
                     glVertex3f(next_objx, next_objy, 0.0f);
                  glEnd();
               }
            }
            glPopMatrix();
         }
      }
      return   true;
   }

   return   false;
}


void CEHSIGauge::DrawNoMap(void)
{
   glPushMatrix();
   {
      if (m_hsi_mode  == EXPANDED_MAP)
      {
         glRotatef(-m_ac_heading, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.65f, 0.0f);
         noMap.Draw(m_CStr_noMap, true, 0.0f, 1.5f);
      }
      else
      {
         glRotatef(-m_ac_heading, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.30f, 0.0f);
         noMap.Draw(m_CStr_noMap, true, 0.0f, 2.0f);
      }
   }
   glPopMatrix();
}


void CEHSIGauge::DrawSelectedCourseInMapMode(void)
{
   glPushMatrix();
      // Adjust the course to takeout magnetic variation
      glRotatef(-m_float_magvar_at_aircraft, 0.0f, 0.0f, 1.0f);

      glBegin(GL_LINES);
         if (m_navigation_source == NAV_SOURCE_VOR_WITHOUT_FIELDS    || m_navigation_source  == NAV_SOURCE_VOR_WITH_FIELDS    ||
             m_navigation_source == NAV_SOURCE_TACAN_WITHOUT_FIELDS  || m_navigation_source  == NAV_SOURCE_TACAN_WITH_FIELDS  ||
             m_long_gps_annunciation_mode == GPS_ANNUNCIATION_APPROACH)
         {
            glRGB(0, 192, 0);    // Green.
         }
         else
         {
            glRGB(0, 255, 255);  // Cyan.
         }
         glVertex3f(0.0f, 0.0f, 0.0f);
         float miles_in_view  =  3600.0f  /  m_hsi_map_range;                    // Diameter of outer ring in miles.
         float length_of_line =  1.0f  +  m_float_primary_dme  /  miles_in_view; // 1 unit plus the distance to the waypoint .
         glVertex3f(length_of_line  *   cos(m_selected_course  *  DEG_TO_RAD),   length_of_line *  sin(m_selected_course   *  DEG_TO_RAD), 0.0f);

         glRGB(255, 255, 255);   // White.
         glVertex3f(0.0f, 0.0f, 0.0f);
         glVertex3f(length_of_line  *  -cos(m_selected_course  *  DEG_TO_RAD),   length_of_line *  -sin(m_selected_course  *  DEG_TO_RAD), 0.0f);
      glEnd();
   glPopMatrix();
}


void CEHSIGauge::DrawHsiSpecifics(void)
{
   glPushMatrix();
   {
      if (m_pWnd == NULL)
      {
         // set the ratio when this is called from the ADI gauge.
         if (m_aspect_ratio  <= 1.0f)
            glScalef(m_aspect_ratio, 1.0f, 1.0f);
         else if (m_aspect_ratio  != 0.0f)
            glScalef(1.0f, 1.0f  /  m_aspect_ratio, 1.0f);
      }

      // The following code deals with the Compass Card and the associated items that move with it.
      glPushMatrix();
      {
         // If the HSI is in composite mode:
         //    1) Draw the ADI
         //    2) Change the viewport (so HSI is drawn toward the bottom of the gauge)
         //    3) Mask out the area to be used by the HSI
         //    4) Draw the HSI.
         if (m_hsi_mode == COMPOSITE   || m_support_ADI_composite_mode)
         {
            if (m_adiGauge)
               m_adiGauge->DrawAdiSpecifics();

            glViewport(rectViewCoord.left + (int)(0.15f * m_width)+1, 
                       rectView.Height() - rectViewCoord.bottom + (int)(0.1f * m_height), 
                       (int)(0.7f * m_width),  
                       (int)(0.7f * m_height));
            glTranslatef(0.0f, -0.85f, 0.0f);

            // Place a black mask down so as to blot out a portion of the ADI gauge.
            glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
               glRGB(0, 0, 0);
               gluDisk(m_pquad, 0.0f,  0.67f, 30, 1);
            glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

            // Draw the Stationary Indicators for the HSI.
            DrawStationaryIndicators();
         }

         // If in ARC mode - either HSI or MAP...
         if (m_hsi_mode == EXPANDED_ARC   || m_hsi_mode  == EXPANDED_MAP)
         {
            glPushMatrix();
            {
               // Adjust the viewport so as to clip the Compass Card at +/- 40.
               glViewport(rectViewCoord.left + (int)(0.15f * m_width)+1, 
                          rectView.Height() - rectViewCoord.bottom + (int)(0.15f * m_height), 
                          (int)(0.7f * m_width),  
                          (int)(0.7f * m_height));
               glScissor(rectViewCoord.left + (int)(0.15f * m_width)+1, 
                         rectView.Height() - rectViewCoord.bottom + (int)(0.15f * m_height), 
                         (int)(0.7f * m_width),  
                         (int)(0.7f * m_height));

               // Move the center of the arc, and everything associated with the arc, down.
               glTranslatef(0.0f, -0.55f, 0.0f);   

               glClearStencil(1);
               glClear(GL_STENCIL_BUFFER_BIT);
               glStencilFunc(GL_ALWAYS, 0, 0);
               glStencilOp(GL_REPLACE, GL_REPLACE, GL_REPLACE);

               glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
               glRGB(0, 0, 0);
               gluDisk(m_pquad, 0, OUTER_RADIUS_ARC_MODE   +  0.03f,  30, 1);
               glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

               glStencilFunc(GL_NOTEQUAL, 1, 1);
               glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);

               // Draw the ticks for the Compass Card and draw the Heading bug.
               glPushMatrix();
               {
                  // Rotate to aircraft heading.
                  glRotatef(m_ac_heading, 0.0f, 0.0f, 1.0f);
                  // Draw the ticks and their labels.
                  theArcModeTicks.Draw();

                  // Heading Bug
                  glPushMatrix();
                     glRotatef(m_heading_bug,   0.0f, 0.0f, 1.0f);
                     glTranslatef(0.0f, OUTER_RADIUS_ARC_MODE, 0.0f);
                     headingBug.Draw(m_headingBug, true, 0.0f, 75.0f);
//                     if (m_cp_500_fail || m_heading_select_knob_failure)
//                     {
//                        glScalef(4.0f, 1.0f, 1.0f);
//                        xOut.Draw(m_xOut, true, 0.0f, 1.0f, 1.75f, false);
//                     }
                  glPopMatrix();
               }
               glPopMatrix();


               // Draw the bearing pointers and Selected Course pointer as needed.
               glPushMatrix();
               {
                  glRotatef(m_ac_heading, 0.0f, 0.0f, 1.0f);

                  // Since we are in ARC mode everything has been scaled (larger) in both the x and y direction.
                  // This makes the needles seem too wide so change the x to y ratio for the needles so as to give the appearance of 
                  // only scaling them (larger) in one direction.  (Make them longer only - not wider.)
                  singleNeedle.SetXtoYratio(0.5f);
                  doubleNeedle.SetXtoYratio(0.5f);
                  selectedCourseNeedle.SetXtoYratio(0.5f);

                  // Don't draw the Bearing #1 and #2 pointers when in composite mode
                  if (m_hsi_mode != COMPOSITE   && !m_support_ADI_composite_mode)
                  {
                     // Draw Bearing #2 if a source exists and it's valid. 
                     if (m_bearing2_source   && m_bearing2_valid)
                     {
                        if (m_hsi_mode == EXPANDED_MAP)                                // If we're in map mode...
                        {
                           if (m_bearing2_distance >  (3600.0f /  m_hsi_map_range))    // and the bearing distance is > the map range.
                              doubleNeedle.Draw(m_doubleNeedle, true, m_bearing2, 360.0f, 1.25f);
                           else if (m_heading_failure)
                              doubleNeedle.Draw(m_doubleNeedle, true, m_bearing2, 135.0f, 1.25f);
                        }
                        else                                                           // No more tests needed - draw the bearing needle.
                           doubleNeedle.Draw(m_doubleNeedle, true, m_bearing2, 360.0f, 1.25f);
                     }

                     // Draw Bearing #1 if a source exists and it's valid. 
                     if (m_bearing1_source   && m_bearing1_valid)
                     {
                        if (m_hsi_mode == EXPANDED_MAP)                                // If we're in map mode...
                        {
                           if (m_bearing1_distance >  (3600.0f /  m_hsi_map_range))    // and the bearing distance is > the map range.
                              singleNeedle.Draw(m_singleNeedle, true, m_bearing1, 320.0f, 1.25f);
                           else if (m_heading_failure)
                              singleNeedle.Draw(m_singleNeedle, true, m_bearing1, 320.0f, 1.25f);
                        }
                        else                                                           // No more tests needed - draw the bearing needle.
                           singleNeedle.Draw(m_singleNeedle, true, m_bearing1, 320.0f, 1.25f);
                     }
                  }

                  if (m_hsi_mode == EXPANDED_ARC)  // Don't draw selected course if in map mode.
                  {
                     if (m_heading_invalid   || !m_long_selected_course_valid)
                     {
                        selectedCourseNeedle.Draw(m_selectedCourseNeedle, true, m_selected_course, 340.0f, 4.0f);
                        glPushMatrix();
                           glRotatef(m_selected_course, 0.0f, 0.0f, 1.0f);
                           glTranslatef(0.0f,  0.95f, 0.0f);
                           glScalef(1.0f, 1.5f, 1.0f);
                           xOut.Draw(m_xOut, true, 0.0f, 3.0f, 1.75f, false);
                        glPopMatrix();
                        glPushMatrix();
                           glRotatef(m_selected_course, 0.0f, 0.0f, 1.0f);
                           glTranslatef(0.0f, -0.95f, 0.0f);
                           glScalef(1.0f, 1.5f, 1.0f);
                           xOut.Draw(m_xOut, true, 0.0f, 3.0f, 1.75f, false);
                        glPopMatrix();
                     }
                     else if (! m_heading_failure)
                        selectedCourseNeedle.Draw(m_selectedCourseNeedle, true, m_selected_course, 340.0f, 4.0f);
                  }

                  // Put the needle x to y ratio back to normal.
                  singleNeedle.SetXtoYratio(1.0f);
                  doubleNeedle.SetXtoYratio(1.0f);
                  selectedCourseNeedle.SetXtoYratio(1.0f);
               }
               glPopMatrix();


               // Draw the Range Ring if in map mode.
               if (m_hsi_mode  == EXPANDED_MAP)
               {
                  glRGB(255, 255, 255);
                  glPushMatrix();
                     glScalef((OUTER_RADIUS_ARC_MODE  /  2.0f), (OUTER_RADIUS_ARC_MODE  /  2.0f), 1.0f);
                     glEnable(GL_LINE_STIPPLE);
                     glLineStipple(2, 0x0707);
                     m_circle.DrawArc(0.0, 180.0);
                     glDisable(GL_LINE_STIPPLE);
                  glPopMatrix();

                  // Label the Range Ring.
                  glPushMatrix();
                     glTranslatef((OUTER_RADIUS_ARC_MODE  /  2.0f), 0.0f, 0.0f);
                     mapRange.Draw(m_CStr_mapRange, true, 0.0f, 2.0f);
                  glPopMatrix();
                  // Draw the map symbols.
                  glPushMatrix();
                     glScalef(1.0f/0.70f, 1.0f/0.70f, 1.0f);
                     glRotatef(m_ac_heading, 0.0f, 0.0f, 1.0f);
                     DrawMapSymbols();
                  glPopMatrix();
               }

               // Mask out a small area at the bottom of the viewport/scissor area.  This will mask out the part of the course needle, 
               // bearing needles, and map that could otherwise draw on top of the bearing annunciators.
               glRGB(0, 0, 0);
               glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                  glBegin(GL_QUADS);
                     glVertex2f(-1.0f, -0.4f);
                     glVertex2f( 1.0f, -0.4f);
                     glVertex2f( 1.0f, -0.5f);
                     glVertex2f(-1.0f, -0.5f);
                  glEnd();
               glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

               glStencilFunc(GL_ALWAYS, 0, 0);
               glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);

               // Reset the viewport to the entire window.
               glViewport(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
               glScissor(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
            }
            glPopMatrix();


            // Move the center of the remaining items so that it corresponds with the center of the arc.
            glTranslatef(0.0f, -0.3895f, 0.0f);

            // Draw the Plane.
            glRotatef(m_ac_heading, 0.0f, 0.0f, 1.0f);
            thePlane.Draw(m_CStr_thePlane,  true, -m_ac_heading, 2.0f, 1.0f);

            if (m_hsi_mode  == EXPANDED_ARC)
            {
               // Course Deviation
               if (! m_heading_failure)
               {
                  glPushMatrix();
                     glRotatef(m_selected_course, 0.0f, 0.0f, 1.0f);
                     lateralPositionTicks.Draw();

                     if (!m_long_lateral_offset_valid)
                     {                      
                        if (m_long_lateral_offset_red_x)
                        {
                           glScalef(7.0f, 1.4f, 1.0f);
                           xOut.Draw(m_xOut, true, 0.0f, 3.0f, 1.75f, false);
                        }
                     }
                     else
                     {
                        glTranslatef(m_lateralPosition_offset, 0.0f, 0.0f);
                        lateralPositionIndicator.Draw(m_lateralPosition_indicator, true, 0.0f, 230.0f, 4.0f);
                     }
                  glPopMatrix();

                  // To/From Indicator
                  if (m_to_from)
                  {
                     glPushMatrix();
                        glRotatef(m_selected_course, 0.0f, 0.0f, 1.0f);
                        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                        if (m_to_from  == 1)
                        {
                           glTranslatef(0.0,  0.1f, 0.0f);
                           toFromIndicator.Draw(m_toFromIndicator,   true, 0.0f,    1.2f);
                        }
                        else if (m_to_from  == 2)
                        {
                           glTranslatef(0.0, -0.1f, 0.0f);
                           toFromIndicator.Draw(m_toFromIndicator,   true, 180.0f,  1.2f);
                        }
                        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                     glPopMatrix();
                  }
               }
            }
         }
         else  // Not in arc mode.
         {
            glClearStencil(1);
            glClear(GL_STENCIL_BUFFER_BIT);
            glStencilFunc(GL_ALWAYS, 0, 0);
            glStencilOp(GL_REPLACE, GL_REPLACE, GL_REPLACE);

            glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
            glRGB(0, 0, 0);
            gluDisk(m_pquad, 0,   OUTER_RADIUS +  0.03f,   30, 1);
            glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);

            glStencilFunc(GL_NOTEQUAL, 1, 1);
            glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);

            glRotatef(m_ac_heading, 0.0f, 0.0f, 1.0f);
            theTicks.Draw();

            // Heading Bug
            glPushMatrix();
               glRotatef(m_heading_bug, 0.0f, 0.0f, 1.0f);
               glTranslatef(0.0, OUTER_RADIUS, 0.0f);
               headingBug.Draw(m_headingBug, true, 0.0f, 50.0f);
//               if (m_cp_500_fail || m_heading_select_knob_failure)
//               {
//                  glScalef(4.0f, 1.0f, 1.0f);
//                  xOut.Draw(m_xOut, true, 0.0f, 1.0f, 1.75f, false);
//               }
            glPopMatrix();

            
            thePlane.Draw(m_CStr_thePlane,  true, -m_ac_heading, 2.0f, 1.0f);


            // Don't draw the Bearing #1 and #2 pointers when in composite, or DG mode.
            if (m_hsi_mode  != COMPOSITE   && !m_support_ADI_composite_mode)
            {
               // Draw Bearing #2 if a source exists and it's valid. 
               if (m_bearing2_source   && m_bearing2_valid)
               {
                  if (m_hsi_mode == NORMAL_MAP)                                  // If we're in map mode...
                  {
                     if (m_bearing2_distance >  (3600.0f /  m_hsi_map_range))    // and the bearing distance is > the map range.
                        doubleNeedle.Draw(m_doubleNeedle, true, m_bearing2, 135.0f, 1.25f);
                     else if (m_heading_failure)
                        doubleNeedle.Draw(m_doubleNeedle, true, m_bearing2, 135.0f, 1.25f);
                  }
                  else                                                           // No more tests needed - draw the bearing needle.
                     doubleNeedle.Draw(m_doubleNeedle, true, m_bearing2, 135.0f, 1.25f);
               }

               // Draw Bearing #1 if a source exists and it's valid. 
               if (m_bearing1_source   && m_bearing1_valid)
               {
                  if (m_hsi_mode == NORMAL_MAP)                                  // If we're in map mode...
                  {
                     if (m_bearing1_distance >  (3600.0f /  m_hsi_map_range))    // and the bearing distance is > the map range.
                        singleNeedle.Draw(m_singleNeedle, true, m_bearing1, 120.0f, 1.25f);
                     else if (m_heading_failure)
                        singleNeedle.Draw(m_singleNeedle, true, m_bearing1, 120.0f, 1.25f);
                  }
                  else                                                           // No more tests needed - draw the bearing needle.
                     singleNeedle.Draw(m_singleNeedle, true, m_bearing1, 120.0f, 1.25f);
               }
            }

            if (m_hsi_mode == NORMAL_HSI  || m_hsi_mode  == COMPOSITE)
            {
               // Selected Course
               if (m_heading_invalid   || !m_long_selected_course_valid)
               {
                  selectedCourseNeedle.Draw(m_selectedCourseNeedle, true, m_selected_course, 120.0f, 4.0f);
                  glPushMatrix();
                     glRotatef(m_selected_course, 0.0f, 0.0f, 1.0f);
                     glTranslatef(0.0f,  0.35f, 0.0f);
                     glScalef(1.0f, 1.5f, 1.0f);
                     xOut.Draw(m_xOut, true, 0.0f, 3.0f, 1.75f, false);
                  glPopMatrix();
                  glPushMatrix();
                     glRotatef(m_selected_course, 0.0f, 0.0f, 1.0f);
                     glTranslatef(0.0f, -0.35f, 0.0f);
                     glScalef(1.0f, 1.5f, 1.0f);
                     xOut.Draw(m_xOut, true, 0.0f, 3.0f, 1.75f, false);
                  glPopMatrix();
               }
               else if (! m_heading_failure)
               {
                  selectedCourseNeedle.Draw(m_selectedCourseNeedle, true, m_selected_course, 120.0f, 4.0f);
               }

               if (m_hsi_mode  == COMPOSITE  || m_support_ADI_composite_mode)
               {
                  glPushMatrix();
                     if (! m_heading_failure)
                        glRotatef(m_selected_course,  0.0f, 0.0f, 1.0f);
                     else
                        glRotatef(-m_ac_heading,      0.0f, 0.0f, 1.0f);

                     lateralPositionTicks.Draw();

                     if (!m_long_lateral_offset_valid)
                     {
                        if (m_long_lateral_offset_red_x)
                        {
                           glScalef(7.0f, 1.4f, 1.0f);
                           xOut.Draw(m_xOut, true, 0.0f, 3.0f, 1.75f, false);
                        }
                     }
                     else if (m_long_selected_course_valid  || m_long_lateral_offset_valid)
                     {
                        glTranslatef(m_lateralPosition_offset, 0.0f, 0.0f);
                        lateralPositionIndicator.Draw(m_lateralPosition_indicator, true, 0.0f, 120.0f, 4.0f);
                     }
                  glPopMatrix();

                  // To/From Indicator
                  if (m_to_from)
                  {
                     glPushMatrix();
                        if (! m_heading_failure)
                           glRotatef(m_selected_course,  0.0f, 0.0f, 1.0f);
                        else
                           glRotatef(-m_ac_heading,      0.0f, 0.0f, 1.0f);

                        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                           if (m_to_from  == 1)
                           {
                              glTranslatef(0.0,  0.1f, 0.0f);
                              toFromIndicator.Draw(m_toFromIndicator, true, 0.0f, 1.2f);
                           }
                           else if (m_to_from  == 2)
                           {
                              glTranslatef(0.0, -0.1f, 0.0f);
                              toFromIndicator.Draw(m_toFromIndicator, true, 180.0f, 1.2f);
                           }
                        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                     glPopMatrix();
                  }
               }
               else if (! m_heading_failure)
               {
                  // Course Deviation
                  glPushMatrix();
                     glRotatef(m_selected_course, 0.0f, 0.0f, 1.0f);
                     lateralPositionTicks.Draw();
                     if (!m_long_lateral_offset_valid)
                     {
                        if (m_long_lateral_offset_red_x)
                        {
                           glScalef(7.0f, 1.4f, 1.0f);
                           xOut.Draw(m_xOut, true, 0.0f, 3.0f, 1.75f, false);
                        }
                     }
                     else if (m_long_selected_course_valid  || m_long_lateral_offset_valid)
                     {
                        glTranslatef(m_lateralPosition_offset, 0.0f, 0.0f);
                        lateralPositionIndicator.Draw(m_lateralPosition_indicator, true, 0.0f, 120.0f, 4.0f);
                     }
                  glPopMatrix();

                  // To/From Indicator
                  if (m_to_from)
                  {
                     glPushMatrix();
                        glRotatef(m_selected_course, 0.0f, 0.0f, 1.0f);
                        glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                           if (m_to_from  == 1)
                           {
                              glTranslatef(0.0,  0.1f, 0.0f);
                              toFromIndicator.Draw(m_toFromIndicator, true, 0.0f, 1.2f);
                           }
                           else if (m_to_from  == 2)
                           {
                              glTranslatef(0.0, -0.1f, 0.0f);
                              toFromIndicator.Draw(m_toFromIndicator, true, 180.0f, 1.2f);
                           }
                        glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
                     glPopMatrix();
                  }
               }
            }
            else if (m_hsi_mode == NORMAL_MAP)
            {
               glPushMatrix();
                  glRGB(255, 255, 255);
                  glScalef(0.30f, 0.30f, 1.0f);
                  glEnable(GL_LINE_STIPPLE);
                  glLineStipple(2, 0x0707);
                  m_circle.Draw();
                  glDisable(GL_LINE_STIPPLE);
               glPopMatrix();

               glPushMatrix();
                  glRotatef(-m_ac_heading, 0.0f, 0.0f, 1.0f);
                  glTranslatef(0.30f, 0.0f, 0.0f);
                  mapRange.Draw(m_CStr_mapRange, true, 0.0f, 1.0f);
               glPopMatrix();
   
               glViewport(rectViewCoord.left + (int)(0.20f * m_width)+1, 
                          rectView.Height() - rectViewCoord.bottom + (int)(0.20f * m_height), 
                          (int)(0.6f * m_width),  (int)(0.6f * m_height));
               DrawMapSymbols();
               glViewport(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, 
                          (int)m_width, (int)m_height);
            }

            glStencilFunc(GL_ALWAYS, 0, 0);
            glStencilOp(GL_KEEP, GL_KEEP, GL_KEEP);
         }

         if (m_hsi_mode == COMPOSITE   || m_support_ADI_composite_mode)
         {
            // Reset the viewport to the entire window.
            glViewport(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
         }

      }
      glPopMatrix();
      // The above code dealt with the Compass Card and the associated items that moved with it.

      if (m_hsi_mode != COMPOSITE   && !m_support_ADI_composite_mode)
      {
         // Draw the Stationary Indicators for the HSI.
         DrawStationaryIndicators();
      }

      if (m_hsi_mode != DIRECTIONAL_GYRO)
      {
         // Data in the center but at the left-hand side of the gauge.
         glPushMatrix();
            glTranslatef(-0.77f, 0.25f, 0.0f);
            gpsAlert.Draw(m_CStr_gpsAlert, true, 0.0f, 1.0f);
         glPopMatrix();
         glPushMatrix();
            glTranslatef(-0.77f, 0.0f, 0.0f);
            navigationSource.Draw(m_CStr_navigationSource, false, 0.0f, 2.0f);
         glPopMatrix();

         // Data in the upper left-hand corner of the gauge.
         glPushMatrix();
            glTranslatef(-0.7f, 0.8f, 0.0f);
            primary_dme.Draw(m_CStr_primary_dme, true, 0.0f, 1.2f);                             // DME distance.
            glTranslatef(0.25f, 0.0f, 0.0f);
            primary_dme_units.Draw(m_CStr_primary_dme_units, true, 0.0f, 1.0f);                 // NM indicator.
         glPopMatrix();

         glPushMatrix();
            glTranslatef(-0.7f, 0.7f, 0.0f);
            groundSpeedOrDMEHoldFreq.Draw(m_CStr_groundSpeedOrDMEHoldFreq, true, 0.0f, 1.0f);               // Ground Speed or DME hold Freq.
            glTranslatef(0.25f, 0.0f, 0.0f);
            groundSpeedOrDMEHoldFreq_units.Draw(m_CStr_groundSpeedOrDMEHoldFreq_units, true, 0.0f, 1.0f);   // KT for ground speed or H for dme hold.
         glPopMatrix();

         glPushMatrix();
            glTranslatef(-0.7f, 0.6f, 0.0f);
            timeToGo.Draw(m_CStr_timeToGo, true, 0.0f, 1.0f);                                   // Time to Go.
         glPopMatrix();

         // Data in the upper right-hand corner of the gauge.
         glPushMatrix();
         {
            glTranslatef(0.525f, 0.8f, 0.0f);
            selectedCourseOrDesiredTrack.Draw(m_CStr_selectedCourseOrDesiredTrack, true, 0.0f, 1.2f);

//            if (m_heading_invalid   || m_cp_500_fail  || !m_long_selected_course_valid)
            if (m_heading_invalid   || !m_long_selected_course_valid)
            {
               glPushMatrix();
                  glTranslatef(0.11f, 0.0f, 0.0f);
                  glScalef(2.5f, 1.0f, 1.0f);
                  xOut.Draw(m_xOut, true, 0.0f, 2.5f, 1.75f, false);
               glPopMatrix();
            }
         }
         glPopMatrix();

         glPushMatrix();
            glTranslatef(0.625f, -0.60f, 0.0f);
            gps_annunciation.Draw(m_CStr_gps_annunciation, true, 0.0f, 1.1f, 1.0f, false);
         glPopMatrix();


         if (m_hsi_mode  == NORMAL_MAP  || m_hsi_mode  == EXPANDED_MAP  || (m_heading_failure   && (m_hsi_mode != COMPOSITE   && !m_support_ADI_composite_mode)))
         {
            // Course Deviation
            if (!m_long_lateral_offset_valid)
            {
               if (m_bool_gps_obs_mode)           
               {
                  // If in GPS OBS mode don't draw the Lateral Position Ticks.
               }
               else
               {
                  glPushMatrix();
                     glTranslatef(-0.35f, -0.74f, 0.0f);
                     aLine.Draw(m_aLine, true, 0.0f, 15.0f);      //    |
                  glPopMatrix();
                  glPushMatrix();
                     glTranslatef( 0.35f, -0.74f, 0.0f);
                     aLine.Draw(m_aLine, true, 0.0f, 15.0f);      //                   |
                  glPopMatrix();
                  glPushMatrix();
                     glTranslatef( 0.0f,  -0.72f, 0.0f);
                     aLine.Draw(m_aLine, true, 90.0f, 306.25f);   //     --------------
                  glPopMatrix();
                  glPushMatrix();
                     glTranslatef(0.0f, -0.78f, 0.0f);
                     lateralPositionTicksBottom.Draw();

                     if (m_back_course)   // If we're doing a back course, show the BC annunciator and reverse the lateral position offset.
                     {
                        glPushMatrix();
                           glTranslatef(-0.08f, 0.0f, 0.0f);
                           backCourseIndicator.Draw(m_backCourseIndicator, true, 0.0f, 1.0f, 1.0, false);
                           m_lateralPosition_offset   *= -1.0f;
                        glPopMatrix();
                     }
                  glPopMatrix();
               }

               if (m_long_gps_symbols  == 0  || m_bool_gps_obs_mode)
               {
                  // Don't draw an X and don't draw the indicator.
               }
               else if (m_navigation_source  == NAV_SOURCE_VOR_WITHOUT_FIELDS    || 
                        m_navigation_source  == NAV_SOURCE_VOR_WITH_FIELDS       ||
                        m_navigation_source  == NAV_SOURCE_TACAN_WITHOUT_FIELDS  || 
                        m_navigation_source  == NAV_SOURCE_TACAN_WITH_FIELDS     ||
                        m_navigation_source  == NAV_SOURCE_GPS_WITHOUT_FIELDS    ||
                        m_navigation_source  == NAV_SOURCE_GPS_WITH_FIELDS)
               {
                  glPushMatrix();
                     glScalef(7.0f, 1.1f, 1.0f);
                     xOut.Draw(m_xOut, true, 0.0f, 3.0f, 1.75f, false);
                  glPopMatrix();
               }
            }
            else
            {
               glPushMatrix();
                  glTranslatef(-0.35f, -0.74f, 0.0f);
                  aLine.Draw(m_aLine, true, 0.0f, 15.0f);      //    |
               glPopMatrix();
               glPushMatrix();
                  glTranslatef( 0.35f, -0.74f, 0.0f);
                  aLine.Draw(m_aLine, true, 0.0f, 15.0f);      //                   |
               glPopMatrix();
               glPushMatrix();
                  glTranslatef( 0.0f,  -0.72f, 0.0f);
                  aLine.Draw(m_aLine, true, 90.0f, 306.25f);   //     --------------
               glPopMatrix();
               glPushMatrix();
                  glTranslatef(0.0f, -0.78f, 0.0f);
                  lateralPositionTicksBottom.Draw();

                  if (m_back_course)   // If we're doing a back course, show the BC annunciator and reverse the lateral position offset.
                  {
                     glPushMatrix();
                        glTranslatef(-0.08f, 0.0f, 0.0f);
                        backCourseIndicator.Draw(m_backCourseIndicator, true, 0.0f, 1.0f, 1.0, false);
                        m_lateralPosition_offset   *= -1.0f;
                     glPopMatrix();
                  }
                  glTranslatef(m_lateralPosition_offset, 0.0f, 0.0f);
                  lateralPositionIndicatorBottom.Draw(m_lateralPosition_indicator_bottom, true, 0.0f, 25.0f, 5.0f);
               glPopMatrix();
            }
         }
      }

      // Draw Bearing #1 and #2 annunciators when not in composite mode.
      if (m_hsi_mode != COMPOSITE   && !m_support_ADI_composite_mode)
      {
         DrawBearingAnnunciators();
      }

      // Control Panel Failure Annuciator
      if (m_cp_500_fail)
      {
         glPushMatrix();
            glTranslatef(-0.75f, -0.375f, 0.0f);
            controlPanelFailed.Draw(m_controlPanelFailed, true, 0.0f, 1.2f, 1.5, true);
         glPopMatrix();
      }

      // XTALK
      if (m_bool_XTALK_Flag)
      {
         glPushMatrix();
            glTranslatef(-0.700f, -0.550f, 0.0f);
            XTALK.Draw(m_XTALK, true, 0.0f, 1.001f, 1.5f, true);
         glPopMatrix();
      }

      // FHDG
      if (m_bool_FHDG_Flag)
      {
         if (m_hsi_mode == COMPOSITE   || m_support_ADI_composite_mode)
         {
            glPushMatrix();
               glTranslatef(-0.455f, -0.55f, 0.0f);
               FHDG.Draw(m_FHDG, true, 0.0f, 1.0f, 1.5, false);
            glPopMatrix();
         }
         else
         {
            glPushMatrix();
               glTranslatef(-0.15f, 0.70f, 0.0f);
               FHDG.Draw(m_FHDG, true, 0.0f, 1.0f, 1.5, false);
            glPopMatrix();
         }
      }

      // Data in the center but at the right-hand side of the gauge.
      if (m_ils_selected  && !m_back_course  && !m_bool_Nav_Pwr_Fail)
      {
         // Glideslope Indicator
         if (m_long_GS_status)
         {
            glPushMatrix();
               glTranslatef(0.75f, 0.0f, 0.0f);
               glideslopeTicks.Draw();
               glTranslatef(0.025f, m_glideslope_offset, 0.0f);
               glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
                  glideslopeIndicator.Draw(m_glideslope_indicator, true, 90.0f, 1.75f, 1.0f);
               glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
            glPopMatrix();
         }
         else if (m_bool_GS_fail)
         {
            glPushMatrix();
               glTranslatef(0.75f, 0.0f, 0.0f);
               glideslopeTicks.Draw();
               glScalef(2.5f, 20.0f, 1.0f);
               xOut.Draw(m_xOut, true, 0.0f, 1.0f, 1.75f, false);
            glPopMatrix();
         }
      }

      if (m_hsi_mode == NORMAL_MAP  || m_hsi_mode  == EXPANDED_MAP   || 
         (m_heading_failure   && m_hsi_mode  != DIRECTIONAL_GYRO  && m_hsi_mode  != COMPOSITE   && !m_support_ADI_composite_mode))
      {
         // To/From Indicator
         if (m_to_from)
         {
            glPushMatrix();
               glTranslatef(0.76f, 0.8f, 0.0f);
               CString  to_from;
               if (m_to_from  == 1)
                  to_from.Format("TO");
               else if (m_to_from  == 2)
                  to_from.Format("FR");
               toFromIndicator.Draw(to_from, true, 0.0f, 1.0f);
            glPopMatrix();
         }
      }

      // Selected Heading
      glPushMatrix();
      {
         glTranslatef(0.525f, 0.7f, 0.0f);
         selectedHeading.SetForegroundColor(192, 192, 0);
         selectedHeading.Draw(m_selectedHeading, true, 0.0f, 1.2f);
//         if (m_cp_500_fail)
//         {
//            glPushMatrix();
//               glTranslatef(0.11f, 0.0f, 0.0f);
//               glScalef(5.0f, 2.0f, 1.0f);
//               xOut.Draw(m_xOut, true, 0.0f, 1.0f, 1.75f, false);
//            glPopMatrix();
//         }
      }
      glPopMatrix();

      // Heading Failure Annuciator
      if (m_heading_failure)
      {
         glPushMatrix();
            if (m_hsi_mode == COMPOSITE   || m_support_ADI_composite_mode)
               glTranslatef(0.15f, -0.175f, 0.0f);
            else
               glTranslatef(0.20f, 0.75f, 0.0f);
            hdgFailed.Draw(m_hdgFailed, true, 0.0f, 1.2f, 1.75, true);
         glPopMatrix();
      }
   }
   glPopMatrix();
}

void  CEHSIGauge::DrawBearingAnnunciators(void)
{
   // Bearing #1 annunciator.
   if (m_bearing1_source)
   {
      // Draw the "legend" needle and possibly X it out...   
      glPushMatrix();
         glTranslatef(-0.80f, -0.95f, 0.0f);
         bearing1Needle.Draw(m_CStr_bearing1Needle, true, 0.0f, 70.0f);
         if (!m_bearing1_valid)
         {
            glTranslatef(0.0f, 0.21f, 0.0f);
            glScalef(1.5f, 3.5f, 1.0f);
            xOut.Draw(m_xOut, true, 0.0f, 1.0f, 1.75f, false);
         }
      glPopMatrix();

      // Draw SOURCE and possibly HOLD...
      glPushMatrix();
         glTranslatef(-0.65f, -0.7f, 0.0f);
         bearing1Source.Draw(m_CStr_bearing1Source, true, 0.0f, 1.0f);
      glPopMatrix();

      if (m_bearing1_source   == BEARING_SOURCE_VOR   && m_DME_hold)    // Don't draw DISTANCE and UNITS
      {
      }
      else  // Draw DISTANCE and UNITS...
      {
         glPushMatrix();
            glTranslatef(-0.65f, -0.8f, 0.0f);
            bearing1Distance.Draw(m_CStr_bearing1Distance, true, 0.0f, 1.0f);
            glTranslatef( 0.15f,  0.0f, 0.0f);
            bearing1Distance_units.Draw(m_CStr_bearing1Distance_units, true, 0.0f, 1.0f);
         glPopMatrix();
      }
   }

   // Bearing #2 annunciator.
   if (m_bearing2_source)
   {
      // Draw the "legend" needle and possibly X it out...   
      glPushMatrix();
         glTranslatef(0.475f, -0.95f, 0.0f);
         bearing2Needle.Draw(m_CStr_bearing2Needle, true, 0.0f, 70.0f);
         if (!m_bearing2_valid)
         {
            glTranslatef(0.0f, 0.21f, 0.0f);
            glScalef(1.5f, 3.5f, 1.0f);
            xOut.Draw(m_xOut, true, 0.0f, 1.0f, 1.75f, false);
         }
      glPopMatrix();

      // Draw SOURCE and possibly HOLD...
      glPushMatrix();
         glTranslatef(0.625f, -0.7f, 0.0f);
         bearing2Source.Draw(m_CStr_bearing2Source, true, 0.0f, 1.0f);
      glPopMatrix();

      if (m_bearing2_source   == BEARING_SOURCE_VOR   && m_DME_hold)    // Don't draw DISTANCE and UNITS
      {
      }
      else  // Draw DISTANCE and UNITS...
      {
         glPushMatrix();
            glTranslatef(0.625f, -0.8f, 0.0f);
            bearing2Distance.Draw(m_CStr_bearing2Distance, true, 0.0f, 1.0f);
            glTranslatef(0.15f,  0.0f, 0.0f);
            bearing2Distance_units.Draw(m_CStr_bearing2Distance_units, true, 0.0f, 1.0f);
         glPopMatrix();
      }
   }
}

void  CEHSIGauge::SetSupportAdiCompositeMode(bool support)
{
   m_support_ADI_composite_mode_cv  =  support;
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CEHSIGauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CEHSIGauge::UpdateRenderVariables()
{
   static   CString  temp;    // Used to do some special formating.

   m_glideslope_offset                 =  m_glideslope_offset_cv;
   m_lateralPosition_offset            =  m_lateralPosition_offset_cv;
   m_selected_course                   =  m_selected_course_cv;
   m_heading_bug                       =  m_heading_bug_cv;
   m_selectedHeading                   =  m_selectedHeading_cv;
   m_CStr_selectedCourseOrDesiredTrack =  m_CStr_selectedCourseOrDesiredTrack_cv;

   m_hsi_mode                       =  m_hsi_mode_cv;
   m_arc_mode                       =  m_arc_mode_cv;
   m_map_mode                       =  m_map_mode_cv;
   m_hsi_map_range                  =  m_hsi_map_range_cv;
   m_CStr_mapRange                  =  m_CStr_mapRange_cv;
   m_heading_failure                =  m_heading_failure_cv;
   m_heading_invalid                =  m_heading_invalid_cv;
   m_attitude_fail                  =  m_attitude_fail_cv;
   m_cp_500_fail                    =  m_cp_500_fail_cv;
   m_heading_select_knob_failure    =  m_heading_select_knob_failure_cv;
   m_to_from                        =  m_to_from_cv;
   m_ac_heading                     =  m_ac_heading_cv;
   m_ac_latitude                    =  m_ac_latitude_cv;
   m_ac_longitude                   =  m_ac_longitude_cv;
   m_support_ADI_composite_mode     =  m_support_ADI_composite_mode_cv;
   m_back_course                    =  m_back_course_cv;
   m_DME_hold                       =  m_DME_hold_cv;
   m_float_magvar_at_aircraft       =  m_float_magvar_at_aircraft_cv;
   m_float_magvar_from_gps          =  m_float_magvar_from_gps_cv;

   m_navigation_source              =  m_navigation_source_cv;
   m_ils_selected                   =  m_ils_selected_cv;
   m_float_primary_dme              =  m_float_primary_dme_cv;
   m_long_primary_dme_status        =  m_long_primary_dme_status_cv;
   m_float_ground_speed             =  m_float_ground_speed_cv;
   m_long_groundspeed_status        =  m_long_groundspeed_status_cv;
   m_float_primary_dme_freq         =  m_float_primary_dme_freq_cv;
   m_float_time_to_go               =  m_float_time_to_go_cv;
   m_long_time_to_go_status         =  m_long_time_to_go_status_cv;
   m_long_gpsAlert_status           =  m_long_gpsAlert_status_cv;
   
   m_bearing1                       =  m_bearing1_cv;
   m_bearing1_source                =  m_bearing1_source_cv;
   m_bearing1_distance              =  m_bearing1_distance_cv;
   m_bearing1_valid                 =  m_bearing1_valid_cv;
   m_long_bearing1_distance_valid   =  m_long_bearing1_distance_valid_cv;
   m_bearing2                       =  m_bearing2_cv;
   m_bearing2_source                =  m_bearing2_source_cv;
   m_bearing2_distance              =  m_bearing2_distance_cv;
   m_bearing2_valid                 =  m_bearing2_valid_cv;
   m_long_bearing2_distance_valid   =  m_long_bearing2_distance_valid_cv;

   m_long_selected_course_valid     =  m_long_selected_course_valid_cv;
   m_long_GS_status                 =  m_long_GS_status_cv;
   m_bool_GS_fail                   =  m_bool_GS_fail_cv;
   m_bool_Nav_Pwr_Fail              =  m_bool_Nav_Pwr_Fail_cv;
   m_long_lateral_offset_valid      =  m_long_lateral_offset_valid_cv;
   m_long_lateral_offset_red_x      =  m_long_lateral_offset_red_x_cv;


   m_long_gps_symbols               =  m_long_gps_symbols_cv;
   m_long_active_leg_index          =  m_long_active_leg_index_cv;
   m_long_gps_annunciation_mode     =  m_long_gps_annunciation_mode_cv;

   m_bool_gps_obs_mode              =  m_bool_gps_obs_mode_cv;
   m_bool_EHSI_Power                =  m_bool_EHSI_Power_cv;

   m_bool_FHDG_Flag                 =  m_bool_FHDG_Flag_cv;
   m_bool_XTALK_Flag                =  m_bool_XTALK_Flag_cv;

   if (m_navigation_source == NAV_SOURCE_GPS_WITHOUT_FIELDS ||
       m_navigation_source == NAV_SOURCE_GPS_WITH_FIELDS)
   {
      switch (m_long_gps_annunciation_mode)
      {
         case  GPS_ANNUNCIATION_ENROUTE:
            m_CStr_gps_annunciation =  "";
            gps_annunciation.SetForegroundColor(0, 0, 0);         // Make it BLACK so it disappears.
            break;

         case  GPS_ANNUNCIATION_TERMINAL:
            m_CStr_gps_annunciation =  "APR ARM";
            gps_annunciation.SetForegroundColor(255, 255, 255);   // White.
            break;

         case  GPS_ANNUNCIATION_APPROACH:
            m_CStr_gps_annunciation =  "APR ACT";
            gps_annunciation.SetForegroundColor(0, 192, 0);       // Green.
            break;

         case  GPS_ANNUNCIATION_OCEANIC:
            m_CStr_gps_annunciation =  "";
            gps_annunciation.SetForegroundColor(0, 0, 0);         // Make it BLACK so it disappears.
            break;
      }
   }
   else
   {
      m_CStr_gps_annunciation =  "";
      gps_annunciation.SetForegroundColor(0, 0, 0);               // Make it BLACK so it disappears.
   }

   switch (m_navigation_source)
   {
      case  NAV_SOURCE_VOR_WITHOUT_FIELDS:
         if (m_ils_selected  && !m_bool_Nav_Pwr_Fail)
            m_CStr_navigationSource =  "LOC";
         else
            m_CStr_navigationSource =  "VOR";

         navigationSource.SetForegroundColor(0, 192, 0);
         primary_dme.SetForegroundColor(0, 192, 0);
         primary_dme_units.SetForegroundColor(0, 192, 0);
         groundSpeedOrDMEHoldFreq.SetForegroundColor(0, 0, 0);          // Make it BLACK so it disappears.
         groundSpeedOrDMEHoldFreq_units.SetForegroundColor(0, 0, 0);    // Make it BLACK so it disappears.
         timeToGo.SetForegroundColor(0, 0, 0);                          // Make it BLACK so it disappears.

         m_long_selected_course_valid  =  1;                            // Basically ignore host if nav source isn't GPS.
         m_CStr_selectedCourseOrDesiredTrack.Format("CRS %03.0f", -m_selected_course);
         selectedCourseOrDesiredTrack.SetForegroundColor(0, 192, 0);
         selectedCourseNeedle.SetForegroundColor(0, 192, 0);
         
         lateralPositionIndicator.SetForegroundColor(0,  192,  0);
         lateralPositionIndicatorBottom.SetForegroundColor(0,  192,  0);
         break;

      case  NAV_SOURCE_VOR_WITH_FIELDS:
         if (m_ils_selected  && !m_bool_Nav_Pwr_Fail)
            m_CStr_navigationSource =  "LOC";
         else
            m_CStr_navigationSource =  "VOR";

         navigationSource.SetForegroundColor(0, 192, 0);
         primary_dme.SetForegroundColor(0, 192, 0);
         primary_dme_units.SetForegroundColor(0, 192, 0);
         groundSpeedOrDMEHoldFreq.SetForegroundColor(0, 192, 0);
         groundSpeedOrDMEHoldFreq_units.SetForegroundColor(0, 192, 0);
         timeToGo.SetForegroundColor(0, 192, 0);

         m_long_selected_course_valid  =  1;                               // Basically ignore host if nav source isn't GPS.
         m_CStr_selectedCourseOrDesiredTrack.Format("CRS %03.0f", -m_selected_course);
         selectedCourseOrDesiredTrack.SetForegroundColor(0, 192, 0);
         selectedCourseNeedle.SetForegroundColor(0, 192, 0);
         
         lateralPositionIndicator.SetForegroundColor(0,  192,  0);
         lateralPositionIndicatorBottom.SetForegroundColor(0,  192,  0);
         break;


      case  NAV_SOURCE_TACAN_WITHOUT_FIELDS:
         m_CStr_navigationSource =  "TCN";

         navigationSource.SetForegroundColor(0, 192, 0);
         primary_dme.SetForegroundColor(0, 192, 0);
         primary_dme_units.SetForegroundColor(0, 192, 0);
         groundSpeedOrDMEHoldFreq.SetForegroundColor(0, 0, 0);          // Make it BLACK so it disappears.
         groundSpeedOrDMEHoldFreq_units.SetForegroundColor(0, 0, 0);    // Make it BLACK so it disappears.
         timeToGo.SetForegroundColor(0, 0, 0);                          // Make it BLACK so it disappears.

         m_long_selected_course_valid  =  1;                            // Basically ignore host if nav source isn't GPS.
         m_CStr_selectedCourseOrDesiredTrack.Format("CRS %03.0f", -m_selected_course);
         selectedCourseOrDesiredTrack.SetForegroundColor(0, 192, 0);
         selectedCourseNeedle.SetForegroundColor(0, 192, 0);
         
         lateralPositionIndicator.SetForegroundColor(0,  192,  0);
         lateralPositionIndicatorBottom.SetForegroundColor(0,  192,  0);
         break;

      case  NAV_SOURCE_TACAN_WITH_FIELDS:
         m_CStr_navigationSource =  "TCN";

         navigationSource.SetForegroundColor(0, 192, 0);
         primary_dme.SetForegroundColor(0, 192, 0);
         primary_dme_units.SetForegroundColor(0, 192, 0);
         groundSpeedOrDMEHoldFreq.SetForegroundColor(0, 192, 0);
         groundSpeedOrDMEHoldFreq_units.SetForegroundColor(0, 192, 0);
         timeToGo.SetForegroundColor(0, 192, 0);

         m_long_selected_course_valid  =  1;                               // Basically ignore host if nav source isn't GPS.
         m_CStr_selectedCourseOrDesiredTrack.Format("CRS %03.0f", -m_selected_course);
         selectedCourseOrDesiredTrack.SetForegroundColor(0, 192, 0);
         selectedCourseNeedle.SetForegroundColor(0, 192, 0);
         
         lateralPositionIndicator.SetForegroundColor(0,  192,  0);
         lateralPositionIndicatorBottom.SetForegroundColor(0,  192,  0);
         break;


      case  NAV_SOURCE_GPS_WITHOUT_FIELDS:
         m_CStr_navigationSource =  "GPS";
         
         if (m_bool_gps_obs_mode)
         {
            if (m_long_selected_course_valid)
               m_CStr_selectedCourseOrDesiredTrack.Format("CRS %03.0f", -m_selected_course);
            else
               m_CStr_selectedCourseOrDesiredTrack =  "CRS    ";
         }
         else
         {
            if (m_long_selected_course_valid)
               m_CStr_selectedCourseOrDesiredTrack.Format("DTK %03.0f", -m_selected_course);
            else
               m_CStr_selectedCourseOrDesiredTrack =  "DTK    ";
         }

         gpsAlert.SetForegroundColor(255, 255, 255);                          // White.

         if (m_long_gps_annunciation_mode == GPS_ANNUNCIATION_APPROACH)
         {
            navigationSource.SetForegroundColor(0, 192, 0);
            primary_dme.SetForegroundColor(0, 192, 0);
            primary_dme_units.SetForegroundColor(0, 192, 0);
            groundSpeedOrDMEHoldFreq.SetForegroundColor(0, 0, 0);             // Make it BLACK so it disappears.
            groundSpeedOrDMEHoldFreq_units.SetForegroundColor(0, 0, 0);       // Make it BLACK so it disappears.
            timeToGo.SetForegroundColor(0, 0, 0);                             // Make it BLACK so it disappears.
            selectedCourseOrDesiredTrack.SetForegroundColor(0, 192, 0);
            selectedCourseNeedle.SetForegroundColor(0, 192, 0);
            lateralPositionIndicator.SetForegroundColor(0,  192, 0);
            lateralPositionIndicatorBottom.SetForegroundColor(0,  192, 0);
         }
         else
         {
            navigationSource.SetForegroundColor(0, 255, 255);
            primary_dme.SetForegroundColor(0, 255, 255);
            primary_dme_units.SetForegroundColor(0, 255, 255);
            groundSpeedOrDMEHoldFreq.SetForegroundColor(0, 0, 0);             // Make it BLACK so it disappears.
            groundSpeedOrDMEHoldFreq_units.SetForegroundColor(0, 0, 0);       // Make it BLACK so it disappears.
            timeToGo.SetForegroundColor(0, 0, 0);                             // Make it BLACK so it disappears.
            selectedCourseOrDesiredTrack.SetForegroundColor(0, 255, 255);
            selectedCourseNeedle.SetForegroundColor(0, 255, 255);
            lateralPositionIndicator.SetForegroundColor(0,  255, 255);
            lateralPositionIndicatorBottom.SetForegroundColor(0,  255, 255);
         }
         break;

      case  NAV_SOURCE_GPS_WITH_FIELDS:
         m_CStr_navigationSource =  "GPS";

         if (m_bool_gps_obs_mode)
         {
            if (m_long_selected_course_valid)
               m_CStr_selectedCourseOrDesiredTrack.Format("CRS %03.0f", -m_selected_course);
            else
               m_CStr_selectedCourseOrDesiredTrack =  "CRS    ";
         }
         else
         {
            if (m_long_selected_course_valid)
               m_CStr_selectedCourseOrDesiredTrack.Format("DTK %03.0f", -m_selected_course);
            else
               m_CStr_selectedCourseOrDesiredTrack =  "DTK    ";
         }

         gpsAlert.SetForegroundColor(255, 255, 255);                       // White.

         if (m_long_gps_annunciation_mode == GPS_ANNUNCIATION_APPROACH)
         {
            navigationSource.SetForegroundColor(0, 192, 0);
            primary_dme.SetForegroundColor(0, 192, 0);
            primary_dme_units.SetForegroundColor(0, 192, 0);
            groundSpeedOrDMEHoldFreq.SetForegroundColor(0, 192, 0);
            groundSpeedOrDMEHoldFreq_units.SetForegroundColor(0, 192, 0);
            timeToGo.SetForegroundColor(0, 192, 0);
            selectedCourseOrDesiredTrack.SetForegroundColor(0, 192, 0);
            selectedCourseNeedle.SetForegroundColor(0, 192, 0);
            lateralPositionIndicator.SetForegroundColor(0,  192, 0);
            lateralPositionIndicatorBottom.SetForegroundColor(0,  192, 0);
         }
         else
         {
            navigationSource.SetForegroundColor(0, 255, 255);
            primary_dme.SetForegroundColor(0, 255, 255);
            primary_dme_units.SetForegroundColor(0, 255, 255);
            groundSpeedOrDMEHoldFreq.SetForegroundColor(0, 255, 255);
            groundSpeedOrDMEHoldFreq_units.SetForegroundColor(0, 255, 255);
            timeToGo.SetForegroundColor(0, 255, 255);
            selectedCourseOrDesiredTrack.SetForegroundColor(0, 255, 255);
            selectedCourseNeedle.SetForegroundColor(0, 255, 255);
            lateralPositionIndicator.SetForegroundColor(0,  255, 255);
            lateralPositionIndicatorBottom.SetForegroundColor(0,  255, 255);
         }
         break;
   }

   switch   (m_long_primary_dme_status)
   {
      case  0:       // Valid
            if (m_float_primary_dme <= 100.0f)
               temp.Format("%.1f",  m_float_primary_dme);
            else
               temp.Format("%.0f",  m_float_primary_dme);
            m_CStr_primary_dme.Format("%5.5s", temp);                                     // Use current color.
            break;

      case  1:       // Not Computed
            primary_dme.SetForegroundColor(255, 0, 0);                                    // Red
            temp  =  "----";
            m_CStr_primary_dme.Format("%5.5s", temp);
            break;

      case  2:       // Invalid
            temp  =  "----";
            m_CStr_primary_dme.Format("%5.5s", temp);
            break;
   }

   switch   (m_long_groundspeed_status)
   {
      case  0:       // Valid
         {
            temp.Format("%.0f", m_float_ground_speed);
            m_CStr_groundSpeedOrDMEHoldFreq.Format("%6.6s", temp);                        // Use current color.
            m_CStr_groundSpeedOrDMEHoldFreq_units.Format("KT");                           // Use current color.
         }
         break;

      case  1:       // Dme hold
         {
            temp.Format("%.2f", m_float_primary_dme_freq);
            groundSpeedOrDMEHoldFreq.SetForegroundColor(255, 255, 255);                   // White
            m_CStr_groundSpeedOrDMEHoldFreq.Format("%6.6s", temp);
            groundSpeedOrDMEHoldFreq_units.SetForegroundColor(255,  255,  0);             // Yellow
            m_CStr_groundSpeedOrDMEHoldFreq_units.Format("H ");
         }
         break;

      case  2:       // Invalid
         {
            temp.Format("%.0f", m_float_ground_speed);
            groundSpeedOrDMEHoldFreq.SetForegroundColor(0, 0, 0);                         // Make BLACK so it disappears.
            m_CStr_groundSpeedOrDMEHoldFreq.Format("%6.6s", temp);
            groundSpeedOrDMEHoldFreq_units.SetForegroundColor(0, 0, 0);                   // Make BLACK so it disappears.
            m_CStr_groundSpeedOrDMEHoldFreq_units.Format("KT");
         }
         break;
   }

   switch   (m_long_time_to_go_status)
   {
      case  0:       // Valid
         {
            int   hours    =  m_float_time_to_go   /  60;
            int   minutes  =  (int)m_float_time_to_go   %  60;

            // Fix funky floating point mis-representations which cause things like 1:00 to be displayed as 0:60
            if (minutes == 60)
            {
               minutes =  0;
               hours++;
            }

            temp.Format("%d:%02d", hours, minutes);
            m_CStr_timeToGo.Format("%6.6s", temp);
         }
         break;

      case  1:       // Dme hold
         timeToGo.SetForegroundColor(0, 0, 0);                          // Make it BLACK so it disappears.
         break;

      case  2:       // Invalid
         temp  =  "--:--";
         m_CStr_timeToGo.Format("%6.6s", temp);
         break;
   }

   switch   (m_long_gpsAlert_status)
   {
      case  0:       // Blank
         m_CStr_gpsAlert   =  "   ";
         break;

      case  1:       // Wpt
         m_CStr_gpsAlert   =  "WPT";
         break;

      case  2:       // Msg
         m_CStr_gpsAlert   =  "MSG";
         break;
   }

   switch (m_bearing1_source)
   {
      case  BEARING_SOURCE_DECLUTTER:
         m_CStr_bearing1Source      =  "";
         break;

      case  BEARING_SOURCE_VOR:
         if (m_ils_selected_cv  && !m_bool_Nav_Pwr_Fail)
            m_CStr_bearing1Source   =  "LOC ";
         else
            m_CStr_bearing1Source   =  "VOR ";
         break;

      case  BEARING_SOURCE_TACAN:
         m_CStr_bearing1Source      =  "TCN ";
         break;

      case  BEARING_SOURCE_GPS:
         m_CStr_bearing1Source      =  "GPS ";
         break;

      default:
         m_bearing1_source          =  BEARING_SOURCE_DECLUTTER;
         m_CStr_bearing1Source      =  "";
         break;
   }

   switch (m_bearing2_source)
   {
      case  BEARING_SOURCE_DECLUTTER:
         m_CStr_bearing2Source      =  "";
         break;

      case  BEARING_SOURCE_VOR:
         if (m_ils_selected_cv  && !m_bool_Nav_Pwr_Fail)
            m_CStr_bearing2Source   =  "LOC ";
         else
            m_CStr_bearing2Source   =  "VOR ";
         break;

      case  BEARING_SOURCE_TACAN:
         m_CStr_bearing2Source      =  "TCN ";
         break;

      case  BEARING_SOURCE_GPS:
         m_CStr_bearing2Source      =  "GPS ";
         break;

      default:
         m_bearing2_source          =  BEARING_SOURCE_DECLUTTER;
         m_CStr_bearing2Source      =  "";
         break;
   }

   switch   (m_long_bearing1_distance_valid)
   {
      case  0:    // Invalid
         bearing1Distance.SetForegroundColor(255, 255, 255);                           // Use normal color.
         m_CStr_bearing1Distance =  "----";
         break;

      case  1:    // No Computed Data
         bearing1Distance.SetForegroundColor(255, 0, 0);                               // Red
         m_CStr_bearing1Distance =  "----";
         break;

      case  2:    // Test
         break;

      case  3:    // Valid
         bearing1Distance.SetForegroundColor(255, 255, 255);                           // Use normal color.
         if (m_bearing1_distance <= 100.0f)
            temp.Format("%.1f",  m_bearing1_distance);
         else
            temp.Format("%.0f",  m_bearing1_distance);
         m_CStr_bearing1Distance.Format("%-5.5s", temp);
         break;
   }

   switch   (m_long_bearing2_distance_valid)
   {
      case  0:    // Invalid
         bearing2Distance.SetForegroundColor(255, 0, 128);                             // Use normal color.
         m_CStr_bearing2Distance =  "----";
         break;

      case  1:    // No Computed Data
         bearing2Distance.SetForegroundColor(255, 0, 0);                               // Red
         m_CStr_bearing2Distance =  "----";
         break;

      case  2:    // Test
         break;

      case  3:    // Valid
         bearing2Distance.SetForegroundColor(255, 0, 128);                             // Use normal color.
         if (m_bearing2_distance <= 100.0f)
            temp.Format("%.1f",  m_bearing2_distance);
         else
            temp.Format("%.0f",  m_bearing2_distance);
         m_CStr_bearing2Distance.Format("%-5.5s", temp);
         break;
   }



   if (m_adiGauge != NULL)
   {
       // Don't care about the return value because it should be false since the ADI is not a valid window.
       m_adiGauge->UpdateRenderVariables();
   }

   return CWidget::UpdateRenderVariables();
}
