// AnnunciatorPanel.cpp: implementation of the CAnnunciatorPanel class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "AnnunciatorPanel.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAnnunciatorPanel::CAnnunciatorPanel()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Annunciator_Panel");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(208,96));

   m_listGraphicalElementVars.clear();

   m_listGraphicalElementVars.push_back("annunciator_bat_bus");
   m_listGraphicalElementVars.push_back("annunciator_canopy");
   m_listGraphicalElementVars.push_back("annunciator_ckpt_alt");
   m_listGraphicalElementVars.push_back("annunciator_fuel_bal");
   m_listGraphicalElementVars.push_back("annunciator_l_fuel_lo");
   m_listGraphicalElementVars.push_back("annunciator_trim_off");

   m_listGraphicalElementVars.push_back("annunciator_gen_bus");
   m_listGraphicalElementVars.push_back("annunciator_fuel_px");
   m_listGraphicalElementVars.push_back("annunciator_blank_1");
   m_listGraphicalElementVars.push_back("annunciator_pmu_status");
   m_listGraphicalElementVars.push_back("annunciator_r_fuel_lo");
   m_listGraphicalElementVars.push_back("annunciator_boost_pump");
 
   m_listGraphicalElementVars.push_back("annunciator_pmu_fail");
   m_listGraphicalElementVars.push_back("annunciator_oil_px");
   m_listGraphicalElementVars.push_back("annunciator_hydr_fl_lo");
   m_listGraphicalElementVars.push_back("annunciator_hydr_px_lo");
   m_listGraphicalElementVars.push_back("annunciator_duct_temp");
   m_listGraphicalElementVars.push_back("annunciator_anti_ice");
 
   m_listGraphicalElementVars.push_back("annunciator_gen");
   m_listGraphicalElementVars.push_back("annunciator_obogs_fail");
   m_listGraphicalElementVars.push_back("annunciator_oil_px_caution");
   m_listGraphicalElementVars.push_back("annunciator_tad_fail");
   m_listGraphicalElementVars.push_back("annunciator_ign_sel");
   m_listGraphicalElementVars.push_back("annunciator_tad_off");
   
   m_listGraphicalElementVars.push_back("annunciator_ckpt_px");
   m_listGraphicalElementVars.push_back("annunciator_chip");
   m_listGraphicalElementVars.push_back("annunciator_bus_tie");
   m_listGraphicalElementVars.push_back("annunciator_obogs_temp");
   m_listGraphicalElementVars.push_back("annunciator_m_fuel_bal");
   m_listGraphicalElementVars.push_back("annunciator_st_ready");

   m_list   =  -1;
}

CAnnunciatorPanel::~CAnnunciatorPanel()
{
}


void  CAnnunciatorPanel::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   const float    column[5]   =  
   {  
      -0.700f  /  m_aspect_ratio, 
      -0.350f  /  m_aspect_ratio, 
       0.000f  /  m_aspect_ratio,  
       0.350f  /  m_aspect_ratio,  
       0.700f  /  m_aspect_ratio   
   };
   const float    row[6]      =  
   {  
      (m_aspect_ratio   >= 1.0f) ?  ( 0.850f /  m_aspect_ratio)   :  ( 0.850f *  m_aspect_ratio *  2.0f),
      (m_aspect_ratio   >= 1.0f) ?  ( 0.510f /  m_aspect_ratio)   :  ( 0.510f *  m_aspect_ratio *  2.0f),
      (m_aspect_ratio   >= 1.0f) ?  ( 0.170f /  m_aspect_ratio)   :  ( 0.170f *  m_aspect_ratio *  2.0f),
      (m_aspect_ratio   >= 1.0f) ?  (-0.170f /  m_aspect_ratio)   :  (-0.170f *  m_aspect_ratio *  2.0f),
      (m_aspect_ratio   >= 1.0f) ?  (-0.510f /  m_aspect_ratio)   :  (-0.510f *  m_aspect_ratio *  2.0f),
      (m_aspect_ratio   >= 1.0f) ?  (-0.850f /  m_aspect_ratio)   :  (-0.850f *  m_aspect_ratio *  2.0f)
   };
   const float    font_size         =  0.6f  /  m_aspect_ratio;
   const float    font_weight       =  1.0f;
   CAnnunciator   *ptr;

   // First Column
   ptr   =  &annunciator_cv[BAT_BUS];
   ptr->Initialize();
   ptr->SetPosition(column[0],   row[0]);
   ptr->SetTitle("BAT BUS",      font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[CANOPY];
   ptr->Initialize();
   ptr->SetPosition(column[0],   row[1]);
   ptr->SetTitle("CANOPY",       font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[CKPT_ALT];
   ptr->Initialize();
   ptr->SetPosition(column[0],   row[2]);
   ptr->SetTitle("CKPT ALT",     font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);
   
   ptr   =  &annunciator_cv[FUEL_BAL];
   ptr->Initialize();
   ptr->SetPosition(column[0],   row[3]);
   ptr->SetTitle("FUEL BAL",     font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[L_FUEL_LO];
   ptr->Initialize();
   ptr->SetPosition(column[0],   row[4]);
   ptr->SetTitle("L FUEL LO",    font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[TRIM_OFF];
   ptr->Initialize();
   ptr->SetPosition(column[0],   row[5]);
   ptr->SetTitle("TRIM OFF",     font_size,  font_weight);
   ptr->SetTitleColor(0,   192,  0);   // Green
   ptr->SetCondition(false);


   // Next Column
   ptr   =  &annunciator_cv[GEN_BUS];
   ptr->Initialize();
   ptr->SetPosition(column[1],   row[0]);
   ptr->SetTitle("GEN BUS",      font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[FUEL_PX];
   ptr->Initialize();
   ptr->SetPosition(column[1],   row[1]);
   ptr->SetTitle("FUEL PX",      font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[BLANK_1];
   ptr->Initialize();
   ptr->SetPosition(column[1],   row[2]);
   ptr->SetTitle("-------",      font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);
   
   ptr   =  &annunciator_cv[PMU_STATUS];
   ptr->Initialize();
   ptr->SetPosition(column[1],   row[3]);
   ptr->SetTitle("PMU STATUS",   font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[R_FUEL_LO];
   ptr->Initialize();
   ptr->SetPosition(column[1],   row[4]);
   ptr->SetTitle("R FUEL LO",    font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[BOOST_PUMP];
   ptr->Initialize();
   ptr->SetPosition(column[1],   row[5]);
   ptr->SetTitle("BOOST PUMP",   font_size,  font_weight);
   ptr->SetTitleColor(0,   192,  0);   // Green
   ptr->SetCondition(false);


   // Next Column
   ptr   =  &annunciator_cv[PMU_FAIL];
   ptr->Initialize();
   ptr->SetPosition(column[2],   row[0]);
   ptr->SetTitle("PMU FAIL",     font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[OIL_PX];
   ptr->Initialize();
   ptr->SetPosition(column[2],   row[1]);
   ptr->SetTitle("OIL PX",       font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[HYDR_FL_LO];
   ptr->Initialize();
   ptr->SetPosition(column[2],   row[2]);
   ptr->SetTitle("HYDR FL LO",   font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);
   
   ptr   =  &annunciator_cv[HYDR_PX_LO];
   ptr->Initialize();
   ptr->SetPosition(column[2],   row[3]);
   ptr->SetTitle("EHYD PX LO",     font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[DUCT_TEMP];
   ptr->Initialize();
   ptr->SetPosition(column[2],   row[4]);
   ptr->SetTitle("DUCT TEMP",    font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[ANTI_ICE];
   ptr->Initialize();
   ptr->SetPosition(column[2],   row[5]);
   ptr->SetTitle("ANTI-ICE",     font_size,  font_weight);
   ptr->SetTitleColor(0,   192,  0);   // Green
   ptr->SetCondition(false);



   // Next Column
   ptr   =  &annunciator_cv[GEN];
   ptr->Initialize();
   ptr->SetPosition(column[3],   row[0]);
   ptr->SetTitle("GEN",          font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[OBOGS_FAIL];
   ptr->Initialize();
   ptr->SetPosition(column[3],   row[1]);
   ptr->SetTitle("OBOGS FAIL",   font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[OIL_PX_CAUTION];
   ptr->Initialize();
   ptr->SetPosition(column[3],   row[2]);
   ptr->SetTitle("OIL PX",       font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);
   
   ptr   =  &annunciator_cv[TAD_FAIL];
   ptr->Initialize();
   ptr->SetPosition(column[3],   row[3]);
   ptr->SetTitle("TAD FAIL",     font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[IGN_SEL];
   ptr->Initialize();
   ptr->SetPosition(column[3],   row[4]);
   ptr->SetTitle("IGN SEL",      font_size,  font_weight);
   ptr->SetTitleColor(0,   192,  0);   // Green
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[TAD_OFF];
   ptr->Initialize();
   ptr->SetPosition(column[3],   row[5]);
   ptr->SetTitle("TAD OFF",      font_size,  font_weight);
   ptr->SetTitleColor(0,   192,  0);   // Green
   ptr->SetCondition(false);
   

   // Next Column
   ptr   =  &annunciator_cv[CKPT_PX];
   ptr->Initialize();
   ptr->SetPosition(column[4],   row[0]);
   ptr->SetTitle("CKPT PX",      font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[CHIP];
   ptr->Initialize();
   ptr->SetPosition(column[4],   row[1]);
   ptr->SetTitle("CHIP",         font_size,  font_weight);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[BUS_TIE];
   ptr->Initialize();
   ptr->SetPosition(column[4],   row[2]);
   ptr->SetTitle("BUS TIE",      font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);
   
   ptr   =  &annunciator_cv[OBOGS_TEMP];
   ptr->Initialize();
   ptr->SetPosition(column[4],   row[3]);
   ptr->SetTitle("OBOGS TEMP",   font_size,  font_weight);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[M_FUEL_BAL];
   ptr->Initialize();
   ptr->SetPosition(column[4],   row[4]);
   ptr->SetTitle("M FUEL BAL",   font_size,  font_weight);
   ptr->SetTitleColor(0,   192,  0);   // Green
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[ST_READY];
   ptr->Initialize();
   ptr->SetPosition(column[4],   row[5]);
   ptr->SetTitle("ST READY",     font_size,  font_weight);
   ptr->SetTitleColor(0,   192,  0);   // Green
   ptr->SetCondition(false);


   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      CPanel::Draw();   // Draw the standard stuff, (bezel, screw heads, and primary title).
   }
   glEndList();
}


void  CAnnunciatorPanel::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      for (int ii = 0; ii < 30; ii++)
      {
         annunciator[ii].Draw();
      }
   }
   glPopMatrix();

   EndDraw();
}

CWidget* CAnnunciatorPanel::CreateObject()
{
   return new CAnnunciatorPanel();
}

void CAnnunciatorPanel::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar      == "annunciator_bat_bus")
      annunciator_cv[ 0].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_canopy")
      annunciator_cv[ 1].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_ckpt_alt")
      annunciator_cv[ 2].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_fuel_bal")
      annunciator_cv[ 3].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_l_fuel_lo")
      annunciator_cv[ 4].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_trim_off")
      annunciator_cv[ 5].SetCondition(*pVariant);

   else if (rstrElementVar == "annunciator_gen_bus")
      annunciator_cv[ 6].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_fuel_px")
      annunciator_cv[ 7].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_blank_1")
      annunciator_cv[ 8].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_pmu_status")
      annunciator_cv[ 9].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_r_fuel_lo")
      annunciator_cv[10].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_boost_pump")
      annunciator_cv[11].SetCondition(*pVariant);
 
   else if (rstrElementVar == "annunciator_pmu_fail")
      annunciator_cv[12].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_oil_px")
      annunciator_cv[13].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_hydr_fl_lo")
      annunciator_cv[14].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_hydr_px_lo")
      annunciator_cv[15].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_duct_temp")
      annunciator_cv[16].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_anti_ice")
      annunciator_cv[17].SetCondition(*pVariant);
 
   else if (rstrElementVar == "annunciator_gen")
      annunciator_cv[18].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_obogs_fail")
      annunciator_cv[19].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_oil_px_caution")
      annunciator_cv[20].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_tad_fail")
      annunciator_cv[21].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_ign_sel")
      annunciator_cv[22].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_tad_off")
      annunciator_cv[23].SetCondition(*pVariant);
   
   else if (rstrElementVar == "annunciator_ckpt_px")
      annunciator_cv[24].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_chip")
      annunciator_cv[25].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_bus_tie")
      annunciator_cv[26].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_obogs_temp")
      annunciator_cv[27].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_m_fuel_bal")
      annunciator_cv[28].SetCondition(*pVariant);
   else if (rstrElementVar == "annunciator_st_ready")
      annunciator_cv[29].SetCondition(*pVariant);

}

/////////////////////////////////////////////////////////////////////////////
//
// bool CAnnunciatorPanel::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 24 June 1999
//
// Engineer         : Charles Brissey
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CAnnunciatorPanel::UpdateRenderVariables()
{
   for (int ii = 0; ii < 30; ii++)
      annunciator[ii] =  annunciator_cv[ii];

   return CWidget::UpdateRenderVariables();
}
