// Annunciator.h: interface for the CAnnunciator class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ANNUNCIATOR_H__E02411D8_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_ANNUNCIATOR_H__E02411D8_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <afxtempl.h>
#include <gl\gl.h>              // OpenGL
#include <gl\glu.h>             // GLU library
#include "..\core\OpenGLtext.h"

#define  glRGB(x, y, z) glColor3ub((GLubyte)x, (GLubyte)y, (GLubyte)z)

class CAnnunciator  
{
public:
	CAnnunciator();
	virtual ~CAnnunciator();

   virtual  void  Initialize();
   virtual  void  Draw(void);

   void  SetTitleColor(int red, int green, int blue);
   void  SetTitle(CString title, float size, float weight, float rotation = 0.0f);
   void  SetPosition(float x_position, float y_position);
   void  SetCondition(bool on);

   CString  m_title;
   float    m_title_size;
   float    m_title_weight;
   float    m_title_rotation;

   int   m_red;
   int   m_green;
   int   m_blue;

   float m_x_position;
   float m_y_position;

   bool  m_last_known_condition;

   COpenGLtext title;
};

#endif // !defined(AFX_ANNUNCIATOR_H__E02411D8_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
