// Annunciator.cpp: implementation of the CAnnunciator class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "Annunciator.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAnnunciator::CAnnunciator()
{
}

CAnnunciator::~CAnnunciator()
{
}

void  CAnnunciator::Initialize()
{
   m_x_position            =  0.0f;
   m_y_position            =  0.0f;
   m_last_known_condition  =  true;    // Assume it's on, so initial colors will be set correctly.

   title.SetBackgroundColor(false, 0,  0,  0);
}

void  CAnnunciator::SetTitle(CString title, float size, float weight, float rotation)
{
   m_title              =  title;
   m_title_size         =  size;
   m_title_weight       =  weight;
   m_title_rotation     =  rotation;
}

void  CAnnunciator::SetTitleColor(int red, int green, int blue)
{
   m_red    =  red;
   m_green  =  green;
   m_blue   =  blue;
}

void  CAnnunciator::SetPosition(float x_position, float y_position)
{
   m_x_position   =  x_position;
   m_y_position   =  y_position;
}


void  CAnnunciator::Draw()
{
   // Draw title.
   glPushMatrix();
   {
      glTranslatef(m_x_position, m_y_position, 0.0f);

      title.SetForegroundColor(m_red, m_green, m_blue);
      title.Draw(m_title, true, m_title_rotation, m_title_size, m_title_weight);
   }
   glPopMatrix();
}


void  CAnnunciator::SetCondition(bool condition)
{
////////////////////////////
//   condition   =  true;    ////////////////////////////
////////////////////////////
   if (m_last_known_condition != condition)
   {
      if (condition)
      {
         m_red    *= 8;
         m_green  *= 8;
         m_blue   *= 8;
      }
      else
      {
         m_red    /= 8;
         m_green  /= 8;
         m_blue   /= 8;
      }
      m_last_known_condition  =  condition;
   }
}