// AngleOfAttackPanel.cpp: implementation of the CAngleOfAttackPanel class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "AngleOfAttackPanel.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAngleOfAttackPanel::CAngleOfAttackPanel()
{
   m_stlStrWidgetName   =  _FSI_STL::string("AoA_Panel");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(32,96));

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("aoa_indexer");

   m_list   =  -1;
}

CAngleOfAttackPanel::~CAngleOfAttackPanel()
{
}

void  CAngleOfAttackPanel::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   const float    column            =  0.0f;
   const float    row[3]            =  {  0.5f  *  m_aspect_ratio,  0.000f  *  m_aspect_ratio,  -0.5f  *  m_aspect_ratio   };
   const float    font_size         =  7.5f  *  m_aspect_ratio;
   const float    font_weight       =  1.0f;
   CAnnunciator   *ptr;

   // First Column
   ptr   =  &annunciator_cv[0];
   ptr->Initialize();
   ptr->SetPosition(column,   row[0]);
   ptr->SetTitle("V",   font_size,  font_weight,   0.0f);
   ptr->SetTitleColor(0,   192,  0);   // Green
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[1];
   ptr->Initialize();
   ptr->SetPosition(column,   row[1]);
   ptr->SetTitle("O",   font_size,  font_weight,   90.0f);
   ptr->SetTitleColor(192, 192,  0);   // Amber
   ptr->SetCondition(false);

   ptr   =  &annunciator_cv[2];
   ptr->Initialize();
   ptr->SetPosition(column,   row[2]);
   ptr->SetTitle("V",   font_size,  font_weight,   180.0f);
   ptr->SetTitleColor(255, 0, 0);      // Red
   ptr->SetCondition(false);

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      CPanel::Draw();   // Draw the standard stuff, (bezel, screw heads, and primary title).
   }
   glEndList();
}


void  CAngleOfAttackPanel::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      for (int ii = 0; ii < 3; ii++)
      {
         annunciator[ii].Draw();
      }
   }
   glPopMatrix();

   EndDraw();
}

CWidget* CAngleOfAttackPanel::CreateObject()
{
   return new CAngleOfAttackPanel();
}

void CAngleOfAttackPanel::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "aoa_indexer")
   {
      switch ((long)(*pVariant))
      {
         case  0:    // Blank requested...
            annunciator_cv[0].SetCondition(false);    // Green chevron
            annunciator_cv[1].SetCondition(false);    // Amber chevron
            annunciator_cv[2].SetCondition(false);    // Red   chevron
            break;

         case  1:    // Red requested...
            annunciator_cv[0].SetCondition(false);    // Green chevron
            annunciator_cv[1].SetCondition(false);    // Amber chevron
            annunciator_cv[2].SetCondition(true);     // Red   chevron
            break;

         case  2:    // Amber requested...
            annunciator_cv[0].SetCondition(false);    // Green chevron
            annunciator_cv[1].SetCondition(true);     // Amber chevron
            annunciator_cv[2].SetCondition(false);    // Red   chevron
            break;

         case  3:    // Amber and Red requested...
            annunciator_cv[0].SetCondition(false);    // Green chevron
            annunciator_cv[1].SetCondition(true);     // Amber chevron
            annunciator_cv[2].SetCondition(true);     // Red   chevron
            break;

         case  4:    // Green requested...
            annunciator_cv[0].SetCondition(true);     // Green chevron
            annunciator_cv[1].SetCondition(false);    // Amber chevron
            annunciator_cv[2].SetCondition(false);    // Red   chevron
            break;

         case  5:    // Blank requested...
            annunciator_cv[0].SetCondition(false);    // Green chevron
            annunciator_cv[1].SetCondition(false);    // Amber chevron
            annunciator_cv[2].SetCondition(false);    // Red   chevron
            break;

         case  6:    // Amber and Green requested...
            annunciator_cv[0].SetCondition(true);     // Green chevron
            annunciator_cv[1].SetCondition(true);     // Amber chevron
            annunciator_cv[2].SetCondition(false);    // Red   chevron
            break;

         case  7:    // Amber, Green and Red requested... (Test mode)
            annunciator_cv[0].SetCondition(true);     // Green chevron
            annunciator_cv[1].SetCondition(true);     // Amber chevron
            annunciator_cv[2].SetCondition(true);     // Red   chevron
            break;
      }
   }

}

/////////////////////////////////////////////////////////////////////////////
//
// bool CAngleOfAttackPanel::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 24 June 1999
//
// Engineer         : Charles Brissey
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CAngleOfAttackPanel::UpdateRenderVariables()
{
   for (int ii = 0; ii < 3; ii++)
      annunciator[ii]   =  annunciator_cv[ii];

   return CWidget::UpdateRenderVariables();
}
