// AngleOfAttackGauge.cpp: implementation of the CAngleOfAttackGauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "AngleOfAttackGauge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAngleOfAttackGauge::CAngleOfAttackGauge()
{
   m_stlStrWidgetName   =  _FSI_STL::string("AoA_Gauge");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(200,200));

   m_aoa_angle          =  216.0f;
   m_aoa_angle          =  m_aoa_angle;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Angle of Attack");

   m_list   =  -1;
}

CAngleOfAttackGauge::~CAngleOfAttackGauge()
{
}

void  CAngleOfAttackGauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());


   theTicks.Initialize();
   theTicks.SetLabelRadius(0.57f);
   theTicks.SetOuterRadius(0.84f);
   theTicks.SetLabelProperties(2.0f, 1.25f);
   theTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   tick_info.location   =  0.0;
   tick_info.type       =  NO_TICK;
   strcpy(tick_info.ident, "18");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  12.0;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  24.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  36.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "15");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  48.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  60.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  72.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "12");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  84.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  96.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  108.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "9");
   theTicks.TickList.AddTail(tick_info);
   
//   tick_info.location   =  120.0f;
//   tick_info.type       =  MINOR;
//   strcpy(tick_info.ident, "");
//   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  132.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  144.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "6");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  156.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  168.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  180.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "3");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  192.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  204.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  216.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "0");
   theTicks.TickList.AddTail(tick_info);

   theTicks.GenerateLists();


   theRedTicks.Initialize();
   theRedTicks.SetLabelRadius(0.57f);
   theRedTicks.SetOuterRadius(0.84f);
   theRedTicks.SetLabelProperties(2.0f, 3.25f);
   theRedTicks.SetTickColor(255, 0, 0);

   tick_info.location   =  0.0;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theRedTicks.TickList.AddTail(tick_info);

   theRedTicks.GenerateLists();


   theGreenTicks.Initialize();
   theGreenTicks.SetLabelRadius(0.57f);
   theGreenTicks.SetOuterRadius(0.82f);
   theGreenTicks.SetLabelProperties(2.0f, 3.25f);
   theGreenTicks.SetTickColor(0, 192, 0);

   tick_info.location   =  90.0;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theGreenTicks.TickList.AddTail(tick_info);

   theGreenTicks.GenerateLists();


   m_primary_title.Format("AOA");
   m_diamond.Format("%c", DIAMOND);
   m_triangle.Format("%c", DELTA);
   m_aoaNeedle.Format("%c", AOA_NEEDLE);


   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      // Draw the standard stuff, (bezel, screw heads, and primary title).
      CPanel::Draw();

      // Draw tick marks and labels.
      theTicks.Draw();
      theRedTicks.Draw();
      theGreenTicks.Draw();
      theGreenTicks.DrawArc(false, 85.0f, 95.0f, 3.25f);
 
      glTranslatef(-0.5f, 0.0f, 0.0f);
      primary_title.Draw(m_primary_title,   true, 0.0f, 2.5f, 1.0f);
      glTranslatef(0.5f, 0.0f, 0.0f);

      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glPushMatrix();
            glRotatef(-(216.0f   -  (216.0f/18.0f  *  8.8f)), 0.0f, 0.0f, 1.0f);
            glTranslatef(0.0f, 0.78f, 0.0f);
            glScalef(1.25f, 2.0f, 1.0f);
            diamond.Draw(m_diamond, true, 0.0f, 1.35f);
         glPopMatrix();

         glPushMatrix();
            glRotatef(-(216.0f   -  (216.0f/18.0f  *  4.9f)), 0.0f, 0.0f, 1.0f);
            glTranslatef(0.0f, 0.80f, 0.0f);
            glScalef(2.25f, 1.25f, 1.0f);
            triangle.Draw(m_triangle, true, 180.0f, 1.35f);
         glPopMatrix();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glEndList();
}

void  CAngleOfAttackGauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      glPushMatrix();
         glRotatef(-m_aoa_angle, 0.0f, 0.0f, 1.0f);
         aoaNeedle.Draw(m_aoaNeedle,  true, 0.0f, 25.0f, 1.0f);
      glPopMatrix();
   }
   glPopMatrix();

   EndDraw();
}

void  CAngleOfAttackGauge::SetAngleOfAttack(float aoa)
{
   if (aoa  >  0.0f)
      m_aoa_angle_cv =  216.0f   -  (216.0f/18.0f  *  aoa);
   else
      m_aoa_angle_cv =  216.0f;
}

CWidget* CAngleOfAttackGauge::CreateObject()
{
   return new CAngleOfAttackGauge();
}

void CAngleOfAttackGauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Angle of Attack")
   {
      SetAngleOfAttack(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CAngleOfAttackGauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CAngleOfAttackGauge::UpdateRenderVariables()
{
   m_aoa_angle =  m_aoa_angle_cv;

   return CWidget::UpdateRenderVariables();
}
