// AltitudeGauge.h: interface for the CAltitudeGauge class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ALTITUDEGAUGE_H__A5E243C1_682A_11D2_AD4C_006008B0E0C3__INCLUDED_)
#define AFX_ALTITUDEGAUGE_H__A5E243C1_682A_11D2_AD4C_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"

class CAltitudeGauge : public COpenGLWidget, public CPanel
{
public:
	CAltitudeGauge();
	virtual ~CAltitudeGauge();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();

   void  SetAltitude(float altitude);
   void  SetBarometer(float barometric_pressure);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

protected:
   CString     m_hundreds;
   CString     m_millibars;
   CString     m_hg_inches;
   float       m_altitude_needle_angle;

   CString     m_hundreds_cv;
   CString     m_millibars_cv;
   CString     m_hg_inches_cv;
   float       m_altitude_needle_angle_cv;

   float       m_hundreds_angle;
   float       m_hundreds_angle_cv;
   float       m_thousands_angle;
   float       m_thousands_angle_cv;
   float       m_ten_thousands_angle;
   float       m_ten_thousands_angle_cv;

   COpenGLtext double_zero_value;
   CString     m_double_zero;

   COpenGLtext comma_value;
   CString     m_comma;

   COpenGLtext hundreds_value;
   COpenGLtext millibar_title;
   COpenGLtext millibar_value;
   COpenGLtext mercury_title;
   COpenGLtext mercury_value;
   COpenGLtext altitude_needle;
   CTicks      theTicks;
   COpenGLtext title;
   CString     m_title;
   CString     millibar;
   CString     in_hg;
   CString     altimeter_needle;

   float       m_hg_inches_value;
   float       m_hg_inches_value_cv;

   int         hundreds_wheel_list;
   int         thousands_wheel_list;
   int         ten_thousands_wheel_list;

   float       m_uncorrected_altitude;
   float       m_uncorrected_altitude_cv;

   bool        m_bool_Power;
   bool        m_bool_Power_cv;

// Attributes
public:
  	enum { IDB = IDB_ALTITUDE  };
};

#endif // !defined(AFX_ALTITUDEGAUGE_H__A5E243C1_682A_11D2_AD4C_006008B0E0C3__INCLUDED_)
