// cpp: implementation of the CAltitudeGauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "AltitudeGauge.h"
#include "math.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAltitudeGauge::CAltitudeGauge()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Altitude");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(200,200));

   m_hundreds.Format("%03d", 0);
   m_altitude_needle_angle       =  0.0f;
   m_hg_inches.Format("%2.2f", 0.0f);
   m_millibars.Format("%4.0f", (0.0f *  33.864f));

   m_hundreds_cv                 =  m_hundreds;
   m_altitude_needle_angle_cv    =  m_altitude_needle_angle;
   m_hg_inches_cv                =  m_hg_inches;
   m_millibars_cv                =  m_millibars;

   m_uncorrected_altitude        =  0.0f;
   m_uncorrected_altitude_cv     =  m_uncorrected_altitude;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Altitude");
   m_listGraphicalElementVars.push_back("barometric_pressure");
   m_listGraphicalElementVars.push_back("Power");

   m_list                        =  -1;
   hundreds_wheel_list           =  -1;
   thousands_wheel_list          =  -1;
   ten_thousands_wheel_list      =  -1;
   m_bool_Power                  = true;
   m_bool_Power_cv               = true;
}

CAltitudeGauge::~CAltitudeGauge()
{
}

void  CAltitudeGauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   millibar.Format("MB");
   in_hg.Format("IN HG");
   altimeter_needle.Format("%c", ALTIMETER_NEEDLE);

   theTicks.Initialize();
   theTicks.SetLabelRadius(0.60f);
   theTicks.SetOuterRadius(0.84f);
   theTicks.SetLabelProperties(2.0f, 1.25f);
   theTicks.SetTickColor(255, 255, 255);

   m_title.Format("ALT");

   TICK_INFO   tick_info;

   tick_info.location   =  0.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "0");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  7.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  14.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  21.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  28.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  36.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "1");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  43.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  50.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  57.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  64.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  72.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "2");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  79.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  86.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  93.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  100.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  108.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "3");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  115.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  122.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  129.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  136.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  144.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "4");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  151.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  158.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  165.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  172.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  180.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "5");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  187.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  194.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  201.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  208.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  216.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "6");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  223.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  230.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  237.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  244.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  252.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "7");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  259.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  266.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  273.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  280.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  288.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "8");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  295.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  302.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  309.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  316.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  324.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "9");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  331.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  338.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  345.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  352.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   theTicks.GenerateLists();

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      // Draw the standard stuff, (bezel, screw heads, and primary title).
      CPanel::Draw();

      title.Draw(m_title, true, 0.0f, 2.0);

      // Draw tick marks and labels.
      theTicks.DrawTickMarks();
      theTicks.DrawTickLabels();

      // Draw a box around the altitude display value.
      glLineWidth(2.0f);                                                // Apply the line width factor.
      glBegin(GL_QUADS);
         glVertex2f(-0.45f,  0.35f);
         glVertex2f( 0.45f,  0.35f);
         glVertex2f( 0.45f,  0.10f);
         glVertex2f(-0.45f,  0.10f);
      glEnd();
      glLineWidth(1.0f);                                                // Apply the line width factor.

      glPushMatrix();
         m_double_zero.Format("00");
         glTranslatef( 0.300f, 0.225f, 0.0f);
         double_zero_value.Draw(m_double_zero,  true, 0.0f, 2.75f, 1.0f);
      glPopMatrix();

      glPushMatrix();
         m_comma.Format(",");
         glTranslatef( 0.0f, 0.225f, 0.0f);
         comma_value.Draw(m_comma,  true, 0.0f, 2.75f, 1.0f);
      glPopMatrix();

 
      glBegin(GL_QUADS);
         // Draw a box around the Millibar display value.
         glVertex2f(-0.45f, -0.225f);
         glVertex2f(-0.05f, -0.225f);
         glVertex2f(-0.05f, -0.35f);
         glVertex2f(-0.45f, -0.35f);

         // Draw a box around the Inches of Mercury display value.
         glVertex2f( 0.45f, -0.225f);
         glVertex2f( 0.05f, -0.225f);
         glVertex2f( 0.05f, -0.35f);
         glVertex2f( 0.45f, -0.35f);
      glEnd();

      glPushMatrix();
         // Draw the millibar display value title.
         glPushMatrix();
            glTranslatef(-0.25f, -0.175f, 0.0f);
            millibar_title.Draw(millibar, true, 0.0f, 1.35f, 1.0f);
         glPopMatrix();

         // Draw the inches of mercury display value title
         glPushMatrix();
            glTranslatef( 0.25f, -0.175f, 0.0f);
            mercury_title.Draw(in_hg,     true, 0.0f, 1.35f, 1.0f);
         glPopMatrix();
      glPopMatrix();

   }
   glEndList();

   if (hundreds_wheel_list != -1)
      glDeleteLists(hundreds_wheel_list, 1);

   hundreds_wheel_list = glGenLists(1);
   glNewList(hundreds_wheel_list, GL_COMPILE);
   {
      glPushMatrix();
      glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
      for (int ii = 0; ii < 10; ii++)
      {
         glPushMatrix();
         {
            glRotatef(ii * 36.0f, 0.0f, 0.0f, 1.0f);     // Rotate ClockWise.
            glTranslatef(0.35f, 0.0f, 0.0f);
            CString  value;
            value.Format("%d", ii);
            glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            hundreds_value.Draw(value, true, 0.0f, 2.75f);
         }
         glPopMatrix();
      }
      glPopMatrix();
   }
   glEndList();


   if (thousands_wheel_list   != -1)
      glDeleteLists(thousands_wheel_list, 1);

   thousands_wheel_list = glGenLists(1);
   glNewList(thousands_wheel_list, GL_COMPILE);
   {
      glPushMatrix();
      glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
      for (int ii = 0; ii < 10; ii++)
      {
         glPushMatrix();
         {
            glRotatef(ii * 36.0f, 0.0f, 0.0f, 1.0f);     // Rotate ClockWise.
            glTranslatef(0.35f, 0.0f, 0.0f);
            CString  value;
            value.Format("%d", ii);
            glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            hundreds_value.Draw(value, true, 0.0f, 3.8f);
         }
         glPopMatrix();
      }
      glPopMatrix();
   }
   glEndList();


   if (ten_thousands_wheel_list  != -1)
      glDeleteLists(ten_thousands_wheel_list, 1);

   ten_thousands_wheel_list = glGenLists(1);
   glNewList(ten_thousands_wheel_list, GL_COMPILE);
   {
      glPushMatrix();
      glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
      for (int ii = 0; ii < 10; ii++)
      {
         glPushMatrix();
         {
            glRotatef(ii * 36.0f, 0.0f, 0.0f, 1.0f);     // Rotate ClockWise.
            glTranslatef(0.35f, 0.0f, 0.0f);
            CString  value;
            if (ii == 0)
               value.Format("%c", SLASH_OUT);
            else if (ii == 9)
               value.Format("%c", NEG);
            else
               value.Format("%d", ii);
            glRotatef(90.0f, 0.0f, 1.0f, 0.0f);
            hundreds_value.Draw(value, true, 0.0f, 3.8f);
         }
         glPopMatrix();
      }
      glPopMatrix();
   }
   glEndList();
}

void  CAltitudeGauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      // Update the hundreds, thousands and ten-thousands portion of the altitude display value.
      glPushMatrix();
         glScissor(rectViewCoord.left + (int)(0.29f * m_width)+1, 
                   rectView.Height() - rectViewCoord.bottom + (int)(0.565f * m_height), 
                   (int)(0.3025f * m_width), (int)(0.10f * m_height));

/*
         glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
            glRGB(64, 144, 255);       // Sky blue.
            glBegin(GL_POLYGON);
               glVertex2f(-1.0f,  1.0f);
               glVertex2f( 1.0f,  1.0f);
               glVertex2f( 1.0f, -1.0f);
               glVertex2f(-1.0f, -1.0f);
            glEnd();
         glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
*/
         // Hundreds place...
         glPushMatrix();
            glTranslatef( 0.10f, 0.225f, 0.0f);
            glRotatef(m_hundreds_angle, 1.0f, 0.0f, 0.0f);
            glCallList(hundreds_wheel_list);
         glPopMatrix();

         // Thousands place...
         glPushMatrix();
            glTranslatef(-0.125f, 0.225f, 0.0f);
            glRotatef(m_thousands_angle, 1.0f, 0.0f, 0.0f);
            glCallList(thousands_wheel_list);
         glPopMatrix();

         // Ten-thousands place...
         glPushMatrix();
            glTranslatef(-0.31f, 0.225f, 0.0f);
            glRotatef(m_ten_thousands_angle, 1.0f, 0.0f, 0.0f);
            glCallList(ten_thousands_wheel_list);
         glPopMatrix();

         glScissor(rectViewCoord.left, rectView.Height() - rectViewCoord.bottom, (int)m_width, (int)m_height);
      glPopMatrix();


      // Update the millibar display value.
      glPushMatrix();
         glTranslatef(-0.25f, -0.285f, 0.0f);
         millibar_value.Draw(m_millibars, true, 0.0f, 1.45f, 1.0f);
      glPopMatrix();

      // Update the inches of mercury display value.
      glPushMatrix();
         glTranslatef( 0.25f, -0.285f, 0.0f);
         mercury_value.Draw(m_hg_inches,  true, 0.0f, 1.45f, 1.0f);
      glPopMatrix();


      // Draw the updated the needle position.
      glPushMatrix();
         glRotatef(-m_altitude_needle_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef( 0.0f, 0.5f, 0.0f);
         altitude_needle.Draw(altimeter_needle,  true, 0.0f, 17.5f, 1.0f);
      glPopMatrix();
   }
   glPopMatrix();


   if (!m_bool_Power)
   {
      glColor4ub(255, 255, 255, 64);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_QUADS);
            glVertex2f(-1.0f, 1.0f);
            glVertex2f( 1.0f, 1.0f);
            glVertex2f( 1.0f, -1.0f);
            glVertex2f(-1.0f, -1.0f);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }

   EndDraw();
}


void  CAltitudeGauge::SetAltitude(float uncorrected_altitude)
{
/* Host will now send a corrected altitude so don't need to correct it here.
   const float gravitational_acceleration =  32.1740856f;
   const float pressure_at_mean_sea_level =  29.92126f;
   const float universal_gas_constant     =  3089.6728f;
   const float temperature_lapse_rate     =  0.0019812f;
   const float absolute_temp_at_msl       =  288.16f;

   const float temperature_ratio =  absolute_temp_at_msl    /  temperature_lapse_rate;
   const float exponent          =  temperature_lapse_rate  *  universal_gas_constant  /  gravitational_acceleration;

   float pressure_ratio    =  m_hg_inches_value    /  pressure_at_mean_sea_level;
   float correction        =  temperature_ratio    *  (1.0f -  pow(pressure_ratio,  exponent));
   float altitude          =  uncorrected_altitude -  correction;
*/
   float altitude          =  uncorrected_altitude;


   int   ten_thousands  =  (int)(altitude /  10000.0f);
   int   thousands      =  (int)(altitude /  1000.0f);
   int   hundreds       =  (int)(altitude -  (thousands  *  1000.0f));

   m_hundreds_angle_cv  =  ((float)hundreds  /  100.0f)  *  36.0f;

   if (altitude   >= 0.0f)
   {
      if (hundreds   >  900)
         m_thousands_angle_cv       =  ((float)thousands       +  1.0f) *  36.0f +  m_hundreds_angle_cv;
      else
         m_thousands_angle_cv       =  ((float)thousands)      *  36.0f;

      if (hundreds   >  900         && thousands   %  10 == 9)
         m_ten_thousands_angle_cv   =  ((float)ten_thousands   +  1.0f) *  36.0f +  m_hundreds_angle_cv;
      else
         m_ten_thousands_angle_cv   =  ((float)ten_thousands)  *  36.0f;
   }
   else
   {
      int   value =  (int)(10.0f    +  (altitude   /  1000.0f));

      if (hundreds   >= -100  && hundreds <  0)
         m_thousands_angle_cv       =  ((float)value  -  9.0f)    *  36.0f +  m_hundreds_angle_cv;
      else
         m_thousands_angle_cv       =  ((float)value  -  10.0f)   *  36.0f;
      
      if (hundreds   >= -100    && hundreds <  0   && value == 9)
         m_ten_thousands_angle_cv   =  ((float)ten_thousands   +  0.0f) *  36.0f +  m_hundreds_angle_cv;
      else
         m_ten_thousands_angle_cv   =  9.0f  *  36.0f;
   }

   m_altitude_needle_angle_cv    =  ((float)hundreds  /  1000.0f) *  360.0f;
}


void  CAltitudeGauge::SetBarometer(float barometric_pressure)
{
//   m_hg_inches_value_cv =  barometric_pressure;

   m_hg_inches_cv.Format("%2.2f", barometric_pressure);
   m_millibars_cv.Format("%4.0f", (barometric_pressure *  33.864f));
}

CWidget* CAltitudeGauge::CreateObject()
{
   return new CAltitudeGauge();
}

void CAltitudeGauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar            == "Altitude")
   {
      m_uncorrected_altitude_cv  =  *pVariant;
   }
   else if (rstrElementVar       == "barometric_pressure")
   {
      m_hg_inches_value_cv       =  *pVariant;
   }
   else if (rstrElementVar       == "Power")
   {
      m_bool_Power_cv            =  *pVariant;
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CAltitudeGauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CAltitudeGauge::UpdateRenderVariables()
{
   // Determine the rate at which this function is getting called.
   LARGE_INTEGER  theFrequency;
   QueryPerformanceFrequency(&theFrequency);
   static   LARGE_INTEGER  theStartCount;
   static   bool  one_time_only  =  true;
   LARGE_INTEGER  theEndCount, diffCount;
   float    iteration_rate;

   if (one_time_only)
   {
      QueryPerformanceCounter(&theStartCount);
      one_time_only  =  false;
   }
   
   QueryPerformanceCounter(&theEndCount);
   diffCount.QuadPart   =  theEndCount.QuadPart -  theStartCount.QuadPart;
   iteration_rate       =  (float)((float)diffCount.QuadPart /  (float)theFrequency.QuadPart);
   QueryPerformanceCounter(&theStartCount);

   m_hundreds              =  m_hundreds_cv;
   m_altitude_needle_angle =  m_altitude_needle_angle_cv;
   m_hg_inches             =  m_hg_inches_cv;
   m_millibars             =  m_millibars_cv;

   m_hundreds_angle        =  m_hundreds_angle_cv;
   m_thousands_angle       =  m_thousands_angle_cv;
   m_ten_thousands_angle   =  m_ten_thousands_angle_cv;


   static   float lpv_output  =  0.0f;
   if (iteration_rate   >= 1.0f)    // If for some reason we haven't been called for more than a second, just snap to desired value.
   {
      m_uncorrected_altitude  =  m_uncorrected_altitude_cv;
      SetAltitude(m_uncorrected_altitude);

      m_hg_inches_value       =  m_hg_inches_value_cv;
      SetBarometer(m_hg_inches_value);

      lpv_output              =  m_uncorrected_altitude_cv;
   }
   else
   {
      float slew_limit_per_iteration   =  320.0f   *  iteration_rate;
      float fraction                   =  m_uncorrected_altitude_cv  *  iteration_rate;
      float calculated_filter_output   =  lpv_output  *  (1.0f -  iteration_rate)  +  fraction;

      if (calculated_filter_output  -  lpv_output  >  slew_limit_per_iteration)  
         lpv_output  += slew_limit_per_iteration;
      else if (lpv_output  -  calculated_filter_output   >  slew_limit_per_iteration)  
         lpv_output  -= slew_limit_per_iteration;
      else
         lpv_output  =  calculated_filter_output;

      m_uncorrected_altitude  =  lpv_output;
      SetAltitude(m_uncorrected_altitude);

      m_hg_inches_value       =  m_hg_inches_value_cv;
      SetBarometer(m_hg_inches_value);
   }

   m_bool_Power   =  m_bool_Power_cv;

   return CWidget::UpdateRenderVariables();
}
