// AirspeedGauge.cpp: implementation of the CAirspeedGauge class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "AirspeedGauge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAirspeedGauge::CAirspeedGauge()
{
   m_stlStrWidgetName   =  _FSI_STL::string("Airspeed");
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(200,200));

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Mach");
   m_listGraphicalElementVars.push_back("IAS");
   m_listGraphicalElementVars.push_back("Max Allowable Airspeed");
   m_listGraphicalElementVars.push_back("Power");

   m_list            =  -1;
   m_bool_Power      = true;
   m_bool_Power_cv   = true;
}

CAirspeedGauge::~CAirspeedGauge()
{
}

void  CAirspeedGauge::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   theTicks.Initialize();
//   theTicks.SetLabelRadius(0.57f);
   theTicks.SetLabelRadius(0.65f);
   theTicks.SetOuterRadius(0.84f);
//   theTicks.SetLabelProperties(1.3f, 1.0f);
   theTicks.SetLabelProperties(1.625f, 1.0f);
//   theTicks.SetTickLengths(0.10f, 0.075f, 0.05f);
   theTicks.SetTickLengths(0.08f, 0.065f, 0.05f);
   theTicks.SetTickColor(255, 255, 255);

   TICK_INFO   tick_info;

   tick_info.location   =  27.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "40");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  32.2f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  37.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  42.7f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  47.9f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "60");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  53.2f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  58.4f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  63.6f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  68.9f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "80");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  74.1f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  79.3f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  84.6f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  89.8f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "100");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  95.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  100.3f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  105.5f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  110.7f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "120");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  116.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  121.2f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  126.4f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  131.6f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "140");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  136.9f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  142.1f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  147.3f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  152.6f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "160");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  157.8f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  163.0f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  168.3f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  173.5f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "180");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  178.7f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  184.0f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  189.2f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  194.4f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "200");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  199.7f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  204.9f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  210.1f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  215.4f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "220");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  220.6f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  225.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  231.1f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  236.3f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "240");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  241.5f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  246.8f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  252.0f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  257.2f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "260");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  262.5f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  267.7f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  272.9f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  278.1f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "280");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  283.4f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  288.6f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  293.8f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  299.1f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "300");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  304.3f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  309.5f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  314.8f;
   tick_info.type       =  MINOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  320.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "320");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  325.0f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  330.0f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  335.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   
   tick_info.location   =  340.0f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "350");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  345.0f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  350.0f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);

   tick_info.location   =  355.0f;
   tick_info.type       =  INTERMEDIATE;
   strcpy(tick_info.ident, "");
   theTicks.TickList.AddTail(tick_info);


   tick_info.location   =  360.0f;
   tick_info.type       =  MAJOR;
   strcpy(tick_info.ident, "400");
   theTicks.TickList.AddTail(tick_info);

   theTicks.GenerateLists();


   // Setup the Red portion of the ticks.  (Indicates overspeed.)
   theRedTicks.Initialize();
   theRedTicks.SetLabelRadius(0.65f);
   theRedTicks.SetOuterRadius(0.84f);
   theRedTicks.SetLabelProperties(1.3f, 1.0f);
   theRedTicks.SetTickColor(255, 0, 0);

   theRedTicks.GenerateLists();


   m_knotsLabel.Format("KNOTS");
   m_machLabel.Format("MACH\n \n.     ");
   m_machValue.Format("%2.0f", 0.543  *  100.0f);
   m_iasNeedle.Format("%c", IAS_POINTER);
   m_max_allowable_airspeedNeedle.Format("%c", BARBER_POINTER);

   if (m_list != -1)
   {
       glDeleteLists(m_list, 1);
   }

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff.
         CPanel::Draw();

         glPushMatrix();
            glTranslatef(0.0f, -0.3f, 0.0f);
            knotsLabel.Draw(m_knotsLabel,   true, 0.0f, 2.0f, 1.0f);
         glPopMatrix();

         glPushMatrix();
            glTranslatef(0.0f, 0.45f, 0.0f);
            machLabel.Draw(m_machLabel, true, 0.0f, 1.6f, 1.0f);
         glPopMatrix();
      }
      glPopMatrix();
   }
   glEndList();
}

void  CAirspeedGauge::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      if (m_ias_angle > m_max_allowable_airspeed_angle)
      {
         theRedTicks.DrawArc(false, m_max_allowable_airspeed_angle - 1.79f, m_ias_angle + 1.79f, 5.0f);
         iasNeedle.SetForegroundColor(255, 0, 0);
      }
      else
         iasNeedle.SetForegroundColor(255, 255, 255);

      // Draw tick marks and labels.
      theTicks.Draw();

      glPushMatrix();
         glTranslatef(0.0f, 0.265f, 0.0f);
         machValue.Draw(m_machValue, true, 0.0f, 1.8f, 1.0f, true);
      glPopMatrix();

      glPushMatrix();
         glRotatef(-m_ias_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.45f, 0.0f);
         iasNeedle.Draw(m_iasNeedle, true, 0.0f, 8.0f);
      glPopMatrix();

      glPushMatrix();
         glRotatef(-m_max_allowable_airspeed_angle, 0.0f, 0.0f, 1.0f);
         glTranslatef(0.0f, 0.45f, 0.0f);
         max_allowable_airspeedNeedle.Draw(m_max_allowable_airspeedNeedle, true, 0.0f, 8.0f);
      glPopMatrix();
   }
   glPopMatrix();

   if (!m_bool_Power)
   {
      glColor4ub(255, 255, 255, 64);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         glBegin(GL_QUADS);
            glVertex2f(-1.0f, 1.0f);
            glVertex2f( 1.0f, 1.0f);
            glVertex2f( 1.0f, -1.0f);
            glVertex2f(-1.0f, -1.0f);
         glEnd();
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }

   EndDraw();
}

CWidget* CAirspeedGauge::CreateObject()
{
   return new CAirspeedGauge();
}

void CAirspeedGauge::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar      == "Mach")
   {
      float mach  =  *pVariant;
      if (mach >= 0.40)
         m_machValue_cv.Format("%2.0f", mach * 100.0f);
      else
         m_machValue_cv.Format("  ");
   }
   else if (rstrElementVar == "IAS")
   {
      m_ias_cv =  *pVariant;
   }
   else if (rstrElementVar == "Max Allowable Airspeed")
   {
      float max_allowable_airspeed  =  *pVariant;

      if (     max_allowable_airspeed        >= 40.0f    && max_allowable_airspeed  <  320.0f)
         m_max_allowable_airspeed_angle_cv   =  (293.0f/280.0f *  (max_allowable_airspeed  -  40.0f))  +  27.0f;
      else if (max_allowable_airspeed        >= 320.0f   && max_allowable_airspeed  <  400.0f)
         m_max_allowable_airspeed_angle_cv   =  (40.0f/80.0f   *  (max_allowable_airspeed  -  320.0f)) +  320.0f;
      else if (max_allowable_airspeed        <  40.0f)
         m_max_allowable_airspeed_angle_cv   =  27.0f;
      else
         m_max_allowable_airspeed_angle_cv   =  0.0f;
      
      // Adjust for the fact that the tip of the needle is not centered.  arctan(0.5*width/length)
      m_max_allowable_airspeed_angle_cv      += 1.79f;
   }
   else if (rstrElementVar == "Power")          // Power
   {
      m_bool_Power_cv =  (bool)*pVariant;
   }

}

/////////////////////////////////////////////////////////////////////////////
//
// bool CAirspeedGauge::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CAirspeedGauge::UpdateRenderVariables()
{
   // Determine the rate at which this function is getting called.
   LARGE_INTEGER  theFrequency;
   QueryPerformanceFrequency(&theFrequency);
   static   LARGE_INTEGER  theStartCount;
   static   bool  one_time_only  =  true;
   LARGE_INTEGER  theEndCount, diffCount;
   float    iteration_rate;

   if (one_time_only)
   {
      QueryPerformanceCounter(&theStartCount);
      one_time_only  =  false;
   }
   
   QueryPerformanceCounter(&theEndCount);
   diffCount.QuadPart   =  theEndCount.QuadPart -  theStartCount.QuadPart;
   iteration_rate       =  (float)((float)diffCount.QuadPart /  (float)theFrequency.QuadPart);
   QueryPerformanceCounter(&theStartCount);


   static   float lpv_output  =  0.0f;
   if (iteration_rate   >= 1.0f)    // If for some reason we haven't been called for more than a second, just snap to desired value.
   {
      m_ias       =  m_ias_cv;
      lpv_output  =  m_ias_cv;
   }
   else
   {
      float slew_limit_per_iteration   =  30.0f    *  iteration_rate;
      float fraction                   =  m_ias_cv *  iteration_rate;
      float calculated_filter_output   =  lpv_output  *  (1.0f -  iteration_rate)  +  fraction;

      if (calculated_filter_output  -  lpv_output  >  slew_limit_per_iteration)  
         lpv_output  += slew_limit_per_iteration;
      else if (lpv_output  -  calculated_filter_output   >  slew_limit_per_iteration)  
         lpv_output  -= slew_limit_per_iteration;
      else
         lpv_output  =  calculated_filter_output;

      m_ias =  lpv_output;
   }


   if (     m_ias    >= 40.0f    && m_ias <  320.0f)
      m_ias_angle =  (293.0f/280.0f *  (m_ias   -  40.0f))  +  27.0f;
   else if (m_ias    >= 320.0f   && m_ias <= 400.0f)
      m_ias_angle =  (40.0f/80.0f   *  (m_ias   -  320.0f)) +  320.0f;
   else if (m_ias    <  40.0f)
      m_ias_angle =  27.0f;
   else
      m_ias_angle =  0.0f;
   
   // Adjust for the fact that the tip of the needle is not centered.  arctan(0.5*width/length)
   m_ias_angle    -= 1.79f;

   m_machValue                      =  m_machValue_cv;
   m_max_allowable_airspeed_angle   =  m_max_allowable_airspeed_angle_cv;

   m_bool_Power                     =  m_bool_Power_cv;

   return CWidget::UpdateRenderVariables();
}
