// AdiGauge.h: interface for the CAdiGauge class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ADIGAUGE_H__E02411D7_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
#define AFX_ADIGAUGE_H__E02411D7_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"
#include "EHSIGauge.h"

enum  gps_annunciation
{
	GPS_ANNUNCIATION_ENROUTE   =  0,
	GPS_ANNUNCIATION_TERMINAL  =  1,
	GPS_ANNUNCIATION_APPROACH  =  2,
   GPS_ANNUNCIATION_OCEANIC   =  4
};

enum  adi_mode
{
   ADI_MODE_COMPOSITE,
   ADI_MODE_NORMAL
};

class CEHSIGauge;

class CAdiGauge : public COpenGLWidget, public CPanel
{
public:
	CAdiGauge();
	virtual ~CAdiGauge();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual  bool  UpdateRenderVariables();

   void  SetPitchAngle(float pitch);
   void  SetRollAngle(float roll);
   void  SetGlideslopeOffset(float offset);
   void  SetLateralPositionOffset(float offset);
   void  SetSupportHsiCompositeMode(bool support);

   void  DrawAdiSpecifics(void);

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

   CEHSIGauge  *m_hsiGauge;

// Attributes
public:
  	enum { IDB = IDB_ADI};

protected:
   COpenGLtext symbolicAircraft;
   CString     m_symbolic_aircraft;

   COpenGLtext zeroDegreeIndex;
   CString     m_zero_degree_index;

   COpenGLtext whiteSkyPointer;
   CString     m_white_sky_pointer;

   COpenGLtext chevron;
   CString     m_chevron;

   CTicks      rollTicks;
   CTicks      bottomTicks;

   COpenGLtext pitchScale;
   CString     m_pitch_scale;

   CTicks      glideslopeTicks;
   COpenGLtext glideslopeIndicator;
   CString     m_glideslope_indicator;

   CTicks      lateralPositionTicks;
   COpenGLtext lateralPositionIndicator;
   CString     m_lateralPosition_indicator;

   COpenGLtext lateralPositionType;
   CString     m_CStr_lateralPositionType;

   COpenGLtext markerBeaconBox;
   COpenGLtext markerBeacon;
   COpenGLtext markerBeacon_cv;
   CString     m_markerBeacon;
   CString     m_markerBeacon_cv;

   CTicks      rateOfTurnTicks;
   COpenGLtext rateOfTurn;
   CString     m_rateOfTurn;

   CTicks      slipAndSkidTicks;
   COpenGLtext slipAndSkid;
   CString     m_slipAndSkid;

   COpenGLtext xOut;
   CString     m_xOut;

   COpenGLtext attitudeFail;
   CString     m_attitudeFail;

   COpenGLtext controlPanelFailed;
   CString     m_controlPanelFailed;

   COpenGLtext backCourseIndicator;
   CString     m_backCourseIndicator;


   typedef  void (CAdiGauge::*function_ptr)();

   float    TimeThisFunction(function_ptr function_to_time);

private:
   void     DrawPitchScale(void);
   void     DrawGlideslope(void);
   void     DrawLocalizer(void);

   long     m_adi_mode;
   long     m_gps_annunciation_mode;
   bool     m_attitude_fail;
   bool     m_cp_500_fail;
   float    m_glideslope_offset;
   long     m_long_GS_status;
   bool     m_bool_GS_fail;
   bool     m_bool_Nav_Pwr_Fail;
   float    m_lateralPosition_offset;
   long     m_long_lateral_offset_valid;
   long     m_marker_beacon;
   float    m_pitch_angle;    // Degrees
   float    m_rate_of_turn;
   float    m_roll_angle;     // Degrees
   float    m_slip_and_skid;
   bool     m_support_HSI_composite_mode;
   bool     m_ils_selected;
   bool     m_back_course;
   long     m_long_lateral_offset_red_x;

   long     m_adi_mode_cv;
   long     m_gps_annunciation_mode_cv;
   bool     m_attitude_fail_cv;
   bool     m_cp_500_fail_cv;
   float    m_glideslope_offset_cv;
   long     m_long_GS_status_cv;
   bool     m_bool_GS_fail_cv;
   bool     m_bool_Nav_Pwr_Fail_cv;
   float    m_lateralPosition_offset_cv;
   long     m_long_lateral_offset_valid_cv;
   long     m_marker_beacon_cv;
   float    m_pitch_angle_cv;    // Degrees
   float    m_rate_of_turn_cv;
   float    m_roll_angle_cv;     // Degrees
   float    m_slip_and_skid_cv;
   bool     m_support_HSI_composite_mode_cv;
   bool     m_ils_selected_cv;
   bool     m_back_course_cv;
   long     m_long_lateral_offset_red_x_cv;

   bool     m_bool_EADI_Power;
   bool     m_bool_EADI_Power_cv;

   COpenGLtext XTALK;
   CString     m_XTALK;
   bool        m_bool_XTALK_Flag;
   bool        m_bool_XTALK_Flag_cv;

   bool        m_bool_FHDG_Flag;
   bool        m_bool_FHDG_Flag_cv;

   int         m_pitch_scale_list;
   int         m_roll_indicators_list;
   GLUquadricObj  *m_pquad;
};

#endif // !defined(AFX_ADIGAUGE_H__E02411D7_6AC9_11D2_AD4F_006008B0E0C3__INCLUDED_)
