// AccelerationPanel.cpp: implementation of the CAccelerationPanel class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "AccelerationPanel.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CAccelerationPanel::CAccelerationPanel()
{
   m_exPtUpperLeft      =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight     =  CExtentsPoint(CPoint(64,32));

   m_stlStrWidgetName   =  _FSI_STL::string("Acceleration_Panel");

   m_acceleration.Format("%+ 5.2f G", 0.0f);
   m_acceleration_cv = m_acceleration;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Acceleration");

   m_list   =  -1;
}

CAccelerationPanel::~CAccelerationPanel()
{
}

void  CAccelerationPanel::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   acceleration.Format("ACCELERATION");

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      // Draw the standard stuff.
      CPanel::Draw();

      glTranslatef(0.0f,    0.15f   /  m_aspect_ratio,   0.0f);
      AccelerationLegend.Draw(acceleration,  true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);

//      (0,0f, -0.15f / m_aspect_ratio, 0.0f);
      glTranslatef(0.0f,   -0.3f   /  m_aspect_ratio,   0.0f);

      // Don't pop matrix since the accleration value will always be in the
      // position after the previous translate.
   }
   glEndList();
}

void  CAccelerationPanel::Render(void)
{
   BeginDraw();

   glCallList(m_list);

   AccelerationValue.Draw(m_acceleration, true, 0.0f, 2.5f /  m_aspect_ratio, 0.0f);

   EndDraw();
}

void  CAccelerationPanel::SetAcceleration(float acceleration)
{
   m_acceleration_cv.Format("%+ 5.2f G", acceleration);
}

CWidget* CAccelerationPanel::CreateObject()
{
   return new CAccelerationPanel();
}

void CAccelerationPanel::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Acceleration")
   {
      SetAcceleration(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CAccelerationPanel::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CAccelerationPanel::UpdateRenderVariables()
{
   m_acceleration = m_acceleration_cv;

   return CWidget::UpdateRenderVariables();
}
