// LeftBrake.cpp : implementation of the CLeftBrake class.
//
//////////////////////////////////////////////////////////////////////

#include "..\core\stdafx.h"
#include "LeftBrake.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLeftBrake::CLeftBrake()
{
   m_exPtUpperLeft        =  CExtentsPoint(CPoint(0,0));
   m_exPtLowerRight       =  CExtentsPoint(CPoint(44,64));

   m_stlStrWidgetName     =  _FSI_STL::string("LeftBrake");

   m_LeftBrake_f          =  0.0f;
   m_LeftBrake_f_cv       =  m_LeftBrake_f;

   m_listGraphicalElementVars.clear();
   m_listGraphicalElementVars.push_back("Left Brake");

   m_list   =  -1;
}

CLeftBrake::~CLeftBrake()
{
}

void  CLeftBrake::Setup(void)
{
   CPanel::Initialize(GetSafeHwnd());

   m_CStr_left_brake   =  "L";
   m_CStr_max          =  "MAX ";
   m_CStr_off          =  "OFF ";

   m_leftbrake_indicator.Format("%c", DIAMOND);
   LeftBrakeIndicator.SetForegroundColor(0,  192,  0);    // Green

   LeftBrakeTicks.Initialize();
   LeftBrakeTicks.SetTickStyle(LINEAR, VERTICAL);
   LeftBrakeTicks.SetTickLengths(0.0375f * m_aspect_ratio, 0.0275f * m_aspect_ratio, 0.0175f * m_aspect_ratio);

   TICK_INFO   tick_info;

   strcpy(tick_info.ident, "");

   tick_info.location   =  1.5f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   LeftBrakeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  1.125f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   LeftBrakeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.75f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   LeftBrakeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.375f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   LeftBrakeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  0.00f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   LeftBrakeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -0.375f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   LeftBrakeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -0.75f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   LeftBrakeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -1.125f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   LeftBrakeTicks.TickList.AddTail(tick_info);

   tick_info.location   =  -1.5f /  m_aspect_ratio;
   tick_info.type       =  MAJOR;
   LeftBrakeTicks.TickList.AddTail(tick_info);

   LeftBrakeTicks.GenerateLists();

   if (m_list != -1)
      glDeleteLists(m_list, 1);

   m_list = glGenLists(1);
   glNewList(m_list, GL_COMPILE);
   {
      glPushMatrix();
      {
         // Draw the standard stuff, (bezel, screw heads, and primary title).
         CPanel::Draw();

         // Draw the L label
         glPushMatrix();
            glTranslatef(-0.4f *  m_aspect_ratio, 0.8f * m_aspect_ratio, 0.0f);
            m_title.Draw(m_CStr_left_brake, true, 0.0f, 3.0f *  m_aspect_ratio, 1.0f);
         glPopMatrix();

         // Draw the MAX label
         glPushMatrix();
            glTranslatef(0.4f *  m_aspect_ratio, 0.8f * m_aspect_ratio, 0.0f);
            m_max.Draw(m_CStr_max, true, 0.0f, 3.0f *  m_aspect_ratio, 1.0f);
         glPopMatrix();

         // Draw the OFF label
         glPushMatrix();
            glTranslatef(0.4f *  m_aspect_ratio, -0.72f * m_aspect_ratio, 0.0f);
            m_off.Draw(m_CStr_off, true, 0.0f, 3.0f *  m_aspect_ratio, 1.0f);
         glPopMatrix();

         // Draw the tick marks
         glTranslatef(-0.08f *  m_aspect_ratio, 0.0f, 0.0f);
         LeftBrakeTicks.Draw();
      }
      glPopMatrix();
   }
   glEndList();
}

void  CLeftBrake::Render(void)
{
   BeginDraw();

   glPushMatrix();
   {
      glCallList(m_list);

      // Brake Force Indicator
      glTranslatef(-0.10f, m_LeftBrake_f / m_aspect_ratio, 0.0f);
      glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
         LeftBrakeIndicator.Draw(m_leftbrake_indicator,   true, 90.0f, 6.0f *  m_aspect_ratio, 1.0f);
      glPolygonMode(GL_FRONT_AND_BACK, GL_LINE);
   }
   glPopMatrix();

   EndDraw();
}

void  CLeftBrake::SetLeftBrakeForce(float force)
{
   if (force  < -200.0f)
      force   = -200.0f;
   else if (force > 0.0f)
      force   = 0.0f;

   m_LeftBrake_f_cv  =  ((force / -200.0f) -0.5f)  *  3.0f;
}

CWidget* CLeftBrake::CreateObject()
{
   return new CLeftBrake();
}

void CLeftBrake::ChangeValue(const CString& rstrElementVar, CChangeValue* pCV)
{
   if (pCV == NULL)
   {
       return;
   }
   CVariant* pVariant = pCV->Variant();

   if (rstrElementVar   == "Left Brake")
   {
      SetLeftBrakeForce(*pVariant);
   }
}

/////////////////////////////////////////////////////////////////////////////
//
// bool CLeftBrake::UpdateRenderVariables()
//
// Inputs           : None.
//
// Return Values    : success value of the update of the rendering variables.
//
// Date             : 16 June 1999
//
// Engineer         : Billy Baker
//
// Description      : Override of the parent's UpdateRenderVariables.  
//                    If the class is being destroyed while in this method,
//                    then the return value should be false. This method is
//                    called by the COMMS layer before it tells the mainframe
//                    that a screen update is needed.
//
/////////////////////////////////////////////////////////////////////////////
bool CLeftBrake::UpdateRenderVariables()
{
   m_LeftBrake_f = m_LeftBrake_f_cv;

   return CWidget::UpdateRenderVariables();
}
