// HoneywellTAS.h: interface for the CHoneywellTAS class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_HONEYWELL_TAS_H__F86C35C9_D2B0_4802_9A65_E3C472B53AFB__INCLUDED_)
#define _HONEYWELL_TAS_H__F86C35C9_D2B0_4802_9A65_E3C472B53AFB__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "..\general\OpenGLWidget.h"
#include "Panel.h"

class CHoneywellTAS : public COpenGLWidget, public CPanel
{
public:
	CHoneywellTAS();
	virtual ~CHoneywellTAS();
   static CWidget* CreateObject();

   void  Setup(void);
   void  Render(void);
   virtual bool UpdateRenderVariables();

   virtual void ChangeValue(const CString& rstrElementVar, CChangeValue* pCV);

protected:
   COpenGLtext verticalSpeed_title;
   CString     m_verticalSpeed_title;

   CTicks      theTicks,theLabels;

   COpenGLtext fpmX1000_title;
   CString     fpm_x1000;

   CString     m_CStr_nacws_display_range;
   COpenGLtext range;
   
   CString     m_CStr_nacws_display_view;
   COpenGLtext view;

   COpenGLtext verticalSpeedNeedle;
   CString     m_verticalSpeedNeedle;
   float       m_float_verticalSpeed_angle;
   float       m_float_vertical_speed;
   float       m_float_vertical_speed_cv;
   float       m_float_Nacws_Display_Range;
   float       m_float_Nacws_Display_Range_cv;
   long        m_long_View;
   long        m_long_View_cv;
   bool        m_bool_Power;
   bool        m_bool_Power_cv;
   bool        m_vsi_valid;
   bool        m_vsi_valid_cv;
   long        m_long_tcas_flag;
   long        m_range_internal;

   CString     m_Cstr_tcas_flag;
   COpenGLtext tcasFlag;
   COpenGLtext symbol;

   long        m_long_nacws_status;
   long        m_long_nacws_status_cv;
   bool        m_bool_nacws_test;
   bool        m_bool_nacws_test_cv;
   time_t      m_timeStart; // test-mode timer

   COpenGLtext aircraftSymbol;
   CString     m_Cstr_ac_symbol;

   #define MAX_NACWS_THREATS 3   
   typedef  struct   nacws_type     // adapted from engine3gauge.h, to try to keeep maintenance similar
   {
      float       delta_altitude;
      float       delta_altitude_cv;
      float       bearing;
      float       bearing_cv;
      float       range;
      float       range_cv;
      long         tgt_type;
      long        tgt_type_cv;
      bool        unknown_altitude;
      bool        active;
      bool        active_cv;
      int         climb_descend;

   }  NACWS;
   NACWS       m_nacws_list[MAX_NACWS_THREATS];

   GLUquadricObj* m_pquad;
   bool filteredGood(float);


private:

// Attributes
public:
   enum { TGT_OTHER, TGT_TA, TGT_TA_NB, TGT_PROX };
   enum { IDB = IDB_TAS  };  // Still using the old Vertical Speed one.  May need a new one.
   enum { VIEW_NORMAL, VIEW_ABOVE, VIEW_BELOW};
   enum { TCAS_TA_ONLY, TCAS_TEST, TCAS_STBY, TCAS_INVALID };
   enum { Range_3NM=1, Range_Min = Range_3NM, Range_5NM, Range_10NM, Range_20NM, Range_40NM, Range_Max = Range_40NM};


};

#endif // !defined(_HONEYWELL_TAS_H__F86C35C9_D2B0_4802_9A65_E3C472B53AFB__INCLUDED_)
