/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : ZCTProtocol.h
//
// Date             : 17 August 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision$
//
// Description      : ZCTProcotol.h contains the definition of the 
//                    CZCTProcotol class. This class is a modification 
//                    of the ioshostcomms code used with the ZCT 
//                    developed control loading diagnostic application 
//                    (iosrt) which was also used as an IOS.  The 
//                    modifications were made to make the code 
//                    object-oriented in the sense that it is derived 
//                    from CProtocol and makes some use of the 
//                    CGenericHostSockets class.  This file 
//                    contains a number of constants that were 
//                    originally declared using #define in the ZCT code 
//                    and a number of data structures.
//                    
//                    Other modifications include a fixed value for
//                    iospSmsBase (0xF4700000) since no shared memory
//                    is used.  This value is determined by the actual
//                    hardware.  A number of variables were also deleted
//                    since they are in the CGenericHostSockets class.
//                    Since the ZCT does not use fixed packet sizes, the
//                    SendData and ReceiveData methods of CGenericHostSockets
//                    is not used to send and receive data.                    
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CProtocol, CGenericHostSockets.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 3, 4, or 5
//                                          Microsoft Windows NT 2000
//                                          VxWorks
//
//                    Compiler(s) - Visual C++ 6.0
//                                  Tornado 1.0.1
//
//                    Architechure(s) - Intel Pentium, Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$                                                                   //
/////////////////////////////////////////////////////////////////////////////
#ifndef _ZCTPROTOCOL_H_
#define _ZCTPROTOCOL_H_

#include "Protocol.h"

/*
 * Limits.
 */

static const unsigned long MAX_COMMAND_DATA         = 600;
static const unsigned long MAX_PLOT_BUFFERS         = 4;
static const unsigned long MAX_PLOT_DATA            = 50;
static const unsigned long MAX_SYMBOLS              = 10000;

/*
 * nType fields.
 *
 * Notes :
 *
 *	Variable types are specified by iosRt in the variable nType that is 
 *  transmitted through the IOSRT_COMMAND_SET_READ_POINTERS and 
 *  IOSRT_COMMAND_SET_WRITE_POINTERS commands.  The bit assignments in 
 *  this variable are specified here.
 */

static const unsigned long DATA_TYPE_BITS           = 0x0000000f;
static const unsigned long PLOT_BIT                 = 0x00000010;
static const unsigned long PLOT_BUFFER_NUMBER_LSB   = 5;
static const unsigned long PLOT_BUFFER_NUMBER_BITS  = (MAX_PLOT_BUFFERS - 1);

/*
 * Plotting.
 */

typedef	struct
{
	void *				pAddress;
	int					nCount;
	int					nType;
	int					nTypeDWords;
	unsigned int		uHostTick;
	int					nArray[MAX_PLOT_DATA << 1];
}						HostPlot;

static const unsigned long HOST_PLOT_HEADER_SIZE    = sizeof(void*) + 
                                                      sizeof(int) * 3 + 
                                                      sizeof(unsigned int);

/*
 * Read, write pointers.
 */

enum
{
	IOSRT_CHAR,						/* 1 byte  */
	IOSRT_LOGICAL,					/* 4 bytes */
	IOSRT_SHORT,					/* 2 bytes */
	IOSRT_USHORT,					/* 2 bytes */
	IOSRT_INT,						/* 4 bytes */
	IOSRT_UINT,						/* 4 bytes */
	IOSRT_FLOAT,					/* 4 bytes */
	IOSRT_DOUBLE,					/* 8 bytes */
};

/*
 * Structure.
 */

typedef	struct
{
	int					nPointerType;
	unsigned int		pPointer;
}						iosRtPointer;

/*
 * Command types.
 */

enum
{
	/*
	 * Host to IosRt commands.
	 */

	HOST_FIRST_COMMAND = (int)('Z' << 24) + (int)('C' << 16) + (int)('T' << 8),

	HOST_COMMAND_NULL = HOST_FIRST_COMMAND,
	HOST_COMMAND_READ_RETURN,
	HOST_COMMAND_NO_READ_POINTERS,
	HOST_COMMAND_READ_OUT_OF_RANGE,
	HOST_COMMAND_TOO_MANY_READ_POINTERS,
	HOST_COMMAND_NO_WRITE_POINTERS,
	HOST_COMMAND_WRITE_OUT_OF_RANGE,
	HOST_COMMAND_TOO_MANY_WRITE_POINTERS,
	HOST_COMMAND_PLOT,

	HOST_LAST_COMMAND = HOST_COMMAND_PLOT,

	/* 
	 * IosRt to Host commands.
	 */

	IOSRT_FIRST_COMMAND,

	IOSRT_COMMAND_NULL = IOSRT_FIRST_COMMAND,
	IOSRT_COMMAND_SET_READ_POINTERS,
	IOSRT_COMMAND_SET_WRITE_POINTERS,
	IOSRT_COMMAND_WRITE,
	IOSRT_COMMAND_READ,

	IOSRT_LAST_COMMAND = IOSRT_COMMAND_READ,
};

/*
 * Host commands.
 */

/*
 * HOST_COMMAND_PLOT
 */

typedef	struct
{
	void *				pAddress;
	int					nCount;
	int					nType;
	int					nTypeDWords;
	unsigned int		uHostTick;
	int					nArray[MAX_PLOT_DATA << 1];
}						PlotParams;

static const unsigned long HOST_COMMAND_PLOT_HEADER_SIZE = sizeof(void*) + 
                                                          sizeof(int) * 3 + 
                                                          sizeof(unsigned int);

/*
 * HOST_COMMAND_READ_RETURN
 */

typedef	struct
{
	int					nCount;
	int					nTag;
	unsigned int		dwData[MAX_COMMAND_DATA];
}						ReadReturnParams;

static const unsigned long HOST_COMMAND_READ_RETURN_HEADER_SIZE = 2 * sizeof(int);

/*
 * IosRt commands.
 */

/*
 * IOSRT_COMMAND_READ.
 */

typedef struct
{
	int					nCount;
	unsigned int		rdData[MAX_COMMAND_DATA];
}						ReadParams;

static const unsigned long IOSRT_COMMAND_READ_HEADER_SIZE   = sizeof(int);

/*
 * IOSRT_COMMAND_SET_READ_POINTERS.
 */

typedef	struct
{
	int					nPointers;
	int					nTag;
	iosRtPointer		pPointers[MAX_COMMAND_DATA];
}						SetReadPointerParams;

static const unsigned long IOSRT_COMMAND_SET_READ_POINTERS_HEADER_SIZE = 2 * sizeof(int);

/*
 * IOSRT_COMMAND_SET_WRITE_POINTERS.
 */

typedef struct
{
	int					nPointers;
	iosRtPointer		pPointers[MAX_COMMAND_DATA];
}						SetWritePointerParams;

static const unsigned long IOSRT_COMMAND_SET_WRITE_POINTERS_HEADER_SIZE = sizeof(int);

/*
 * IOSRT_COMMAND_WRITE
 */

typedef struct
{
	int					nCount;
	unsigned int		wrData[MAX_COMMAND_DATA];
}						WriteParams;

static const unsigned long IOSRT_COMMAND_WRITE_HEADER_SIZE  = sizeof(int);

/*
 * Command buffers.
 */

/*
 * Host command buffer.
 */

typedef	struct HOSTCOMMAND
{
	int			volatile nCommand;
	int			volatile nCommandSize;
	union
	{
				PlotParams				Plot;
				ReadReturnParams		ReadReturn;
	}			Command;
}				HostCommand;

static const unsigned long HOST_COMMAND_HEADER_SIZE     = sizeof(int) * 2;
static const unsigned long HOST_COMMAND_MAX_SIZE        = sizeof(HostCommand);

/*
 * IosRt command buffer.
 */

typedef	struct
{
	int			volatile nCommand;
	int			volatile nCommandSize;
	union
	{
				ReadParams				Read;
				SetReadPointerParams	SetReadPointers;
				SetWritePointerParams	SetWritePointers;
				WriteParams				Write;
	}			Command;
}				iosRtCommand;

static const unsigned long IOSRT_COMMAND_HEADER_SIZE    = sizeof(int) * 2;
static const unsigned long IOSRT_COMMAND_MAX_SIZE       = sizeof(iosRtCommand);

/*
 * Symbols.
 */

static const unsigned long MAX_SYMBOL_NAME_LENGTH  = MAX_VARIABLE_NAME_LEN;

/*
 * FSI symbol types.
 */

enum
{
	IOS_INTEGER,
	IOS_FLOAT,
	IOS_DOUBLE,
	IOS_LOGICAL,
	IOS_SHORT,
	IOS_CHAR,
	IOS_USHORT,
};

/*
 * FSI symbol structure.
 */

typedef	struct
{
	unsigned int		nNameOffset;
	unsigned int		nType;
	unsigned int		nValue;
}						ios_symbol_entry;

/*
 * FSI symbol file structure.
 */

typedef	struct
{
	int					nCount;
	ios_symbol_entry *	pSymbolEntries;
	char *				pSymbolNames;
}						ios_symbols_hdr;

// MAX_ETHERNET_SEG is defined in protocol.h
static const unsigned char  ZCT_MAX_SEGMENTS_TO_SEND  = 1;
static const unsigned short ZCT_MAX_SEND_BUFFER       = HOST_COMMAND_MAX_SIZE * 8 *
                                                        ZCT_MAX_SEGMENTS_TO_SEND;

static const unsigned char  ZCT_MAX_SEGMENTS_TO_RECEIVE  = 1;
static const unsigned short ZCT_MAX_RECEIVE_BUFFER    = MAX_ETHERNET_SEG * 
                                                        ZCT_MAX_SEGMENTS_TO_RECEIVE;

static const unsigned short ZCT_RECEIVE_BUFFER_CACHE  = 1;
static const unsigned short ZCT_SEND_BUFFER_CACHE     = 1;

static const unsigned short ZCT_PORT            = 4000;

class CZCTProtocol : public CProtocol
{
protected:
    BOOL            iosbCommandReceiveRequested;
    int             iosnReadPointers;
    int             iosnSendBufferPositionIn;
    int             iosnSendBufferPositionOut;
    int             iosnSetReadPointersTag;
    int             iosnWritePointers;

    HostPlot        ioshpPlotBuffers[MAX_PLOT_BUFFERS];
    int             iospReadPointers[MAX_COMMAND_DATA];
    int             iospReadPointerTypes[MAX_COMMAND_DATA];
    int             iospWritePointers[MAX_COMMAND_DATA];
    int             iospWritePointerTypes[MAX_COMMAND_DATA];

    void			iosPlotAdd(void * pAddress, int nType);
    HostPlot*		iosPlotFind(int nType);

    void			iosCommandNull();
    void			iosCommandRead();
    void			iosCommandSetReadPointers();
    void			iosCommandSetWritePointers();
    void			iosCommandWrite();

    BOOL            iosSendCommand(HostCommand* hcCommand);

public:
    iosRtCommand    iosCommandReceive;

    unsigned int    iosuHostTick;
    int             iosnReceiveDataCount;
    char *          iospReceiveDataPointer;
    int             iosnSendBufferCount;
    char *          iospSmsBase;

    bool            m_bCommandComplete;

	CZCTProtocol();
	virtual ~CZCTProtocol();

    virtual bool ReadValues() { return false; }
    virtual void ProcessCommands();


    void			iosPlotData();
    void			iosPlotInitialize();

    int             iosReceiveData();
    int             iosSendData();
};

#endif // !defined(_ZCTPROTOCOL_H_)
