/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : Protocol.h
//
// Date             : 06 May 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.5 $
//
// Description      : Protocol.h contains the definition needed by the methods 
//                    to start the communications process, process commands
//                    from the client, and cleanup the communications process.
//                    These methods are found in Protocol.cpp.  See the comments
//                    in Protocol.cpp for more detailed information.
//
//                    The protocol implemented in Protocol.cpp will send a 
//                    packet of MAX_SEND_BUFFER every time that HostComms is 
//                    called.  The contents of the buffer is determined by 
//                    commands sent from the client.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CByteConversion, CGenericHostSockets, CData.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//                                          VXWorks
//
//                    Compiler(s) - Visual C++ 6.0
//                                  Tornado 1.0.1
//
//                    Architechure(s) - Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: Protocol.h $
// Revision 1.5  2000/02/14 09:21:44  billyb
// Changed typedef for array mutator.  Changed Variable 
// structure to have length for two dimensions.
// Revision 1.4  2000/02/10 21:01:22  billyb
// Changed typedef for ArrayMutator.
// Revision 1.3  2000/01/26 09:23:12  billyb
// Added typedef for a mutator to change an array element.
// Changed Mutator* member to a void *.  Added length of
// an array.
// Revision 1.2  1999/11/30 07:41:09  billyb
// Added size mismatch error.
/////////////////////////////////////////////////////////////////////////////
#ifndef _PROTOCOL_H_
#define _PROTOCOL_H_

// Maximum len of a string for a symbol name.
static const unsigned short MAX_VARIABLE_NAME_LEN   =   80;

// Note: this is for IPv4.  IPv6 is 1440.
static const unsigned short MAX_ETHERNET_SEG        = 1460;

// typedef for a function pointer.  The function should not
// return any values and should have one parameter which should
// be an address.
typedef void (*Mutator)(void*);
typedef void (*ArrayMutator)(void*, int, int, int);

// Host structure for storing information about which variable to read and
// the address of the function to call to change the value of the variable.
// The reference count is to make sure that data is not repeated in the 
// buffer.
struct Variable
{
    long            s_lAddress;
    long            s_lLength1D;
    long            s_lLength2D;
    BOOL            s_bPlayBack;
    float           s_fLow;
    float           s_fHigh;
    void*           s_pChangeValue;
    unsigned short  s_ushSize;
    unsigned short  s_ushReferenceCount;
    char            s_cName[MAX_VARIABLE_NAME_LEN];
};

struct Error
{
    unsigned short  s_ushIndex;
    unsigned char   s_ucError;
};

enum
{
    NOT_FOUND           =    1,
    BUFFER_EXCEEDED     =    2,
    DUPLICATE_VARIABLE  =    4,
    MAX_VAR_EXCEEDED    =    8,
    SIZE_MISMATCH       =   16
};

class CGenericHostSockets;

class CProtocol
{
protected:
    // Number of registered variables.
    short int           m_shPossibleVariables;

    // Number of variables actually being sent.
    short int           m_shVarCount;

    // Number of bytes requested by the client to be sent.
    long int            m_lBytesAdded;

    // Number of real errors since some errors may be a not found
    // and a max variable exceeded and a max buffer exceeded.
    short int           m_shUniqueErrors;

    // Number of times a variable was asked to be added but was not 
    // registered.
    short int           m_shNotFoundVariables;

    // Number of times a variable that had already been added was asked to
    // be added again.
    short int           m_shDuplicateVariables;

    // Number of times a variable was asked to be added but the buffer
    // length had already been met.
    short int           m_shBufferExceededVariables;

    // Number of times a variable was asked to be added but the maximum
    // number of variables was already met.  The variables added here
    // probably also got added to the NotFound value.
    short int           m_shMaxVarExceededVariables;

    // The last index that was requested by the client.
    short int           m_shLastIndex;

    // Number of times a variable was asked to be added but the size from
    // the client did not match the size that was registered.
    short int           m_shSizeMismatchVariables;

    bool                m_bNotFoundChanged;
    bool                m_bDuplicateChanged;
    bool                m_bVarCountChanged;
    bool                m_bBufferExceededChanged;

    bool                m_bMaxVarExceededChanged;
    bool                m_bSizeMismatchChanged;

    CProtocol();

public:
    ~CProtocol();

    // The all important sockets.  A derived class should
    // create a new instance with the parameters for that
    // protocol.
    CGenericHostSockets*    m_pSockets;

    // Protocol specific methods.
    virtual bool ReadValues()       = 0;
    virtual void ProcessCommands()  = 0;

    // Accessors
    short int PossibleVariables();
    short int VariableCount();
    long  int BytesAdded();
    short int NotFoundVariables();
    short int DuplicateVariables();
    short int UniqueErrors();
    short int BufferExceededVariables();
    short int MaxVarExceededVariables();
    short int LastIndex();
    short int SizeMismatchVariables();

    // Mutators
    void PossibleVariables(const short int shPossibleVariables);
    void VariableCount(const short int shVariableCount);
    void BytesAdded(const long int lBytesAdded);
    void NotFoundVariables(const short int shNotFoundVariables);
    void DuplicateVariables(const short int shDuplicateVariables);
    void UniqueErrors(const short int shUniqueErrors);
    void BufferExceededVariables(const short int shBufferExceededVariables);
    void MaxVarExceededVariables(const short int shMaxVarExceededVariables);
    void LastIndex(const short int shLastIndex);
    void SizeMismatchVariables(const short int shSizeMismatchVariables);
};

#endif
