/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : Protocol.cpp
//
// Date             : 06 May 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision$
//
// Description      : Protocol.cpp contains the implementation of the methods 
//                    to start the communications process, process commands
//                    from the client, and cleanup the communications process.
//                    The HostComms method should be called at a regular 
//                    interval by another function that schedules the calls
//                    at a periodic rate.
//
//                    The protocol implemented here will send a packet of
//                    MAX_SEND_BUFFER every time that HostComms is called.
//                    The contents of the buffer is determined by commands sent
//                    from the client.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CGenericHostSockets.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//                                          VXWorks
//
//                    Compiler(s) - Visual C++ 6.0
//                                  Tornado 1.0.1
//
//                    Architechure(s) - Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log$
/////////////////////////////////////////////////////////////////////////////
#include "HostComms.h"
#include "GenericHostSockets.h"
#include "Protocol.h"

CProtocol::CProtocol()
{
    m_shPossibleVariables       = 0;

    m_shVarCount                = 0;
    m_lBytesAdded               = 0;
    m_shUniqueErrors            = 0;
    m_shNotFoundVariables       = 0;
    m_shDuplicateVariables      = 0;
    m_shBufferExceededVariables = 0;
    m_shMaxVarExceededVariables = 0;
    m_shLastIndex               = 0;
    m_shSizeMismatchVariables   = 0;

    m_bNotFoundChanged          = false;
    m_bDuplicateChanged         = false;
    m_bVarCountChanged          = false;
    m_bBufferExceededChanged    = false;
    m_bMaxVarExceededChanged    = false;
    m_bSizeMismatchChanged      = false;

    m_pSockets                  = NULL;
}

CProtocol::~CProtocol()
{
    if (m_pSockets != NULL)
    {
        delete m_pSockets;
        m_pSockets = NULL;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//                              Accessors
//
/////////////////////////////////////////////////////////////////////////////
short int CProtocol::PossibleVariables()
{
    return m_shPossibleVariables;
}

short int CProtocol::VariableCount()
{
    return m_shVarCount;
}

long int CProtocol::BytesAdded()
{
    return m_lBytesAdded;
}

short int CProtocol::NotFoundVariables()
{
    return m_shNotFoundVariables;
}

short int CProtocol::DuplicateVariables()
{
    return m_shDuplicateVariables;
}

short int CProtocol::UniqueErrors()
{
    return m_shUniqueErrors;
}

short int CProtocol::BufferExceededVariables()
{
    return m_shBufferExceededVariables;
}

short int CProtocol::MaxVarExceededVariables()
{
    return m_shMaxVarExceededVariables;
}

short int CProtocol::LastIndex()
{
    return m_shLastIndex;
}

short int CProtocol::SizeMismatchVariables()
{
    return m_shSizeMismatchVariables;
}

/////////////////////////////////////////////////////////////////////////////
//
//                              Mutators
//
/////////////////////////////////////////////////////////////////////////////
void CProtocol::PossibleVariables(const short int shPossibleVariables)
{
    m_shPossibleVariables = shPossibleVariables;
}

void CProtocol::VariableCount(const short int shVariableCount)
{
    m_shVarCount = shVariableCount;
}

void CProtocol::BytesAdded(const long int lBytesAdded)
{
    m_lBytesAdded = lBytesAdded;
}

void CProtocol::NotFoundVariables(const short int shNotFoundVariables)
{
    m_shNotFoundVariables = shNotFoundVariables;
}

void CProtocol::DuplicateVariables(const short int shDuplicateVariables)
{
    m_shDuplicateVariables = shDuplicateVariables;
}

void CProtocol::UniqueErrors(const short int shUniqueErrors)
{
    m_shUniqueErrors = shUniqueErrors;
}

void CProtocol::BufferExceededVariables(const short int shBufferExceededVariables)
{
    m_shBufferExceededVariables = shBufferExceededVariables;
}

void CProtocol::MaxVarExceededVariables(const short int shMaxVarExceededVariables)
{
    m_shMaxVarExceededVariables = shMaxVarExceededVariables;
}

void CProtocol::LastIndex(const short int shLastIndex)
{
    m_shLastIndex = shLastIndex;
}

void CProtocol::SizeMismatchVariables(const short int shSizeMismatchVariables)
{
    m_shSizeMismatchVariables = shSizeMismatchVariables;
}
