/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : hostLog.cpp
//
// Date             : 24 January 2000
//
// Engineer         : Michael F Lawson
//
// Revision         : $Revision: 1.3 $
//
// Description      : This is a wrapper class to support logging messages
//                    to the host machine's log process.
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : 
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//                                          VXWorks
//
//                    Compiler(s) - Visual C++ 6.0
//                                  Tornado 1.0.1
//
//                    Architechure(s) - Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: log_report.cpp $
// Revision 1.3  2000/06/16 20:42:29  billyb
// Added new function from latest code from
// Mike and Charles.
// Revision 1.2  2000/03/30 07:42:33  billyb
// Initial release.
/////////////////////////////////////////////////////////////////////////////

#define  MAX_MSG_LEN    128

#include "log_report.h"
#include <stdio.h>

#ifdef   WIN32  /* Windows */

    static char *msg_text[] = {"INFO: ",
                               "WARNING: ",
                               "ERROR: ",
                               "FATAL: "};

    void Log_Report(char* Event,  int Severity)
    {
        fprintf(stderr, msg_text[Severity]);
        fprintf(stderr, Event);
    }

    void Log_Report(char* format, char* arg, int Severity)
    {
        fprintf(stderr, msg_text[Severity]);
        fprintf(stderr, format, arg);
    }
   
    void Log_Report(char* format, int arg, int Severity)
    {
        fprintf(stderr, msg_text[Severity]);
        fprintf(stderr, format, arg);
    }

    void Log_Report(char* format, int arg1, int arg2, int Severity)
    {
        fprintf(stderr, msg_text[Severity]);
        fprintf(stderr, format, arg1, arg2);
    }


    void Log_Report(char* format, char* arg1, int arg2, int Severity)
    {
        fprintf(stderr, msg_text[Severity]);
        fprintf(stderr, format, arg1, arg2);
    }

#else   /* vxWorks */


    extern "C"
    {
        #include "..\..\..\reusable_cat\reusable_cat.h"
    }

    void Log_Report(char* Event,  int Severity)
    {
        JPATS_Log_Report(Event, Severity);
    }

    void Log_Report(char* format, char* arg, int Severity)
    {
        char szMessage[MAX_MSG_LEN];
        sprintf(szMessage, format, arg);
        JPATS_Log_Report(szMessage, Severity);
    }

    void Log_Report(char* format, int arg, int Severity)
    {
        char szMessage[MAX_MSG_LEN];
        sprintf(szMessage, format, arg);
        JPATS_Log_Report(szMessage, Severity);
    }

    void Log_Report(char* format, int arg1, int arg2, int Severity)
    {
        char szMessage[MAX_MSG_LEN];
        sprintf(szMessage, format, arg1, arg2);
        JPATS_Log_Report(szMessage, Severity);
    }

    void Log_Report(char* format, char* arg1, int arg2, int Severity)
    {
        char szMessage[MAX_MSG_LEN];
        sprintf(szMessage, format, arg1, arg2);
        JPATS_Log_Report(szMessage, Severity);
    }

#endif /* vxWorks */