-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Thomas Haley
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Scheduler.IO;
with Ada.Streams;

-------------------------------------------------------------------------------
-- This packagge provides a scheduler for communications with the IOS.
-------------------------------------------------------------------------------
package Jpats_HostComms_Scheduler is

   type Instance is new Scheduler.IO.Instance with private;

   type Handle is access all Instance'Class;

   ----------------------------------------------------------------------------
   -- Initialize the IOS/Host communications model.
   ----------------------------------------------------------------------------
   procedure Initialize
     (An_Instance : in out Instance);

   ----------------------------------------------------------------------------
   -- Retrieve and process any IOS requests. Gather up all host information
   -- requested by the IOS and request that it be sent. The data will actually
   -- be send by a non-realtime task.
   ----------------------------------------------------------------------------
   procedure Update
     (An_Instance          : in out Instance;
      Integration_Constant : in     Float);

   ----------------------------------------------------------------------------
   -- This routine is called only during a replay. It keeps the communications
   -- link alive (and allows replay commands), but doesn't accept variable
   -- updates.
   ----------------------------------------------------------------------------
   procedure Update_In_Freeze (An_Instance : in out Instance);


   -------------------------------------------------------------------------------
   -- Routine to save a snapshot of the instance to the given stream.
   --
   -- Note that the predefined attributes 'Write and 'Output can be used on any
   -- object to store its value in the given stream.
   -------------------------------------------------------------------------------
   procedure Save
     (An_Instance : in out Instance;
      To_Stream   : access Ada.Streams.Root_Stream_Type'Class);

   procedure Restore
     (An_Instance : in out Instance;
      From_Stream : access Ada.Streams.Root_Stream_Type'Class);

   function Snapshot_Size (An_Instance : Instance) return Natural;

private
   type Instance is new Scheduler.IO.Instance with record
      Ios_Responding : Boolean := False;
   end record;

end Jpats_HostComms_Scheduler;
