/////////////////////////////////////////////////////////////////////////////
//
//           F L I G H T S A F E T Y   I N T E R N A T I O N A L
//                     Simulation Systems Division
//                      2700 North Hemlock Circle
//                     Broken Arrow, Oklahoma 74012
//                          (918) 259-4000
/////////////////////////////////////////////////////////////////////////////
//
// DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
// Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
// technical or operational data or information from automatic dissemination
// under the International Exchange Program or by other means.  This protection
// covers information required solely for administrative or operational
// purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
//
// WARNING:  This document contains technical data whose export is restricted
// by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
// Executive Order 12470.  Violation of these export control laws is subject
// to severe criminal penalties.  Dissemination of this document is controlled
// under DOD Directive 5230.25
//
/////////////////////////////////////////////////////////////////////////////
//
//
// Filename         : IOSProtocol.h
//
// Date             : 06 May 1999
//
// Engineer         : Billy Baker
//
// Revision         : $Revision: 1.4 $
//
// Description      : IOSProtocol.h contains the definition needed by the methods 
//                    to start the communications process, process commands
//                    from the client, and cleanup the communications process.
//                    These methods are found in IOSProtocol.cpp.  See the comments
//                    in Protocol.cpp for more detailed information.
//
//                    The protocol implemented in IOSProtocol.cpp will send a 
//                    packet every time that IOSHostComms is called.  The 
//                    contents of the buffer is determined by 
//                    commands sent from the client.  
//
// Classification   : UNCLASSIFIED
//
// Requirements     : None.
//
// Components Used  : CGenericHostSockets.
//
// Operational 
//    Restrictions  : Machine dependencies/restrictions
//                        None.
//                    Design dependencies/restrictions
//                        None.
//                    Operations containing dependencies/restrictions
//                        None.
//                    Compiler dependencies/restrictions
//                        None.
//                    Other conditions for proper execution
//                        None.
//
// Environment      : Operating system(s) - Microsoft Windows NT 4.0 with
//                                              NT service pack 4
//                                          Microsoft Windows NT 2000
//                                          VXWorks
//
//                    Compiler(s) - Visual C++ 6.0
//                                  Tornado 1.0.1
//
//                    Architechure(s) - Pentium II
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//                              R e v i s i o n   H i s t o r y
//
/////////////////////////////////////////////////////////////////////////////
// $Log: IOSProtocol.h $
// Revision 1.4  2000/02/14 09:22:07  billyb
// Changed comments about data for CHANGE_VARIABLE.
// Revision 1.3  2000/02/09 20:17:03  billyb
// Changed comments about the size of data from the client.
/////////////////////////////////////////////////////////////////////////////
#ifndef _IOSPROTOCOL_H_
#define _IOSPROTOCOL_H_

static const unsigned short IOS_MAX_VARIABLES         = 2048;

// MAX_ETHERNET_SEG is defined in protocol.h
static const unsigned char  IOS_MAX_SEGMENTS_TO_SEND  = 4;

static const unsigned short IOS_MAX_SEND_BUFFER       = MAX_ETHERNET_SEG * 
                                                        IOS_MAX_SEGMENTS_TO_SEND;

static const unsigned char  IOS_MAX_SEGMENTS_TO_RECEIVE  = 1;
static const unsigned short IOS_MAX_RECEIVE_BUFFER    = MAX_ETHERNET_SEG *
                                                        IOS_MAX_SEGMENTS_TO_RECEIVE;

static const unsigned short IOS_RECEIVE_BUFFER_CACHE  = 4;
static const unsigned short IOS_SEND_BUFFER_CACHE     = 4;

static const unsigned short IOS_PORT                  = 3000;

// Command structure:
//
// ADD_VARIABLE
//      short           command ID
//      unsigned short  variable index to add
//      unsgined short  length of next field
//      char[length]    should be the name of a variable 
//      unsigned short  size of variable in bytes as defined in IOS variable 
//                      data file.
//
// DELETE_VARIABLE
//      short           command ID
//      unsigned short  variable index to delete
//
// CHANGE_VARIABLE
//      short           command ID
//      unsigned short  variable index to change
//      unsigned short  length of next field
//      char[length]    should be a stream of bytes that make a value
//      int             index of 1D element to change
//      int             index of 2D element to change

//
// RESET
//      short           command ID
//
//
// All data should fit in a data packet from the IOS.
enum
{
    DIAGNOSTICS         = -1,
    CHANGE_VARIABLE     = -2,
    ADD_VARIABLE        = -3, 
    DELETE_VARIABLE     = -4,
    RESET               = -5
};

class CIOSProtocol : public CProtocol
{
public:
    CIOSProtocol();
    ~CIOSProtocol();

    Variable    m_Variables[IOS_MAX_VARIABLES];
    Variable    m_ReadAddresses[IOS_MAX_VARIABLES];
    Error       m_Errors[IOS_MAX_VARIABLES];

    virtual bool ReadValues();

    // Inherited version. It just calls the new ProcessCommands with the flags set false.
    virtual void ProcessCommands(); 
    virtual void ProcessCommands(BOOL noChange, BOOL onlyChange);
};

#endif
